C ***************************************************** 
C ******* RELPAIR VERSION 2.0.1, JUNE 13, 2004 ********
C *** WRITTEN BY WILLIAM L. DUREN, MICHAEL EPSTEIN, *** 
C ********** MINGYAO LI AND MICHAEL BOEHNKE *********** 
C ***************************************************** 
C
C FOR EACH PUTATIVE PAIR ENCOUNTERED, DETERMINE WHETHER THE PAIR
C IS MOST LIKELY AN MZ TWIN PAIR, A FULL SIB PAIR, A PARENT/OFFSPRING
C PAIR, A HALF SIB PAIR, A GRANDPARENT/GRANDCHILD PAIR, AN AVUNCULAR
C PAIR, A FIRST COUSINS PAIR OR AN UNRELATED PAIR. THE USER IS GIVEN
C THE OPTION OF CONSIDERING ALL POSSIBLE PAIRS OF INDIVIDUALS IN THE
C SAMPLE OR ALL POSSIBLE WITHIN-FAMILY PAIRS.
C
C METHOD:
C     CALCULATE THE PROBABILITIES OF THE PAIR MARKER DATA CONDITIONAL
C     ON EACH RELATIVE TYPE ALLOWING FOR LINKAGE OR ASSUMING UNLINKED
C     LOCI.
C
C REFERENCES:
C     BOEHNKE M, COX NJ (1997) ACCURATE INFERENCE OF RELATIONSHIPS IN
C       SIB-PAIR LINKAGE STUDIES. AM J HUM GENET 61:423-429
C     EPSTEIN M, DUREN W, AND BOEHNKE M (2000) IMPROVED INFERENCE OF
C       RELATIONSHIP FOR PAIRS OF INDIVIDUALS. AM J HUM GENET 67:1219-
C       1231 
C
C THIS PROGRAM READS MENDEL LOCUS AND PEDIGREE FILES AND CONVERTS BAND 
C LENGTH GENOTYPES TO ALLELE NUMBER GENOTYPES (1 TO NALL).  
C
C ASSUMPTIONS:  
C 1. AUTOSOMAL, CODOMINANT LOCI.
C 2. NO MORE THAN 99 ALLELES PER MARKER (SOFT LIMIT: MAXALL=50).
C 3. NO MORE THAN 10,000 MARKERS (SOFT LIMIT: MAXLOC=2000).
C 4. CHROMOSOMES NEVER OF LENGTH GREATER THAN 50 MORGANS.
C 5. IN EACH GENOTYPE EITHER BOTH ALLELES OR NEITHER ALLELE SPECIFIED.
C
C KEY TO RELATIVE TYPES:
C 1=MZ TWINS, 2=FULL SIBS, 3=PARENT/OFFSPRING, 4=HALF SIBS
C 5=GRANDPARENT/GRANDCHILD, 6=AVUNCULAR, 7=FIRST COUSINS
C 8=UNRELATED.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      PARAMETER(MAXALL=50,MAXFAM=3000,MAXLOC=2000,MAXPEO=200,MAXREL=8
     1,MXPTOT=5000,NFRQPR=3) 
C
      COMMON /D1/ITWIN,IFULL,IPOFF,IHALF,IGRCH,IAVNC,ICOUS,IRAND
      COMMON /D2/KCON,KRES,KLOC,KPED,KIN,KOUT,KDET
      COMMON /D3/MINTYP
      COMMON /D4/IRECL
C
      CHARACTER*8 ALLNAM(MAXALL,MAXLOC),ID(MXPTOT)
     1,P1ID(MXPTOT),P2ID(MXPTOT),PEDID(MXPTOT),SEX(MXPTOT)
     2,TRMODE(MAXLOC),TWIN(MXPTOT),XXSIGN,XYSIGN,GP1ID(MXPTOT)
     3,GP2ID(MXPTOT),GP3ID(MXPTOT),GP4ID(MXPTOT)
      CHARACTER*32 LOCNAM(MAXLOC)
      CHARACTER*72 PEDFN
      CHARACTER*5000000 BUFF(MAXREL)
      CHARACTER*5000000 FAMBUF
      DOUBLE PRECISION POSIT(MAXLOC),PRLIK(MAXREL),PRREL(MAXREL)
     1,THETA(MAXLOC),GENERR,PSI(MAXLOC),ALLFRQ(MAXALL,MAXLOC)
     2,CRITVAL
      INTEGER OUTTYPE,ICHROM(MAXLOC),NALL(MAXLOC),KTAB1(MAXREL,MAXREL)
     1,KTAB2(MAXREL,MAXREL),IGENES(0:1,MAXLOC,MXPTOT),IBUFF(MAXREL)
     2,FAMPRS(MAXFAM),IFAMBUF,KDISC(MAXFAM),PERM(MAXLOC)
      LOGICAL ALLPR,NOLINK,WRTMAP,WRTPED
C
C **********************************************************************
C INITIALIZATIONS.
C **********************************************************************
C
      ITWIN=1
      IFULL=2
      IPOFF=3
      IHALF=4
      IGRCH=5
      IAVNC=6
      ICOUS=7
      IRAND=8 
C
      KCON=1
      KRES=2
      KLOC=3
      KPED=4
      KIN=5
      KOUT=6
      KDET=7
C
      MINTYP=1
C
C BUFFERED OUTPUT HANDLING.
C
      IRECL=94
C
      IFAMBUF=1
      DO 10 IREL=1,MAXREL
        IBUFF(IREL)=1
 10   CONTINUE
C
C **********************************************************************
C TAKE THE ORIGINAL DATA AND MAKE IT OVER IN A FORMAT CONVENIENT FOR THE
C ANALYSES.
C **********************************************************************
C
C INPUT THE FILE NAMES AND OPEN THE FILES.  READ THE CONTROL FILE.
C
      CALL FOPEN(ALLPR,MINSHR,WRTMAP,WRTPED,XXSIGN,XYSIGN,PEDFN
     1,OUTTYPE,GENERR,CRITVAL)
C
C CHECK FLEXIBLE CODE PARAMETERS FOR PROGRAM DESIGN LIMITS.
C
      CALL CHKPAR(MAXALL,MAXLOC)
C
C READ THE LOCUS FILE, ESTABLISH THE ALLELE MATCHES, AND READ THE
C LOCUS POSITIONS.  CHECK FOR LOCUS FILE ERRORS.
C
      CALL LOCFIL(ALLNAM,ICHROM,LOCNAM,NALL,NFRQPR,NLOCI
     1,NLOCIN,NOLINK,POSIT,THETA,TRMODE,WRTMAP,IPOSIX
     2,NXLINK,ALLFRQ,PSI,MAXALL,MAXLOC,PERM) 
C
C **********************************************************************
C CARRY OUT THE ANALYSES TO ASSESS THE MOST LIKELY RELATIONSHIPS.
C **********************************************************************
C
C INITIALIZE COUNTS.
C
      CALL START(KTAB2,KTAB1,MAXREL,KNUFF)
C
C READ THE OLD PEDIGREE FILE AND OUTPUT THE NEW PEDIGREE DATA.
C DO ALL PEDIGREE ERROR CHECKING.
C    
      CALL MODPED(ALLNAM,ALLPR,ID,LOCNAM,MAXPEO
     1,NALL,NFXTOT,NLOCI,NLOCIN,NPAIR,NPED,NRNTOT,KDISC,P1ID,P2ID
     2,PEDID,SEX,TWIN,WRTPED,XXSIGN,XYSIGN,NXLINK,GP1ID
     3,GP2ID,GP3ID,GP4ID,IGENES,MAXLOC,MXPTOT,MAXALL,MAXREL
     4,MAXFAM,FAMPRS,PERM)
C
C PERFORM THE ACTUAL ANALYSIS, CALCULATING LIKELIHOOD RATIOS
C AND SHARING SCORES FOR EACH PAIR.
C   
      CALL ANALYZ(ALLPR,IPOSIX,ID,MAXALL,MAXFAM,MAXLOC,MAXREL,MINSHR
     1,MXPTOT,NFAM,NLOCI,NRNTOT,NTYPE2,KDISC,P1ID,P2ID,PEDID,PRLIK
     2,PRMAX,PRREL,IPUTREL,TWIN,THETA,SEX,NXLINK,OUTTYPE,GP1ID,GP2ID
     3,GP3ID,GP4ID,XXSIGN,XYSIGN,NPAIR,GENERR,IGENES,PSI,ALLFRQ
     4,KTAB2,CRITVAL,BUFF,IBUFF,FAMPRS,FAMBUF,IFAMBUF,PERM,KTAB1,KNUFF)
C
C REPORT THE RESULTS FOR THE COUNTS.
C
      CALL FINAL(ALLPR,MINSHR,NTYPE2,OUTTYPE,NPAIR,GENERR
     1,KTAB2,MAXREL,CRITVAL,BUFF,IBUFF,FAMPRS,FAMBUF,IFAMBUF,KDISC
     2,MAXFAM,NPED,KTAB1,KNUFF)
C  
      END
C
C
C
      SUBROUTINE FOPEN(ALLPR,MINSHR,WRTMAP,WRTPED,XXSIGN,XYSIGN,PEDFN
     1,OUTTYPE,GENERR,CRITVAL)
C
C READ IN THE FILE NAMES AND OPEN THE FILES.
C      
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      COMMON /D2/KCON,KRES,KLOC,KPED,KIN,KOUT,KDET
C
      CHARACTER*1 ECHMAP,ECHPED
      CHARACTER*8 TYPE,XXSIGN,XYSIGN
      CHARACTER*72 CONFN,FILNAM,LOCFN,PEDFN,RESFN,STR
      INTEGER OUTTYPE
      LOGICAL ALLPR,WRTMAP,WRTPED
C
      WRITE(KOUT,101)
 101  FORMAT(A)
      WRITE(KOUT,101)
      WRITE(KOUT,102)
 102  FORMAT(' ***************************************************** ')
      WRITE(KOUT,103)
 103  FORMAT(' ******* RELPAIR VERSION 2.0.1, JUNE 13, 2004 ******** ')
      WRITE(KOUT,104)
 104  FORMAT(' *** WRITTEN BY WILLIAM L. DUREN, MICHAEL EPSTEIN, *** ')
      WRITE(KOUT,105)
 105  FORMAT(' ********** MINGYAO LI AND MICHAEL BOEHNKE *********** ')
      WRITE(KOUT,206)
 206  FORMAT(' ***************************************************** ')
      WRITE(KOUT,101)
C
 10   WRITE(KOUT,101)' CONTROL FILE NAME:  '
      READ(KIN,101,ERR=10)CONFN
      FILNAM=CONFN
      OPEN(KCON,FILE=CONFN,STATUS='OLD',ERR=79)
C
      READ(KCON,101,ERR=90)LOCFN
      FILNAM=LOCFN
      OPEN(KLOC,FILE=LOCFN,STATUS='OLD',ERR=81)
C
      READ(KCON,101,ERR=90)PEDFN
      FILNAM=PEDFN
      OPEN(KPED,FILE=PEDFN,STATUS='OLD',ERR=82)
C
      READ(KCON,101,ERR=90)RESFN
      FILNAM=RESFN
      OPEN(KRES,FILE=RESFN,STATUS='UNKNOWN',ERR=83)
      I=INDEX(FILNAM,' ')
      IF(I.LE.0)I=1
      STR=FILNAM(1:I-1)//'.detail'
      OPEN(KDET,FILE=STR(1:I+7),STATUS='UNKNOWN',ERR=83)
C
      WRITE(KRES,101)
      WRITE(KRES,102)
      WRITE(KRES,103)
      WRITE(KRES,104)
      WRITE(KRES,105)
      WRITE(KRES,206)
C
      WRITE(KRES,706)CONFN
 706  FORMAT(/' CONTROL FILE:   ',A48/) 
      WRITE(KRES,106)LOCFN
 106  FORMAT(' LOCUS FILE:   ',A48/) 
      WRITE(KRES,107)PEDFN
 107  FORMAT(' PEDIGREE FILE:   ',A48/) 
C
      READ(KCON,101,ERR=90)TYPE
      CALL MBLANK(TYPE)
      ALLPR=.FALSE. 
      IF(TYPE.EQ.'ALL'.OR.TYPE.EQ.'all')ALLPR=.TRUE.
C
      READ(KCON,101,ERR=90)ECHMAP
      CALL MBLANK(ECHMAP)
      WRTMAP=.FALSE.
      IF(ECHMAP(1:1).EQ.'Y'.OR.ECHMAP(1:1).EQ.'y')WRTMAP=.TRUE.
C
      READ(KCON,101,ERR=90)ECHPED
      CALL MBLANK(ECHPED)
      WRTPED=.FALSE.
      IF(ECHPED(1:1).EQ.'Y'.OR.ECHPED(1:1).EQ.'y')WRTPED=.TRUE.
C
      READ(KCON,101,ERR=90)XXSIGN
      READ(KCON,101,ERR=90)XYSIGN
      CALL MBLANK(XXSIGN)
      CALL MBLANK(XYSIGN)
C
      READ(KCON,108,ERR=90)MINSHR 
 108  FORMAT(I8)
      IF(MINSHR.LE.0)GO TO 85
C
      READ(KCON,114,ERR=90)GENERR
      IF(GENERR.LT.1.D-99)GO TO 95
C
 114  FORMAT(F8.6)
C
C OUTPUT OPTIONS:
C
C 1. OUTPUT PAIRS WHOSE PUTATIVE AND INFERRED RELATIONSHIPS DIFFER
C    AND WHOSE SHARED GENOTYPED LOCI AND INFERRED:PUTATIVE LIKELIHOOD
C    RATIO MEET THE USER'S SPECIFICATIONS. 
C
C 2. ALL PAIRS, REGARDLESS OF PUTATIVE AND INFERRED RELATIONSHIPS.
C
C NOTE: ANY DISCREPANCY BETWEEN PUTATIVE AND INFERRED RELATIONSHIPS
C WITHIN A FAMILY WILL CAUSE ALL PAIRS WITHIN THAT FAMILY TO BE OUTPUT
C IN THE .detail FILE, TO ASSIST IN TRACKING DOWN THE PROBLEM.  THIS IS 
C THE CASE FOR BOTH OUTPUT OPTIONS AND FOR BOTH "ALL PAIRS" AND "FAMILIES 
C ONLY" ANALYSES.
C
      READ(KCON,108,ERR=90)OUTTYPE   
      IF(OUTTYPE.NE.1.AND.OUTTYPE.NE.2)GO TO 110
C     
      READ(KCON,115,ERR=90)CRITVAL
115   FORMAT(F10.2)
C   
      IF(.NOT.ALLPR)GO TO 60
      WRITE(KOUT,101)' ANALYZING ALL POSSIBLE PAIRS OF INDIVIDUALS '
      WRITE(KOUT,101)'    IN THE DATA SET ...  '
      WRITE(KRES,109)
 109  FORMAT(' TYPE OF ANALYSIS: ALL PAIRS (OPTION=ALL)')
      GO TO 70
 60   WRITE(KOUT,101)' ANALYZING WITHIN FAMILIES ONLY ...  '
      WRITE(KRES,97)
 97   FORMAT(' TYPE OF ANALYSIS: WITHIN FAMILIES ONLY (OPTION=FAMILY)')
C      
 70   IF(OUTTYPE.EQ.1)WRITE(KRES,71)
      IF(OUTTYPE.EQ.2)WRITE(KRES,72)
 71   FORMAT(/,' TYPE OF OUTPUT: DIFFERENT INFERRED PAIRS ONLY '
     1,'(OPTION=1)')
 72   FORMAT(/,' TYPE OF OUTPUT: ALL TESTED PAIRS (OPTION=2)')
C
      WRITE(KRES,76)MINSHR
 76   FORMAT(/,' MINIMUM NUMBER OF GENOTYPED MARKERS SHARED: ',I5)
C
      WRITE(KRES,77)GENERR
 77   FORMAT(/' ASSUMED GENOTYPING ERROR RATE: ',F5.3)
C
      WRITE(KRES,78)CRITVAL
 78   FORMAT(/' CRITICAL VALUE OF THE INFERRED VS PUTATIVE LIKELIHOOD'
     1,/' RATIO FOR A PAIR TO BE OUTPUT ("CRITVAL"): ',F7.2)
C
C
      RETURN
C
 79   WRITE(KOUT,131)
 131  FORMAT(' *** ERROR *** UNABLE TO OPEN THE CONTROL FILE.')
      STOP
C
 80   WRITE(KOUT,111)
 111  FORMAT(' *** ERROR *** UNABLE TO OPEN TEMPORARY FILE.')
      STOP
C
 81   WRITE(KOUT,121)
 121  FORMAT(' *** ERROR *** UNABLE TO OPEN LOCUS FILE.')
      STOP
C
 82   WRITE(KOUT,122)
 122  FORMAT(' *** ERROR *** UNABLE TO OPEN PEDIGREE FILE.')
      STOP
C
 83   WRITE(KOUT,123)
 123  FORMAT(' *** ERROR *** UNABLE TO OPEN RESULTS FILE.'/
     1,15X,'PLEASE CHECK PERMISSIONS AND DISK SPACE.')
      STOP
C
 85   WRITE(KOUT,125)
 125  FORMAT(' *** ERROR *** MINIMUM NUMBER OF MARKERS SHARED FOR'
     1,' A PAIR'/,15X,'SHOULD BE GREATER THAN 0.')
      STOP
C
  90  WRITE(KOUT,112)
 112  FORMAT(' *** ERROR *** UNABLE TO READ PART OF CONTROL'
     1,' FILE. VERIFY THAT'/15X,'THE CONTROL FILE CONSISTS'
     2,' OF 12 ENTRIES WITH'/15X,'FORMATS AS IN THE'
     3,' DOCUMENTATION.')
      STOP
C
 95   WRITE(KOUT,96)
 96   FORMAT(' *** WARNING *** GENOTYPING ERROR RATE IS SET TO ZERO.')
C
 100  CALL MBLANK(FILNAM)
      I=INDEX(FILNAM,' ')
      IF(I.EQ.0)I=1
      WRITE(KOUT,113)FILNAM
 113  FORMAT(' *** ERROR *** UNABLE TO OPEN TEMPORARY FILE --',A
     1,' CHECK PERMISSIONS'/15X,'AND DISK SPACE.')
      STOP
C
 110  WRITE(KOUT,116)
 116  FORMAT(' *** ERROR *** OUTPUT TYPE SHOULD BE 1 (DISCREPANCIES)'
     1,' OR 2 (ALL).')
      STOP
C
      END
C
C
C
      SUBROUTINE DRAWLN(KDEV,NRET)
C
C DRAW A SEPARATING LINE IN THE SPECIFIED DEVICE.  INCLUDE
C NRET CARRIAGE RETURNS AT THE END.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
      WRITE(KDEV,101)
 101  FORMAT(1X,79('_'))
C
      IF(NRET.LE.0)GO TO 20
C
      DO 10 IRET=1,NRET
        WRITE(KDEV,*)
 10   CONTINUE
C
 20   RETURN
      END      
C
C
C
      SUBROUTINE MBLANK(STRING)
C
C THIS SUBROUTINE MOVES ALL BLANKS IN A CHARACTER STRING TO
C THE RIGHT END OF THE STRING.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
      CHARACTER C*1,STRING*(*)
C
      I=1
      LSTR=LEN(STRING)
      DO 20 J=1,LSTR
        IF(STRING(J:J).EQ.' ')GO TO 20
          IF(I.EQ.J)GO TO 10
            C=STRING(I:I)
            STRING(I:I)=STRING(J:J)
            STRING(J:J)=C
 10       I=I+1
 20   CONTINUE 
C
      RETURN
      END
C
C
C
      SUBROUTINE CHKPAR(MAXALL,MAXLOC)
C
C NOTIFY USER IF PROGRAM LIMITS OF ADJUSTABLE PARAMETERS ARE 
C EXCEEDED.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      COMMON /D2/KCON,KRES,KLOC,KPED,KIN,KOUT,KDET
C
      IF(MAXALL.GT.99)GO TO 10
      IF(MAXLOC.GT.10000)GO TO 20
C
      RETURN
C
 10   WRITE(KOUT,101)MAXALL
 101  FORMAT(' *** ERROR *** THE CODE PARAMETER "MAXALL" IS SET'
     1,' TO ',I4,'.'/15X,' IT MUST NOT EXCEED 99.')
      STOP
C
 20   WRITE(KOUT,102)MAXLOC
 102  FORMAT(' *** ERROR *** THE CODE PARAMETER "MAXLOC" IS SET'
     1,' TO ',I6,','/15X,' IT MUST NOT EXCEED 10000.')
      STOP
C
      END
C
C
C
      SUBROUTINE LOCFIL(ALLNAM,ICHROM,LOCNAM,NALL,NFRQPR,NLOCI
     1,NLOCIN,NOLINK,POSIT,THETA,TRMODE,WRTMAP,IPOSIX
     2,NXLINK,ALLFRQ,PSI,MAXALL,MAXLOC,PERM)
C      
C READ THE LOCUS FILE AND LOCUS POSITIONS AND ESTABLISH EQUIVALANCES 
C BETWEEN BAND SIZE ALLELES AND NUMBERED 1 TO NALL ALLELES.  ALSO SORT
C THE LOCI TO ENSURE THAT ALL X-LINKED MARKERS ARE LISTED AFTER ANY
C AUTOSOMAL MARKERS.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      COMMON /D2/KCON,KRES,KLOC,KPED,KIN,KOUT,KDET
C
      CHARACTER*8 ALLNAM(MAXALL,MAXLOC),TRMODE(MAXLOC)
      CHARACTER*32 LOCNAM(MAXLOC)
      CHARACTER*80 LINSTR
      CHARACTER*128 TMPFMT
      DOUBLE PRECISION MAPFUN,THETA(MAXLOC),ALLFRQ(MAXALL,MAXLOC)
     1,POSIT(MAXLOC),PSI(MAXLOC)
      INTEGER ICHROM(MAXLOC),NALL(MAXLOC),PERM(MAXLOC)
      LOGICAL NOLINK,WRTMAP,INFLD
C
C ALLOW FOR A FLEXIBLE COLUMN FORMAT IN THE LOCUS FILE.  ENTRIES NEED
C ONLY BE SEPARATED BY >= 1 SPACE.  THIS IS A BIT TRICKY TO DO IN FORTRAN.
C
      NLOCIN=0
      NLOCI=0
      NAUTO=0
      NXLINK=0
      NCZERO=0
C
C READ A MARKER NAME LINE.
C
 1    READ(KLOC,101,END=40)LINSTR
 101  FORMAT(A80)
      IFLD=0 
      INFLD=.FALSE.
      ISTART=1
C
C MAKE SURE IT'S OK TO BE FILLING IN ARRAYS INDEXED WITH NLOCIN.
C
      IF(NLOCIN.GT.MAXLOC)GO TO 300
      NLOCIN=NLOCIN+1 
      THETA(NLOCIN)=0.5D0
C
      DO 5 ICHAR=1,80
        IF(INFLD.AND.LINSTR(ICHAR:ICHAR).EQ.' ')THEN
C
C LEAVING A FIELD HERE.
C
          INFLD=.FALSE.
          IEND=ICHAR-1
          IFLDLEN=IEND-ISTART+1
C
          IF(IFLD.EQ.1)THEN
C
C FIRST FIELD: MARKER NAME.
C
            WRITE(TMPFMT,102)'(A',IFLDLEN,')'
 102        FORMAT(A2,I3,A1)
            CALL MBLANK(TMPFMT)
            READ(LINSTR(ISTART:IEND),TMPFMT)LOCNAM(NLOCIN)
C
          ELSE IF(IFLD.EQ.2)THEN
C
C SECOND FIELD: TRANSMISSION MODE.
C
            WRITE(TMPFMT,102)'(A',IFLDLEN,')'
            CALL MBLANK(TMPFMT)
            READ(LINSTR(ISTART:IEND),TMPFMT)TRMODE(NLOCIN)
            IF(TRMODE(NLOCIN).EQ.'AUTOSOME')THEN
              NAUTO=NAUTO+1    
            ELSE IF(TRMODE(NLOCIN).EQ.'X-LINKED')THEN
              NXLINK=NXLINK+1
            ELSE
              GO TO 250
            ENDIF
C
          ELSE IF(IFLD.EQ.3)THEN
C
C THIRD FIELD: NUMBER OF ALLELES.
C
            WRITE(TMPFMT,102)'(I',IFLDLEN,')'
            CALL MBLANK(TMPFMT)
            READ(LINSTR(ISTART:IEND),TMPFMT)NA
            IF(NA.GT.MAXALL)GO TO 270
            NALL(NLOCIN)=NA
C
          ELSE IF(IFLD.EQ.4)THEN
C
C FOURTH FIELD: CHROMOSOME NUMBER.
C
            WRITE(TMPFMT,102)'(I',IFLDLEN,')'
            CALL MBLANK(TMPFMT)
            READ(LINSTR(ISTART:IEND),TMPFMT)ICHROM(NLOCIN) 
C
          ELSE IF(IFLD.EQ.5)THEN
C
C FIFTH FIELD: POSITION.
C
            IND=INDEX(LINSTR(ISTART:IEND),'.')
            IF(IND.LE.0)GO TO 280
              WRITE(TMPFMT,103)'(F',IFLDLEN,'.',IFLDLEN-IND,')'
 103          FORMAT(A2,I3,A1,I3,A1)
              CALL MBLANK(TMPFMT)
              READ(LINSTR(ISTART:IEND),TMPFMT)POS
              IF(POS.LT.0.D0.OR.POS.GT.50.D0)GO TO 290
C
          ENDIF
        ELSE IF(.NOT.INFLD.AND.LINSTR(ICHAR:ICHAR).NE.' ')THEN
C
C ENTERING A NEW FIELD HERE.
C
          INFLD=.TRUE.
          ISTART=ICHAR
          IFLD=IFLD+1
        ENDIF
 5    CONTINUE
C 
C READ NAME AND FREQUENCY OF EACH ALLELE.
C
      AFTOT=0.D0
      DO 7 IALL=1,NA
        READ(KLOC,101)LINSTR
        IFLD=0 
        INFLD=.FALSE.
        DO 6 ICHAR=1,80
          IF(INFLD.AND.LINSTR(ICHAR:ICHAR).EQ.' ')THEN
C
C LEAVING A FIELD HERE.
C
            INFLD=.FALSE.
            IEND=ICHAR-1
            IFLDLEN=IEND-ISTART+1
C
            IF(IFLD.EQ.1)THEN
C
C FIRST FIELD: ALLELE NAME.
C
              WRITE(TMPFMT,102)'(A',IFLDLEN,')'
              CALL MBLANK(TMPFMT)
              READ(LINSTR(ISTART:IEND),TMPFMT)ALLNAM(IALL,NLOCIN)
C
            ELSE IF(IFLD.EQ.2)THEN
C
C SECOND FIELD: ALLELE FREQUENCY.
C
              IND=INDEX(LINSTR(ISTART:IEND),'.')
              IF(IND.LE.0)GO TO 295
                WRITE(TMPFMT,103)'(F',IFLDLEN,'.',IFLDLEN-IND,')'
                CALL MBLANK(TMPFMT)
                READ(LINSTR(ISTART:IEND),TMPFMT)AFRQ
                IF(AFRQ.LE.0.D0.OR.AFRQ.GT.1.D0)GO TO 340
                  AFTOT=AFTOT+AFRQ
                  ALLFRQ(IALL,NLOCIN)=AFRQ
C
            ENDIF
          ELSE IF(.NOT.INFLD.AND.LINSTR(ICHAR:ICHAR).NE.' ')THEN
C
C ENTERING A NEW FIELD HERE.
C
            INFLD=.TRUE.
            ISTART=ICHAR
            IFLD=IFLD+1
          ENDIF
 6      CONTINUE
 7    CONTINUE
C
C WE'VE READ IN ALL THE INFORMATION ABOUT THIS LOCUS.  SET GENOME-WIDE
C POSITIONS APPROPRIATELY AND UPDATE SOME COUNTS.
C
C CHECK FOR CHROMOSOME NUMBER OUT OF BOUNDS.
C
      ICHR=ICHROM(NLOCIN)
      P=0.D0
      IF(ICHR.GE.1.D4)GO TO 110
C
C OTHERWISE, INTERPRET THE CHROMOSOME NUMBER AND MAKE SURE X-LINKED
C LOCI ARE PLACED AFTER AUTOSOMES.
C
      IF(ICHR.LT.0)THEN
C
C SKIP THIS LOCUS.  MAKE ITS POSITION HUGE SO IT SORTS TO THE END OF
C THE ARRAY.
C
        P=2.D6+NLOCIN
C
      ELSE IF(ICHR.EQ.0)THEN
C
C ASSUMING THAT THIS HOLDS FOR ALL LOCI (CHECKED LATER), ASSIGN 
C POSITIONS SUCH THAT LOCI WILL BE UNLINKED, WITH X-LINKED LOCI AT 
C THE END.
C
        NLOCI=NLOCI+1
        NCZERO=NCZERO+1
        IF(TRMODE(NLOCIN).EQ.'AUTOSOME')THEN
          P=100.D0*NLOCIN
        ELSE
          P=100.D0*(MAXLOC+NLOCIN)
        ENDIF
C
      ELSE IF(ICHR.GT.0)THEN
C
C BASE POSITION ON CHROMOSOME NUMBER, LEAVING ENOUGH SPACE SO THAT
C ADJACENT CHROMOSOMES ARE UNLINKED AND AGAIN PUTTING X-LINKED LOCI
C AFTER AUTOSOMES.
C
        NLOCI=NLOCI+1
        IF(TRMODE(NLOCIN).EQ.'AUTOSOME')THEN
          P=ICHR*100.D0+POS
        ELSE
          P=1.D6+ICHR*100.D0+POS
        ENDIF
      ENDIF
C
      POSIT(NLOCIN)=P
C
C IF ALLELE FREQUENCIES AT THIS LOCUS DO NOT SUM TO 1, WARN THE
C USER AND RESCALE ALLELE FREQUENCIES.  THE PARAMETER NFRQPR
C DETERMINES THE NUMBER OF SIGNIFICANT DIGITS TO WHICH WE CARRY
C THIS CALCULATION.
C
      AFSLOP=1.D0
      DO 175 I=1,NFRQPR
        AFSLOP=AFSLOP*1.D-1
 175  CONTINUE
      AFLOW=1.D0-AFSLOP
      AFHI=1.D0+AFSLOP
      IF(AFTOT.LT.AFLOW.OR.AFTOT.GT.AFHI)THEN
        WRITE(KOUT,111)LOCNAM(NLOCIN),AFTOT
        DO 180 IALL=1,NA
          ALLFRQ(IALL,NLOCIN)=ALLFRQ(IALL,NLOCIN)/AFTOT
 180    CONTINUE
      ENDIF
C
C LOOP BACK TO HANDLE THE NEXT LOCUS.
C
      GO TO 1
C
C WE'VE READ IN ALL THE LOCI, SO DO SOME GLOBAL WORK.  IF ALL
C CHROMOSOMES ARE GIVEN AS 0, ASSUME ALL LOCI ARE UNLINKED.
C
 40   IF(NCZERO.NE.0.AND.NCZERO.NE.NLOCI)GO TO 310
      NOLINK=.FALSE.
      IF(NCZERO.EQ.NLOCI)NOLINK=.TRUE.
C
C STORE THE INDEX OF THE FIRST X-LINKED LOCUS.
C
      IF(NXLINK.GT.0)IPOSIX=NAUTO+1
C
C SORT THE LOCI IN GENOME ORDER AND CALCULATE THE RECOMBINATION 
C FRACTIONS BETWEEN THEM.  NOTE THAT THETA WAS SET TO 0.5 EARLIER
C BY DEFAULT.
C
      CALL INDEXX(POSIT,PERM,NLOCIN,MAXLOC)
C
      IF(WRTMAP)THEN
        WRITE(KOUT,106)
 106    FORMAT(' WRITING MARKER MAP TO RESULTS FILE ... ')
        CALL DRAWLN(KRES,1)
        WRITE(KRES,107)
 107    FORMAT(' *** MARKERS USED IN ANALYSIS *** ')
        CALL DRAWLN(KRES,1)
        WRITE(KRES,888)
 888    FORMAT('   MARKER   CHROM   POSITION ')
      ENDIF
C
      ICHRPR=100000
      DO 70 LOCUS=1,NLOCI-1
        IPRML=PERM(LOCUS)
        ICHR=ICHROM(IPRML)
        IF(WRTMAP)THEN
          IF(ICHR.NE.ICHRPR)CALL DRAWLN(KRES,1)
          IF(ICHR.GT.0)WRITE(KRES,889)LOCNAM(IPRML),ICHR
     1    ,DMOD(POSIT(IPRML),100.D0)
 889      FORMAT(2X,A8,3X,I2,5X,F6.3)
        ENDIF
C      
        DIFF=POSIT(PERM(LOCUS+1))-POSIT(IPRML) 
        IF(.NOT.NOLINK.AND.DIFF.LT.50.D0)THETA(LOCUS)=MAPFUN(DIFF)
        ICHRPR=ICHR      
 70   CONTINUE
C
      IF(WRTMAP)THEN
        IPRML=PERM(NLOCI)
        ICHR=ICHROM(IPRML)
        WRITE(KRES,889)LOCNAM(IPRML),ICHR,DMOD(POSIT(IPRML),100.D0)
      ENDIF
C
C CALCULATE SOME ELEMENTS OF THE TRANSITION MATRIX FOR LATER USE.
C
 80   DO 160 LOCUS=1,NLOCI
        TH=THETA(LOCUS)
        PSI(LOCUS)=TH*TH+(1.D0-TH)*(1.D0-TH)
 160  CONTINUE
C
C DO SOME HOUSEKEEPING:  NO LONGER NEED LOCUS FILE.
C
      CLOSE(KLOC)
C
      RETURN
C
 110  WRITE(KOUT,202)LOCNAM(NLOCIN)
 202  FORMAT(' *** ERROR *** FOR LOCUS ',A,' IN THE LOCUS FILE,'
     1,' THE CHROMOSOME'/17X,' NUMBER IS GREATER THAN 9999.  THE,'
     2,' LOCUS FILE FORMAT'/17X,' SPECIFIES THAT CHROMOSOMES SHOULD,'
     3,' BE GIVEN AS'/17X,' INTEGERS OF NO MORE THAN FOUR DIGITS.')
      STOP
C
 111  FORMAT(' *** WARNING *** FOR LOCUS ',A,' IN THE LOCUS FILE,'
     1,' THE GIVEN ALLELE'/17X,' FREQUENCIES SUM TO ',F8.5,' INSTEAD'
     2,' OF SUMMING TO 1.'/17X,' THE ALLELE FREQUENCIES HAVE BEEN'
     3,' RESCALED ACCORDINGLY.')
C
 200  IF(NLOCIN.GT.0)GO TO 210
        WRITE(KOUT,112)
 112    FORMAT(' *** ERROR *** PROBLEM READING FIRST LINE OF LOCUS'
     1  ,' FILE.')
        STOP
C
 210  WRITE(KOUT,113)LOCNAM(NLOCIN)
 113  FORMAT(' *** ERROR *** PROBLEM READING LOCUS FILE AT OR NEAR'
     1,' LOCUS ',A,'.')
      STOP
C
 250  WRITE(KOUT,115)LOCNAM(NLOCIN)
 115  FORMAT(' *** ERROR *** FOR LOCUS ',A,' IN THE LOCUS FILE, THE'
     1,' MODE OF TRANSMISSION'/15X,' IS OMITTED OR IMPROPERLY'
     2,' SPECIFIED.  IT MUST BE'/15X,' EITHER "AUTOSOME" OR'
     3,' "X-LINKED".')
      STOP
C
 270  WRITE(KOUT,117)LOCNAM(NLOCIN),NA,MAXALL
 117  FORMAT(' *** ERROR *** FOR LOCUS ',A,' IN THE LOCUS FILE, THE'
     1,' NUMBER OF ALLELES'/15X,' IS ',I4,', WHICH IS GREATER THAN'
     2,' THE ALLOWABLE LIMIT OF ',I2,'.'//15X,' THIS LIMIT MAY BE'
     3,' SET AS HIGH AS 99 BY MODIFYING THE VALUE'/15X,' OF THE'
     4,' CODE PARAMETER "MAXALL".')
      STOP
C
 280  WRITE(KOUT,118)LOCNAM(NLOCIN)
 118  FORMAT(' *** ERROR *** FOR LOCUS ',A,' IN THE LOCUS FILE, THE'
     1,' POSITION ',/15X,' NEEDS TO BE WRITTEN IN FLOATING POINT'
     2,' FORMAT.')
      STOP
C
 290  WRITE(KOUT,119)LOCNAM(NLOCIN),POS
 119  FORMAT(' *** ERROR *** FOR LOCUS ',A,' IN THE LOCUS FILE, THE'
     1,' POSITION IS ',F16.8/15X,' IT SHOULD BE BETWEEN 0 AND 50'
     2,' MORGANS.')
      STOP
C
 295  WRITE(KOUT,120)LOCNAM(NLOCIN),ALLNAM(IALL,NLOCIN)
 120  FORMAT(' *** ERROR *** FOR LOCUS ',A,' IN THE LOCUS FILE, THE'
     1,' FREQUENCY ',/15X,' OF ALLELE ',A,' NEEDS TO BE WRITTEN IN'
     2,' FLOATING POINT FORMAT.')
      STOP
C
 300  WRITE(KOUT,121)NLOCIN,MAXLOC
 121  FORMAT(' *** ERROR *** THE NUMBER OF LOCI OBSERVED IN THE'
     1,' LOCUS FILE'/15X,' IS ',I6,', WHICH IS GREATER THAN THE'
     2,' ALLOWABLE LIMIT OF ',I5,'.'//15X,' THIS LIMIT MAY BE SET'
     3,' AS HIGH AS 10000 BY MODIFYING THE VALUE'/15X,' OF THE CODE'
     4,' PARAMETER "MAXLOC".')
      STOP
C
 310  WRITE(KOUT,122)
 122  FORMAT(' *** ERROR *** SINCE AT LEAST ONE CHROMOSOME NUMBER'
     1,' WAS BLANK OR ZERO,'/15X,' ALL OTHER CHROMOSOME NUMBERS'
     2,' MUST ALSO BE'/15X,' BLANK OR ZERO.')
      STOP
C
 340  WRITE(KOUT,125)LOCNAM(NLOCIN),ALLNAM(IALL,NLOCIN),AFRQ
 125  FORMAT(' *** ERROR *** FOR LOCUS ',A,' IN THE LOCUS FILE,'
     1,' ALLELE ',A,' IS'/15X,' ASSIGNED A FREQUENCY OF ',F16.8/15X
     2,' ALLELE FREQUENCIES MUST BE STRICTLY GREATER THAN 0 AND'/15X
     3,' NO LARGER THAN 1.')
      STOP
C
      END
C
C
C
      FUNCTION MAPFUN(X)
C
C DETERMINE THE RECOMBINATION FRACTION CORRESPONDING TO MAP DISTANCE
C X MORGANS (100X cM) BY USING KOSAMBI'S MAP FUNCTION.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
      DOUBLE PRECISION MAPFUN
      Y=DEXP(4.D0*X)
      MAPFUN=(Y-1.D0)/(Y+1.D0)/2.D0
C
      RETURN
      END
C
C
C
      SUBROUTINE START(KTAB2,KTAB1,MAXREL,KNUFF)
C
C INITIALIZE COUNTS.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
      INTEGER KTAB2(MAXREL,MAXREL),KTAB1(MAXREL,MAXREL)
C
C INITIALIZE.
C
      KNUFF=0
C
      DO 20 IREL=1,MAXREL
        DO 10 JREL=1,MAXREL
          KTAB1(IREL,JREL)=0
          KTAB2(IREL,JREL)=0
 10     CONTINUE
 20   CONTINUE
C
      RETURN
      END
C
C
      SUBROUTINE MODPED(ALLNAM,ALLPR,ID,LOCNAM,MAXPEO
     1,NALL,NFXTOT,NLOCI,NLOCIN,NPAIR,NPED,NRNTOT,KDISC,P1ID,P2ID
     2,PEDID,SEX,TWIN,WRTPED,XXSIGN,XYSIGN,NXLINK,GP1ID
     3,GP2ID,GP3ID,GP4ID,IGENES,MAXLOC,MXPTOT,MAXALL,MAXREL
     4,MAXFAM,FAMPRS,PERM)
C
C READ THE OLD PEDIGREE FILE AND OUTPUT THE NEW PEDIGREE INFORMATION.  
C THE NEW FORMAT WILL HAVE ONLY THE ADEQUATELY DESCRIBED MEMBERS, IT 
C WILL USE THE 1 TO NALL ALLELE DESIGNATIONS, AND GENOTYPES WILL 
C NOT BE SPLIT BY SLASHES.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      COMMON /D2/KCON,KRES,KLOC,KPED,KIN,KOUT,KDET
      COMMON /D3/MINTYP
C
      CHARACTER*8 ALLNAM(MAXALL,MAXLOC),ID(MXPTOT),IDTEMP(MAXPEO)
     1,P1ID(MXPTOT),P2ID(MXPTOT),PEDID(MXPTOT),FAMID,SEX(MXPTOT)
     2,TWIN(MXPTOT),XXSIGN,XYSIGN,GP1ID(MXPTOT),P1TEMP(MAXPEO)
     3,GP2ID(MXPTOT),GP3ID(MXPTOT),GP4ID(MXPTOT),P2TEMP(MAXPEO)
      CHARACTER*17 CGENO(MAXPEO,MAXLOC),TGENO(MAXLOC)
      CHARACTER*32 LOCNAM(MAXLOC)
      CHARACTER*72 FRMT1,FRMT2
      INTEGER NALL(MAXLOC),IGENES(0:1,MAXLOC,MXPTOT),PERM(MAXLOC)
     1,FAMPRS(MAXFAM),KDISC(MAXFAM)
      LOGICAL ALLPR,WRTPED
C
C PROMPT THE USER, SINCE THIS STAGE MAY TAKE A WHILE.  OUTPUT
C PEDIGREE FILE IF REQUESTED.
C
      IF(.NOT.WRTPED)GO TO 1
      WRITE(KOUT,101)
 101  FORMAT(' WRITING PEDIGREE INFORMATION TO RESULTS FILE ... ')
      CALL DRAWLN(KRES,1)
      WRITE(KRES,102)
 102  FORMAT(' *** PEDIGREE INFORMATION *** ')
      CALL DRAWLN(KRES,1)
      GO TO 2
 1    WRITE(KOUT,103)' PROCESSING PEDIGREE FILE ... '
 103  FORMAT(A)
C
C READ THE PEDIGREE FORMATS.
C
 2    READ(KPED,103,ERR=90)FRMT1
      READ(KPED,103,ERR=90)FRMT2
      CALL MBLANK(FRMT1)
      CALL MBLANK(FRMT2)
C
C OUTPUT FORMATS TO RESULTS FILE IF REQUESTED.  DO SO BEFORE
C ERROR CHECKING AS AN AID TO THE USER IN TRACKING DOWN PROBLEMS.
C
      IF(.NOT.WRTPED)GO TO 3
        WRITE(KRES,103)' INPUT FORMATS: '
        WRITE(KRES,103) FRMT1
        WRITE(KRES,103) FRMT2
        CALL DRAWLN(KRES,1)
C
C CHECK FOR MISSING OR INVALID INPUT FORMATS.
C
      IF(FRMT1(1:1).EQ.' '.OR.FRMT2(1:1).EQ.' ')GO TO 90
      IF(FRMT1(1:1).NE.'('.OR.FRMT2(1:1).NE.'(')GO TO 90
C
C NPED IS THE NUMBER OF FAMILIES CURRENTLY READ IN.  NRNTOT GIVES
C A RUNNING TOTAL OF THE INDIVIDUALS READ IN WHO MEET THE ANALYSIS
C CRITERIA.
C
 3    NPED=0
      NRNTOT=0
C
C WHILE PEDIGREES REMAIN, FIND ALL PUTATIVE FULL SIB PAIRS (INCLUDING
C TWINS).  FOR EACH SIB, AT EACH LOCUS, CONVERT THE BAND-LENGTH GENOTYPE
C TO A 1 TO NALL GENOTYPE.  FOR EACH SIB PAIR, WRITE OUT THEIR MODIFIED
C DATA.  INCLUDE ONLY THOSE LOCI THAT ARE TO BE USED IN THE ANALYSIS.
C
 5    READ(KPED,FRMT1,END=80,ERR=100)NPEO,FAMID
      CALL MBLANK(FAMID)
C    
      IF(WRTPED)WRITE(KRES,FRMT1)NPEO,FAMID
C
C UPDATE THE COUNTS.  NFXTOT GIVES THE "FIXED" TOTAL OF INDIVIDUALS
C MEETING THE ANALYSIS CRITERIA UP TO BUT NOT INCLUDING THE CURRENT
C FAMILY.  THUS, NRNTOT-NFXTOT GIVES THE NUMBER OF INDIVIDUALS IN
C THE CURRENT FAMILY WHO MEET THE ANALYSIS CRITERIA.
C
      NFXTOT=NRNTOT
      NPED=NPED+1
      IF(NPED.GT.MAXFAM)GO TO 110
      KDISC(NPED)=0
      FAMPRS(NPED)=0
C
C WARN WHEN FAMILY ID MISSING IN ALL PAIRS CASE.
C
      IF(ALLPR.AND.FAMID(1:1).EQ.' ')WRITE(KOUT,114)NPED
C
C PEDIGREES CAN HAVE AT MOST MAXPEO PEOPLE AND MUST HAVE AT LEAST 1.
C SINCE NPEO=0 IS INVALID, THIS CHECK ALSO HANDLES A BLANK FIELD.
C
      IF(NPEO.LT.1.OR.NPEO.GT.MAXPEO)GO TO 120
C
C SAVE THE GENOTYPES FOR ALL THE MEMBERS IN THIS PEDIGREE WHO HAVE 
C SUFFICIENT DATA PRESENT.
C
      DO 30 IPEO=1,NPEO
        NRNTOT=NRNTOT+1
        IF(NRNTOT.GT.MXPTOT)GO TO 130
        READ(KPED,FRMT2,END=80,ERR=140)ID(NRNTOT),P1ID(NRNTOT)
     1  ,P2ID(NRNTOT),SEX(NRNTOT),TWIN(NRNTOT),(CGENO(NRNTOT-NFXTOT
     1  ,LOCUS),LOCUS=1,NLOCIN)
C
        CALL MBLANK(ID(NRNTOT))
        CALL MBLANK(P1ID(NRNTOT))
        CALL MBLANK(P2ID(NRNTOT))
        CALL MBLANK(SEX(NRNTOT))
        CALL MBLANK(TWIN(NRNTOT))       
C
C CGENO WAS READ IN BASED ON THE GENOTYPE ORDER IN THE PEDIGREE FILE, 
C WHILE TGENO IS IN GENOME ORDER.
C
        DO 35 LOCUS=1,NLOCI
          IPRML=PERM(LOCUS)
          CALL MBLANK(CGENO(NRNTOT-NFXTOT,IPRML))
          TGENO(LOCUS)=CGENO(NRNTOT-NFXTOT,IPRML)  
 35     CONTINUE
C
        PEDID(NRNTOT)=FAMID
C
C OUTPUT PEDIGREE INFORMATION TO RESULTS FILE IF REQUESTED.  DO SO
C BEFORE ERROR CHECKING TO AID THE USER IN TRACKING DOWN PROBLEMS.
C NOTE THAT GENOTYPES ARE OUTPUT IN GENOME ORDER, AND GENOTYPES FOR
C MARKERS NOT USED IN THE ANALYSIS ARE OMITTED.  THIS CORRESPONDS TO
C THE WAY THE LOCUS FILE WAS OUTPUT.
C
        IF(WRTPED)WRITE(KRES,FRMT2)ID(NRNTOT),P1ID(NRNTOT),P2ID(NRNTOT)
     1  ,SEX(NRNTOT),TWIN(NRNTOT),(TGENO(LOCUS),LOCUS=1,NLOCI)
C
C ALLOW FOR '0' AS MISSING PARENT CODE.
C
        IF(P1ID(NRNTOT).EQ.'0       ')P1ID(NRNTOT)(1:1)=' '
        IF(P2ID(NRNTOT).EQ.'0       ')P2ID(NRNTOT)(1:1)=' '
C
C CHECK FOR THE FOLLOWING ERRORS:
C   MISSING PEDIGREE MEMBER ID.
C   MEMBER ID MATCHES THAT OF OWN PARENT.
C   INVALID SEX CODE.
C
        IF(ID(NRNTOT)(1:1).EQ.' ')GO TO 150
        IF(ID(NRNTOT).EQ.P1ID(NRNTOT).OR.ID(NRNTOT).EQ.P2ID(NRNTOT))
     1    GO TO 160
        IF(SEX(NRNTOT).NE.XXSIGN.AND.SEX(NRNTOT).NE.XYSIGN.AND
     1    .SEX(NRNTOT)(1:1).NE.' ')GO TO 170
C
C STORE ALL IDS AND PARENTS FOR SUBSEQUENT IDENTIFICATION OF GRANDPARENTS.
C
        IDTEMP(IPEO)=ID(NRNTOT)
        P1TEMP(IPEO)=P1ID(NRNTOT)
        P2TEMP(IPEO)=P2ID(NRNTOT)
C
C IF THERE AREN'T ENOUGH GENOTYPES, DON'T SAVE THIS PERSON FOR ANALYSIS.
C
 10     NTYPE=0
        DO 20 LOCUS=1,NLOCI
          IF(TGENO(LOCUS)(1:1).NE.' ')NTYPE=NTYPE+1
 20     CONTINUE
C  
        IF(NTYPE.LT.MINTYP)NRNTOT=NRNTOT-1
C
 30   CONTINUE
C
C  FIND GRANDPARENTAL IDS OF THOSE PEOPLE SAVED FOR ANALYSIS. 
C
      DO 34 IPEO=NFXTOT+1,NRNTOT
        GP1ID(IPEO)='        '
        GP2ID(IPEO)='        '
        IF(P1ID(IPEO)(1:1).NE.' ')THEN
          DO 31 JPEO=1,NPEO
            IF(IDTEMP(JPEO).EQ.P1ID(IPEO))THEN
              GP1ID(IPEO)=P1TEMP(JPEO)
              GP2ID(IPEO)=P2TEMP(JPEO)
              GO TO 32
            ENDIF
 31       CONTINUE
        ENDIF
C
 32     GP3ID(IPEO)='        '
        GP4ID(IPEO)='        '
        IF(P2ID(IPEO)(1:1).NE.' ')THEN
          DO 33 JPEO=1,NPEO
            IF(IDTEMP(JPEO).EQ.P2ID(IPEO))THEN
              GP3ID(IPEO)=P1TEMP(JPEO)
              GP4ID(IPEO)=P2TEMP(JPEO)
              GO TO 34
            ENDIF
 33       CONTINUE
        ENDIF
 34   CONTINUE
C
      NFMCUR=NRNTOT-NFXTOT
      IF(NFMCUR.NE.1)GO TO 40
        IF(ALLPR)GO TO 50
          NRNTOT=NRNTOT-1
          GO TO 5
 40   IF(NFMCUR.EQ.0)GO TO 5
C
C WRITE OUT THE PERTINENT INFO INTO THE IGENES ARRAY IN GENOME ORDER.
C
 50   DO 70 ISIB=NFXTOT+1,NRNTOT
        DO 60 LOCUS=1,NLOCI
          IPRML=PERM(LOCUS)
          CALL GETGEN(ALLNAM,ISIB-NFXTOT,LOCNAM,IPRML,MAXALL,MAXLOC
     1    ,NALL,NEW1,NEW2,FAMID,CGENO(ISIB-NFXTOT,IPRML))
          IGENES(0,LOCUS,ISIB)=NEW1
          IGENES(1,LOCUS,ISIB)=NEW2
 60     CONTINUE
 70   CONTINUE    
      GO TO 5 
C
C DO SOME HOUSEKEEPING:  NO LONGER NEED PEDIGREE FILE.
C
 80   CLOSE(KPED) 
      RETURN
C
 90   WRITE(KOUT,104)
 104  FORMAT(' *** ERROR *** PROBLEM READING FORMAT STATEMENTS'
     1,' AT TOP OF'/15X,'PEDIGREE FILE.')
      STOP
C
 100  WRITE(KOUT,105)NPED+1
 105  FORMAT(' *** ERROR *** IN PEDIGREE NUMBER ',I6,' IN THE'
     1,' PEDIGREE FILE,'/15X,'THERE IS A PROBLEM READING'
     2,' INDIVIDUAL NUMBER,'/15X,'AND/OR PEDIGREE NAME ENTRIES'
     3,' AT THE BEGINNING,'/15X,'OF THE PEDIGREE.')
      STOP
C
 110  WRITE(KOUT,106)MAXFAM
 106  FORMAT(' *** ERROR *** THE NUMBER OF FAMILIES IN THE'
     1,' PEDIGREE FILE EXCEEDS'/15X,'THE MAXIMUM LIMIT OF '
     2,I6,'.  TO INCREASE THIS LIMIT,'/15X,'MODIFY THE CODE'
     3,' PARAMETER "MAXFAM".')
      STOP
C
 120  WRITE(KOUT,107)NPED,NPEO,MAXPEO
 107  FORMAT(' *** ERROR *** IN PEDIGREE NUMBER ',I6,' IN THE'
     1,' PEDIGREE FILE,'/15X,'THE NUMBER OF PEOPLE SPECIFIED'
     2,' IS ',I6,', WHICH'/15X,'IS OUT OF RANGE.  THE CURRENT'
     3,' UPPER LIMIT'/15X,'IS ',I4,'.'//15X,'THIS LIMIT MAY BE'
     4,' SET HIGHER BY MODIFYING THE VALUE'/15X,'OF THE CODE'
     5,' PARAMETER "MAXPEO".')
      STOP
C
 130  WRITE(KOUT,108)MXPTOT
 108  FORMAT(' *** ERROR *** THERE ARE MORE THAN ',I6,' INDIVIDUALS'
     1,' IN THE DATA SET.'/' THE CODE PARAMETER "MXPTOT" NEEDS TO'
     2,' BE INCREASED.')
      STOP
C
 140  WRITE(KOUT,109)NPED,NRNTOT-NFXTOT
 109  FORMAT(' *** ERROR *** IN PEDIGREE NUMBER ',I6,' IN THE'
     1,' PEDIGREE FILE,'/15X,'THERE IS A PROBLEM READING PERSON'
     2,' NUMBER ',I4,'.')
      STOP
C
 150  WRITE(KOUT,111)NPED,NRNTOT-NFXTOT
 111  FORMAT(' *** ERROR *** IN PEDIGREE NUMBER ',I6,' IN THE'
     1,' PEDIGREE FILE,'/15X,'PERSON NUMBER ',I4,' IS MISSING'
     2,' ITS MEMBER IDENTIFIER.')
      STOP
C
 160  WRITE(KOUT,112)NPED,NRNTOT-NFXTOT
 112  FORMAT(' *** ERROR *** IN PEDIGREE NUMBER ',I6,' IN THE'
     1,' PEDIGREE FILE,'/15X,'PERSON NUMBER ',I4,' HAS A PARENT'
     2,' WHICH MATCHES,'/15X,'THE MEMBER IDENTIFIER.')
      STOP
C
 170  WRITE(KOUT,113)NPED,NRNTOT-NFXTOT,SEX(NRNTOT),XXSIGN,XYSIGN
 113  FORMAT(' *** ERROR *** IN PEDIGREE NUMBER ',I6,' IN THE'
     1,' PEDIGREE FILE,'/15X,'PERSON NUMBER ',I4,' HAS SEX CODE'
     2,' "',A8,'", WHICH'/15X,'IS INVALID.  SEX CODES MUST BE'
     3,' "',A8,'" OR "',A8,'".')
      STOP
C
 114  FORMAT(' *** WARNING *** IN PEDIGREE NUMBER ',I6,' IN THE'
     1,' PEDIGREE FILE,'/17X,'THE PEDIGREE IDENTIFIER IS MISSING.'
     2,'  SINCE ANALYSIS HAS'/17X,'BEEN REQUESTED FOR ALL PAIRS'
     3,' OF INDIVIDUALS IN'/17X,'THE DATABASE, PEDIGREES SHOULD BE'
     4,' UNIQUELY IDENTIFIED.') 
C
      END
C
C
C
      SUBROUTINE GETGEN(ALLNAM,IJSIB,LOCNAM,LOCUS,MAXALL
     1,MAXLOC,NALL,NEW1,NEW2,PEDID,GTYPE)
C	
C THIS SUBROUTINE CONVERTS A BAND-LENGTH GENOTYPE INTO A 1 TO NALL
C GENOTYPE.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      COMMON /D2/KCON,KRES,KLOC,KPED,KIN,KOUT,KDET
C
      INTEGER KALL(2),NALL(MAXLOC)
      CHARACTER*8 ALLNAM(MAXALL,MAXLOC),C(2),PEDID
      CHARACTER*17 GTYPE
      CHARACTER*32 LOCNAM(MAXLOC)
C
C IF THIS GENOTYPE IS MISSING, RETURN WITH A GENOTYPE OF 00.
C
      NEW1=0
      NEW2=0
      CALL MBLANK(GTYPE)
      IF(GTYPE(1:1).EQ.' ')GO TO 30
C
C LOCATE THE SEPARATING SLASH IN THE ORIGINAL GENOTYPE.
C
      I=INDEX(GTYPE,'/')
      LGTYPE=LEN(GTYPE)
C 
      IF(I.LE.1.OR.I.GE.LGTYPE)GO TO 40
        C(1)=GTYPE(1:MIN(8,I-1))
        C(2)=GTYPE(I+1:MIN(I+8,LGTYPE))
      
C
C IDENTIFY THE TWO ALLELES IN THE ORIGINAL GENOTYPE.
C
        DO 20 I=1,2
          DO 10 J=1,NALL(LOCUS)
            IF(C(I).NE.ALLNAM(J,LOCUS))GO TO 10
              KALL(I)=J
              GO TO 20
 10       CONTINUE
          GO TO 50
 20     CONTINUE
C
        NEW1=KALL(1)
        NEW2=KALL(2)
C
 30     RETURN
C
C IF AN ALLELE ISN'T FOUND OR THERE IS NO SLASH IN THE GENOTYPE, 
C OUTPUT AN ERROR MESSAGE AND STOP.
C
 40   WRITE(KOUT,101)GTYPE,LOCUS,IJSIB,PEDID
 101  FORMAT(' *** ERROR *** NO SLASH PRESENT IN GENOTYPE ',A8,' AT'
     1,' LOCUS NUMBER ',I4/' FOUND IN DESCENDENT NUMBER ',I4,' IN '
     2,' PEDIGREE ',A8/,'.')
      STOP
C
 50   WRITE(KOUT,102)C(I),LOCUS,IJSIB,PEDID
 102  FORMAT(' *** ERROR *** ALLELE ',A8,' AT LOCUS NUMBER ',I4
     1,' FOUND IN DESCENDENT'/15X,' NUMBER ',I4,' IN PEDIGREE '
     2,A8,' IS NOT IN'/15X,' THE LOCUS FILE.')
      STOP
C
      END
C 
C
C
      SUBROUTINE ANALYZ(ALLPR,IPOSIX,ID,MAXALL,MAXFAM,MAXLOC,MAXREL
     1,MINSHR,MXPTOT,NFAM,NLOCI,NRNTOT,NTYPE2,KDISC,P1ID,P2ID,PEDID
     2,PRLIK,PRMAX,PRREL,IPUTREL,TWIN,THETA,SEX,NXLINK,OUTTYPE,GP1ID
     3,GP2ID,GP3ID,GP4ID,XXSIGN,XYSIGN,NPAIR,GENERR,IGENES,PSI,ALLFRQ
     4,KTAB2,CRITVAL,BUFF,IBUFF,FAMPRS,FAMBUF,IFAMBUF,PERM,KTAB1,KNUFF)
C
C EXAMINE ALL MEMBER PAIRS AND PERFORM LIKELIHOOD ANALYSIS ON 
C THOSE PAIRS WHICH MEET THE PROPER CRITERIA.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      COMMON /D1/ITWIN,IFULL,IPOFF,IHALF,IGRCH,IAVNC,ICOUS,IRAND
      COMMON /D2/KCON,KRES,KLOC,KPED,KIN,KOUT,KDET
C
      CHARACTER*8 ID(MXPTOT),IDI,IDJ,P1ID(MXPTOT),P2ID(MXPTOT),P1I
     1,P2I,P1J,P2J,PEDID(MXPTOT),FAMIDI,TWIN(MXPTOT),SEX(MXPTOT)
     2,SEXI,SEXJ,GP1I,GP2I,GP3I,GP4I,GP1J,GP2J,GP3J,GP4J
     3,GP1ID(MXPTOT),GP2ID(MXPTOT),GP3ID(MXPTOT),GP4ID(MXPTOT)
     4,XXSIGN,XYSIGN,TWINI,TWINJ
      CHARACTER*5000000 BUFF(MAXREL)
      CHARACTER*5000000 FAMBUF
      DOUBLE PRECISION PRLIK(MAXREL),PRREL(MAXREL),THETA(MAXLOC)
     1,ALLFRQ(MAXALL,MAXLOC),PSI(MAXLOC)
      INTEGER OUTTYPE,XTYPE,KTAB1(MAXREL,MAXREL),KTAB2(MAXREL,MAXREL)
     1,IGENES(0:1,MAXLOC,MXPTOT),IBUFF(MAXREL),FAMPRS(MAXFAM),IFAMBUF
     2,KDISC(MAXFAM),PERM(MAXLOC)
      LOGICAL ALLPR,DIFFAM,XLINK,HAVP1I,HAVP2I
     1,HAVP1J,HAVP2J,HAVGP1I,HAVGP2I,HAVGP3I,HAVGP4I,HAVTWNI
C
C INITIALIZE.
C
      NPAIR=0
      NFAM=0
C
      WRITE(KOUT,101)NRNTOT
 101  FORMAT(I10,' INDIVIDUALS MEET ANALYSIS CRITERIA ...')
      IF(ALLPR)THEN
        NTOTPAIR=NRNTOT*(NRNTOT-1)/2
        WRITE(KOUT,102)NTOTPAIR
      ENDIF
 102  FORMAT(I10,' PAIRS WILL BE EXAMINED ...')    
C    
      DO 50 ISIB=1,NRNTOT-1
C  
        IDI=ID(ISIB)
        P1I=P1ID(ISIB)
        P2I=P2ID(ISIB)
        HAVP1I=P1I(1:1).NE.' '
        HAVP2I=P2I(1:1).NE.' '
        TWINI=TWIN(ISIB)
        HAVTWNI=TWINI(1:1).NE.' '
        FAMIDI=PEDID(ISIB)                 
        IF(ISIB.EQ.1.OR.FAMIDI.NE.PEDID(ISIB-1))THEN
          NFAM=NFAM+1
        ENDIF
        GP1I=GP1ID(ISIB)
        GP2I=GP2ID(ISIB)
        GP3I=GP3ID(ISIB)
        GP4I=GP4ID(ISIB)
        HAVGP1I=GP1I(1:1).NE.' '
        HAVGP2I=GP2I(1:1).NE.' '
        HAVGP3I=GP3I(1:1).NE.' '
        HAVGP4I=GP4I(1:1).NE.' '
        CALL MBLANK(SEX(ISIB))
        SEXI=SEX(ISIB)
C     
        DO 40 JSIB=ISIB+1,NRNTOT
C
          IDJ=ID(JSIB)   
          CALL MBLANK(SEX(JSIB))
          SEXJ=SEX(JSIB)
          NPAIR=NPAIR+1   
          DIFFAM=FAMIDI.NE.PEDID(JSIB) 
C
C IDENTIFY THE PUTATIVE RELATIONSHIP BETWEEN THE PAIR. 
C
          IPUTREL=IRAND
          IF(DIFFAM)THEN
            IF(ALLPR)THEN
              GO TO 20
            ENDIF
            NPAIR=NPAIR-1        
            GO TO 50
          ENDIF
C
C SAME FAMILY.  EXAMINE PEDIGREE STRUCTURE.
C
          FAMPRS(NFAM)=FAMPRS(NFAM)+1
          P1J=P1ID(JSIB)
          P2J=P2ID(JSIB)
          HAVP1J=P1J(1:1).NE.' '
          HAVP2J=P2J(1:1).NE.' '
          TWINJ=TWIN(JSIB)
          GP1J=GP1ID(JSIB)
          GP2J=GP2ID(JSIB)
          GP3J=GP3ID(JSIB)
          GP4J=GP4ID(JSIB) 
C
C CHECK FOR SIB PAIR (AT LEAST ONE SHARED PARENT).
C
          NMATCH=0
          IF(HAVP1I)THEN
            IF(P1I.EQ.P1J)NMATCH=NMATCH+1
            IF(P1I.EQ.P2J)NMATCH=NMATCH+1
          ENDIF
          IF(HAVP2I)THEN
            IF(P2I.EQ.P1J)NMATCH=NMATCH+1
            IF(P2I.EQ.P2J)NMATCH=NMATCH+1
          ENDIF
C
          IF(NMATCH.EQ.2)THEN
C
C BOTH PARENTS MATCH, FULL SIBS.
C
            IPUTREL=IFULL
C
C MZ TWINS.
C
            IF(HAVTWNI.AND.TWINI.EQ.TWINJ)IPUTREL=ITWIN
            GO TO 20
          ENDIF
          IF(NMATCH.EQ.1)THEN
C
C ONE PARENT MATCHES,HALF SIBS.
C
            IPUTREL=IHALF
            GO TO 20
          ENDIF
C        
C CHECK FOR PARENT-OFFSPRING RELATIONSHIP.
C   
          IF(IDI.EQ.P1J.OR.IDI.EQ.P2J.OR.P1I.EQ.IDJ.OR.P2I.EQ.IDJ)THEN
            IPUTREL=IPOFF
            GO TO 20
          ENDIF
C
C CHECK FOR GRANDPARENT-GRANDCHILD RELATIONSHIP.
C
          IF(GP1I.EQ.IDJ.OR.GP2I.EQ.IDJ.OR.GP3I.EQ.IDJ.OR.GP4I.EQ.IDJ
     1        .OR.GP1J.EQ.IDI.OR.GP2J.EQ.IDI.OR.GP3J.EQ.IDI.OR.GP4J
     2        .EQ.IDI)THEN
            IPUTREL=IGRCH
            GO TO 20
          ENDIF
C
C CHECK FOR AVUNCULAR RELATIONSHIP.  SINCE WE HAVE ALREADY CHECKED THE
C MORE DIRECT RELATIONSHIPS, ANY PAIR IN WHICH ONE PERSON'S PARENTS ARE
C THE OTHER PERSON'S GRANDPARENTS (ON ONE SIDE) WILL FIT INTO THIS 
C CATEGORY.  WATCH OUT FOR MISSINGNESS.
C
          IF(HAVP1I.AND.HAVP2I)THEN
            IF((P1I.EQ.GP1J.AND.P2I.EQ.GP2J).OR
     1          .(P1I.EQ.GP2J.AND.P2I.EQ.GP1J).OR
     2          .(P1I.EQ.GP3J.AND.P2I.EQ.GP4J).OR
     3          .(P1I.EQ.GP4J.AND.P2I.EQ.GP3J))THEN
              IPUTREL=IAVNC
              GO TO 20
            ENDIF
          ENDIF
C
          IF(HAVP1J.AND.HAVP2J)THEN
            IF((P1J.EQ.GP1I.AND.P2J.EQ.GP2I).OR
     1          .(P1J.EQ.GP2I.AND.P2J.EQ.GP1I).OR
     2          .(P1J.EQ.GP3I.AND.P2J.EQ.GP4I).OR
     3          .(P1J.EQ.GP4I.AND.P2J.EQ.GP3I))THEN
              IPUTREL=IAVNC
              GO TO 20
            ENDIF
          ENDIF
C
C CHECK FOR FIRST COUSINS.  SINCE WE HAVE ALREADY CHECKED THE MORE 
C DIRECT RELATIONSHIPS, ANY PAIR WITH A SET OF GRANDPARENTS IN COMMON 
C WILL FIT INTO THIS CATEGORY.  AGAIN, WATCH OUT FOR MISSINGNESS.
C
          IF(HAVGP1I.AND.HAVGP2I)THEN
            IF((GP1I.EQ.GP1J.AND.GP2I.EQ.GP2J).OR
     1          .(GP1I.EQ.GP2J.AND.GP2I.EQ.GP1J).OR
     2          .(GP1I.EQ.GP3J.AND.GP2I.EQ.GP4J).OR
     3          .(GP1I.EQ.GP4J.AND.GP2I.EQ.GP3J))THEN
              IPUTREL=ICOUS
              GO TO 20
            ENDIF
          ENDIF
C
          IF(HAVGP3I.AND.HAVGP4I)THEN
            IF((GP3I.EQ.GP1J.AND.GP4I.EQ.GP2J).OR
     1          .(GP3I.EQ.GP2J.AND.GP4I.EQ.GP1J).OR
     2          .(GP3I.EQ.GP3J.AND.GP4I.EQ.GP4J).OR
     3          .(GP3I.EQ.GP4J.AND.GP4I.EQ.GP3J))THEN
              IPUTREL=ICOUS
              GO TO 20
            ENDIF
          ENDIF
C
C GIVE PROGRESS REPORTS WHEN THERE ARE LOTS OF PAIRS.
C
 20       IF(MOD(NPAIR,10000).EQ.0)THEN
            IF(ALLPR)THEN
              WRITE(KOUT,103)NPAIR,100*DFLOAT(NPAIR)/DFLOAT(NTOTPAIR)
 103          FORMAT(I10,' PAIRS (',F6.2,'%) EXAMINED ...')
            ELSE
              WRITE(KOUT,104)NPAIR
 104          FORMAT(I10,' PAIRS EXAMINED ...')
            ENDIF
          ENDIF
C
C ANALYZE THE PAIR INDEXED BY ISIB AND JSIB.
C   
C XLINK INDICATES WHETHER IT IS AUTOSOMAL DATA ANALYSIS OR 
C X-LINKED DATA ANALYSIS.
C
C FOR X-LINKED CASE, THERE ARE THREE TYPES OF PAIRS:
C  1: FEMALE-FEMALE PAIR;
C  2: MALE-MALE PAIR;
C  3: MALE-FEMALE PAIR;
C
          XLINK=.FALSE.
          XTYPE=0
          IF(NXLINK.GT.0)THEN
            XLINK=.TRUE.
            IF(SEXI.EQ.XXSIGN.AND.SEXJ.EQ.XXSIGN)XTYPE=1
            IF(SEXI.EQ.XYSIGN.AND.SEXJ.EQ.XYSIGN)XTYPE=2
            IF(SEXI.EQ.XXSIGN.AND.SEXJ.EQ.XYSIGN.OR.
     1        SEXI.EQ.XYSIGN.AND.SEXJ.EQ.XXSIGN)XTYPE=3
          ENDIF
C
          CALL DOPAIR(ID,PEDID,TWIN,KDISC,ALLPR,ISIB,JSIB,MAXFAM
     1    ,MAXLOC,MAXREL,MINSHR,MXPTOT,NFAM,NLOCI,NTYPE2,PRLIK,PRMAX
     2    ,PRREL,IPUTREL,NPAIR,THETA,OUTTYPE,XLINK,XTYPE,IPOSIX,SEXI
     3    ,XXSIGN,ALLFRQ,GENERR,IGENES,MAXALL,PSI,KTAB2,CRITVAL,BUFF
     4    ,IBUFF,FAMPRS,FAMBUF,IFAMBUF,PERM,KTAB1,TWINI,TWINJ,KNUFF)
C
 40     CONTINUE    
 50   CONTINUE                 
C  
C REPORT WHEN ALL PAIRS ANALYZED.
C
      IF(ALLPR)THEN
        WRITE(KOUT,103)NPAIR,100.D0
      ELSE
        WRITE(KOUT,104)NPAIR
      ENDIF
C
      RETURN
C
      END
C
C
C 
      SUBROUTINE DOPAIR(ID,PEDID,TWIN,KDISC,ALLPR,ISIB,JSIB,MAXFAM
     1,MAXLOC,MAXREL,MINSHR,MXPTOT,NFAM,NLOCI,NTYPE2,PRLIK,PRMAX,PRREL
     2,IPUTREL,NPAIR,THETA,OUTTYPE,XLINK,XTYPE,IPOSIX,SEXI,XXSIGN
     3,ALLFRQ,GENERR,IGENES,MAXALL,PSI,KTAB2,CRITVAL,BUFF,IBUFF
     4,FAMPRS,FAMBUF,IFAMBUF,PERM,KTAB1,TWINI,TWINJ,KNUFF)
C
C ANALYZE THE MEMBER PAIR INDEXED BY ISIB AND JSIB.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      COMMON /D2/KCON,KRES,KLOC,KPED,KIN,KOUT,KDET
C
      CHARACTER*8 ID(MXPTOT),PEDID(MXPTOT),FAMIDI,FAMIDJ,TWIN(MXPTOT)
     1,SEXI,XXSIGN,TWINI,TWINJ
      CHARACTER*5000000 BUFF(MAXREL)
      CHARACTER*5000000 FAMBUF
      DOUBLE PRECISION PRLIK(MAXREL),PRREL(MAXREL),THETA(MAXLOC)
     1,ALLFRQ(MAXALL,MAXLOC),PSI(MAXLOC)
      INTEGER OUTTYPE,XTYPE,KTAB1(MAXREL,MAXREL),IGENES(0:1,MAXLOC
     1,MXPTOT),KTAB2(MAXREL,MAXREL),IBUFF(MAXREL),FAMPRS(MAXFAM)
     2,IFAMBUF,KDISC(MAXFAM),PERM(MAXLOC)
      LOGICAL ALLPR,DIFINF,XLINK
C         
      FAMIDI=PEDID(ISIB)
      FAMIDJ=PEDID(JSIB)
C
C CALCULATE THE PROBABILITY OF THE MARKER DATA CONDITIONAL ON 
C EACH RELATIONSHIP.
C
      CALL PRLINK(ISIB,JSIB,NLOCI,PRREL,THETA,NTYPE2,XLINK,XTYPE
     1,IPOSIX,MAXREL,SEXI,XXSIGN,ALLFRQ,GENERR,IGENES,MAXLOC,MXPTOT
     2,MAXALL,PSI,PERM)
C
      CALL PRBEST(IBEST,PRREL,PRMAX,IPUTREL,MINSHR,NTYPE2,MAXREL,I2ND
     1,PR2ND)
C
      DIFINF=IBEST.NE.IPUTREL
      IF(NFAM.GT.MAXFAM)GO TO 50
C
      CALL SUMUP(ALLPR,IBEST,MAXREL,NTYPE2,FAMIDI,FAMIDJ,PRLIK,PRMAX
     1,PRREL,IPUTREL,NPAIR,ID(ISIB),ID(JSIB),TWINI,TWINJ,MXPTOT
     2,OUTTYPE,RATIO,CRITVAL,DIFINF,BUFF,IBUFF,FAMBUF,IFAMBUF,MINSHR
     3,NFAM,KDISC,MAXFAM,I2ND,PR2ND,KTAB1,KTAB2,KNUFF)
C
      RETURN
C
 50   WRITE(KOUT,101)MAXFAM
 101  FORMAT(' *** ERROR *** THE NUMBER OF FAMILIES IN THE'
     1,' PEDIGREE FILE EXCEEDS'/15X,' THE MAXIMUM LIMIT OF '
     2,I6,'.  TO INCREASE THIS LIMIT,'/15X,' MODIFY THE CODE'
     3,' PARAMETER "MAXFAM".')
      STOP
C
      END
C
C
C
      SUBROUTINE PRLINK(ISIB,JSIB,NLOCI,PRREL,THETA,NTYPE2,XLINK,XTYPE
     1,IPOSIX,MAXREL,SEXI,XXSIGN,ALLFRQ,GENERR,IGENES,MAXLOC,MXPTOT
     2,MAXALL,PSI,PERM)
C
C RUN BAUM'S FORWARD ALGORITHM TO CALCULATE THE JOINT PROBABILITY OF
C THE MARKER DATA FOR THE PAIR ALLOWING FOR LINKED MARKERS.  FOR EACH
C LOCUS IN TURN STARTING AT THE FIRST, CALCULATE BY RECURSION ALPHA:
C THE JOINT PROBABILITY OF THE MARKER DATA ON ALL PREVIOUS MARKERS AND
C THE IBD STATUS VECTOR AT THE CURRENT MARKER.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      COMMON /D1/ITWIN,IFULL,IPOFF,IHALF,IGRCH,IAVNC,ICOUS,IRAND
      COMMON /D2/KCON,KRES,KLOC,KPED,KIN,KOUT,KDET
C
      CHARACTER*8 SEXI,XXSIGN
      DOUBLE PRECISION ALLFRQ(MAXALL,MAXLOC),PRREL(MAXREL),PSI(MAXLOC)
     1,THETA(MAXLOC)
      INTEGER IGENES(0:1,MAXLOC,MXPTOT),PERM(MAXLOC)
      LOGICAL XLINK,MZPOSS,POPOSS,HSPOSS,FSPOSS,GGPOSS
      INTEGER XTYPE
C
C INITIALIZE.
C
      SMALL=1.D-99
      EPSI=1.D-300
      SCALEU=0.D0
      SCALEP=0.D0
      SCALEH=0.D0
      SCALEF=0.D0
      SCALET=0.D0
      SCALEG=0.D0
      SCALEA=0.D0
      SCALEC=0.D0
      MZPOSS=.TRUE.
      POPOSS=.TRUE.
      HSPOSS=.TRUE.
      FSPOSS=.TRUE.
      GGPOSS=.TRUE.
C
C NAUTO IS THE NUMBER OF AUTOSOMAL LOCI, WHICH ARE SORTED SO THAT
C THEY ARE ENCOUNTERED BEFORE ANY X-LINKED LOCI.
C
      NAUTO=NLOCI
      IF(XLINK)NAUTO=IPOSIX-1
C
C INITIALIZE ALPHAS, DEPENDING ON WHETHER THE FIRST MARKER IS AUTOSOMAL
C OR X-LINKED.  REGARDLESS, UNRELATEDS ARE ALWAYS EXPECTED TO SHARE 0.
C ALSO, PROBABILITIES FOR X-LINKED MATERNAL HALF SIBS AND MATERNAL 
C GRANDPARENT/GRANDCHILD RELATIONSHIPS ARE THE SAME AS THE AUTOSOMAL 
C PROBABILITIES.
C 
      AUN0=1.D0
      AHS0=0.5D0
      AHS1=0.5D0
      AGG0=0.5D0
      AGG1=0.5D0
C
      IF(NAUTO.GT.0)THEN
C
C AUTOSOMAL FIRST MARKER.
C
        APO1=1.D0
        AMZ2=1.D0
C
        AFS0=0.25D0
        AFS1=0.5D0
        AFS2=0.25D0
C
        AAV0=0.5D0
        AAV1=0.5D0
C
        ACO0=0.75D0
        ACO1=0.25D0
C
      ELSE IF(XTYPE.EQ.1)THEN
C
C X-LINKED FIRST MARKER, FEMALE-FEMALE PAIR.
C
        APO1=1.D0
        AMZ2=1.D0
C
C PATERNAL HALF SISTERS.
C
        AHS21=1.D0
C
C FULL SIBS.
C
        AFS1=0.5D0
        AFS2=0.5D0
C
C PATERNAL GRANDMOTHER/GRANDDAUGHTER.
C
        AGG21=1.D0
C
C MATERNAL AUNT/NIECE.
C
        AAV0=0.25D0
        AAV1=0.75D0
C
C PATERNAL AUNT/NIECE.
C
        AAV20=0.5D0
        AAV21=0.5D0
C
C FIRST COUSINS CONNECTED THROUGH BROTHERS.
C
        ACO0=0.5D0
        ACO1=0.5D0
C
C FIRST COUSINS CONNECTED THROUGH SISTERS.
C
        ACO20=0.625D0
        ACO21=0.375D0
C
C FIRST COUSINS CONNECTED THROUGH A BROTHER AND A SISTER.
C
        ACO30=0.75D0
        ACO31=0.25D0
C
      ELSE IF(XTYPE.EQ.2)THEN
C
C X-LINKED FIRST MARKER, MALE-MALE PAIR.
C
        AMZ1=1.D0
        APO0=1.D0
C
C PATERNAL HALF BROTHERS.
C
        AHS20=1.D0
C
C FULL SIBS.
C
        AFS0=0.5D0
        AFS1=0.5D0
C
C PATERNAL GRANDFATHER/GRANDSON.
C
        AGG20=1.D0
C
C MATERNAL UNCLE/NEPHEW.
C
        AAV0=0.75D0
        AAV1=0.25D0
C
C PATERNAL UNCLE/NEPHEW.
C
        AAV20=1.D0
C
C FIRST COUSINS CONNECTED THROUGH SISTERS.
C
        ACO0=0.625D0
        ACO1=0.375D0
C
C FIRST COUSINS CONNECTED THROUGH AT LEAST ONE BROTHER.
C
        ACO20=1.D0
C
      ELSE IF(XTYPE.EQ.3)THEN
C
C X-LINKED FIRST MARKER, MALE-FEMALE PAIR.
C
C N.B. ALTHOUGH MZ TWINS ARE TECHNICALLY NOT POSSIBLE HERE,
C WE COULD CERTAINLY HAVE A SAMPLE DUPLICATION.  IN THIS
C CASE, WE WILL NOT DETECT IT.
C
        APO1=1.D0
C  
C PATERNAL HALF SIBS.
C
        AHS20=1.D0                
C
C FULL SIBS.
C
        AFS0=0.5D0
        AFS1=0.5D0
C
C PATERNAL GRANDPARENT/GRANDCHILD (EITHER DIRECTION).
C
        AGG20=1.D0
C
C MATERNAL AUNT/NEPHEW.
C
        AAV0=0.25D0
        AAV1=0.75D0
C
C MATERNAL UNCLE/NIECE.
C
        AAV20=0.75D0
        AAV21=0.25D0
C
C PATERNAL AUNT/NEPHEW.
C
        AAV30=1.D0
C
C PATERNAL UNCLE/NIECE.
C
        AAV40=0.5D0
        AAV41=0.5D0
C
C FIRST COUSINS CONNECTED THROUGH SISTERS.
C
        ACO0=0.625D0
        ACO1=0.375D0
C
C FIRST COUSINS WHO ARE SISTER'S SON AND BROTHER'S DAUGHTER.
C
        ACO20=0.75D0
        ACO21=0.25D0
C
C ALL OTHER FIRST COUSINS.
C
        ACO30=1.D0
C
      ELSE
        WRITE(KOUT,5)
 5      FORMAT(' *** ERROR *** NO VALID GENOTYPES FOUND.')
        STOP
      ENDIF
C
      PNOERR=(1.D0-GENERR)
      PNOERR=PNOERR*PNOERR
      PERR=1.D0-PNOERR
      NTYPE2=0
      PXKIK0=1.D0
      PXKIK1=1.D0
      PXKIK2=1.D0
C
C FOR EACH LOCUS...
C
      DO 300 LOCUS=1,NLOCI
C
C CALCULATE THE CONDITIONAL PROBABILITY OF THE MARKER DATA
C AT EACH LOCUS GIVEN EACH IBD SHARING STATUS FOR THE PAIR.
C      
        IPRML=PERM(LOCUS)
        IG11=IGENES(0,LOCUS,ISIB)
        IG21=IGENES(0,LOCUS,JSIB)
        IF(IG11*IG21.GT.0)GO TO 10
C
C IF THE DATA ARE MISSING FOR EITHER INDIVIDUAL, THE PROBABILITIES ARE
C NECESSARILY ONE AT THIS LOCUS.
C
          PXKIK0=1.D0
          PXKIK1=1.D0
          PXKIK2=1.D0
          GO TO 170
C
 10     IG12=IGENES(1,LOCUS,ISIB)
        IG22=IGENES(1,LOCUS,JSIB)
        NTYPE2=NTYPE2+1
C
C DIFFERENTIATE AMONG THE 7 DISTINCT CASES:
C (II II),(II JJ),(II IJ),(II JK),(IJ IJ),(IJ IK),(IJ KL)
C
        IF(IG11.EQ.IG12)GO TO 50
          IF(IG21.EQ.IG22)GO TO 70
C
C BOTH HETERO, SO EITHER (IJ IJ), (IJ IK), OR (IJ KL).
C IDENTIFY ALLELES, AND BRANCH AS FOLLOWS:
C
C   (IJ IJ) --> 140
C   (IJ IK) --> 150
C   (IJ KL) --> 160
C
            IF(IG11.NE.IG21)GO TO 20
              AFRQ1=ALLFRQ(IG11,IPRML)
              AFRQ2=ALLFRQ(IG12,IPRML)
              IF(IG12.EQ.IG22)GO TO 140
                AFRQ3=ALLFRQ(IG22,IPRML)
                GO TO 150
 20         IF(IG12.NE.IG22)GO TO 30
              AFRQ1=ALLFRQ(IG12,IPRML)
              AFRQ2=ALLFRQ(IG11,IPRML)
              AFRQ3=ALLFRQ(IG21,IPRML)
              GO TO 150
 30         IF(IG11.NE.IG22)GO TO 40
              AFRQ1=ALLFRQ(IG11,IPRML)
              AFRQ2=ALLFRQ(IG12,IPRML)
              IF(IG12.EQ.IG21)GO TO 140
                AFRQ3=ALLFRQ(IG21,IPRML)
                GO TO 150
 40         IF(IG12.NE.IG21)GO TO 160
              AFRQ1=ALLFRQ(IG12,IPRML)
              AFRQ2=ALLFRQ(IG11,IPRML)
              AFRQ3=ALLFRQ(IG22,IPRML)
              GO TO 150
C
 50     IF(IG21.EQ.IG22)GO TO 90
C
C FIRST HOMO, SECOND HETERO, SO EITHER (II IJ) OR (II JK).
C IDENTIFY ALLELES, AND BRANCH AS FOLLOWS:
C
C   (II IJ) --> 120
C   (II JK) --> 130
C
          AFRQ1=ALLFRQ(IG11,IPRML)
          IF(IG11.NE.IG21)GO TO 60
            AFRQ2=ALLFRQ(IG22,IPRML)
            GO TO 120
 60       AFRQ2=ALLFRQ(IG21,IPRML) 
          IF(IG11.EQ.IG22)GO TO 120
            AFRQ3=ALLFRQ(IG22,IPRML)
            GO TO 130
C
C FIRST HETERO, SECOND HOMO, SO EITHER (IJ II) OR (JK II).
C IDENTIFY ALLELES, AND BRANCH AS FOLLOWS:
C
C   (IJ II) --> 120
C   (JK II) --> 130
C
 70       AFRQ1=ALLFRQ(IG21,IPRML)
          IF(IG21.NE.IG11)GO TO 80
            AFRQ2=ALLFRQ(IG12,IPRML)
            GO TO 120
 80       AFRQ2=ALLFRQ(IG11,IPRML) 
          IF(IG21.EQ.IG12)GO TO 120
            AFRQ3=ALLFRQ(IG12,IPRML)
            GO TO 130
C
C BOTH HOMO, SO EITHER (II II) OR (II JJ).
C BRANCH AS FOLLOWS:
C
C   (II II) --> FALL THROUGH TO 100
C   (II JJ) --> 110
C
 90     IF(IG11.NE.IG21)GO TO 110
C
C FOR THE OBSERVED CASE, CALCULATE THE PROBABILITIES.
C
C CASE 1: II II
C
 100    AFRQ1=ALLFRQ(IG11,IPRML)
        A1SQ=AFRQ1*AFRQ1
C
C X-LINKED FEMALE-FEMALE PAIR OR AUTOSOMAL.
C
        PXKIK0=A1SQ*A1SQ
        PXKIK1=A1SQ*AFRQ1
        PXKIK2=A1SQ
        IF(LOCUS.GT.NAUTO.AND.XTYPE.GT.1)THEN
C
C X-LINKED MALE-MALE PAIR OR X-LINKED MALE-FEMALE PAIR.
C
          IF(XTYPE.EQ.2)THEN
            PXKIK0=A1SQ
            PXKIK1=AFRQ1
          ELSE IF(XTYPE.EQ.3)THEN
            PXKIK0=PXKIK1
            PXKIK1=PXKIK2
          ENDIF
          PXKIK2=0.D0
        ENDIF
        GO TO 170
C
C CASE 2: II JJ
C
 110    A1A2=ALLFRQ(IG11,IPRML)*ALLFRQ(IG21,IPRML)
C
C X-LINKED FEMALE-FEMALE PAIR OR AUTOSOMAL.
C
        PXKIK0=A1A2*A1A2
        PXKIK1=0.D0
        PXKIK2=0.D0
        IF(LOCUS.GT.NAUTO.AND.XTYPE.GT.1)THEN
C
C X-LINKED MALE-MALE PAIR OR X-LINKED MALE-FEMALE PAIR.
C
          IF(XTYPE.EQ.2)THEN
            PXKIK0=A1A2
          ELSE IF(XTYPE.EQ.3)THEN
            IF(SEXI.EQ.XXSIGN)THEN
              PXKIK0=A1A2*ALLFRQ(IG11,IPRML)
            ELSE
              PXKIK0=A1A2*ALLFRQ(IG21,IPRML)
            ENDIF
          ENDIF
        ENDIF
        GO TO 170
C
C CASE 3: II IJ
C
 120    FACTOR=AFRQ1*AFRQ1*AFRQ2
C
C X-LINKED FEMALE-FEMALE PAIR OR AUTOSOMAL.
C
        IF(LOCUS.GT.NAUTO.AND.XTYPE.EQ.3)THEN
C
C X-LINKED MALE-FEMALE PAIR (MALE-MALE IMPOSSIBLE).
C
          FACTOR=AFRQ1*AFRQ2
        ENDIF
        PXKIK0=(AFRQ1+AFRQ1)*FACTOR
        PXKIK1=FACTOR
        PXKIK2=0.D0
        GO TO 170
C
C CASE 4: II JK
C
 130    FACTOR=(AFRQ1+AFRQ1)*AFRQ2*AFRQ3
C
C X-LINKED FEMALE-FEMALE PAIR OR AUTOSOMAL.
C
        PXKIK0=AFRQ1*FACTOR
        IF(LOCUS.GT.NAUTO.AND.XTYPE.EQ.3)THEN
C
C X-LINKED MALE-FEMALE PAIR (MALE-MALE IMPOSSIBLE).
C
          PXKIK0=FACTOR
        ENDIF
        PXKIK1=0.D0
        PXKIK2=0.D0
        GO TO 170
C
C CASE 5: IJ IJ
C
 140    A1A2=AFRQ1*AFRQ2
C
C X-LINKED FEMALE-FEMALE PAIR OR AUTOSOMAL (X-LINKED MALE IMPOSSIBLE).
C
        PXKIK2=A1A2+A1A2
        PXKIK0=PXKIK2*PXKIK2
        PXKIK1=A1A2*(AFRQ1+AFRQ2)
        GO TO 170
C
C CASE 6: IJ IK 
C
 150    FACTOR=AFRQ1*AFRQ2*AFRQ3 
C
C X-LINKED FEMALE-FEMALE PAIR OR AUTOSOMAL (X-LINKED MALE IMPOSSIBLE).
C
        PXKIK0=(AFRQ1+AFRQ1)*(FACTOR+FACTOR)
        PXKIK1=FACTOR
        PXKIK2=0.D0
        GO TO 170
C
C CASE 7: IJ KL
C
 160    FACTOR=ALLFRQ(IG11,IPRML)*ALLFRQ(IG12,IPRML)*ALLFRQ(IG21,IPRML)
     1       *ALLFRQ(IG22,IPRML) 
C
C X-LINKED FEMALE-FEMALE PAIR OR AUTOSOMAL (X-LINKED MALE IMPOSSIBLE).
C
        PXKIK0=4.D0*FACTOR
        PXKIK1=0.D0
        PXKIK2=0.D0
C
C HANDLE GENOTYPE ERROR AND SET SOME FLAGS.
C
 170    ERRADJ=PXKIK0*PERR  
        PXKIK1=PXKIK1*PNOERR+ERRADJ
        PXKIK2=PXKIK2*PNOERR+ERRADJ
C
C IF THIS IS THE LAST LOCUS, SKIP PAST THE TRANSITION PART.
C
        IF(LOCUS.EQ.NLOCI)GO TO 310
C
C IF THIS IS THE LAST AUTOSOMAL LOCUS BUT THERE ARE STILL
C X-LINKED LOCI TO COME, HANDLE TRANSITION TO THE FIRST 
C X-LINKED LOCUS HERE.
C
        IF(XLINK.AND.LOCUS.EQ.NAUTO)THEN
C
C UNRELATEDS.  SAME AS AUTOSOMAL.
C
          AUN0=AUN0*PXKIK0
          IF(AUN0.LT.SMALL)CALL SCALE1(SCALEU,AUN0,EPSI)
C
C PARENT/OFFSPRING.  FATHER/SON PAIRS WILL SHIFT FROM SHARING 1 ALLELE 
C AT AUTOSOMAL LOCI TO SHARING 0 ON THE X CHROMOSOME.  OTHER TYPES SAME 
C AS AUTOSOMAL.
C
          IF(PXKIK1.LT.SMALL)THEN
            POPOSS=.FALSE.
          ELSE IF(POPOSS)THEN
            APO1=APO1*PXKIK1
            IF(APO1.LT.SMALL)CALL SCALE1(SCALEP,APO1,EPSI)
          ENDIF
          IF(XTYPE.EQ.2)APO0=APO1
C
C HALF SIBS.  MATERNAL HALF SIBS SAME AS AUTOSOMAL.  HANDLE
C THE VARIOUS X-LINKED PATERNAL HALF-SIB CASES SEPARATELY.
C
          AHS0=0.5*(AHS0*PXKIK0+AHS1*PXKIK1)
          AHS1=AHS0
          IF(AHS0.LT.SMALL.OR.AHS1.LT.SMALL)CALL SCALE2(SCALEH,AHS0
     1      ,AHS1,EPSI)
          SCALEH2=SCALEH
          IF(XTYPE.EQ.1)THEN
C
C PATERNAL HALF SISTERS MUST SHARE 1 ALLELE ON X.
C
            AHS21=AHS0+AHS1
C
          ELSE
C
C PATERNAL HALF BROTHERS AND HALF BROTHER/SISTER PAIRS MUST SHARE 0 
C ON X.
C
            AHS20=AHS0+AHS1
C
          ENDIF
C
C FULL SIBS.
C
          TERM=0.5*(AFS0*PXKIK0+AFS1*PXKIK1+AFS2*PXKIK2)
C
          IF(XTYPE.EQ.1)THEN
C
C SISTERS MUST SHARE AT LEAST 1 ALLELE ON X.
C
            AFS1=TERM
            AFS2=TERM
C
          ELSE
C
C BROTHERS CAN SHARE AT MOST 1 ALLELE WITH THEIR FULL SIBS.
C
            AFS0=TERM
            AFS1=TERM
C
          ENDIF
C
C MZ TWINS.  MALE TWINS GO FROM SHARING 2 ON AUTOSOMAL LOCI TO 
C SHARING 1 ON X.
C
          IF(PXKIK2.LT.SMALL)THEN
            MZPOSS=.FALSE.
          ELSE IF(MZPOSS)THEN
            AMZ2=AMZ2*PXKIK2
            IF(AMZ2.LT.SMALL)CALL SCALE1(SCALET,AMZ2,EPSI)
          ENDIF
          IF(XTYPE.EQ.2)AMZ1=AMZ2
C
C GRANDPARENT/GRANDCHILD.
C
          AGG0=0.5*(AGG0*PXKIK0+AGG1*PXKIK1)
          AGG1=AGG0
          IF(AGG0.LT.SMALL.OR.AGG1.LT.SMALL)CALL SCALE2(SCALEG,AGG0
     1      ,AGG1,EPSI)
          SCALEG2=SCALEG
C
          IF(XTYPE.EQ.1)THEN
C
C PATERNAL GRANDMOTHER/GRANDDAUGHTER PAIRS MUST SHARE 1 ON X.
C
            AGG21=AGG0+AGG1
C
          ELSE
C
C ALL OTHER PATERNAL GRANDPARENT/GRANDCHILD PAIRS MUST SHARE 0 ON X.
C
            AGG20=AGG0+AGG1
C
          ENDIF
C
C AVUNCULAR.
C
          A0XPX0=AAV0*PXKIK0
          A1XPX1=AAV1*PXKIK1
          SCALEA2=SCALEA
          SCALEA3=SCALEA
          SCALEA4=SCALEA
C
          IF(XTYPE.EQ.1)THEN
C
C MATERNAL AUNT/NIECE.
C
            AAV0=0.25*(A0XPX0+A1XPX1)
            AAV1=AAV0+AAV0+AAV0
            IF(AAV0.LT.SMALL.OR.AAV1.LT.SMALL)CALL SCALE2(SCALEA,AAV0
     1        ,AAV1,EPSI)
C
C PATERNAL AUNT/NIECE.
C
            AAV20=0.5*(A0XPX0+A1XPX1)
            AAV21=AAV20
            IF(AAV20.LT.SMALL.OR.AAV21.LT.SMALL)CALL SCALE2(SCALEA2
     1        ,AAV20,AAV21,EPSI)
C
          ELSE IF(XTYPE.EQ.2)THEN
C
C MATERNAL UNCLE/NEPHEW.
C
            AAV1=0.25*(A0XPX0+A1XPX1)
            AAV0=AAV1+AAV1+AAV1
            IF(AAV0.LT.SMALL.OR.AAV1.LT.SMALL)CALL SCALE2(SCALEA,AAV0
     1        ,AAV1,EPSI)
C
C PATERNAL UNCLE/NEPHEW.
C
            AAV20=A0XPX0+A1XPX1
            IF(AAV20.LT.SMALL)CALL SCALE1(SCALEA2,AAV20,EPSI)
C
          ELSE
C
C MATERNAL AUNT/NEPHEW.
C
            AAV0=0.25*(A0XPX0+A1XPX1)
            AAV1=AAV0+AAV0+AAV0
            IF(AAV0.LT.SMALL.OR.AAV1.LT.SMALL)CALL SCALE2(SCALEA,AAV0
     1        ,AAV1,EPSI)
C 
C MATERNAL UNCLE/NIECE.
C
            AAV21=0.25*(A0XPX0+A1XPX1)
            AAV20=AAV21+AAV21+AAV21
            IF(AAV20.LT.SMALL.OR.AAV21.LT.SMALL)CALL SCALE2(SCALEA2
     1        ,AAV20,AAV21,EPSI)
C
C PATERNAL AUNT/NEPHEW.
C
            AAV30=A0XPX0+A1XPX1
            IF(AAV30.LT.SMALL)CALL SCALE1(SCALEA3,AAV30,EPSI)
C
C PATERNAL UNCLE/NIECE.
C
            AAV40=0.5*(A0XPX0+A1XPX1)
            AAV41=AAV40
            IF(AAV40.LT.SMALL.OR.AAV41.LT.SMALL)CALL SCALE2(SCALEA4
     1        ,AAV40,AAV41,EPSI)
C
          ENDIF 
C
C FIRST COUSINS.
C
          A0XPX0=ACO0*PXKIK0
          A1XPX1=ACO1*PXKIK1
          SCALEC2=SCALEC
          SCALEC3=SCALEC
C
          IF(XTYPE.EQ.1)THEN
C
C CONNECTED THROUGH BROTHERS.
C
            ACO0=0.5*(A0XPX0+A1XPX1)
            ACO1=ACO0
            IF(ACO0.LT.SMALL.OR.ACO1.LT.SMALL)CALL SCALE2(SCALEC,ACO0
     1        ,ACO1,EPSI)
C
C CONNECTED THROUGH SISTERS.
C
            ACO20=0.625*(A0XPX0+A1XPX1)
            ACO21=0.375*(A0XPX0+A1XPX1)
            IF(ACO20.LT.SMALL.OR.ACO21.LT.SMALL)CALL SCALE2(SCALEC2
     1        ,ACO20,ACO21,EPSI)
C
C CONNECTED THROUGH A BROTHER AND A SISTER.
C
            ACO31=0.25*(A0XPX0+A1XPX1)
            ACO30=ACO31+ACO31+ACO31
            IF(ACO30.LT.SMALL.OR.ACO31.LT.SMALL)CALL SCALE2(SCALEC3
     1        ,ACO30,ACO31,EPSI)
C
          ELSE IF(XTYPE.EQ.2)THEN
C
C CONNECTED THROUGH SISTERS.
C
            ACO0=0.625*(A0XPX0+A1XPX1)
            ACO1=0.375*(A0XPX0+A1XPX1)
            IF(ACO0.LT.SMALL.OR.ACO1.LT.SMALL)CALL SCALE2(SCALEC,ACO0
     1        ,ACO1,EPSI)
C
C CONNECTED THROUGH AT LEAST ONE BROTHER.
C
            ACO20=A0XPX0+A1XPX1
            IF(ACO20.LT.SMALL)CALL SCALE1(SCALEC2,ACO20,EPSI) 
C
          ELSE
C
C CONNECTED THROUGH SISTERS.
C
            ACO0=0.625*(A0XPX0+A1XPX1)
            ACO1=0.375*(A0XPX0+A1XPX1)
            IF(ACO0.LT.SMALL.OR.ACO1.LT.SMALL)CALL SCALE2(SCALEC,ACO0
     1        ,ACO1,EPSI)
C
C SISTER'S SON AND BROTHER'S DAUGHTER.
C
            ACO21=0.25*(A0XPX0+A1XPX1)
            ACO20=ACO21+ACO21+ACO21
            IF(ACO20.LT.SMALL.OR.ACO21.LT.SMALL)CALL SCALE2(SCALEC2
     1        ,ACO20,ACO21,EPSI)
C 
C ALL OTHERS.
C
            ACO30=A0XPX0+A1XPX1
            IF(ACO30.LT.SMALL)CALL SCALE1(SCALEC3,ACO30,EPSI) 
C
          ENDIF
C
C WE'VE HANDLED TRANSITION TO THE FIRST X-LINKED LOCUS COMPLETELY, 
C SO GO TO THE NEXT LOCUS.
C
          GO TO 300
C
        ENDIF
C
C INTERMEDIATE CALCULATIONS.
C
        TH=THETA(LOCUS)
        ONEMTH=1.D0-TH
        THSQ=TH*TH
        PS=PSI(LOCUS)
        ONEMPS=1.D0-PS
        PSSQ=PS*PS
C
C UNRELATEDS.  THIS RELATIONSHIP TYPE IS THE SAME FOR BOTH AUTOSOMAL 
C AND X-LINKED.
C
        AUN0=AUN0*PXKIK0
        IF(AUN0.LT.SMALL)CALL SCALE1(SCALEU,AUN0,EPSI)
C
C PARENT/OFFSPRING.  SHARING IS NECESSARILY 1, EXCEPT IN THE X-LINKED
C MALE-MALE CASE, IN WHICH SHARING IS NECESSARILY 0.
C
        IF(LOCUS.GE.NAUTO.AND.XTYPE.EQ.2)THEN  
          APO0=APO0*PXKIK0
          IF(APO0.LT.SMALL)CALL SCALE1(SCALEP,APO0,EPSI)
        ELSE
          IF(PXKIK1.LT.SMALL)THEN
            POPOSS=.FALSE.
          ELSE IF(POPOSS)THEN
            APO1=APO1*PXKIK1
            IF(APO1.LT.SMALL)CALL SCALE1(SCALEP,APO1,EPSI)
          ENDIF
        ENDIF
C
C HALF SIBS.  MATERNAL HALF SIBS AND AUTOSOMAL ARE THE SAME.  HANDLE
C THE VARIOUS X-LINKED PATERNAL HALF-SIB CASES SEPARATELY.
C
        A0XPX0=AHS0*PXKIK0
        A1XPX1=AHS1*PXKIK1
        TERM=PS*(A1XPX1-A0XPX0)
        AHS0=A1XPX1-TERM
        AHS1=A0XPX0+TERM
        IF(AHS0.LT.SMALL.OR.AHS1.LT.SMALL)CALL SCALE2(SCALEH,AHS0
     1    ,AHS1,EPSI)
C
        IF(LOCUS.GE.NAUTO)THEN
C
C HANDLE X-LINKED TRANSITION PROBABILITIES FOR PATERNAL HALF SIBS.
C
          IF(XTYPE.EQ.1)THEN
C
C PATERNAL HALF SISTERS NECESSARILY SHARE 1 ON X.
C
            IF(PXKIK1.LT.SMALL)THEN
              HSPOSS=.FALSE.
            ELSE IF(HSPOSS)THEN
              AHS21=AHS21*PXKIK1
              IF(AHS21.LT.SMALL)CALL SCALE1(SCALEH2,AHS21,EPSI)
            ENDIF
C
          ELSE
C
C PATERNAL HALF BROTHERS AND HALF BROTHER/SISTERS NECESSARILY SHARE 
C 0 ON X.
C
            AHS20=AHS20*PXKIK0
            IF(AHS20.LT.SMALL)CALL SCALE1(SCALEH2,AHS20,EPSI)
C
          ENDIF
        ENDIF
C
C FULL SIBS.
C
        IF(LOCUS.LT.NAUTO)THEN 
          A0XPX0=AFS0*PXKIK0 
          A1XPX1=AFS1*PXKIK1
          A2XPX2=AFS2*PXKIK2
          TRANS00=PSSQ
          TRANS22=TRANS00
          TRANS10=PS*ONEMPS
          TRANS12=TRANS10
          TRANS01=TRANS10+TRANS10
          TRANS21=TRANS01
          TRANS20=ONEMPS*ONEMPS
          TRANS02=TRANS20
          TRANS11=TRANS00+TRANS20
          AFS0=A0XPX0*TRANS00+A1XPX1*TRANS10+A2XPX2*TRANS20
          AFS1=A0XPX0*TRANS01+A1XPX1*TRANS11+A2XPX2*TRANS21
          AFS2=A0XPX0*TRANS02+A1XPX1*TRANS12+A2XPX2*TRANS22
          IF(AFS0.LT.SMALL.OR.AFS1.LT.SMALL.OR.AFS2.LT.SMALL)
     1      CALL SCALE3(SCALEF,AFS0,AFS1,AFS2,EPSI)
C
        ELSE IF(XTYPE.EQ.1)THEN
C
C X-LINKED FEMALE-FEMALE.
C
          IF(PXKIK1.LT.SMALL.AND.PXKIK2.LT.SMALL)THEN
            FSPOSS=.FALSE.
          ELSE IF(FSPOSS)THEN
            A1XPX1=AFS1*PXKIK1
            A2XPX2=AFS2*PXKIK2
            TERM=PS*(A2XPX2-A1XPX1)
            AFS1=A2XPX2-TERM
            AFS2=A1XPX1+TERM
            IF(AFS1.LT.SMALL.OR.AFS2.LT.SMALL)CALL SCALE2(SCALEF,AFS1
     1        ,AFS2,EPSI)
          ENDIF
C
        ELSE
C
C X-LINKED MALE-MALE OR MALE-FEMALE.
C
          A0XPX0=AFS0*PXKIK0
          A1XPX1=AFS1*PXKIK1
          TERM=PS*(A1XPX1-A0XPX0)
          AFS0=A1XPX1-TERM
          AFS1=A0XPX0+TERM
          IF(AFS0.LT.SMALL.OR.AFS1.LT.SMALL)CALL SCALE2(SCALEF,AFS0
     1      ,AFS1,EPSI)
C
        ENDIF
C
C MZ TWINS.
C
        IF(LOCUS.LT.NAUTO.OR.XTYPE.EQ.1)THEN 
C
C AUTOSOMAL OR X-LINKED FEMALE-FEMALE.
C
          IF(PXKIK2.LT.SMALL)THEN
            MZPOSS=.FALSE.
          ELSE IF(MZPOSS)THEN
            AMZ2=AMZ2*PXKIK2
            IF(AMZ2.LT.SMALL)CALL SCALE1(SCALET,AMZ2,EPSI)
          ENDIF
C
        ELSE IF(XTYPE.EQ.2)THEN
C
C X-LINKED MALE-MALE.
C
          IF(PXKIK1.LT.SMALL)THEN
            MZPOSS=.FALSE.
          ELSE IF(MZPOSS)THEN
            AMZ1=AMZ1*PXKIK1
            IF(AMZ1.LT.SMALL)CALL SCALE1(SCALET,AMZ1,EPSI)
          ENDIF
C
        ELSE IF(XTYPE.EQ.3)THEN
C
C X-LINKED MALE-FEMALE. 
C
          MZPOSS=.FALSE. 
C
        ENDIF
C
C GRANDPARENT/GRANDCHILD.
C
        A0XPX0=AGG0*PXKIK0
        A1XPX1=AGG1*PXKIK1
        TERM=TH*(A1XPX1-A0XPX0)
        AGG0=A0XPX0+TERM
        AGG1=A1XPX1-TERM
        IF(AGG0.LT.SMALL.OR.AGG1.LT.SMALL)CALL SCALE2(SCALEG,AGG0
     1    ,AGG1,EPSI)
C
        IF(LOCUS.GE.NAUTO)THEN
C
C HANDLE X-LINKED TRANSITION PROBABILITIES FOR PATERNAL GRANDPARENT/
C GRANDCHILD CASE.
C
          IF(XTYPE.EQ.1)THEN
C
C PATERNAL GRANDMOTHER/GRANDDAUGHTER PAIRS NECESSARILY SHARE 1 ON X.
C
            IF(PXKIK1.LT.SMALL)THEN
              GGPOSS=.FALSE.
            ELSE IF(GGPOSS)THEN
              AGG21=AGG21*PXKIK1
              IF(AGG21.LT.SMALL)CALL SCALE1(SCALEG2,AGG21,EPSI)
            ENDIF
C
          ELSE
C
C ALL OTHER PATERNAL GRANDPARENT/GRANDCHILD PAIRS NECESSARILY SHARE 
C 0 ON X.
C
            AGG20=AGG20*PXKIK0
            IF(AGG20.LT.SMALL)CALL SCALE1(SCALEG2,AGG20,EPSI)
C
          ENDIF
        ENDIF
C
C AVUNCULAR.  THERE ARE TONS OF CASES HERE.
C
        IF(LOCUS.LT.NAUTO)THEN 
C
          A0XPX0=AAV0*PXKIK0
          A1XPX1=AAV1*PXKIK1
          TERM=(0.5D0*TH+PS*ONEMTH)*(A1XPX1-A0XPX0)
          AAV0=A1XPX1-TERM
          AAV1=A0XPX0+TERM
          IF(AAV0.LT.SMALL.OR.AAV1.LT.SMALL)CALL SCALE2(SCALEA,AAV0
     1      ,AAV1,EPSI)
C
        ELSE IF(XTYPE.EQ.1)THEN
C
C MATERNAL AUNT/NIECE.
C
          A0XPX0=AAV0*PXKIK0
          A1XPX1=AAV1*PXKIK1
          TRANS00=PS*ONEMTH
          TRANS01=1.D0-TRANS00
          TRANS10=TRANS01/3.D0
          TRANS11=1.D0-TRANS10
          AAV0=A0XPX0*TRANS00+A1XPX1*TRANS10
          AAV1=A0XPX0*TRANS01+A1XPX1*TRANS11
          IF(AAV0.LT.SMALL.OR.AAV1.LT.SMALL)CALL SCALE2(SCALEA,AAV0
     1      ,AAV1,EPSI)
C
C PATERNAL AUNT/NIECE.
C
          A0XPX0=AAV20*PXKIK0
          A1XPX1=AAV21*PXKIK1
          TERM=PS*(A1XPX1-A0XPX0)
          AAV20=A1XPX1-TERM
          AAV21=A0XPX0+TERM
          IF(AAV20.LT.SMALL.OR.AAV21.LT.SMALL)CALL SCALE2(SCALEA2,AAV20
     1      ,AAV21,EPSI)
C
        ELSE IF(XTYPE.EQ.2)THEN
C
C MATERNAL UNCLE/NEPHEW.
C
          A0XPX0=AAV0*PXKIK0
          A1XPX1=AAV1*PXKIK1
          TRANS11=PS*ONEMTH
          TRANS10=1.D0-TRANS11
          TRANS01=TRANS10/3.D0
          TRANS00=1.D0-TRANS01
          AAV0=A0XPX0*TRANS00+A1XPX1*TRANS10
          AAV1=A0XPX0*TRANS01+A1XPX1*TRANS11
          IF(AAV0.LT.SMALL.OR.AAV1.LT.SMALL)CALL SCALE2(SCALEA,AAV0
     1      ,AAV1,EPSI)
C
C PATERNAL UNCLE/NEPHEW.
C
          AAV20=AAV20*PXKIK0
          IF(AAV20.LT.SMALL)CALL SCALE1(SCALEA2,AAV20,EPSI)
C
        ELSE
C
C MATERNAL AUNT/NEPHEW.
C
          A0XPX0=AAV0*PXKIK0
          A1XPX1=AAV1*PXKIK1
          TRANS00=PS*ONEMTH
          TRANS01=1.D0-TRANS00
          TRANS10=TRANS01/3.D0
          TRANS11=1.D0-TRANS10
          AAV0=A0XPX0*TRANS00+A1XPX1*TRANS10
          AAV1=A0XPX0*TRANS01+A1XPX1*TRANS11
          IF(AAV0.LT.SMALL.OR.AAV1.LT.SMALL)CALL SCALE2(SCALEA,AAV0
     1      ,AAV1,EPSI)
C 
C MATERNAL UNCLE/NIECE.
C
          A0XPX0=AAV20*PXKIK0
          A1XPX1=AAV21*PXKIK1
          TRANS11=PS*ONEMTH
          TRANS10=1.D0-TRANS11
          TRANS01=TRANS10/3.D0
          TRANS00=1.D0-TRANS01
          AAV20=A0XPX0*TRANS00+A1XPX1*TRANS10
          AAV21=A0XPX0*TRANS01+A1XPX1*TRANS11
          IF(AAV20.LT.SMALL.OR.AAV21.LT.SMALL)CALL SCALE2(SCALEA2,AAV20
     1      ,AAV21,EPSI)
C
C PATERNAL AUNT/NEPHEW.
C
          AAV30=AAV30*PXKIK0
          IF(AAV30.LT.SMALL)CALL SCALE1(SCALEA3,AAV30,EPSI)
C
C PATERNAL UNCLE/NIECE.
C
          A0XPX0=AAV40*PXKIK0
          A1XPX1=AAV41*PXKIK1
          TERM=PS*(A1XPX1-A0XPX0)
          AAV40=A1XPX1-TERM
          AAV41=A0XPX0+TERM
          IF(AAV40.LT.SMALL.OR.AAV41.LT.SMALL)CALL SCALE2(SCALEA4,AAV40
     1      ,AAV41,EPSI)
C
        ENDIF 
C
C FIRST COUSINS. 
C
        IF(LOCUS.LT.NAUTO)THEN 
C
          A0XPX0=ACO0*PXKIK0
          A1XPX1=ACO1*PXKIK1
          TERM=0.5D0*THSQ+PS*ONEMTH*ONEMTH
          TRANS11=TERM 
          TRANS00=(2.D0+TRANS11)/3.D0
          TRANS10=1.D0-TERM
          TRANS01=TRANS10/3.D0 
          ACO0=A0XPX0*TRANS00+A1XPX1*TRANS10
          ACO1=A0XPX0*TRANS01+A1XPX1*TRANS11
          IF(ACO0.LT.SMALL.OR.ACO1.LT.SMALL)CALL SCALE2(SCALEC,ACO0
     1      ,ACO1,EPSI)
C
        ELSE IF(XTYPE.EQ.1)THEN
C
C CONNECTED THROUGH BROTHERS.
C
          A0XPX0=ACO0*PXKIK0
          A1XPX1=ACO1*PXKIK1
          TERM=PS*(A1XPX1-A0XPX0)
          ACO0=A1XPX1-TERM
          ACO1=A0XPX0+TERM
          IF(ACO0.LT.SMALL.OR.ACO1.LT.SMALL)CALL SCALE2(SCALEC,ACO0
     1      ,ACO1,EPSI)
C
C CONNECTED THROUGH SISTERS.
C
          A0XPX0=ACO20*PXKIK0
          A1XPX1=ACO21*PXKIK1
          TERM=PS*(2.D0+ONEMTH*ONEMTH)
          TRANS00=(2.D0+TERM)/5.D0
          TRANS10=(3.D0-TERM)/3.D0
          TRANS01=(3.D0-TERM)/5.D0
          TRANS11=TERM/3.D0
          ACO20=A0XPX0*TRANS00+A1XPX1*TRANS10
          ACO21=A0XPX0*TRANS01+A1XPX1*TRANS11
          IF(ACO20.LT.SMALL.OR.ACO21.LT.SMALL)CALL SCALE2(SCALEC2,ACO20
     1      ,ACO21,EPSI)
C
C CONNECTED THROUGH A BROTHER AND A SISTER.
C
          A0XPX0=ACO30*PXKIK0
          A1XPX1=ACO31*PXKIK1
          TRANS11=PS*(1.D0-TH)
          TRANS10=1.D0-TRANS11
          TRANS01=TRANS10/3.D0
          TRANS00=1.D0-TRANS01
          ACO30=A0XPX0*TRANS00+A1XPX1*TRANS10
          ACO31=A0XPX0*TRANS01+A1XPX1*TRANS11
          IF(ACO30.LT.SMALL.OR.ACO31.LT.SMALL)CALL SCALE2(SCALEC3,ACO30
     1      ,ACO31,EPSI)
C
        ELSE IF(XTYPE.EQ.2)THEN
C
C CONNECTED THROUGH SISTERS.
C
          A0XPX0=ACO0*PXKIK0
          A1XPX1=ACO1*PXKIK1
          TERM=PS*(2.D0+ONEMTH*ONEMTH)
          TRANS00=(2.D0+TERM)/5.D0
          TRANS10=(3.D0-TERM)/3.D0
          TRANS01=(3.D0-TERM)/5.D0
          TRANS11=TERM/3.D0
          ACO0=A0XPX0*TRANS00+A1XPX1*TRANS10
          ACO1=A0XPX0*TRANS01+A1XPX1*TRANS11
          IF(ACO0.LT.SMALL.OR.ACO1.LT.SMALL)CALL SCALE2(SCALEC,ACO0
     1      ,ACO1,EPSI)
C
C CONNECTED THROUGH AT LEAST ONE BROTHER.
C
          ACO20=ACO20*PXKIK0
          IF(ACO20.LT.SMALL)CALL SCALE1(SCALEC2,ACO20,EPSI) 
C
        ELSE
C
C CONNECTED THROUGH SISTERS.
C
          A0XPX0=ACO0*PXKIK0
          A1XPX1=ACO1*PXKIK1
          TERM=PS*(2.D0+ONEMTH*ONEMTH)
          TRANS00=(2.D0+TERM)/5.D0
          TRANS10=(3.D0-TERM)/3.D0
          TRANS01=(3.D0-TERM)/5.D0
          TRANS11=TERM/3.D0
          ACO0=A0XPX0*TRANS00+A1XPX1*TRANS10
          ACO1=A0XPX0*TRANS01+A1XPX1*TRANS11
          IF(ACO0.LT.SMALL.OR.ACO1.LT.SMALL)CALL SCALE2(SCALEC,ACO0
     1      ,ACO1,EPSI)
C
C SISTER'S SON AND BROTHER'S DAUGHTER.
C
          A0XPX0=ACO20*PXKIK0
          A1XPX1=ACO21*PXKIK1
          TRANS11=PS*(1.D0-TH)
          TRANS10=1.D0-TRANS11
          TRANS01=TRANS10/3.D0
          TRANS00=1.D0-TRANS01
          ACO20=A0XPX0*TRANS00+A1XPX1*TRANS10
          ACO21=A0XPX0*TRANS01+A1XPX1*TRANS11
          IF(ACO20.LT.SMALL.OR.ACO21.LT.SMALL)CALL SCALE2(SCALEC2,ACO20
     1      ,ACO21,EPSI)
C 
C ALL OTHERS.
C
          ACO30=ACO30*PXKIK0
          IF(ACO30.LT.SMALL)CALL SCALE1(SCALEC3,ACO30,EPSI) 
C
        ENDIF
C
 300  CONTINUE
C
C FINISH EACH RELATIVE CLASS.
C
 310  DO 320 I=1,MAXREL
        PRREL(I)=-1.D20
 320  CONTINUE
C
C UNRELATEDS.
C
      TERM=AUN0*PXKIK0
      IF(TERM.GT.EPSI)PRREL(IRAND)=SCALEU+DLOG(TERM)
C
C PARENT/OFFSPRING.
C
      IF(POPOSS)THEN
        IF(XLINK.AND.XTYPE.EQ.2)THEN  
          TERM=APO0*PXKIK0
        ELSE
          TERM=APO1*PXKIK1
        ENDIF
        IF(TERM.GT.EPSI)PRREL(IPOFF)=SCALEP+DLOG(TERM)
      ENDIF
C
C HALF SIBS.
C
      TERM=AHS0*PXKIK0+AHS1*PXKIK1
      IF(TERM.GT.EPSI)PRREL(IHALF)=SCALEH+DLOG(TERM)
C
      IF(XLINK.AND.HSPOSS)THEN
        PR=-1.D20
        IF(XTYPE.EQ.1)THEN
          TERM=AHS21*PXKIK1
        ELSE
          TERM=AHS20*PXKIK0
        ENDIF
        IF(TERM.GT.EPSI)PR=SCALEH2+DLOG(TERM)
        IF(PR.GT.PRREL(IHALF))PRREL(IHALF)=PR 
      ENDIF
C
C FULL SIBS.
C
      IF(FSPOSS)THEN
        IF(XLINK)THEN
          IF(XTYPE.EQ.1)THEN
            TERM=AFS1*PXKIK1+AFS2*PXKIK2
          ELSE
            TERM=AFS0*PXKIK0+AFS1*PXKIK1
          ENDIF
        ELSE
          TERM=AFS0*PXKIK0+AFS1*PXKIK1+AFS2*PXKIK2
        ENDIF
        IF(TERM.GT.EPSI)PRREL(IFULL)=SCALEF+DLOG(TERM)
      ENDIF
C
C MZ TWINS.
C
      IF(MZPOSS)THEN
        IF(XLINK.AND.XTYPE.EQ.2)THEN
          TERM=AMZ1*PXKIK1
        ELSE
          TERM=AMZ2*PXKIK2
        ENDIF
        IF(TERM.GT.EPSI)PRREL(ITWIN)=SCALET+DLOG(TERM)
      ENDIF
C
C GRANDPARENT/GRANDCHILD.
C
      TERM=AGG0*PXKIK0+AGG1*PXKIK1
      IF(TERM.GT.EPSI)PRREL(IGRCH)=SCALEG+DLOG(TERM)
C
      IF(XLINK.AND.GGPOSS)THEN
        PR=-1.D20
        IF(XTYPE.EQ.1)THEN
          TERM=AGG21*PXKIK1
        ELSE
          TERM=AGG20*PXKIK0
        ENDIF
        IF(TERM.GT.EPSI)PR=SCALEG2+DLOG(TERM)
        IF(PR.GT.PRREL(IGRCH))PRREL(IGRCH)=PR 
      ENDIF
C
C AVUNCULAR.
C
      TERM=AAV0*PXKIK0+AAV1*PXKIK1
      IF(TERM.GT.EPSI)PRREL(IAVNC)=SCALEA+DLOG(TERM)
C
      IF(XLINK)THEN
        PR=-1.D20
        IF(XTYPE.EQ.1)THEN
          TERM=AAV20*PXKIK0+AAV21*PXKIK1
          IF(TERM.GT.EPSI)PR=SCALEA2+DLOG(TERM)
          IF(PR.GT.PRREL(IAVNC))PRREL(IAVNC)=PR 
        ELSE IF(XTYPE.EQ.2)THEN
          TERM=AAV20*PXKIK0
          IF(TERM.GT.EPSI)PR=SCALEA2+DLOG(TERM)
          IF(PR.GT.PRREL(IAVNC))PRREL(IAVNC)=PR 
        ELSE
          TERM=AAV20*PXKIK0+AAV21*PXKIK1
          IF(TERM.GT.EPSI)PR=SCALEA2+DLOG(TERM)
          IF(PR.GT.PRREL(IAVNC))PRREL(IAVNC)=PR 
          TERM=AAV30*PXKIK0
          IF(TERM.GT.EPSI)PR=SCALEA3+DLOG(TERM)
          IF(PR.GT.PRREL(IAVNC))PRREL(IAVNC)=PR 
          TERM=AAV40*PXKIK0+AAV41*PXKIK1
          IF(TERM.GT.EPSI)PR=SCALEA4+DLOG(TERM)
          IF(PR.GT.PRREL(IAVNC))PRREL(IAVNC)=PR 
        ENDIF
      ENDIF
C
C FIRST COUSINS.
C
      TERM=ACO0*PXKIK0+ACO1*PXKIK1
      IF(TERM.GT.EPSI)PRREL(ICOUS)=SCALEC+DLOG(TERM)
C
      IF(XLINK)THEN
        PR=-1.D20
        IF(XTYPE.EQ.1)THEN
          TERM=ACO20*PXKIK0+ACO21*PXKIK1
          IF(TERM.GT.EPSI)PR=SCALEC2+DLOG(TERM)
          IF(PR.GT.PRREL(ICOUS))PRREL(ICOUS)=PR 
          TERM=ACO30*PXKIK0+ACO31*PXKIK1
          IF(TERM.GT.EPSI)PR=SCALEC3+DLOG(TERM)
          IF(PR.GT.PRREL(ICOUS))PRREL(ICOUS)=PR 
        ELSE IF(XTYPE.EQ.2)THEN
          TERM=ACO20*PXKIK0
          IF(TERM.GT.EPSI)PR=SCALEC2+DLOG(TERM)
          IF(PR.GT.PRREL(ICOUS))PRREL(ICOUS)=PR 
        ELSE
          TERM=ACO20*PXKIK0+ACO21*PXKIK1
          IF(TERM.GT.EPSI)PR=SCALEC2+DLOG(TERM)
          IF(PR.GT.PRREL(ICOUS))PRREL(ICOUS)=PR 
          TERM=ACO30*PXKIK0
          IF(TERM.GT.EPSI)PR=SCALEC3+DLOG(TERM)
          IF(PR.GT.PRREL(ICOUS))PRREL(ICOUS)=PR 
        ENDIF
      ENDIF
C
      RETURN
      END
C
C
C
      SUBROUTINE SCALE1(SCALE,ALPHA,EPSI)
C
C CONVERT ALPHA TO LOG SCALE, HANDLING UNDERFLOW.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
      IF(ALPHA.LT.EPSI)THEN
        SCALE=-1.D20
        ALPHA=0.D0
      ELSE
        SCALE=SCALE+DLOG(ALPHA) 
        ALPHA=1.D0
      ENDIF
C
      RETURN
      END
C
C
C
      SUBROUTINE SCALE2(SCALE,ALPHA1,ALPHA2,EPSI)
C
C CONVERT ALPHA1 AND ALPHA2 TO LOG SCALE, HANDLING UNDERFLOW.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
      PRMAX=ALPHA1
      IF(ALPHA2.GT.PRMAX)PRMAX=ALPHA2
      IF(PRMAX.LT.EPSI)THEN
        SCALE=-1.D20
        ALPHA1=0.D0
        ALPHA2=0.D0
      ELSE
        SCALE=SCALE+DLOG(PRMAX)
        FACTOR=1.D0/PRMAX
        ALPHA1=ALPHA1*FACTOR
        ALPHA2=ALPHA2*FACTOR
      ENDIF
C
      RETURN
      END
C
C
C
      SUBROUTINE SCALE3(SCALE,ALPHA1,ALPHA2,ALPHA3,EPSI)
C
C CONVERT ALPHA1, ALPHA2, AND ALPHA3 TO LOG SCALE, HANDLING UNDERFLOW.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
      PRMAX=ALPHA1
      IF(ALPHA2.GT.PRMAX)PRMAX=ALPHA2
      IF(ALPHA3.GT.PRMAX)PRMAX=ALPHA3
      IF(PRMAX.LT.EPSI)THEN
        SCALE=-1.D20
        ALPHA1=0.D0
        ALPHA2=0.D0
        ALPHA3=0.D0
      ELSE
        SCALE=SCALE+DLOG(PRMAX)
        FACTOR=1.D0/PRMAX
        ALPHA1=ALPHA1*FACTOR
        ALPHA2=ALPHA2*FACTOR
        ALPHA3=ALPHA3*FACTOR
      ENDIF
C
      RETURN
      END
C
C
C
      SUBROUTINE PRBEST(IBEST,PR,PRMAX,IPUTREL,MINSHR,NTYPE2,MAXREL
     1,I2ND,PR2ND)
C
C DETERMINE WHICH RELATIVE CLASS IS MOST LIKELY.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
      DOUBLE PRECISION PR(MAXREL)
C
      EPSI=1.D-20
      PRMAX=-1.D20
      PR2ND=-1.D30
      IBEST=-1
      I2ND=-1
      DO 20 IREL=MAXREL,1,-1
        IF(PR(IREL).GT.(PRMAX+EPSI))THEN
          PR2ND=PRMAX
          I2ND=IBEST
          PRMAX=PR(IREL)
          IBEST=IREL
        ELSE IF(PR(IREL).GT.(PR2ND+EPSI))THEN
          PR2ND=PR(IREL)
          I2ND=IREL
        ENDIF
 20   CONTINUE
C
      RETURN
      END
C
C
C 
      SUBROUTINE SUMUP(ALLPR,IBEST,MAXREL,NTYPE2,FAMIDI,FAMIDJ,PRLIK
     1,PRMAX,PRREL,IPUTREL,NPAIR,SIB1ID,SIB2ID,TWINI,TWINJ,MXPTOT
     2,OUTTYPE,RATIO,CRITVAL,DIFINF,BUFF,IBUFF,FAMBUF,IFAMBUF,MINSHR
     3,NFAM,KDISC,MAXFAM,I2ND,PR2ND,KTAB1,KTAB2,KNUFF)
C
C STORE THE RESULTS FOR THE CURRENT PAIR AND UPDATE THE COUNTS.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      COMMON /D1/ITWIN,IFULL,IPOFF,IHALF,IGRCH,IAVNC,ICOUS,IRAND
      COMMON /D2/KCON,KRES,KLOC,KPED,KIN,KOUT,KDET
      COMMON /D4/IRECL
C
      CHARACTER*1 CTWIN
      CHARACTER*8 FAMIDI,FAMIDJ,SIB1ID,SIB2ID,TWINI,TWINJ
      CHARACTER*5000000 BUFF(MAXREL)
      CHARACTER*5000000 FAMBUF
      DOUBLE PRECISION PRLIK(MAXREL),PRREL(MAXREL)
      INTEGER OUTTYPE,IBUFF(MAXREL),KTAB1(MAXREL,MAXREL),IFAMBUF
     1,KDISC(MAXFAM),KTAB2(MAXREL,MAXREL)
      LOGICAL ALLPR,DIFINF,DIFFAM,DISCREP,ENUFF
      CHARACTER*2 RELNAM(MAXREL)
      CHARACTER*6 RATSTR
C
      CALL MBLANK(FAMIDI)
      CALL MBLANK(FAMIDJ)
C
      ENUFF=NTYPE2.GE.MINSHR
      DIFFAM=FAMIDI.NE.FAMIDJ
      IF(ENUFF)THEN
        KNUFF=KNUFF+1
      ELSE IF(DIFFAM)THEN
        GO TO 110
      ENDIF
C
      RELNAM(ITWIN)='MZ'
      RELNAM(IFULL)='FS'
      RELNAM(IPOFF)='PO'
      RELNAM(IHALF)='HS'
      RELNAM(IGRCH)='GG'
      RELNAM(IAVNC)='AV'
      RELNAM(ICOUS)='CO'
      RELNAM(IRAND)='UN'
C
C MARK APPARENT TWINS THAT WERE ALREADY LABELED AS TWINS
C IN THE PEDIGREE FILE.
C
      CTWIN=' '
      IF(TWINI.EQ.TWINJ.AND.TWINI(1:1).NE.' ')CTWIN='*'
C
      DO 100 IREL=1,MAXREL
        PRLIK(IREL)=0.D0
        IF(PRREL(IREL).GT.-1.D8.AND.(PRREL(IREL)-PRMAX).GT.-1.D2)THEN
          PRLIK(IREL)=DEXP(PRREL(IREL)-PRMAX)
        ENDIF
 100  CONTINUE
C
      IF(ENUFF)THEN
        IF(PRLIK(I2ND).LT.1.D-20)THEN
          RAT2=1.D100
        ELSE
          RAT2=PRLIK(IBEST)/PRLIK(I2ND)
        ENDIF
        IF(RAT2.GE.CRITVAL)THEN
          KTAB1(IPUTREL,IBEST)=KTAB1(IPUTREL,IBEST)+1
        ENDIF
      ENDIF
C
C STORE THE STATISTICS FOR THIS PAIR.  EXCEPT WHEN ALL PAIRS ARE BEING 
C OUTPUT (OUTTYPE=2) OR BOTH MEMBERS OF THE PAIR BELONG TO THE SAME FAMILY, 
C ONLY INCLUDE THOSE PAIRS WHOSE RATIO OF INFERRED VS PUTATIVE IS GREATER 
C THAN THE CRITICAL VALUE AND WHICH SHARE AT LEAST MINSHR TYPED LOCI.
C
      IF(PRLIK(IPUTREL).LT.1.D-20)THEN
        RATIO=1.D100
      ELSE
        RATIO=PRLIK(IBEST)/PRLIK(IPUTREL)
      ENDIF
      RATSTR='> 10^6'
      IF(RATIO.LT.1.D6)THEN
        IF(RATIO.GE.1.D4)THEN
          WRITE(RATSTR,101)IDINT(RATIO)
        ELSE
          WRITE(RATSTR,102)RATIO
        ENDIF
      ENDIF
C
      DISCREP=DIFINF.AND.ENUFF.AND.RATIO.GE.CRITVAL
C
      IF(.NOT.DIFFAM)THEN
        WRITE(FAMBUF(IFAMBUF:IFAMBUF+IRECL),103),FAMIDI,SIB1ID
     1  ,RELNAM(IPUTREL),RELNAM(IBEST),(PRLIK(IREL),IREL=1,MAXREL)
     2  ,FAMIDJ,SIB2ID,RATSTR,NTYPE2
        IFAMBUF=IFAMBUF+IRECL
        IF(IFAMBUF.GT.5000000)THEN
          WRITE(KOUT,104)' *** ERROR *** OVERFLOWED OUTPUT BUFFER'
          STOP
        ENDIF
        IF(DISCREP)THEN
          KDISC(NFAM)=KDISC(NFAM)+1
          KTAB2(IPUTREL,IBEST)=KTAB2(IPUTREL,IBEST)+1
        ENDIF
      ELSE IF(OUTTYPE.EQ.2.OR.DISCREP)THEN
        IF(DISCREP)THEN
          KTAB2(IPUTREL,IBEST)=KTAB2(IPUTREL,IBEST)+1
        ENDIF
        WRITE(BUFF(IBEST)(IBUFF(IBEST):IBUFF(IBEST)+IRECL),103)
     1  FAMIDI,SIB1ID,RELNAM(IPUTREL),RELNAM(IBEST),(PRLIK(IREL)
     2  ,IREL=1,MAXREL),FAMIDJ,SIB2ID,RATSTR,NTYPE2
        IBUFF(IBEST)=IBUFF(IBEST)+IRECL
        IF(IBUFF(IBEST).GT.5000000)THEN
          WRITE(KOUT,104)' *** ERROR *** OVERFLOWED OUTPUT BUFFER'
          STOP
        ENDIF
      ENDIF
 101  FORMAT(I6)
 102  FORMAT(F6.1)
 103  FORMAT(2A8,2A2,8F6.4,2A8,A6,I4)
 104  FORMAT(A)
C
 110  RETURN
      END
C
C 
C
      SUBROUTINE FINAL(ALLPR,MINSHR,NTYPE2,OUTTYPE,NPAIR
     1,GENERR,KTAB2,MAXREL,CRITVAL,BUFF,IBUFF,FAMPRS,FAMBUF,IFAMBUF
     2,KDISC,MAXFAM,NPED,KTAB1,KNUFF)
C
C REPORT THE RESULTS FOR THE COUNTS.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      COMMON /D1/ITWIN,IFULL,IPOFF,IHALF,IGRCH,IAVNC,ICOUS,IRAND
      COMMON /D2/KCON,KRES,KLOC,KPED,KIN,KOUT,KDET
      COMMON /D4/IRECL
C
      INTEGER KTAB2(MAXREL,MAXREL),OUTTYPE,KINF2(MAXREL),KPUT2(MAXREL)
     1,IBUFF(MAXREL),FAMPRS(MAXFAM),KDISC(MAXFAM),FAMIND(250000)
     2,ALLIND(200000),KTAB1(MAXREL,MAXREL),KPUT1(MAXREL),KINF1(MAXREL)
      LOGICAL ALLPR
      CHARACTER*5 DSCSTR
      CHARACTER*32 RELSTR(MAXREL)
      CHARACTER*79 LINSTR(31)
      CHARACTER*256 TMPSTR
      CHARACTER*5000000 BUFF(MAXREL),FAMBUF,TMPBUF1,TMPBUF2
      DOUBLE PRECISION FAMRAT(250000),ALLRAT(200000)
C
      WRITE(KRES,*)
      WRITE(KRES,12)MINSHR,KNUFF
 12   FORMAT(' NUMBER OF PAIRS SHARING ENOUGH TYPED LOCI (>= ',I4,'): '
     1,I10)
      WRITE(KRES,13)MINSHR,NPAIR-KNUFF
 13   FORMAT(' NUMBER OF PAIRS SHARING TOO FEW TYPED LOCI (< ',I4,'): '
     1,I10)
      WRITE(KRES,14)
 14   FORMAT(' ',63('-'),' ')
      WRITE(KRES,21)NPAIR
 21   FORMAT(' TOTAL NUMBER OF PAIRS BEING ANALYZED:                '
     1,I10/)
C
      KTOT1=0
      KTOT2=0
      DO 779 I=1,MAXREL
        KPUT2(I)=0
        KINF2(I)=0
        KPUT1(I)=0
        KINF1(I)=0
        DO 778 J=1,MAXREL
          KPUT2(I)=KPUT2(I)+KTAB2(I,J)
          KINF2(I)=KINF2(I)+KTAB2(J,I)
          KTOT2=KTOT2+KTAB2(I,J)
          KPUT1(I)=KPUT1(I)+KTAB1(I,J)
          KINF1(I)=KINF1(I)+KTAB1(J,I)
          KTOT1=KTOT1+KTAB1(I,J)
 778    CONTINUE
 779  CONTINUE
C
      WRITE(KRES,51)'NOTATION:'
      WRITE(KRES,52)'        MZ -- MONOZYGOTIC TWINS     '
     1,             '      FULL(FS) -- FULL SIBS         '
      WRITE(KRES,52)' P/OFF(PO) -- PARENT/OFFSPRING      '
     1,             '      HALF(HS) -- HALF SIBS         '
      WRITE(KRES,52)' GP/GC(GG) -- GRANDPARENT/GRANDCHILD'
     1,             '      AVNC(AV) -- AVUNCULAR         '
      WRITE(KRES,52)'  COUS(CO) -- FIRST COUSINS         '
     1,             '     UNREL(UN) -- UNRELATED         '
 51   FORMAT(/4X,A9/)
 52   FORMAT(4X,2(A38))
      CALL DRAWLN(KRES,1)  
C
      WRITE(KDET,51)'NOTATION:'
      WRITE(KDET,52)'        MZ -- MONOZYGOTIC TWINS     '
     1,             '      FULL(FS) -- FULL SIBS         '
      WRITE(KDET,52)' P/OFF(PO) -- PARENT/OFFSPRING      '
     1,             '      HALF(HS) -- HALF SIBS         '
      WRITE(KDET,52)' GP/GC(GG) -- GRANDPARENT/GRANDCHILD'
     1,             '      AVNC(AV) -- AVUNCULAR         '
      WRITE(KDET,52)'  COUS(CO) -- FIRST COUSINS         '
     1,             '     UNREL(UN) -- UNRELATED         '
      CALL DRAWLN(KDET,1)  
C
C PUTATIVE-INFERRED RELATIONSHIP TABLE WITH BORDERS.
C
      WRITE(KRES,24)CRITVAL
 24   FORMAT(/3X,'TABLE 1.  COUNTS OF STRONGLY INFERRED'
     1,' RELATIONSHIPS',//3X,'CONSISTS OF PAIRS WHOSE INFERRED'
     2,' RELATIONSHIP IS MORE LIKELY THAN ALL OTHERS '/3X,'BY AT'
     3,' LEAST A FACTOR OF "CRITVAL" (',F8.2,')'/)
      WRITE(KRES,25)
 25   FORMAT(/34X,'INFERRED RELATIONSHIP'/)
C
      LINSTR(1)(1:39)= '    _______ _____ ______ ______ ______ '
      LINSTR(2)(1:39)= '   |       |     |      |      |      |'
      LINSTR(3)(1:39)= '   |       | MZ  | FULL | P/OFF| HALF |'
      LINSTR(4)(1:39)= '   |_______|_____|______|______|______|'
      LINSTR(5)(1:39)= '   |       |     |      |      |      |'
      LINSTR(6)(1:39)= ' P | MZ    |     |      |      |      |'
      LINSTR(7)(1:39)= ' U |_______|_____|______|______|______|'
      LINSTR(8)(1:39)= ' T |       |     |      |      |      |'
      LINSTR(9)(1:39)= ' A | FULL  |     |      |      |      |'
      LINSTR(10)(1:39)=' T |_______|_____|______|______|______|'
      LINSTR(11)(1:39)=' I |       |     |      |      |      |'
      LINSTR(12)(1:39)=' V | P/OFF |     |      |      |      |'
      LINSTR(13)(1:39)=' E |_______|_____|______|______|______|'
      LINSTR(14)(1:39)='   |       |     |      |      |      |'
      LINSTR(15)(1:39)=' R | HALF  |     |      |      |      |'
      LINSTR(16)(1:39)=' E |_______|_____|______|______|______|'
      LINSTR(17)(1:39)=' L |       |     |      |      |      |'
      LINSTR(18)(1:39)=' A | GP/GC |     |      |      |      |'
      LINSTR(19)(1:39)=' T |_______|_____|______|______|______|'
      LINSTR(20)(1:39)=' I |       |     |      |      |      |'
      LINSTR(21)(1:39)=' O | AVNC  |     |      |      |      |'
      LINSTR(22)(1:39)=' N |_______|_____|______|______|______|'
      LINSTR(23)(1:39)=' S |       |     |      |      |      |'
      LINSTR(24)(1:39)=' H | COUS  |     |      |      |      |'
      LINSTR(25)(1:39)=' I |_______|_____|______|______|______|'
      LINSTR(26)(1:39)=' P |       |     |      |      |      |'
      LINSTR(27)(1:39)='   | UNREL |     |      |      |      |'
      LINSTR(28)(1:39)='   |_______|_____|______|______|______|'
      LINSTR(29)(1:39)='   |       |     |      |      |      |'
      LINSTR(30)(1:39)='   | TOTAL |     |      |      |      |'
      LINSTR(31)(1:39)='   |_______|_____|______|______|______|'
C
      LINSTR(1)(40:79)= '______ ______ _______ ________ ________ '
      LINSTR(2)(40:79)= '      |      |       |        |        |'
      LINSTR(3)(40:79)= ' GP/GC| AVNC | COUS  |  UNREL |  TOTAL |'
      LINSTR(4)(40:79)= '______|______|_______|________|________|'
      LINSTR(5)(40:79)= '      |      |       |        |        |'
      LINSTR(6)(40:79)= '      |      |       |        |        |'
      LINSTR(7)(40:79)= '______|______|_______|________|________|'
      LINSTR(8)(40:79)= '      |      |       |        |        |'
      LINSTR(9)(40:79)= '      |      |       |        |        |'
      LINSTR(10)(40:79)='______|______|_______|________|________|'
      LINSTR(11)(40:79)='      |      |       |        |        |'
      LINSTR(12)(40:79)='      |      |       |        |        |'
      LINSTR(13)(40:79)='______|______|_______|________|________|'
      LINSTR(14)(40:79)='      |      |       |        |        |'
      LINSTR(15)(40:79)='      |      |       |        |        |'
      LINSTR(16)(40:79)='______|______|_______|________|________|'
      LINSTR(17)(40:79)='      |      |       |        |        |'
      LINSTR(18)(40:79)='      |      |       |        |        |'
      LINSTR(19)(40:79)='______|______|_______|________|________|'
      LINSTR(20)(40:79)='      |      |       |        |        |'
      LINSTR(21)(40:79)='      |      |       |        |        |'
      LINSTR(22)(40:79)='______|______|_______|________|________|'
      LINSTR(23)(40:79)='      |      |       |        |        |'
      LINSTR(24)(40:79)='      |      |       |        |        |'
      LINSTR(25)(40:79)='______|______|_______|________|________|'
      LINSTR(26)(40:79)='      |      |       |        |        |'
      LINSTR(27)(40:79)='      |      |       |        |        |'
      LINSTR(28)(40:79)='______|______|_______|________|________|'
      LINSTR(29)(40:79)='      |      |       |        |        |'
      LINSTR(30)(40:79)='      |      |       |        |        |'
      LINSTR(31)(40:79)='______|______|_______|________|________|'
C
      DO 29 IREL=1,MAXREL
        WRITE(LINSTR(3*(IREL+1))(13:78),444)(KTAB1(IREL,JREL)
     1  ,JREL=1,MAXREL),KPUT1(IREL)
 444    FORMAT(I5,'|',5(I6,'|'),I7,'|',I8,'|',I8)
 29   CONTINUE
      WRITE(LINSTR(30)(13:78),444)(KINF1(JREL),JREL=1,MAXREL),KTOT1
C
      DO 30 I=1,31
        WRITE(KRES,445)LINSTR(I)
 445    FORMAT(A79)
 30   CONTINUE
C
      WRITE(KRES,*)
      CALL DRAWLN(KRES,1)  
C
      WRITE(KRES,26)CRITVAL
 26   FORMAT(/3X,'TABLE 2.  COUNTS OF LIKELY DISCREPANCIES'//3X
     1,'CONSISTS OF PAIRS WHOSE INFERRED RELATIONSHIP IS MORE LIKELY'
     2,' THAN THE PUTATIVE '/3X,'RELATIONSHIP BY AT LEAST A FACTOR OF'
     3,' "CRITVAL" (',F8.2,')'/)
      WRITE(KRES,25)
C
      DO 31 IREL=1,MAXREL
        WRITE(LINSTR(3*(IREL+1))(13:78),444)(KTAB2(IREL,JREL)
     1  ,JREL=1,MAXREL),KPUT2(IREL)
 31   CONTINUE
      WRITE(LINSTR(30)(13:78),444)(KINF2(JREL),JREL=1,MAXREL),KTOT2
C
      DO 32 I=1,31
        WRITE(KRES,445)LINSTR(I)
 32   CONTINUE
C
      KFAMPR=0
      KALLPR=0
      ITMP1=1
      ITMP2=1
C
C OUTPUT FAMILIES IN WHICH AT LEAST ONE DISCREPANCY WAS FOUND.
C
      IND=1
      DO 50 IFAM=1,NPED
        NPAIRS=FAMPRS(IFAM)
        IF(KDISC(IFAM).GT.0.OR.OUTTYPE.EQ.2)THEN
          IF(KDISC(IFAM).EQ.1)THEN
            WRITE(KDET,112)FAMBUF(IND:IND+7)
 112        FORMAT(' *** ALL PAIRS WITHIN FAMILY ',A
     1      ,' (1 DISCREPANCY) ***')
          ELSE
            WRITE(TMPSTR,113)KDISC(IFAM)
 113        FORMAT('(',I8,' ')
            CALL MBLANK(TMPSTR(1:9))
            I=INDEX(TMPSTR,' ')
            TMPSTR(I+1:I+18)='DISCREPANCIES) ***'
            WRITE(KDET,114)FAMBUF(IND:IND+7),TMPSTR(1:I+18)
 114        FORMAT(' *** ALL PAIRS WITHIN FAMILY ',A,' ',A)
          ENDIF
          CALL DRAWLN(KDET,1)
          CALL DOHDR(KDET)
          CALL DRAWLN(KDET,0)
          DO 49 IPAIR=1,NPAIRS
            TMPSTR=FAMBUF(IND:IND+IRECL)
            DSCSTR='     '
            IF(TMPSTR(85:90).EQ.'> 10^6')THEN
              RAT=1000001.D0
            ELSE
              READ(TMPSTR(85:90),996)RAT
 996          FORMAT(F6.0)
            ENDIF
            READ(TMPSTR(91:94),997)KOM
 997        FORMAT(I4)
            IF(TMPSTR(17:18).NE.TMPSTR(19:20).AND.RAT.GE.CRITVAL
     1          .AND.KOM.GE.MINSHR)THEN
              DSCSTR='^^^^^'
              IF(RAT.GE.CRITVAL)THEN
                KFAMPR=KFAMPR+1
                IF(KFAMPR.GE.250000)GO TO 300
                  FAMRAT(KFAMPR)=RAT
                  WRITE(TMPBUF1(ITMP1:ITMP1+48),998)TMPSTR(1:8)
     1            ,TMPSTR(9:16),TMPSTR(77:84),TMPSTR(17:18)
     2            ,TMPSTR(19:20),TMPSTR(85:90)
 998              FORMAT(1X,3(A8,2X),2(A2,2X),3X,A6)
                  ITMP1=ITMP1+48
              ENDIF
            ENDIF
            DO 33 I=1,MAXREL
              ISTART=21+6*(I-1)
              IEND=26+6*(I-1)
              IF(TMPSTR(ISTART:IEND).EQ.'0.0000')THEN
                TMPSTR(ISTART:IEND)='<.0001'
              ENDIF
 33         CONTINUE
            WRITE(KDET,999)TMPSTR(1:8),TMPSTR(9:16),TMPSTR(17:18)
     1      ,TMPSTR(19:20),TMPSTR(21:26),TMPSTR(27:32),TMPSTR(33:38)
     2      ,TMPSTR(39:44),TMPSTR(45:50),TMPSTR(51:56),TMPSTR(57:62)
     3      ,TMPSTR(63:68),TMPSTR(69:76),TMPSTR(77:84),DSCSTR
     4      ,TMPSTR(85:90),TMPSTR(91:94)
 999        FORMAT(/2(1X,A8),2(1X,A2),8A7/2(1X,A8),1X,A5,1X
     1      ,'INF/PUT RATIO: ',A6,4X,'# SHARED GENOTYPED LOCI: ',A5)
            IND=IND+IRECL
 49       CONTINUE
          WRITE(KDET,*)
          IF(IFAM.LT.NPED.OR.ALLPR)CALL DRAWLN(KDET,1)
        ELSE
          IND=IND+IRECL*NPAIRS
        ENDIF
 50   CONTINUE
C
C OUTPUT PAIRS FROM DIFFERENT FAMILIES FOR WHICH THE PUTATIVE AND 
C INFERRED RELATIONSHIPS DIFFER.
C
      IF(ALLPR)THEN
        RELSTR(ITWIN)='MZ TWINS ***'
        RELSTR(IFULL)='FULL SIBS ***'
        RELSTR(IPOFF)='PARENT/OFFSPRING ***'
        RELSTR(IHALF)='HALF SIBS ***'
        RELSTR(IGRCH)='GRANDPARENT/GRANDCHILD ***'
        RELSTR(IAVNC)='AVUNCULAR ***'
        RELSTR(ICOUS)='FIRST COUSINS ***'
        RELSTR(IRAND)='UNRELATED ***'
        DSCSTR='^^^^^'
        DO 61 IREL=1,MAXREL
          IF(KTAB2(IRAND,IREL).EQ.0)GO TO 61
          IF(OUTTYPE.NE.2.AND.IREL.EQ.IRAND)GO TO 61
          WRITE(KDET,111)RELSTR(IREL)
 111      FORMAT(' *** PUTATIVE UNRELATED PAIRS MOST LIKELY ',A)
          CALL DRAWLN(KDET,1)
          CALL DOHDR(KDET)
          CALL DRAWLN(KDET,0)
          KREC=IBUFF(IREL)/IRECL
          IND=1
          DO 60 IREC=1,KREC
            TMPSTR=BUFF(IREL)(IND:IND+IRECL)
            IF(TMPSTR(85:90).EQ.'> 10^6')THEN
              RAT=1000001.D0
            ELSE
              READ(TMPSTR(85:90),996)RAT
            ENDIF
            IF(RAT.GE.CRITVAL)THEN
              KALLPR=KALLPR+1
              IF(KALLPR.GE.200000)GO TO 300
                ALLRAT(KALLPR)=RAT
                WRITE(TMPBUF2(ITMP2:ITMP2+58),995)TMPSTR(1:8)
     1          ,TMPSTR(9:16),TMPSTR(69:76),TMPSTR(77:84),TMPSTR(17:18)
     2          ,TMPSTR(19:20),TMPSTR(85:90)
 995            FORMAT(1X,4(A8,2X),2(A2,2X),3X,A6)
                ITMP2=ITMP2+58
            ENDIF
            DO 34 I=1,MAXREL
              ISTART=21+6*(I-1)
              IEND=26+6*(I-1)
              IF(TMPSTR(ISTART:IEND).EQ.'0.0000')THEN
                TMPSTR(ISTART:IEND)='<.0001'
              ENDIF
 34         CONTINUE
            WRITE(KDET,999)TMPSTR(1:8),TMPSTR(9:16),TMPSTR(17:18)
     1      ,TMPSTR(19:20),TMPSTR(21:26),TMPSTR(27:32),TMPSTR(33:38)
     2      ,TMPSTR(39:44),TMPSTR(45:50),TMPSTR(51:56),TMPSTR(57:62)
     3      ,TMPSTR(63:68),TMPSTR(69:76),TMPSTR(77:84),DSCSTR
     4      ,TMPSTR(85:90),TMPSTR(91:94)
            IND=IND+IRECL
 60         CONTINUE
          WRITE(KDET,*)
          IF(IREL.LT.MAXREL)CALL DRAWLN(KDET,1)
 61       CONTINUE
        ENDIF
C
C SORT AND WRITE OUT THE STRONGEST DISCREPANCIES.
C
      WRITE(KRES,*)
      CALL DRAWLN(KRES,1)
      WRITE(KRES,*)'*** STRONGEST DISCREPANCIES WITHIN FAMILIES ***'
      CALL DRAWLN(KRES,1)
      WRITE(KRES,292)
 292  FORMAT('  PED       ID1       ID2      PUT INF  INF/PUT RATIO')
      CALL DRAWLN(KRES,1)
C
      IF(KFAMPR.EQ.0)THEN
        WRITE(KRES,*)' NONE.'
      ELSE IF(KFAMPR.EQ.1)THEN
        FAMIND(1)=1
      ELSE
        CALL INDEXX(FAMRAT,FAMIND,KFAMPR,250000)
      ENDIF
      DO 70 I=KFAMPR,1,-1
        IND=1+48*(FAMIND(I)-1)
        WRITE(KRES,293)TMPBUF1(IND:IND+47)
 293    FORMAT(A48)
 70   CONTINUE
C
      IF(ALLPR)THEN
        WRITE(KRES,*)
        CALL DRAWLN(KRES,1)
        WRITE(KRES,*)'*** STRONGEST DISCREPANCIES ACROSS FAMILIES ***'
        CALL DRAWLN(KRES,1)
        WRITE(KRES,*)'  PED1      ID1       PED2      ID2     PUT INF  '
     1  ,'INF/PUT RATIO'
        CALL DRAWLN(KRES,1)
C
        IF(KALLPR.EQ.0)THEN
          WRITE(KRES,*)' NONE.'
        ELSE IF(KALLPR.EQ.1)THEN
          ALLIND(1)=1
        ELSE
          CALL INDEXX(ALLRAT,ALLIND,KALLPR,200000)
        ENDIF
        DO 80 I=KALLPR,1,-1
          IND=1+58*(ALLIND(I)-1)
          WRITE(KRES,294)TMPBUF2(IND:IND+57)
 294      FORMAT(A58)
 80     CONTINUE
      ENDIF
C
C AT THIS POINT, WE'RE DONE.
C
      WRITE(KOUT,295)
 295  FORMAT(1X,'ANALYSIS COMPLETE. ')
      CLOSE(KRES)
      CLOSE(KDET)
      RETURN
C
 300  WRITE(KOUT,296)' *** ERROR *** OVERFLOWED OUTPUT BUFFER'
 296  FORMAT(A)
      STOP
C
      END
C
C
C
      SUBROUTINE DOHDR(KDEV)
C
C WRITE THE HEADER FOR THIS CATEGORY TO THE SPECIFIED DEVICE.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
      WRITE(KDEV,101)
 101  FORMAT(16X,'RELATION',21X,'LIKELIHOOD RATIOS ')
      WRITE(KDEV,102)
 102  FORMAT('  PED      ID    PUT INF   MZ    FULL'
     1,'   P/OFF  HALF   GP/GC  AVNC  COUSIN  UNREL ')
C
      RETURN
      END
C
C
C
      SUBROUTINE INDEXX(ARRAY,INDX,N,MAXN)
C
C INDEX THE ARRAY ARRAY.  THAT IS, CREATE AN ARRAY INDEX SUCH THAT
C ARRAY(INDX(I)) IS IN ASCENDING ORDER FOR THE FIRST N ARRAY ELEMENTS.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION ARRAY(MAXN)
      INTEGER INDX(MAXN)
C
      DO 1 J=1,N
        INDX(J)=J
 1    CONTINUE
C
      L=N/2+1
      IR=N
C
 10   CONTINUE
        IF(L.GT.1)THEN
          L=L-1
          INDXT=INDX(L)
          Q=ARRAY(INDXT)
        ELSE
          INDXT=INDX(IR)
          Q=ARRAY(INDXT)
          INDX(IR)=INDX(1)
          IR=IR-1
          IF(IR.EQ.1)THEN
            INDX(1)=INDXT
            GO TO 30
          ENDIF
        ENDIF
        I=L
        J=L+L
 20     IF(J.LE.IR)THEN
          IF(J.LT.IR.AND.ARRAY(INDX(J)).LT.ARRAY(INDX(J+1)))J=J+1
          IF(Q.LT.ARRAY(INDX(J)))THEN
            INDX(I)=INDX(J)
            I=J
            J=J+J
          ELSE
            J=IR+1
          ENDIF
        GO TO 20
        ENDIF
        INDX(I)=INDXT
      GO TO 10
C
 30   RETURN
      END
