C **********************************************************************
C **********************************************************************
C *************************   PROGRAM RH2PT   **************************
C **********************************************************************
C **************************   VERSION 3.00  ***************************
C **********************************************************************
C ************************    SEPTEMBER 1996  **************************
C **********************************************************************
C ********* PROGRAMMED BY ELIZABETH HAUSER AND MICHAEL BOEHNKE *********
C **********************************************************************
C **********************************************************************
C ** CALCULATE DESCRIPTIVE STATISTICS FOR RH MAPPING EXPERIMENTS,     **
C ** INCLUDING RETENTION PROBABILITY ESTIMATES, BREAKAGE PROBABILITY  **
C ** ESTIMATES, TWO-POINT LOD SCORES USING COX'S MODEL AND THE EQUAL  **
C ** RETENTION PROBABILITY MODEL, AND LINKAGE GROUPS.  ALLOW PROPERLY **
C ** FOR ANY PLOIDY.                                                  **
C **********************************************************************
C **********************************************************************
C
C INITIALIZATIONS
C
      IMPLICIT REAL*8(A-H,O-Z)
      PARAMETER(MAXCHR=2,MAXHYB=200,MAXLOC=60
     1,MXPAIR=MAXLOC*(MAXLOC-1)/2,NCUTPT=3)
C
      CHARACTER*1 CRET(MAXLOC)
      CHARACTER*4 LNAME(MAXLOC),LNAMEP(MAXLOC)
      CHARACTER*8 HNAME(MAXHYB)
      CHARACTER*10 GROUP(MAXLOC)
C
      INTEGER EALL(NCUTPT),ENDPT(NCUTPT,2,MXPAIR),N(0:2,0:2)
     1,NOBS(MAXHYB),OUTOPT,PERM(MAXLOC),RETAIN(MAXHYB,MAXLOC)
     2,X(NCUTPT,MAXLOC)
C
      REAL*8 LODCUT(NCUTPT)
C
      DATA LODCUT/4.D0,6.D0,8.D0/
      DATA EALL/3*0/
      DATA KTERMR,KTERMW/5,6/
      DATA KIN,KOUT,KSCR/7,8,4/
      SMALL=1.D-7
C
C PRINT HEADERS, READ THE FILE NAMES, AND DEFINE THE LOGICAL UNIT NUMBERS.
C
      CALL FILES(KIN,KOUT,KSCR,KTERMR,KTERMW)
C
C INPUT THE DATA.  PRINT TABLES 1, 2, AND 3.  
C
      CALL INCON(CRET,HNAME,KIN,KOUT,KTERMW,LNAME,LNAMEP,MAXCHR,MAXHYB
     1,MAXLOC,NCHR,NERR,NHYB,NHYBT,NLOCUS,NOBS,NTOTAL,OUTOPT,PERM
     2,RETAIN)
C
C IF ERRORS WERE ENCOUNTERED, STOP.  OTHERWISE, DO THE REMAINING
C CALCULATIONS AND PRINT THE CORRESPONDING TABLES.
C
      IF(NERR.GT.0)GO TO 10
C
C CREATE TABLE 4:  LOCUS RETENTION PROBABILITIES.
C
      CALL TABLE4(KOUT,LNAME,MAXHYB,MAXLOC,NCHR,NHYB,NLOCT,NLOCUS
     1,NOBS,NTOTAL,PERM,RETAIN)
C
C IF DESIRED, CREATE TABLE 5:  CORETENTION PROBABILITIES.
C
      IF(OUTOPT.EQ.0)
     1 CALL TABLE5(KOUT,LNAME,MAXHYB,MAXLOC,N,NHYB,NLOCUS,NOBS,PERM
     2,RETAIN,SMALL)
C
C CREATE TABLE 6:  TWO-POINT LOD SCORES AND PARAMETER ESTIMATES.
C
      CALL TABLE6(EALL,ENDPT,KOUT,LNAME,LODCUT,MAXHYB,MAXLOC
     1,MXPAIR,N,NCHR,NHYB,NLOCUS,NCUTPT,NOBS,PERM,RETAIN,SMALL)
C
C WRITE OUT THE TABLE OF LINKAGE GROUPS.
C
      CALL TABLE7(EALL,ENDPT,GROUP,KOUT,LNAME,LODCUT,MAXLOC,MXPAIR
     1,NLOCUS,NCUTPT,PERM,X)
C
C CREATE TABLE 8:  PAIRS OF TOTALLY-LINKED LOCI.
C
      CALL TABLE8(KOUT,LNAME,MAXHYB,MAXLOC,N,NHYB,NLOCUS,NOBS,PERM
     1,RETAIN)
C
 10   STOP
      END
C
C
C
      SUBROUTINE FILES(KIN,KOUT,KSCR,KTERMR,KTERMW)
C
C PRINT HEADERS, READ THE FILE NAMES, AND DEFINE THE LOGICAL UNIT NUMBERS.
C
      CHARACTER*80 FILNAM
 101  FORMAT(A)
C
C OUTPUT A HEADER FOR THE PROGRAM TO THE SCREEN FILE.
C
      WRITE(KTERMW,101)' *********************************************'
      WRITE(KTERMW,101)' *************   PROGRAM RH2PT   *************'
      WRITE(KTERMW,101)' *********************************************'
      WRITE(KTERMW,101)' **************   VERSION 3.00  **************'
      WRITE(KTERMW,101)' *********************************************'
      WRITE(KTERMW,101)' *************   SEPTEMBER 1996  *************'
      WRITE(KTERMW,101)' *********************************************'
      WRITE(KTERMW,101)' *  BY ELIZABETH HAUSER AND MICHAEL BOEHNKE  *'
      WRITE(KTERMW,101)' *********************************************'
      WRITE(KTERMW,101)' '
C
C DETERMINE THE FILE NAMES.
C
 10   WRITE(KTERMW,101)' INPUT FILE NAME:   '
      READ(KTERMR,101,ERR=20)FILNAM
      OPEN(KIN,FILE=FILNAM,STATUS='OLD',ERR=20)
      GO TO 30
C
 20   WRITE(KTERMW,101)' *** ERROR IN FILE SPECIFICATION.  TRY AGAIN.'
      GO TO 10
 
 30   WRITE(KTERMW,101)' OUTPUT FILE NAME:  '
      READ(KTERMR,101,ERR=40)FILNAM
      OPEN(KOUT,FILE=FILNAM,STATUS='UNKNOWN',ERR=40)
      GO TO 50
C
 40   WRITE(KTERMW,101)' *** ERROR IN FILE SPECIFICATION.  TRY AGAIN.'
      GO TO 30
C
 50   OPEN(KSCR,STATUS='SCRATCH')
C
C OUTPUT A HEADER FOR THE PROGRAM TO THE OUTPUT FILE.
C
      WRITE(KOUT,101)' ***********************************************'
      WRITE(KOUT,101)' **************   PROGRAM RH2PT   **************'
      WRITE(KOUT,101)' ***********************************************'
      WRITE(KOUT,101)' ***************   VERSION 3.00  ***************'
      WRITE(KOUT,101)' ***********************************************'
      WRITE(KOUT,101)' *************    SEPTEMBER 1996  **************'
      WRITE(KOUT,101)' ***********************************************'
      WRITE(KOUT,101)' *   BY ELIZABETH HAUSER AND MICHAEL BOEHNKE   *'
      WRITE(KOUT,101)' ***********************************************'
C
      RETURN
      END
C
C
C
      SUBROUTINE INCON(CRET,HNAME,KIN,KOUT,KTERMW,LNAME,LNAMEP,MAXCHR
     1,MAXHYB,MAXLOC,NCHR,NERR,NHYB,NHYBT,NLOCUS,NOBS,NTOTAL,OUTOPT,PERM
     2,RETAIN)
C
C READ THE DATA, CHECK FOR ERRORS, FIND UNIQUE HYBRID CLASSES, AND
C COUNT THE NUMBER OF HYBRIDS IN EACH CLASS.  PRINT TABLES 1, 2, AND 3.
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*1 CHAR,CRET(MAXLOC),INCHAR(0:2)
      CHARACTER*4 LNAM,LNAME(MAXLOC),LNAMEP(MAXLOC)
      CHARACTER*8 HNAME(MAXHYB)
      CHARACTER*200 FRMT
      INTEGER NOBS(MAXHYB),OUTOPT,PERM(MAXLOC),RETAIN(MAXHYB,MAXLOC)
C
C READ THE NUMBERS OF HYBRIDS AND LOCI, THE OUTPUT OPTION, AND THE
C PLOIDY.
C
      NERR=0
      READ(KIN,101)NLOCUS,NHYBT,OUTOPT,NCHR
 101  FORMAT(20I4)
C
C CHECK THAT THESE NUMBERS MAKE SENSE.
C
      IF(NLOCUS.GT.1.AND.NLOCUS.LE.MAXLOC)GO TO 10
        NERR=NERR+1
        WRITE(KOUT,102)NLOCUS,MAXLOC
 102    FORMAT(/' *** ERROR *** THE NUMBER OF LOCI IS REPORTED TO BE',I5
     1  ,'.  IT MUST BE AT'/15X,'LEAST TWO AND NO GREATER THAN ',I6,'.')
C
 10   IF(NHYBT.GT.0.AND.NHYBT.LE.MAXHYB)GO TO 20
        NERR=NERR+1
        WRITE(KOUT,103)NHYBT,MAXHYB
 103    FORMAT(/' *** ERROR *** THE NUMBER OF HYBRIDS IS REPORTED TO BE'
     1  ,I5,'.  IT MUST BE'/15X,'POSITIVE AND NO GREATER THAN ',I6,'.')
C
 20   IF(OUTOPT.EQ.0.OR.OUTOPT.EQ.1)GO TO 30
        NERR=NERR+1
        WRITE(KOUT,104)OUTOPT
 104    FORMAT(/' *** ERROR *** THE OUTPUT OPTION MUST EQUAL 0 (PRINT'
     1  ,' TABLE 5) OR 1 (DO NOT).'/15X,'IT IS REPORTED TO BE',I5,'.')
C
 30   IF(NCHR.EQ.0)NCHR=1
      IF(NCHR.GT.0.AND.NCHR.LE.MAXCHR)GO TO 40
        NERR=NERR+1
        WRITE(KOUT,105)NCHR,MAXCHR
 105    FORMAT(/' *** ERROR *** THE NUMBER OF CHROMOSOMES IS REPORTED '
     1  ,'TO BE',I5,'.  IT MUST BE'/15X,'POSITIVE AND NO GREATER THAN'
     2  ,I6,'.')
C
C READ THE LOCUS NAMES AND CHECK THAT THEY ARE ALL DIFFERENT.
C
 40   READ(KIN,106)(LNAME(I),I=1,NLOCUS)
 106  FORMAT(20A4)
C
      NLOC1=NLOCUS-1
      DO 60 LOCUS1=1,NLOC1
        LNAM=LNAME(LOCUS1)
        DO 50 LOCUS2=LOCUS1+1,NLOCUS
          IF(LNAM.NE.LNAME(LOCUS2))GO TO 50
            NERR=NERR+1
            WRITE(KOUT,107)LOCUS1,LOCUS2,LNAME
 107        FORMAT(/' *** ERROR *** LOCUS NUMBERS ',I4,' AND ',I4
     1      ,' HAVE THE SAME NAME, ',A4,'.')
 50     CONTINUE
 60   CONTINUE
C
C READ THE RETENTION INPUT FORMAT.
C
      READ(KIN,108)FRMT
 108  FORMAT(A)
C
C READ THE SYMBOLS FOR PRESENT, ABSENT, AND MISSING LOCI.  CHECK
C THAT THEY ARE ALL DIFFERENT.
C
      READ(KIN,109)INCHAR(1),INCHAR(0),INCHAR(2)
 109  FORMAT(3A1)
      IF(INCHAR(0).NE.INCHAR(1).AND.INCHAR(0).NE.INCHAR(2)
     1.AND.INCHAR(1).NE.INCHAR(2))GO TO 70
        NERR=NERR+1
        WRITE(KOUT,111)INCHAR(1),INCHAR(0),INCHAR(2)
 111    FORMAT(/' *** ERROR *** THE SYMBOLS ',A1,', ',A1,', AND ',A1
     1  ,' FOR PRESENT, ABSENT, AND MISSING'/' DATA ARE NOT ALL'
     2  ,' DIFFERENT.')
C
C READ THE INPUT PERMUTATION FOR THE LOCI.  CONVERT IT TO NUMBERS,
C CHECKING THAT ALL LOCI ARE PRESENT EXACTLY ONCE.
C
 70   READ(KIN,106)(LNAMEP(I),I=1,NLOCUS)
      CALL NAMIND(KOUT,LNAMEP,LNAME,NERR,NLOCUS,NLOCUS,PERM)
C
C OUTPUT TABLE 1:  PERMUTED LOCUS NAMES.
C
      WRITE(KOUT,112)
 112  FORMAT(///' TABLE 1:  PERMUTED LOCUS NAMES'
     1//'       LOCUS        LOCUS'/'       NUMBER       NAME'/)
C
      DO 80 I=1,NLOCUS
        WRITE(KOUT,113)I,LNAME(PERM(I))
 113  FORMAT(I11,10X,A4)
 80   CONTINUE
C
C OUTPUT TABLE 2:  RETENTION STATUS CHARACTERS AND PLOIDY.
C
      WRITE(KOUT,114)INCHAR(1),INCHAR(0),INCHAR(2)
 114  FORMAT(////' TABLE 2:  RETENTION STATUS CHARACTERS'
     1//5X,A1,' = RETAINED'/5X,A1,' = NOT RETAINED'/5X,A1,' = UNTYPED')
C
C READ AND COMPRESS THE HYBRID DATA.  CHECK THAT ALL RETENTION
C SYMBOLS ARE ADMISSABLE.  OUTPUT TABLE 3.
C
      WRITE(KOUT,115)(I,I=1,NLOCUS)
 115  FORMAT(////' TABLE 3:  PERMUTED RADIATION HYBRID RETENTION STATUS'
     1,' DATA'//' HYBRID  HYBRID   NUMBER      LOCUS NUMBER'
     2/' NUMBER   NAME   OBSERVED   ',25I3,39(/28X,25I3))
      WRITE(KOUT,106)
C
      NHYB=0
      NTOTAL=0
      DO 140 I=1,NHYBT
        NHYB=NHYB+1
C
C TRANSLATE THE SYMBOLS FOR PRESENT, ABSENT, AND MISSING LOCI TO 1, 0,
C AND 2, RESPECTIVELY.  NOBST=0 OR BLANK IN THE DATA FILE BY CONVENTION
C IMPLIES THAT NOBST=1.
C
        READ(KIN,FRMT)HNAME(NHYB),(CRET(J),J=1,NLOCUS),NOBS(NHYB)
        IF(NOBS(NHYB).EQ.0)NOBS(NHYB)=1
        NTOTAL=NTOTAL+NOBS(NHYB)
        WRITE(KOUT,116)I,HNAME(NHYB),NOBS(NHYB)
     1  ,(CRET(PERM(J)),J=1,NLOCUS)
 116    FORMAT(I5,5X,A4,I8,6X,25(2X,A1),39(/28X,25(2X,A1)))
C
C CHECK THAT THE HYBRID OBSERVATIONS ARE ADMISSABLE.
C
        DO 100 J=1,NLOCUS
          CHAR=CRET(J)
          DO 90 K=0,2
            IF(CHAR.NE.INCHAR(K))GO TO 90
              RETAIN(NHYB,J)=K
              GO TO 100
 90       CONTINUE
          NERR=NERR+1
          WRITE(KOUT,117)I,HNAME(NHYB),CHAR,J,LNAME(J)
 117      FORMAT(/' *** ERROR *** HYBRID NUMBER ',I4,' NAMED ',A4
     1    ,' HAS ILLEGAL OBSERVATION ',A1/15X,'FOR LOCUS NUMBER ',I4
     2    ,' NAMED ',A4,'.')
 100    CONTINUE
C
C CHECK WHETHER THIS HYBRID REPEATS A PREVIOUS ONE.  IF SO, COMPRESS THE
C DATA.
C
        IF(NOBS(NHYB).GT.0)GO TO 110
          WRITE(KOUT,118)I,NOBS(NHYB)
 118      FORMAT(/' *** ERROR *** HYBRID NUMBER ',I4,' IS REPORTEDLY'
     1    ,' OBSERVED ',I4,' TIMES.')
C
C CHECK WHETHER AN IDENTICAL HYBRID IS ALREADY PRESENT.
C
 110    NHYB1=NHYB-1
        IF(NHYB1.EQ.0)GO TO 140
        DO 130 JCLASS=1,NHYB1
          DO 120 LOCUS=1,NLOCUS
            IF(RETAIN(NHYB,LOCUS).NE.RETAIN(JCLASS,LOCUS))GO TO 130
 120      CONTINUE
          NOBS(JCLASS)=NOBS(JCLASS)+NOBS(NHYB)
          NHYB=NHYB-1
          GO TO 140
 130    CONTINUE
 140  CONTINUE
C
C PRINT THE NUMBERS OF UNIQUE RETENTION PATTERNS.
C
      WRITE(KOUT,119)NTOTAL,NHYB,NCHR
 119  FORMAT(/' TOTAL NUMBER OF HYBRIDS OBSERVED:',I24
     1/' NUMBER OF UNIQUE HYBRID RETENTION PATTERNS OBSERVED:',I5
     2/' PLOIDY:',I50)
C
C NOTE THAT ERRORS HAVE BEEN ENCOUNTERED IF THEY HAVE.
C
      IF(NERR.GT.0)WRITE(KOUT,121)NERR
      IF(NERR.GT.0)WRITE(KTERMW,121)NERR
 121  FORMAT(' PROGRAM TERMINATED DUE TO ',I6,' ERRORS.')
C
      RETURN
      END
C
C
C
      SUBROUTINE TABLE4(KOUT,LNAME,MAXHYB,MAXLOC,NCHR,NHYB,NLOCT,NLOCUS
     1,NOBS,NTOTAL,PERM,RETAIN)
C
C PRINT TABLE 4:  LOCUS RETENTION PROBABILITIES.
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*4 LNAME(MAXLOC)
      INTEGER NOBS(MAXHYB),PERM(MAXLOC),RETAIN(MAXHYB,MAXLOC),RLOC,RLOCT
C
C OUTPUT A HEADER FOR TABLE 4.
C
      WRITE(KOUT,101)
 101  FORMAT(////'         TABLE 4:  LOCUS RETENTION PROBABILITIES'/
     1/'                                           P(RETAINED)'
     2/' LOCUS    TYPED    P(TYPED)  RETAINED   OVERALL   HAPLOID'/)
C
C ESTIMATE THE RETENTION PROBABILITIES FOR EACH LOCUS AND THE AVERAGE
C RETENTION PROBABILITIES FOR ALL LOCI.  NLOCT AND RLOCT COUNT THE
C TOTAL NUMBER OF TYPINGS AND THE TOTAL NUMBER OF RETENTIONS OVER THE
C ENTIRE DATA SET.  NTOTAL IS THE TOTAL NUMBER OF HYBRIDS.
C
      NLOCT=0
      RLOCT=0
C
C FOR EACH LOCUS ...
C
      DO 20 LOC=1,NLOCUS
        LOCUS=PERM(LOC)
C
C DETERMINE THE NUMBERS OF LOCI TYPED (NLOC) AND RETAINED (RLOC).
C
        NLOC=0
        RLOC=0
        DO 10 IHYB=1,NHYB
          IR=RETAIN(IHYB,LOCUS)
          IF(IR.EQ.2)GO TO 10
            NLOC=NLOC+NOBS(IHYB)
            RLOC=RLOC+IR*NOBS(IHYB)
 10     CONTINUE
C
C ESTIMATE AND OUTPUT THE LOCUS-SPECIFIC TYPING AND RETENTION RATES.
C
        RA=0.D0
        IF(NLOC.NE.0)RA=DBLE(RLOC)/DBLE(NLOC)
        TYP=0.D0
        IF(NTOTAL.NE.0)TYP=DBLE(NLOC)/DBLE(NTOTAL)
        RAHAP=1.D0-(1.D0-RA)**(1.D0/NCHR)
        WRITE(KOUT,102)LNAME(LOCUS),NLOC,TYP,RLOC,RA,RAHAP
 102    FORMAT(1X,A5,I8,F12.3,I8,2X,2F10.3)
        RLOCT=RLOCT+RLOC
        NLOCT=NLOCT+NLOC
 20   CONTINUE
C
C ESTIMATE AND OUTPUT THE OVERALL TYPING AND RETENTION RATES.
C
      AVGRET=0.D0
      IF(NLOCT.NE.0)AVGRET=DBLE(RLOCT)/DBLE(NLOCT)
      AVGTYP=0.D0
      IF(NTOTAL.NE.0)AVGTYP=DBLE(NLOCT)/DBLE(NTOTAL*NLOCUS)
      AVGHAP=1.D0-(1.D0-AVGRET)**(1.D0/NCHR)
      WRITE(KOUT,103)
 103  FORMAT(A)
      WRITE(KOUT,102)'TOTAL',NLOCT,AVGTYP,RLOCT,AVGRET,AVGHAP
C
      RETURN
      END
C
C
C
      SUBROUTINE TABLE5(KOUT,LNAME,MAXHYB,MAXLOC,N,NHYB,NLOCUS,NOBS,PERM
     1,RETAIN,SMALL)
C
C CREATE TABLE 5:  CORETENTION PROBABILITIES.
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*4 LNAME(MAXLOC)
      INTEGER N(0:2,0:2),NOBS(MAXHYB),PERM(MAXLOC),RETAIN(MAXHYB,MAXLOC)
C
C OUTPUT A HEADER.
C
      WRITE(KOUT,101)
 101  FORMAT(////15X,'TABLE 5:  CONDITIONAL CORETENTION PROBABILITIES'//
     1,21X,'BOTH'/' LOCUS1    LOCUS2    TYPED   P(L1|L2)  P(L1|NOT L2)'
     2,'   P(L2|L1)  P(L2|NOT L1)'/)
C
C FOR ALL POSSIBLE LOCUS PAIRS (LOC1,LOC2), LOC1 < LOC2 ...
C
      NLOC1=NLOCUS-1
      DO 30 LOC1=1,NLOC1
        LOCUS1=PERM(LOC1)
        DO 20 LOC2=LOC1+1,NLOCUS
          LOCUS2=PERM(LOC2)
C
C CALCULATE RETENTION AND BREAKAGE ESTIMATES FOR THIS LOCUS PAIR.  
C USE ONLY THOSE HYBRIDS FOR WHICH BOTH LOCI ARE TYPED.
C
          NTOT=0
          N(0,0)=0
          N(0,1)=0
          N(1,0)=0
          N(1,1)=0
C
C CREATE THE 2 X 2 TABLE COUNTING THE NUMBERS OF HYBRIDS ACCORDING TO
C THE PRESENCE OR ABSENCE OF EACH LOCUS FOR HYBRIDS THAT ARE TYPED FOR
C BOTH LOCI.
C
          DO 10 IHYB=1,NHYB
            IR1=RETAIN(IHYB,LOCUS1)
            IF(IR1.EQ.2)GO TO 10
              IR2=RETAIN(IHYB,LOCUS2)
              IF(IR2.EQ.2)GO TO 10
                NI=NOBS(IHYB)
                NTOT=NTOT+NI
                N(IR1,IR2)=N(IR1,IR2)+NI
 10       CONTINUE
C
C ESTIMATE THE TWO-LOCUS CONDITIONAL CORETENTION PROBABILITIES.  
C BRATIO(,,,0) CALCULATES THE RATIO PROTECTING AGAINST DIVISION BY ZERO.
C
          PAGB=BRATIO(N(1,1),N(0,1)+N(1,1),SMALL,0)
          PBGA=BRATIO(N(1,1),N(1,0)+N(1,1),SMALL,0)
          PAGBC=BRATIO(N(1,0),N(0,0)+N(1,0),SMALL,0)
          PBGAC=BRATIO(N(0,1),N(0,0)+N(0,1),SMALL,0)
C
C WRITE OUT THE CONDITIONAL CORETENTION PROBABILITIES.
C
          WRITE(KOUT,102)LNAME(LOCUS1),LNAME(LOCUS2),NTOT,PAGB,PAGBC
     1    ,PBGA,PBGAC
 102      FORMAT(2X,A4,6X,A4,I9,F10.3,F12.3,F13.3,F12.3)
C
C IF THERE WAS NOTHING TYPED FOR THIS LOCUS PAIR, OUTPUT A WARNING.
C
          IF(NTOT.EQ.0)WRITE(KOUT,103)LNAME(LOCUS1),LNAME(LOCUS2)
 103      FORMAT(' *** WARNING *** NO HYBRIDS WERE TYPED FOR LOCUS PAIR'
     2    ,1X,A4,' AND ',A4,'.')
C
 20     CONTINUE
        WRITE(KOUT,104)
 104    FORMAT(A)
 30   CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE TABLE6(EALL,ENDPT,KOUT,LNAME,LODCUT,MAXHYB,MAXLOC
     1,MXPAIR,N,NCHR,NHYB,NLOCUS,NCUTPT,NOBS,PERM,RETAIN,SMALL)
C
C CREATE TABLE 6:  TWO-POINT LOD SCORES AND PARAMETER ESTIMATES.
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*4 LNAME(MAXLOC)
      INTEGER EALL(NCUTPT),ENDPT(NCUTPT,2,MXPAIR),N(0:2,0:2)
     1,NOBS(MAXHYB),PERM(MAXLOC),RETAIN(MAXHYB,MAXLOC)
      REAL*8 LODCUT(NCUTPT),LOGLIK
C
C OUTPUT A HEADER FOR TABLE 6.
C
      WRITE(KOUT,101)
 101  FORMAT(///' TABLE 6:  MAXIMUM LOD SCORES AND BREAKAGE PROBABILITY'
     1,' AND DISTANCE ESTIMATES'//20X,'BOTH',47X,'LOD'/'  LOCUS1'
     2,'  LOCUS2    TYPED    --    -+    +-    ++    P(BR)     DIST'
     3,'   SCORE'/)
C
C FOR ALL POSSIBLE LOCUS PAIRS (LOC1,LOC2), LOC1 < LOC2 ...
C
      NLOC1=NLOCUS-1
      DO 40 LOC1=1,NLOC1
        LOCUS1=PERM(LOC1)
        DO 30 LOC2=LOC1+1,NLOCUS
          LOCUS2=PERM(LOC2)
C
          NTOT=0
          N(0,0)=0
          N(0,1)=0
          N(1,0)=0
          N(1,1)=0
C
C CREATE THE 2 X 2 TABLE COUNTING THE NUMBERS OF HYBRIDS ACCORDING TO
C THE PRESENCE OR ABSENCE OF EACH LOCUS FOR HYBRIDS THAT ARE TYPED FOR
C BOTH LOCI.
C
          DO 10 IHYB=1,NHYB
            IR1=RETAIN(IHYB,LOCUS1)
            IF(IR1.EQ.2)GO TO 10
              IR2=RETAIN(IHYB,LOCUS2)
              IF(IR2.EQ.2)GO TO 10
                NI=NOBS(IHYB)
                NTOT=NTOT+NI
                N(IR1,IR2)=N(IR1,IR2)+NI
 10       CONTINUE
C
C ESTIMATE THETA AND RET ASSUMING EQUAL RETENTION.  ICASE NOTES WHETHER
C THE BREAKAGE ESTIMATE IS (ESSENTIALLY) ONE.  
C
          ICASE=0
          RET1=DBLE(NTOT-N(1,1)+N(0,0))/DBLE(NTOT)/2.D0
          RET1=RET1**(1.D0/NCHR)
          RET=1.D0-RET1
          THETA=RET1-(DBLE(N(0,0))/DBLE(NTOT))**(1.D0/NCHR)
          THETA=THETA/RET/RET1
          IF(THETA.GT.1.D0-SMALL)ICASE=1
          THETA=BOUND(THETA,SMALL)
C
C CALCULATE THE LOD SCORE FOR THIS LOCUS PAIR.
C
          ZLOD=LOGLIK(THETA,RET,N,NCHR)-LOGLIK(1.D0,RET,N,NCHR)
C
C WRITE OUT THE TABLE OF BREAKAGE AND DISTANCE ESTIMATES AND LOD SCORES.
C
          IF(ICASE.EQ.0)WRITE(KOUT,102)LNAME(LOCUS1),LNAME(LOCUS2),NTOT
     1    ,N(0,0),N(0,1),N(1,0),N(1,1),THETA,-DLOG(1.D0-THETA),ZLOD
 102      FORMAT(2X,A5,3X,A5,I9,I7,3I6,F9.3,F9.3,F8.2)
C
          IF(ICASE.EQ.1)WRITE(KOUT,103)LNAME(LOCUS1),LNAME(LOCUS2),NTOT
     1    ,N(0,0),N(0,1),N(1,0),N(1,1),THETA,'    INF ',ZLOD
 103      FORMAT(2X,A5,3X,A5,I9,I7,3I6,F9.3,1X,A8,F8.2)
C
C CREATE THE ENDPOINT ARRAYS FOR LOD SCORE CUT POINTS.  THESE ARRAYS
C WILL BE USED LATER TO CREATE THE LINKAGE GROUPS TABLE.
C
          DO 20 ICUTPT=1,NCUTPT
            IF(ZLOD.LT.LODCUT(ICUTPT))GO TO 20
              EALL(ICUTPT)=EALL(ICUTPT)+1
              ENDPT(ICUTPT,1,EALL(ICUTPT))=LOC1
              ENDPT(ICUTPT,2,EALL(ICUTPT))=LOC2
 20       CONTINUE
C
 30     CONTINUE
        WRITE(KOUT,104)
 104    FORMAT(A)
 40   CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE TABLE7(EALL,ENDPT,GROUP,KOUT,LNAME,LODCUT,MAXLOC,MXPAIR
     1,NLOCUS,NCUTPT,PERM,X)
C
C WRITE OUT TABLE 7:  LINKAGE GROUPS.
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*4 LNAME(MAXLOC)
      CHARACTER*10 GROUP(MAXLOC)
      INTEGER EALL(NCUTPT),ENDPT(NCUTPT,2,MXPAIR),PERM(MAXLOC)
     1,X(NCUTPT,MAXLOC)
      REAL*8 LODCUT(NCUTPT)
C
C OUTPUT A HEADER FOR TABLE 7.
C
      WRITE(KOUT,101)
 101  FORMAT(////8X,'TABLE 7:  LINKAGE GROUPS')
C
C FOR EACH LOD SCORE CUTPOINT ...
C
      DO 40 ICUTPT=1,NCUTPT
        NEXT=0
        WRITE(KOUT,102)LODCUT(ICUTPT)
 102    FORMAT(//'  LOD SCORE CRITERION:',F7.2)
C
C CHECK THAT THERE WERE LINKED LOCI.
C
        IF(EALL(ICUTPT).GT.0)GO TO 10
          WRITE(KOUT,103)'  NO LOCUS PAIR MET THE LOD SCORE CRITERION.'
 103      FORMAT(/A)
          GO TO 40
C
C IF SO, FIND THE LINKAGE GROUPS USING THE SPANNING FOREST ALGORITHM.
C
 10     CALL SPANFO(NLOCUS,EALL(ICUTPT),ENDPT,X,ICUTPT)
        WRITE(KOUT,104)1
 104    FORMAT(/'  LINKAGE GROUP',I3,':')
        DO 30 J=1,NLOCUS
          NEXT2=0
          DO 20 K=1,NLOCUS
            LOCUS=PERM(K)
            IF(X(ICUTPT,K).NE.J)GO TO 20
              NEXT=NEXT+1
              NEXT2=NEXT2+1
              GROUP(NEXT2)=LNAME(LOCUS)
 20       CONTINUE
          WRITE(KOUT,105)(GROUP(M),M=1,NEXT2)
 105      FORMAT(2X,10A6)
          IF(NEXT.EQ.NLOCUS)GO TO 40
          WRITE(KOUT,104)J+1
 30     CONTINUE
 40   CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE TABLE8(KOUT,LNAME,MAXHYB,MAXLOC,N,NHYB,NLOCUS,NOBS,PERM
     1,RETAIN)
C
C CREATE TABLE 8:  PAIRS OF TOTALLY-LINKED LOCI.
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*4 LNAME(MAXLOC)
      INTEGER N(0:2,0:2),NOBS(MAXHYB),PERM(MAXLOC),RETAIN(MAXHYB,MAXLOC)
C
C FOR ALL POSSIBLE LOCUS PAIRS (LOC1,LOC2), LOC1 < LOC2 ...
C
      NTLINK=0
      NLOC1=NLOCUS-1
      DO 50 LOC1=1,NLOC1
        LOCUS1=PERM(LOC1)
        DO 40 LOC2=LOC1+1,NLOCUS
          LOCUS2=PERM(LOC2)
C
C INITIALIZE THE RETENTION DATA ARRAY.
C
          DO 20 I=0,2
            DO 10 J=0,2
              N(I,J)=0
 10         CONTINUE
 20       CONTINUE
C
C COUNT HYBRIDS TO FILL THE RETENTION DATA ARRAY.
C
          DO 30 IHYB=1,NHYB
            IR1=RETAIN(IHYB,LOCUS1)
            IR2=RETAIN(IHYB,LOCUS2)
            NI=NOBS(IHYB)
            N(IR1,IR2)=N(IR1,IR2)+NI
 30       CONTINUE
C
C IF THESE LOCI ARE TOTALLY-LINKED, ADD THEM TO THE TABLE.
C
          IF(N(0,1)+N(1,0).GT.0)GO TO 40
            NTLINK=NTLINK+1
C
C IF WE GET ANY LOCI PAIRS THAT ARE TOTALLY-LINKED, OUTPUT A HEADER.
C
            IF(NTLINK.EQ.1)WRITE(KOUT,101)
 101        FORMAT(////11X,'TABLE 8:  TOTALLY-LINKED LOCUS PAIRS'//
     1      ,'                         LOCUS-PAIR RETENTION STATUS'/
     2      ,' LOCUS1    LOCUS2    --  -+  +-  ++  -?  +?  ?-  ?+  ??'/)
C
            WRITE(KOUT,102)LNAME(LOCUS1),LNAME(LOCUS2)
     1      ,((N(I,J),J=0,1),I=0,1),N(0,2),N(1,2),N(2,0),N(2,1),N(2,2)
 102        FORMAT(2X,A4,6X,A4,3X,9I4)
 40     CONTINUE
C
 50   CONTINUE
      RETURN
      END
C
C
C
      FUNCTION BRATIO(RET,TOT,SMALL,OPTION)
C
C CALCULATE THE RATIO OF RET AND TOT, CHECKING FOR ZERO-DIVIDE, AND
C OPTINALLY (IF OPTION=1) BOUNDING THE RESULT AWAY FROM 0 AND 1.
C
      IMPLICIT REAL*8(A-H,O-Z)
      INTEGER RET,TOT,OPTION
C
      BRATIO=0.D0
      IF(TOT.NE.0)BRATIO=DBLE(RET)/DBLE(TOT)
      IF(OPTION.EQ.0)GO TO 10
        IF(BRATIO.LT.SMALL)BRATIO=SMALL
        IF(BRATIO.GT.1.D0-SMALL)BRATIO=1.D0-SMALL
 10   RETURN
      END
C
C
C
      FUNCTION BOUND(RATIO,SMALL)
C
C BOUND RATIO AWAY FROM 0 AND 1.
C
      IMPLICIT REAL*8(A-H,O-Z)
C
      BOUND=RATIO
      IF(BOUND.LT.SMALL)BOUND=SMALL
      IF(BOUND.GT.1.D0-SMALL)BOUND=1.D0-SMALL
C
      RETURN
      END
C
C
C
      FUNCTION LOGLIK(THETA,RET,N,NCHR)
C
C THIS FUNCTION CALCULATES THE LOGLIKELIHOOD FOR THE PAIRWISE MODEL.
C
      IMPLICIT REAL*8(A-H,O-Z)
      INTEGER N(0:2,0:2)
      REAL*8 LOGLIK
C
      ONE=1.D0
      SC=(ONE-RET)**NCHR
      PROB00=SC*(ONE-RET*THETA)**NCHR
      TERM1=N(0,0)*DLOG10(PROB00)
      TERM23=(N(0,1)+N(1,0))*DLOG10(SC-PROB00)
      TERM4=N(1,1)*DLOG10(ONE-2.D0*SC+PROB00)
      LOGLIK=TERM1+TERM23+TERM4
      WRITE(4,999)N,RET,THETA,TERM1,TERM23,TERM4,LOGLIK
 999  FORMAT(9I3,2F9.6,4F9.5)
C
      RETURN
      END
C
C
C
      SUBROUTINE SPANFO(N,E,ENDPT,X,A)
C
C THIS SUBROUTINE WAS TAKEN FROM A. NIJENHUIS AND H.S. WILF,
C COMBINATORIAL ALGORIGTHMS, 1978 (PAGES 158-170).  MODIFIED
C FOR A 3 DIMENSIONAL ENDPT ARRAY AND A 2 DIMENSIONAL X ARRAY.
C
      IMPLICIT INTEGER(A-Z)
      DIMENSION ENDPT(3,2,E),X(3,N+1)
      MM=1+MAX0(N,E)
C
C START LINK.
C
      DO 11 I=1,N
        X(A,I)=-I
 11   CONTINUE
      DO 12 M=1,E
      DO 12 L=1,2
        P=ENDPT(A,L,M)
        ENDPT(A,L,M)=X(A,P)
        X(A,P)=-L*MM-M
 12   CONTINUE
C
C END LINK--START MAIN S/R.
C
      K=0
      LOC=0
      I=0
 20   I=I+1
      IF(I.GT.N)GO TO 21
        Q=X(A,I)
      IF(Q.GT.0)GO TO 20
      K=K+1
      X(A,I)=K
      IF(Q+I)30,20,20
C
C 30 IS CALL TO COMPONENT-FROM WHERE TO 20
C
 21   DO 23 M=1,E
 22   R=-ENDPT(A,1,M)
      IF(R.LT.0)GO TO 23
      S=ENDPT(A,2,M)
      ENDPT(A,2,M)=ENDPT(A,2,R)
      ENDPT(A,2,R)=S
      ENDPT(A,1,M)=ENDPT(A,1,R)
      ENDPT(A,1,R)=X(A,ENDPT(A,2,R))
      GO TO 22
 23   CONTINUE
      DO 24 I=1,LOC
        X(A,ENDPT(A,2,I))=X(A,ENDPT(A,1,I))
 24   CONTINUE
      RETURN
C
C END MAIN S/R--START COMPONENT.
C
 30   P=I
      S=-Q
      ASSIGN 31 TO RTNVIS
      GO TO 53
C
C CALL TO VISIT-FROM WHERE TO 31.
C
 31   L0=L1
      M0=M1
      R=0
      ASSIGN 43 TO RTNVIS
      GO TO 41
 32   GO TO 40
 33   IF (R.EQ.0)GO TO 34
      LOC=LOC+1
      X(A,P)=ENDPT(A,1,R)+ENDPT(A,2,R)-P
      ENDPT(A,1,R)=-LOC
      ENDPT(A,2,R)=P
 34   P=M
      IF(M)20,20,32
C
C END COMPONENT-START SCAN.
C
 40   S=-X(A,P)
 41   L=S/MM
      M=S-L*MM
      IF(L.EQ.0)GO TO 33
      L1=3-L
      M1=M
      GO TO 50
 42   R=M1
      GO TO 44
 43   ENDPT(A,L0,M0)=Q
      L0=L1
      M0=M1
 44   S=IABS(ENDPT(A,L,M))
      ENDPT(A,L,M)=P
      GO TO 41
C
C END SCAN-START VISIT.
C
 50   Q=ENDPT(A,L1,M1)
      IF(Q)51,44,54
 51   IF(Q.LT.-MM)GO TO 52
      Q=-Q
      ENDPT(A,L1,M1)=0
      GO TO RTNVIS,(31,43)
 52   ENDPT(A,L1,M1)=-Q
 53   L1=-Q/MM
      M1=-Q-L1*MM
      GO TO 50
 54   IF(Q.GT.MM)GO TO 44
      IF(X(A,Q))44,42,42
      END
C
C
C
      SUBROUTINE NAMIND(KOUT,LNAME,LNAMET,NERR,NLOCT,NLOCUS,PERM)
C
C CHECK THAT THE LOCUS NAMES LNAME ARE ALL DIFFERENT AND THAT THEY
C ARE ALL AMONG THE NAMES IN LNAMET.
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*4 LNAM,LNAME(NLOCUS),LNAMET(NLOCT)
      INTEGER PERM(NLOCUS)
C
      NLOC1=NLOCUS-1
      DO 20 LOCUS1=1,NLOC1
        LNAM=LNAME(LOCUS1)
        DO 10 LOCUS2=LOCUS1+1,NLOCUS
          IF(LNAM.NE.LNAME(LOCUS2))GO TO 10
            WRITE(KOUT,101)LOCUS1,LOCUS2,LNAM
 101        FORMAT(/' *** ERROR *** LOCUS NUMBERS ',I4,' AND ',I4
     1      ,' HAVE THE SAME NAME, ',A4,'.')
            NERR=NERR+1
 10     CONTINUE
 20   CONTINUE
C
      DO 50 LOCUS=1,NLOCUS
        PERM(LOCUS)=1
        LNAM=LNAME(LOCUS)
        DO 30 LOCUST=1,NLOCT
          IF(LNAMET(LOCUST).EQ.LNAM)GO TO 40
 30     CONTINUE
          WRITE(KOUT,102)LOCUS,LNAM
 102      FORMAT(/' *** ERROR *** LOCUS NUMBER ',I4,' WITH NAME ',A4
     1    ,' IS NOT PRESENT AMONG'/15X,'THE LOCI FOR THIS PROBLEM SET.')
          NERR=NERR+1
          GO TO 50
 40     PERM(LOCUS)=LOCUST
 50   CONTINUE
C
      RETURN
      END
