C **********************************************************************
C **********************************************************************
C ************************   PROGRAM RHMAXLIK   ************************
C **********************************************************************
C **************************   VERSION 3.0    **************************
C *************************   SEPTEMBER 1996   *************************
C **********************************************************************
C *************************   PROGRAMMED BY   **************************
C ***************   MICHAEL BOEHNKE, ELIZABETH HAUSER,   ***************
C *******   KENNETH LANGE, KATHRYN LUNETTA, AND JILL VANDERSTOEP  ******
C **********************************************************************
C **********************************************************************
C * IDENTIFY MAXIMUM LIKELIHOOD LOCUS ORDERS FOR POLYPLOID RADIATION   *
C * HYBRID MAPPING DATA.  SINGLE OR MULTIPLE HYBRID PANELS,            *
C * PROPORTIONAL OR NON-PROPORTIONAL DISTANCES.  RETENTION             *
C * PROBABILITY MODELS:  EQUAL, CENTROMERIC, LEFT-ENDPOINT, GENERAL    *
C * (HAPLOID DATA ONLY), SELECTED LOCUS, AND CONDITIONAL SELECTED      *
C * LOCUS ORDERING STRATEGIES:  LIST, STEPWISE LOCUS ORDERING,         * 
C * SIMULATED ANNEALING, AND BRANCH AND BOUND.                         *
C **********************************************************************
C **********************************************************************
C
C INITIALIZATIONS.
C
      IMPLICIT REAL*8(A-H,O-Z)
      PARAMETER(EMSTEP=2.D0,MAXCHR=2,MAXHYB=100,MAXLOC=60
     1,MAXORD=1000,MAXPAN=2,MAXPAR=120,TOL=1.D-8)
C
      CHARACTER*1 CRET(MAXLOC),INCHAR(0:2)
      CHARACTER*4 HNAMET(MAXPAN,MAXHYB),LNAME(MAXLOC),LNAMEA(MAXLOC)
     1,LNAMEC(MAXLOC),LNAMEL(MAXLOC),LNAMET(MAXLOC)
      CHARACTER*8 PNAME(MAXPAR)
      CHARACTER*10 CMODEL(7),CORDOP(4)
      CHARACTER*80 FILNAM
      CHARACTER*200 FRMT
C
      INTEGER APERM(MAXLOC),BBOPT,BPERM(MAXORD,MAXLOC),BRKOBS(0:MAXLOC)
     1,BRLIST(0:MAXLOC),BSTPRM(MAXLOC),CHECK(MAXPAN,MAXHYB)
     2,CPERM(MAXLOC),FRAME(MAXLOC,MAXLOC),HLIST(MAXPAN,MAXHYB)
     3,INDEX(MAXORD),INPERM(MAXLOC),NCHR(MAXPAN),NHYB(MAXPAN)
     4,NHYBT(MAXPAN),NOBS(MAXPAN,MAXHYB),NOBST(MAXPAN,MAXHYB)
     5,NUMHYB(MAXPAN),NXTPRM(MAXLOC),ORDOPT,OUTOPT,PERM(MAXLOC)
     6,REMAIN(MAXLOC),RET(MAXPAN,MAXHYB,MAXLOC)
     7,RETAIN(MAXPAN,MAXHYB,MAXLOC),RETHYB(MAXLOC),SAOPT,SCROPT,SELNUM
     8,SUBPRM(2,MAXLOC),TYPED(MAXLOC),USEINC
C
      REAL*4 BLIKE(MAXORD)
      REAL*8 ALPHA(MAXLOC,0:MAXCHR),ALPHAP(2,MAXLOC,0:MAXCHR,0:MAXCHR)
     1,BETAP(2,MAXLOC,0:MAXCHR),BDISTC(0:MAXLOC,0:MAXCHR)
     2,BETA(MAXLOC,0:MAXCHR),BINOM(0:MAXCHR,0:MAXCHR),BRKDST(0:MAXLOC)
     3,BRKTOT(0:MAXLOC),BSTPAR(MAXPAR),CONDP(MAXHYB),DF(MAXPAR)
     4,DFHYB(MAXHYB,MAXPAR),DP(MAXPAR)
     5,DTRANS(MAXLOC,0:MAXCHR,0:MAXCHR,3),HDLIST(MAXPAN,MAXHYB)
     6,HPROB(MAXPAN,MAXHYB),HPROBB(MAXPAN,MAXHYB),NRET(MAXLOC)
     7,NTYPE(MAXLOC),PAR(MAXPAR),PBREAK(2,0:MAXLOC,0:MAXCHR)
     8,PRODMX(0:MAXCHR,0:MAXCHR),RETEST(MAXPAN,MAXLOC)
     9,RETOBS(MAXPAN,MAXLOC),TRANS1(MAXLOC,0:1,0:1)
     1,TRANSP(MAXLOC,0:MAXCHR,0:MAXCHR),TRMISS(0:MAXCHR,0:MAXCHR)
C
      DATA KTERMR,KTERMW/5,6/
      DATA KIN,KOUT,KITER,KSCR1,KSCR2/8,9,7,3,4/
      DATA CMODEL/'     EQUAL','CENTROMERE','LEFT ENDPT','   GENERAL'
     1,'        S1','        S2','        S3'/
      DATA CORDOP/'      LIST','  STEPWISE','SIM ANNEAL','    BRANCH'/
      DATA CONV1,CONV2,MXITER,NCONV/0.002D0,0.00002D0,500,4/
C
      TENLOG=DLOG(10.D0)
      CONV1=CONV1*TENLOG
      CONV2=CONV2*TENLOG
C
C PRINT A HEADER, READ THE FILE NAMES, AND DEFINE THE LOGICAL UNIT NUMBERS.
C
      CALL FILES(FILNAM,KIN,KITER,KOUT,KTERMR,KTERMW)
C
C WHILE PROBLEM SETS REMAIN, INPUT THE DATA FOR THE CURRENT PROBLEM SET.
C
      NDSET=0
   10 CALL INPUTS(CRET,FRMT,HNAMET,INCHAR,KIN,KOUT,LNAMET,MAXCHR,MAXHYB,
     1MAXLOC,MAXPAN,NCHR,NDSET,NERR,NHYBT,NLOCT,NOBST,NPAN,NPROB,RET,
     2SCROPT)
      IF(NERR.GT.0)GO TO 110
      NDSET=NDSET+1
      IF(SCROPT.GE.1)WRITE(KTERMW,101)' STARTING PROBLEM SET',NDSET
 101  FORMAT(3(A,I8))
C
C CALCULATE THE BINOMIAL COEFFICIENTS.
C
      CALL COMB(BINOM,MAXCHR,MAXCHR)
C
C FOR EACH PROBLEM IN THE CURRENT SET ...
C
      DO 100 IPROB=1,NPROB
        IF(SCROPT.GE.1)WRITE(KTERMW,101)' STARTING PROBLEM ',IPROB,
     1  ' OF ',NPROB,' IN PROBLEM SET ',NDSET
C
C READ THE CONTROL INFORMATION REQUIRED FOR ALL ORDERING METHODS FOR
C THE CURRENT PROBLEM.  NLUSE IS EQUAL TO NLOCUS, OR IF BRBND IS CALLED,
C THE NUMBER OF LOCI SUCCESSFULLY ORDERED AT LEVEL ADDMIN LOG10-UNITS.
C
        CALL INPUTP(CMODEL,CORDOP,HYBMIN,ICONDS,IMISS,INFOPT,INPERM
     1  ,IPROB,KIN,KOUT,LNAME,LNAMET,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MLTOPT
     2  ,MODEL,NBEST,NCHR,NERR,NHYBT,NHYB,NLOCT,NLOCUS,NOBS,NOBST,NPAN
     3  ,NPAR,NUMHYB,ORDOPT,OUTOPT,RET,RETAIN,SELNUM,USEINC)
        IF(NERR.GT.0)GO TO 110
        NLUSE=NLOCUS
C
C USE THE SPECIFIED ORDERING OPTION TO DETERMINE THE SET OF BEST LOCUS
C ORDERS.
C
      GO TO (20,30,40,50) ORDOPT
C
C ORDOPT=1:  MAXIMIZE THE LIKELIHOODS FOR A LIST OF USER-SPECIFIED
C ORDERS.  USE THE MORE STRINGENT CONVERGENCE CRITERION.  ALL ORDERS
C EVALUATED ARE PRINTED SINCE PRTMAX IS SET TO HUGE.
C
   20 CONV=CONV2
      PRTMAX=1.D20
C
      CALL ORDLST(ALPHA,ALPHAP,BETA,BETAP,BINOM,BLIKE,BPERM,BRLIST
     1,CHECK,CONDP,CONV,DF,DFHYB,DP,DTRANS,EMSTEP,FRMT,HPROB,ICONDS
     2,KIN,KITER,KOUT,KTERMW,LNAME,LNAMEL,MAXCHR,MAXHYB,MAXLOC,MAXORD
     3,MAXPAN,MAXPAR,MLTOPT,MODEL,MXITER,NCHR,NCONV,NHYB,NLOCUS,NOBS
     4,NPAN,NPAR,NRET,NTYPE,NUMHYB,NUMORD,OUTOPT,PAR,PERM,PNAME,RETAIN
     5,SCROPT,SELNUM,SUBPRM,TENLOG,TOL,TRANS1,TRANSP)
      IF(NUMORD.EQ.0)GO TO 100
      GO TO 60
C
C ORDOPT=2:  USE STEPWISE LOCUS ORDERING TO ATTEMPT TO FIND THE BEST
C LOCUS ORDERS.  USE THE LESS STRINGENT CONVERGENCE CRITERION.
C
   30 CONV=CONV1
      CALL BRBND(ALPHA,ALPHAP,APERM,BBOPT,BESTLK,BETA,BETAP,BINOM
     1,BRLIST,BSTPRM,CHECK,CONDP,CONV,CPERM,DF,DFHYB,DP,DTRANS,EMSTEP
     2,HPROB,ICONDS,KIN,KITER,KOUT,KSCR1,KSCR2,KTERMW,KWRITE,LNAME
     3,LNAMEA,LNAMEC,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MLTOPT,MODEL
     4,MXITER,NCHR,NCONV,NHYB,NLOCUS,NOBS,NPAN,NPAR,NRET,NTYPE,NUMHYB
     5,NUMORD,NXTPRM,ORDOPT,OUTOPT,PAR,PERM,PNAME,PRTMAX,REMAIN,RETAIN
     6,SAVMAX,SCROPT,SELNUM,SUBPRM,TENLOG,TOL,TRANS1,TRANSP)
      IF(BBOPT.LT.-1)NLUSE=-BBOPT
      IF(BBOPT.EQ.-1)GO TO 100
      GO TO 60
C
C ORDOPT=3:  USE SIMULATED ANNEALING TO ATTEMPT TO FIND THE
C BEST LOCUS ORDERS.  USE THE LESS STRINGENT CONVERGENCE CRITERION.
C
   40 CONV=CONV1
      CALL ANNEAL(ALPHA,ALPHAP,BETA,BETAP,BINOM,BLIKE,BPERM,BRLIST
     1,CHECK,CONDP,CONV,DF,DFHYB,DP,DTRANS,EMSTEP,HPROB,ICONDS,KIN
     2,KITER,KOUT,KTERMW,LNAME,LNAMEA,MAXCHR,MAXHYB,MAXLOC,MAXORD
     3,MAXPAN,MAXPAR,MLTOPT,MODEL,MXITER,NCHR,NCONV,NHYB,NLOCUS,NOBS
     4,NPAN,NPAR,NRET,NTYPE,NUMHYB,NUMORD,OUTOPT,PAR,PERM,PNAME,PRTMAX
     5,RETAIN,SAOPT,SCROPT,SELNUM,SUBPRM,TENLOG,TOL,TRANS1,TRANSP)
      IF(SAOPT.EQ.-1)GO TO 100
      GO TO 60
C
C USE BRANCH AND BOUND TO FIND THE BEST LOCUS ORDERS.  USE THE LESS
C STRINGENT CONVERGENCE CRITERION.
C
   50 CONV=CONV1
      CALL BRBND(ALPHA,ALPHAP,APERM,BBOPT,BESTLK,BETA,BETAP,BINOM,BRLIST
     1,BSTPRM,CHECK,CONDP,CONV,CPERM,DF,DFHYB,DP,DTRANS,EMSTEP,HPROB
     2,ICONDS,KIN,KITER,KOUT,KSCR1,KSCR2,KTERMW,KWRITE,LNAME,LNAMEA
     3,LNAMEC,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MLTOPT,MODEL,MXITER
     4,NCHR,NCONV,NHYB,NLOCUS,NOBS,NPAN,NPAR,NRET,NTYPE,NUMHYB,NUMORD
     5,NXTPRM,ORDOPT,OUTOPT,PAR,PERM,PNAME,PRTMAX,REMAIN,RETAIN,SAVMAX
     6,SCROPT,SELNUM,SUBPRM,TENLOG,TOL,TRANS1,TRANSP)
      IF(BBOPT.EQ.-1)GO TO 100
      IF(BBOPT.LT.-1)NLUSE=-BBOPT
      GO TO 60
C
C IF STEPWISE LOCUS ORDERING OR BRANCH AND BOUND WAS USED, RE-READ
C THE REMAINING ORDERS FROM THE SCRATCH FILE AND DELETE USELESS ORDERS.
C
   60 IF(ORDOPT.EQ.1.OR.ORDOPT.EQ.3)GO TO 90
        REWIND(KWRITE)
C
        CUTPT=BESTLK-PRTMAX
        NORD=0
        DO 80 I=1,NUMORD
          NORD=NORD+1
          IF(NORD.LE.MAXORD)GO TO 70
            REWIND(KWRITE)
            GO TO 90
   70       READ(KWRITE,102)BLIKE(NORD),(BPERM(NORD,J),J=1,NLUSE)
 102        FORMAT(F15.9,10(100I3/))
          IF(-BLIKE(NORD).LT.CUTPT)NORD=NORD-1
   80   CONTINUE
        CLOSE(KWRITE)
        NUMORD=NORD
C
C IF THERE IS SUFFICIENT SPACE, SORT THE CANDIDATE LOCUS ORDERS BY
C MINUS THEIR MAXIMUM LOG-LIKELIHOODS.
C
   90 IF(NUMORD.LE.MAXORD)CALL INDEXX(NUMORD,BLIKE,INDEX)
C
C OUTPUT THE BEST ORDERS AND MINUS THEIR MAXIMUM LOG-LIKELIHOODS.
C OUTPUT THE RETENTION STATUS DATA USING THE BEST LOCUS ORDER.
C
      CALL OUTORD(BESTLK,BLIKE,BPERM,INDEX,KOUT,KWRITE,LNAME,MAXHYB
     1,MAXLOC,MAXORD,MAXPAN,NBEST,NHYB,NLOCUS,NLUSE,NOBS,NPAN,NUMORD
     2,PERM,PRTMAX,RETAIN,TENLOG)
C
C IF ONLY PARTIAL ORDERING WAS SUCCESSFULLY DONE, DO NOT PRINT
C LIKELY POSITION, ESTIMATES OR INFLUENTIAL HYBRIDS, EVEN IF
C THEY WERE REQUESTED.
C
      IF(NLUSE.NE.NLOCUS)GO TO 100
C
C PRINT THE LIKELY POSITIONS IF AT LEAST 2 LOCUS ORDERS ARE GOOD,
C THE ORDERS WERE SORTED, AND THIS WAS NOT A LIST OF LOCUS ORDERS.
C
      IF(NUMORD.GT.1.AND.NUMORD.LE.MAXORD.AND.ORDOPT.NE.1)
     1 CALL FRLOC(BLIKE,BPERM,FRAME,INDEX,KOUT,LNAME,MAXLOC,MAXORD
     2,NLOCUS,NUMORD,PERM,SAVMAX,TENLOG)
C
C PRINT THE ESTIMATES FOR THE BEST LOCUS ORDER (OUTOPT=0) OR ORDERS
C (OUTOPT>1).  USE THE MORE STRINGENT CONVERGENCE CRITERION.
C
      CONV=CONV2
      CALL OUTEST(ALPHA,ALPHAP,BETA,BETAP,BINOM,BESTLK,BLIKE,BPERM
     1,BRLIST,BSTPRM,CHECK,CONDP,CONV,DF,DFHYB,DP,DTRANS,EMSTEP
     2,HPROB,ICONDS,INDEX,KITER,KOUT,LNAME,MAXCHR,MAXHYB,MAXLOC,MAXORD
     3,MAXPAN,MAXPAR,MLTOPT,MODEL,MXITER,NBEST,NCHR,NCONV,NHYB,NLOCUS
     4,NOBS,NPAN,NPAR,NRET,NTYPE,NUMHYB,NUMORD,OUTOPT,PAR,PERM,PNAME
     5,PRTMAX,RETAIN,RETEST,RETOBS,SELNUM,SUBPRM,TOL,TRANS1,TRANSP)
C
C PRINT THE INFLUENTIAL HYBRID INFORMATION IF INFOPT>0.  NOTE:
C USE THE LESS STRINGENT CONVERGENCE CRITERION.  IF NUMORD>MAXORD,
C WE ONLY PRINT AN ERROR MESSAGE.
C
      CONV=CONV1
      IF(INFOPT.GE.1)
     1 CALL INFHYB(ALPHA,ALPHAP,BDISTC,BETA,BETAP,BINOM,BLIKE,BPERM
     2,BRKDST,BRKOBS,BRKTOT,BRLIST,BSTPAR,CHECK,CONDP,CONV,DF,DFHYB,DP
     3,DTRANS,EMSTEP,HDLIST,HLIST,HNAMET,HPROB,HPROBB,HYBMIN,ICONDS
     4,IMISS,INCHAR,INDEX,INPERM,IPROB,KITER,KOUT,MAXCHR,MAXHYB,MAXLOC
     5,MAXORD,MAXPAN,MAXPAR,MLTOPT,MODEL,MXITER,NBEST,NCHR,NCONV,NHYB
     6,NHYBT,NLOCUS,NOBS,NOBST,NPAN,NPAR,NRET,NTYPE,NUMHYB,NUMORD,OUTOPT
     7,PAR,PBREAK,PERM,PNAME,PRODMX,PRTMAX,RET,RETAIN,RETHYB,SELNUM
     8,SUBPRM,TOL,TRANS1,TRANSP,TRMISS,TYPED,USEINC)
  100 CONTINUE
C
C CONTINUE UNTIL THERE ARE NO MORE PROBLEM SETS.
C
      GO TO 10
C
  110 STOP
      END
C
C
C
      SUBROUTINE FILES(FILNAM,KIN,KITER,KOUT,KTERMR,KTERMW)
C
C PRINT A HEADER, READ THE FILE NAMES, AND DEFINE THE LOGICAL UNIT NUMBERS.
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*80 FILNAM
 101  FORMAT(A)
C
C OUTPUT A HEADER FOR THE PROGRAM TO THE SCREEN FILE.
C
      WRITE(KTERMW,101)' **********************************************'
      WRITE(KTERMW,101)' ************   PROGRAM RHMAXLIK   ************'
      WRITE(KTERMW,101)' **********************************************'
      WRITE(KTERMW,101)' **************   VERSION 3.0   ***************'
      WRITE(KTERMW,101)' **********************************************'
      WRITE(KTERMW,101)' *************   SEPTEMBER 1996   *************'
      WRITE(KTERMW,101)' **********************************************'
      WRITE(KTERMW,101)' ***  BY MICHAEL BOEHNKE, KATHRYN LUNETTA,  ***'
      WRITE(KTERMW,101)' ***  ELIZABETH HAUSER, KENNETH LANGE, AND  ***'
      WRITE(KTERMW,101)' *************  JILL VANDERSTOEP  *************'
      WRITE(KTERMW,101)' **********************************************'
      WRITE(KTERMW,101)' '
C
C DETERMINE THE FILE NAMES.
C
   10 WRITE(KTERMW,101)' INPUT FILE NAME:      '
      READ(KTERMR,101,ERR=20)FILNAM
      OPEN(KIN,FILE=FILNAM,STATUS='OLD',ERR=20)
      GO TO 30
C
   20 WRITE(KTERMW,101)' *** ERROR IN FILE SPECIFICATION.  TRY AGAIN.'
      GO TO 10
C
   30 WRITE(KTERMW,101)' OUTPUT FILE NAME:     '
      READ(KTERMR,101,ERR=40)FILNAM
      OPEN(KOUT,FILE=FILNAM,STATUS='UNKNOWN',ERR=40)
      GO TO 50
C
   40 WRITE(KTERMW,101)' *** ERROR IN FILE SPECIFICATION.  TRY AGAIN.'
      GO TO 30
C
   50 WRITE(KTERMW,101)' ITERATION FILE NAME:  '
      READ(KTERMR,101,ERR=60)FILNAM
      OPEN(KITER,FILE=FILNAM,STATUS='UNKNOWN',ERR=60)
      GO TO 70
C
   60 WRITE(KTERMW,101)' *** ERROR IN FILE SPECIFICATION.  TRY AGAIN.'
      GO TO 50
C
C OUTPUT A HEADER FOR THE PROGRAM TO THE OUTPUT FILE.
C
   70 WRITE(KOUT,101)' **********************************************'
      WRITE(KOUT,101)' ***********   PROGRAM RHMAXLIK   *************'
      WRITE(KOUT,101)' **********************************************'
      WRITE(KOUT,101)' **************  VERSION 3.0   ****************'
      WRITE(KOUT,101)' **********************************************'
      WRITE(KOUT,101)' ***********   SEPTEMBER 1996   ***************'
      WRITE(KOUT,101)' **********************************************'
      WRITE(KOUT,101)' **** BY MICHAEL BOEHNKE, KATHRYN LUNETTA *****'
      WRITE(KOUT,101)' *** ELIZABETH HAUSER, KENNETH LANGE, AND  ****'
      WRITE(KOUT,101)' *************  JILL VANDERSTOEP  *************'
      WRITE(KOUT,101)' **********************************************'
C
      RETURN
      END
C
C
C
      SUBROUTINE INPUTS(CRET,FRMT,HNAMET,INCHAR,KIN,KOUT,LNAMET,MAXCHR
     1,MAXHYB,MAXLOC,MAXPAN,NCHR,NDSET,NERR,NHYBT,NLOCT,NOBST,NPAN
     2,NPROB,RET,SCROPT)
C
C INPUT THE DATA FOR THE CURRENT PROBLEM SET.
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*1 CHAR,CRET(MAXLOC),INCHAR(0:2)
      CHARACTER*4 HNAMET(MAXPAN,MAXHYB),LNAME,LNAMET(MAXLOC)
      CHARACTER*200 FRMT
      INTEGER NCHR(MAXPAN),NHYBT(MAXPAN),NOBST(MAXPAN,MAXHYB)
     1,RET(MAXPAN,MAXHYB,MAXLOC),SCROPT
C
C READ THE NUMBER OF PROBLEMS IN THIS SET, THE TOTAL NUMBER OF LOCI,
C THE NUMBER OF HYBRIDS (OR MINUS THE NUMBER OF HYBRID PANELS, IF MORE 
C THAN 1), THE SCREEN OUTPUT OPTION, AND THE PLOIDY.  CHECK THAT THEIR 
C VALUES MAKE SENSE.  IF WE ENCOUNTER AN ERROR IN THE READ, STOP.
C
      NERR=1
      READ(KIN,101,END=220,ERR=200)NPROB,NLOCT,NHYBT(1),SCROPT,NCHR(1)
 101  FORMAT(20I4)
      NERR=0
C
      IF(NPROB.GT.0)GO TO 10
        WRITE(KOUT,102)NPROB
 102    FORMAT(/' *** ERROR *** THE NUMBER OF PROBLEMS IN THE PROBLEM',
     1  ' SET IS REPORTED TO'/15X,'BE',I4,'.  IT MUST BE POSITIVE.')
        NERR=NERR+1
        GO TO 200
C
   10 IF(NLOCT.GT.1.AND.NLOCT.LE.MAXLOC.AND.NLOCT.LE.999)GO TO 20
        WRITE(KOUT,103)NLOCT,MAXLOC
 103    FORMAT(/' *** ERROR *** THE NUMBER OF LOCI IN THE PROBLEM SET',
     1  ' IS REPORTED TO'/15X,'BE',I4,'.  IT MUST BE AT LEAST TWO AND',
     2  ' NO GREATER THAN THE'/15X,'MAXIMUM OF ',I6,' AND 999.')
        NERR=NERR+1
C
   20 NPAN=1
      IF(NHYBT(1).GT.0.AND.NHYBT(1).LE.MAXHYB)GO TO 40
      IF(NHYBT(1).LT.0)NPAN=-NHYBT(1)
      IF(NPAN.LE.MAXPAN)GO TO 40
      IF(NPAN.GT.MAXPAN)GO TO 30
        WRITE(KOUT,104)NHYBT(1),MAXHYB
 104    FORMAT(/' *** ERROR *** THE NUMBER OF HYBRIDS IN THE PROBLEM',
     1  ' SET IS REPORTED TO'/15X,'BE ',I4,'.  IT MUST BE POSITIVE AND'
     2  ,' NO GREATER THAN',I4,'.')
        NERR=NERR+1
        GO TO 40
   30   WRITE(KOUT,105)NPAN,MAXPAN
 105    FORMAT(/' *** ERROR *** THE NUMBER OF HYBRID PANELS IN THE',
     1  ' PROBLEM SET IS '/15X,'REPORTED TO BE ',I4,'.  IT MUST BE',
     2  ' BETWEEN 1 AND ',I4,'.')
        NERR=NERR+1
C
   40 IF(SCROPT.EQ.0.OR.SCROPT.EQ.1.OR.SCROPT.EQ.2)GO TO 50
        WRITE(KOUT,106)SCROPT
 106    FORMAT(/' *** ERROR *** SCREEN OUTPUT OPTION FOR THE PROBLEM',
     1  ' SET IS REPORTED TO'/15X,'BE',I4,'.  IT MUST BE ZERO, ONE,',
     2  ' OR TWO.')
        NERR=NERR+1
C
   50 IF(NCHR(1).EQ.0)NCHR(1)=1
      IF(NCHR(1).GT.0.AND.NCHR(1).LE.MAXCHR)GO TO 60
      IF(NPAN.GT.1)GO TO 60
        WRITE(KOUT,107)NCHR(1),MAXCHR
 107    FORMAT(/' *** ERROR *** THE NUMBER OF CHROMOSOMES FOR THE',
     1  ' PROBLEM SET IS REPORTED'/15X,'TO BE',I4,'.  IT MUST BE NO',
     2  ' GREATER THAN',I4,/15X,'AND MUST BE 1 FOR MODEL 4',
     3  ' (GENERAL RETENTION MODEL).')
        NERR=NERR+1
C
C READ THE LOCUS NAMES AND THE FORMAT FOR READING THE RETENTION DATA.
C CHECK THAT THE LOCUS NAMES ARE ALL DIFFERENT.
C
   60 READ(KIN,108)(LNAMET(I),I=1,NLOCT)
 108  FORMAT(20A4)
C
      NLOCT1=NLOCT-1
      DO 80 LOCUS1=1,NLOCT1
        LNAME=LNAMET(LOCUS1)
        DO 70 LOCUS2=LOCUS1+1,NLOCT
          IF(LNAME.NE.LNAMET(LOCUS2))GO TO 70
            WRITE(KOUT,109)LOCUS1,LOCUS2,LNAME
 109        FORMAT(/' *** ERROR *** LOCUS NUMBERS ',I4,' AND ',I4,
     1      ' HAVE THE SAME NAME, ',A4,'.')
            NERR=NERR+1
   70   CONTINUE
   80 CONTINUE
C
      READ(KIN,111)FRMT
 111  FORMAT(A)
C
C ECHO THE LOCUS NAMES FOR THE DATA SET.
C
      WRITE(KOUT,112)NDSET+1
 112  FORMAT(///' LOCUS NAMES FOR PROBLEM SET',I6//
     1'  LOCUS         LOCUS'/'  NUMBER        NAME'/)
C
      DO 90 I=1,NLOCT
        WRITE(KOUT,113)I,LNAMET(I)
 113    FORMAT(I6,11X,A4)
   90 CONTINUE
C
C READ THE SYMBOLS FOR PRESENT, ABSENT, AND MISSING LOCI.
C
      READ(KIN,114)INCHAR(1),INCHAR(0),INCHAR(2)
 114  FORMAT(3A1)
      WRITE(KOUT,115)INCHAR(1),INCHAR(0),INCHAR(2)
 115  FORMAT(//' RETENTION STATUS CHARACTERS'//5X,A1,' = RETAINED'/5X
     1,A1,' = NOT RETAINED'/5X,A1,' = UNTYPED')
C
      IF(INCHAR(0).NE.INCHAR(1).AND.INCHAR(0).NE.INCHAR(2).AND.INCHAR(1)
     1.NE.INCHAR(2))GO TO 100
        WRITE(KOUT,116)INCHAR(1),INCHAR(0),INCHAR(2)
 116    FORMAT(/' *** ERROR *** THE SYMBOLS ',A1,', ',A1,', AND ',A1,
     1  ' FOR PRESENT, ABSENT, AND MISSING'/15X,'DATA ARE NOT ALL',
     2  ' DIFFERENT.')
        NERR=NERR+1
C
C OUTPUT A HEADER FOR THE RETENTION STATUS DATA
C
  100 WRITE(KOUT,117)NDSET+1
 117  FORMAT(///' RADIATION HYBRID RETENTION STATUS DATA FOR',
     1' PROBLEM SET',I6,'.')
      NTOTAL=0
C
C FOR EACH HYBRID PANEL . . .
C
      DO 190 IPAN=1,NPAN
C
C READ THE RETENTION INFORMATION.  PRINT THE HYBRID DATA.
C
        IF(NPAN.GT.1)WRITE(KOUT,118)IPAN,NPAN
        WRITE(KOUT,119)(I,I=1,NLOCT)
 118    FORMAT(/' HYBRID PANEL',I4,' OF ',I4,'.')
 119    FORMAT(/' HYBRID  HYBRID   NUMBER     LOCUS',' NUMBER'/
     1  '  NAME   NUMBER  OBSERVED  ',20I3,10(/27X,20I3))
        WRITE(KOUT,111)
C
C IF NPAN > 1, READ THE NUMBER OF HYBRIDS NHYBT(IPAN) AND PLOIDY
C NCHR(IPAN) FOR THIS PANEL.  CHECK TO MAKE SURE THE VALUES ARE LEGAL.
C
        IF(NPAN.GT.1)READ(KIN,101)NHYBT(IPAN),NCHR(IPAN)
  110   IF(NCHR(IPAN).EQ.0)NCHR(IPAN)=1
        IF(NCHR(IPAN).GT.0.AND.NCHR(IPAN).LE.MAXCHR)GO TO 120
          WRITE(KOUT,121)IPAN,NCHR(IPAN),MAXCHR
 121      FORMAT(/' *** ERROR *** THE NUMBER OF CHROMOSOMES FOR PANEL',
     1    I4,' IS REPORTED'/15X,'TO BE',I4,'.  IT MUST BE NO',
     2    ' GREATER THAN',I4,', AND MUST BE ONE'/15X,'FOR MODEL 4',
     3    ' (GENERAL RETENTION MODEL).')
          NERR=NERR+1
  120   IF(NHYBT(IPAN).GT.0.AND.NHYBT(IPAN).LE.MAXHYB)GO TO 130
          WRITE(KOUT,122)IPAN,NHYBT(IPAN),MAXHYB
 122      FORMAT(/' *** ERROR *** THE NUMBER OF HYBRIDS IN PANEL',I4
     1    ,' IS REPORTED TO'/15X,'BE ',I4,'.  IT MUST BE POSITIVE AND'
     2    ,' NO GREATER THAN',I4,'.')
          NERR=NERR+1
C
C FOR EACH HYBRID. . .
C
  130   DO 180 IHYBT=1,NHYBT(IPAN)
C
C TRANSLATE THE SYMBOLS FOR PRESENT, ABSENT, AND MISSING LOCI
C TO 1, 0, AND 2, RESPECTIVELY.  NOBST=0 BY CONVENTION IMPLIES
C THAT NOBST=1.
C
  140     READ(KIN,FRMT)HNAMET(IPAN,IHYBT),(CRET(J),J=1,NLOCT),NOBST
     1    (IPAN,IHYBT)
          IF(NOBST(IPAN,IHYBT).EQ.0)NOBST(IPAN,IHYBT)=1
          NTOTAL=NTOTAL+NOBST(IPAN,IHYBT)
C
C CHECK THAT THE HYBRID OBSERVATIONS ARE ADMISSABLE.
C
          DO 160 J=1,NLOCT
            CHAR=CRET(J)
            DO 150 K=0,2
              IF(CHAR.NE.INCHAR(K))GO TO 150
                RET(IPAN,IHYBT,J)=K
                GO TO 160
  150       CONTINUE
            WRITE(KOUT,123)IHYBT,HNAMET(IPAN,IHYBT),IPAN,CHAR,J,
     1      LNAMET(J)
 123        FORMAT(/' *** ERROR *** HYBRID NUMBER ',I4,' NAMED ',A4,
     1      ' IN PANEL ',I4,/15X,'HAS ILLEGAL OBSERVATION ',A1,
     2      ' FOR LOCUS NUMBER ',I4,' NAMED ',A4,'.') 
            NERR=NERR+1
  160     CONTINUE
C
C CHECK THE NUMBER OF TIMES HYBRIDS ARE OBSERVED.
C
          IF(NOBST(IPAN,IHYBT).GT.0)GO TO 170
            WRITE(KOUT,124)IHYBT,IPAN,NOBST(IPAN,IHYBT)
 124        FORMAT(/' *** ERROR *** HYBRID NUMBER ',I4,' IN PANEL ',I4,
     1      /15X,'IS REPORTEDLY OBSERVED ',I4,' TIMES.')
            NERR=NERR+1
C
C PRINT THE HYBRID.
C
  170     WRITE(KOUT,125)HNAMET(IPAN,IHYBT),IHYBT,NOBST(IPAN,IHYBT),
     1    (CRET(J),J=1,NLOCT)
 125      FORMAT(2X,A4,I7,I9,5X,20(2X,A1),50(/27X,20(2X,A1)))
  180   CONTINUE
  190 CONTINUE
      GO TO 210
C
  200 WRITE(KOUT,126)
 126  FORMAT(/' ERROR ENCOUNTERED WHILE READING THE FIRST INPUT',
     1' RECORD FOR A PROBLEM'/' SET.  THIS MAY HAVE OCCURRED BECAUSE',
     2' OF EXTRA INFORMATION OR BLANK'/' LINES AT THE END OF THE',
     3' INPUT FILE.')
      STOP
C
  210 WRITE(KOUT,127)NTOTAL
 127  FORMAT(/' TOTAL NUMBER OF HYBRIDS:',I6)
C
  220 CONTINUE
      RETURN
      END
C
C
C
      SUBROUTINE INPUTP(CMODEL,CORDOP,HYBMIN,ICONDS,IMISS,INFOPT,INPERM
     1,IPROB,KIN,KOUT,LNAME,LNAMET,MAXHYB,MAXLOC,MAXPAN,MAXPAR
     2,MLTOPT,MODEL,NBEST,NCHR,NERR,NHYBT,NHYB,NLOCT,NLOCUS,NOBS,NOBST
     3,NPAN,NPAR,NUMHYB,ORDOPT,OUTOPT,RET,RETAIN,SELNUM,USEINC)
C
C READ THE CONTROL INFORMATION FOR THE CURRENT PROBLEM.
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*4 LNAME(MAXLOC),LNAMET(MAXLOC),SELNAM
      CHARACTER*10 CINFOP,CMODEL(7),CORDOP(4),CUSINC,CCONDS
      CHARACTER*16 CMOPT
      INTEGER INPERM(MAXLOC),NCHR(MAXPAN),NHYB(MAXPAN),NHYBT(MAXPAN)
     1,NOBS(MAXPAN,MAXHYB),NOBST(MAXPAN,MAXHYB),NUMHYB(MAXPAN)
     2,ORDOPT,OUTOPT,RET(MAXPAN,MAXHYB,MAXLOC)
     3,RETAIN(MAXPAN,MAXHYB,MAXLOC),SELLOC,SELNUM,USEINC
C
C READ THE CONTROL INFORMATION FOR THE CURRENT PROBLEM.
C CHECK THAT THE INPUT VALUES MAKE SENSE.
C   NLOCUS:  NUMBER OF LOCI.
C   MODEL:   RETENTION MODEL FOR THE ANALYSIS.
C   ORDOPT:  ORDERING OPTION FOR SELECTING BEST ORDER(S).
C   USEINC:  =1 USE ALL DATA; =0 USE COMPLETELY TYPED HYBRIDS ONLY.
C   NBEST:   NO MORE THAN THE NBEST BEST LOCUS ORDERS WILL BE PRINTED.
C   INFOPT:  =1 PRINT INFLUENTIAL HYBRID INFORMATION; =0 DO NOT.
C   OUTOPT:  =0 BASIC OUTPUT; =1 ALSO ALL ESTIMATES; =2 ALSO ITERATIONS.
C   HYBMIN:  MINIMUM DIFFERENCE TO CALL HYBRID INFLUENTIAL.
C   MLTOPT:  =1 IF PROPORTIONAL DISTANCES, =0 IF NON-PROP (DEFAULT IS 0)
C   ICONDS:  =1 IF CONDITION ON SELECTED LOCUS, =0 IF NOT
C
      NERR=0
      MLTOPT=0
      ICONDS=0
      READ(KIN,101)NLOCUS,MODEL,ORDOPT,USEINC,NBEST,INFOPT,OUTOPT,
     1HYBMIN,MLTOPT,ICONDS
 101  FORMAT(7I4,F8.5,2I4)
C
C   SELLOC:  =0 NOT SELECTED LOCUS MODEL (MODEL=1,2,3,4); 
C            =1 SELECTED LOCUS MODEL (MODEL=5,6,7).
C            
      SELLOC=0
      IF(MODEL.GT.4)SELLOC=1
C
C DETERMINE THE NUMBER OF HAPLOID PANELS.
C
      NCHRN1=0
      DO 10 IPAN=1,NPAN
        IF(NCHR(IPAN).EQ.1)NCHRN1=NCHRN1+1
 10   CONTINUE
C
      IF(NLOCUS.GT.1.AND.NLOCUS.LE.NLOCT)GO TO 20
        WRITE(KOUT,102)NLOCUS,NLOCT
 102    FORMAT(/' *** ERROR *** THE NUMBER OF LOCI FOR THE CURRENT',
     1  ' PROBLEM IS REPORTED TO'/15X,'BE',I4,'.  IT MUST BE',
     2  ' AT LEAST TWO AND NO GREATER THAN ',I4,'.')
        NERR=NERR+1
C
   20 IF(MODEL.GE.1.AND.MODEL.LE.3)GO TO 30
      IF(MODEL.GT.4.AND.MODEL.LE.7)GO TO 30
      IF(MODEL.EQ.4.AND.NCHRN1.EQ.NPAN)GO TO 30
        WRITE(KOUT,103)MODEL
 103    FORMAT(/' *** ERROR *** RETENTION MODELS 1 (EQUAL), 2',
     1  ' (CENTROMERIC), 3 (LEFT'/15X,'ENDPOINT),  4 (GENERAL:',
     2  '  HAPLOID DATA ONLY), 5 (S1),',/15X,
     3  '6 (S2), AND 7 (S3) ARE ALLOWED.  MODEL ',I4,' WAS',/15X,
     4  'REQUESTED.')
        NERR=NERR+1
C
   30 IF(NLOCUS.GE.4.OR.MODEL.NE.4)GO TO 40
        WRITE(KOUT,104)
 104    FORMAT(/' *** ERROR *** THE GENERAL MODEL IS NOT IDENTIFIABLE',
     1  ' UNLESS THERE ARE AT'/15X,'LEAST FOUR LOCI TO BE ORDERED.')
        NERR=NERR+1
C
   40 IF(ORDOPT.GT.0.AND.ORDOPT.LT.5)GO TO 50
        WRITE(KOUT,105)ORDOPT
 105    FORMAT(/' *** ERROR *** ORDERING OPTIONS 1 (LIST), 2',
     1  ' (STEPWISE), 3 (SIMULATED'/15X,'ANNEALING), AND 4 (BRANCH',
     2  ' AND BOUND) ARE ALLOWED.'/15X,'ORDERING OPTION ',I4,
     3  ' WAS REQUESTED.')
        NERR=NERR+1
C
   50 IF(NLOCUS.GT.2.OR.ORDOPT.EQ.1)GO TO 60
        WRITE(KOUT,106)
 106    FORMAT(/' *** ERROR *** IF THERE ARE ONLY TWO LOCI, ONLY THE',
     1  ' LIST OF ORDERS'/15X,'ORDERING OPTION (ORDOPT=1) IS ALLOWED.')
        NERR=NERR+1
C
   60 IF(USEINC.EQ.0.OR.USEINC.EQ.1)GO TO 70
        WRITE(KOUT,107)USEINC
 107    FORMAT(/' *** ERROR *** INCOMPLETE DATA INDICATOR MUST BE ONE',
     1  ' (USE INCOMPLETELY'/15X,'TYPED HYBRIDS) OR ZERO (DO NOT).',
     2  '  IT IS ',I4,'.')
        NERR=NERR+1
C
C IF NBEST=0, BY CONVENTION, POTENTIALLY ALL ORDERS ARE TO BE PRINTED.
C
   70 IF(NBEST.GE.0)GO TO 80
        WRITE(KOUT,108)NBEST
 108    FORMAT(/' *** ERROR *** THE MAXIMUM NUMBER OF BEST ORDERS TO',
     1  ' PRINT IS'/15X,'LISTED AS ',I6,'.  IT MUST BE NON-NEGATIVE.')
        NERR=NERR+1
C
   80 IF(INFOPT.EQ.0.OR.INFOPT.EQ.1)GO TO 90
        WRITE(KOUT,109)INFOPT
 109    FORMAT(/' *** ERROR *** INFLUENTIAL HYBRID OUTPUT INDICATOR',
     1  ' MUST BE ONE (YES)'/15X,'OR ZERO (NO).  IT IS ',I4,'.')
        NERR=NERR+1
C
   90 IF(OUTOPT.GE.0.AND.OUTOPT.LE.2)GO TO 100
        WRITE(KOUT,111)OUTOPT
 111    FORMAT(/' *** ERROR *** OUTPUT OPTION INDICATOR MUST BE ZERO',
     1  ' (BASIC), ONE (ALSO'/15X,'ALL ESTIMATES) OR TWO (ALSO',
     2  ' ITERATIONS).  IT IS ',I4,'.')
        NERR=NERR+1
C
  100 IF(HYBMIN.GE.0.D0)GO TO 110
        WRITE(KOUT,112)HYBMIN
 112    FORMAT(/' *** ERROR *** THE MINIMUM DIFFERENCE TO CONSIDER A',
     1  ' HYBRID INFLUENTIAL'/15X,'IS REPORTED TO BE',F12.5,'.  IT',
     2  ' MUST BE NON-NEGATIVE.')
        NERR=NERR+1
C
  110 IF(MLTOPT.EQ.1.OR.MLTOPT.EQ.0.OR.NPAN.EQ.1)GO TO 120
        WRITE(KOUT,113)MLTOPT
 113    FORMAT(/' *** ERROR *** THE DISTANCES OPTION IS',
     1  ' REPORTED TO BE',I4,'.'/15X,'IT MUST BE ONE (PROPORTIONAL)',
     2  ' OR ZERO'/15X,'ZERO (NON-PROPORTIONAL) DISTANCES.')
        NERR=NERR+1
C
  120 IF(MODEL.NE.4.OR.MLTOPT.EQ.0) GO TO 130
        WRITE(KOUT,114)MLTOPT,MODEL
 114    FORMAT(/' *** ERROR *** THE DISTANCES OPTION IS',
     1  ' REPORTED TO BE',I4,', AND THE',/15X,'MODEL IS',I4,
     2  '.  ONLY NON-PROPORTIONAL DISTANCES',/15X,'(DISTANCE',
     3  ' OPTION 0) ARE SUPPORTED FOR THE GENERAL',/15X,'MODEL.')
        NERR=NERR+1
C
  130 IF(ICONDS.EQ.0)GO TO 140
      IF(ICONDS.EQ.1.AND.MODEL.EQ.1.OR.MODEL.EQ.5.OR.MODEL.EQ.6)
     1GO TO 140
        WRITE(KOUT,115)ICONDS,MODEL
 115    FORMAT(/' *** ERROR *** THE CONDITIONAL MODEL OPTION',
     1  ' IS REPORTED TO BE',I4,/15X,'AND THE MODEL IS ',I4,'.',
     2  ' THE CONDITIONAL MODEL OPTION IS',/15X,'SUPPORTED ONLY FOR',
     3  ' MODELS 1, 5, AND 6.')
        NERR=NERR+1
C
C READ THE LOCUS NAMES FOR THE CURRENT PROBLEM.  CHECK THAT THEY ARE ALL
C DIFFERENT AND THAT THEY ARE IN THE DATA SET.  DETERMINE THE INPUT ORDER
C OF THE LOCI.
C
  140 IF(NLOCUS.LE.0.OR.NLOCUS.GT.NLOCT)GO TO 150
        READ(KIN,116)(LNAME(LOCUS),LOCUS=1,NLOCUS)
 116    FORMAT(20A4)
C
      CALL NAMIND(KOUT,LNAME,LNAMET,NERR,NLOCT,NLOCUS,INPERM)
C
C FOR SELECTED LOCUS MODELS (MODEL>4 OR MODEL=1 AND ICONDS=1)
C READ IN THE NAME OF THE SELECTED LOCUS AND DETERMINE WHETHER IT IS
C ONE OF THE PROBLEM LOCI.  SELNUM IS THE INDEX OF THE LOCATION OF THE
C SELECTED LOCUS IN THE ARRAY OF PROBLEM LOCI.
C
  150 SELNUM=0
      IF(SELLOC.EQ.0.AND.ICONDS.EQ.0)GO TO 170
        READ(KIN,116)SELNAM
        DO 160 ILOC=1,NLOCUS
          IF(SELNAM.NE.LNAME(ILOC))GO TO 160
            SELNUM=ILOC
            GO TO 170
  160   CONTINUE
        WRITE(KOUT,117)SELNAM
 117    FORMAT(/' *** ERROR *** THE SELECTED LOCUS IS REPORTED TO BE ',
     1  A5,'.'/15X,'IT MUST BE ONE OF THE PROBLEM LOCI.')
        NERR=NERR+1
C
C RE-ORDER AND COMPRESS RET TO GIVE RETAIN FOR THIS PROBLEM.  SET
C NOBS AND NHYB.  IF WE HAVE A SELECTED LOCUS, MAKE SURE IT IS AT LEAST 
C PARTIALLY TYPED.  IF WE ARE CONDITIONING ON THE SELECTED LOCUS 
C (ICONDS=1), MAKE SURE IT IS PRESENT IN TYPED HYBRIDS.  IMISS IS THE
C NUMBER OF HYBRIDS THAT ARE UNTYPED FOR THE SELECTED LOCUS.
C
  170 IMISS=0
C
C FOR EACH HYBRID PANEL . . .
C 
      DO 240 IPAN=1,NPAN
        NHYB(IPAN)=0
        NUMHYB(IPAN)=0
        DO 230 IHYBT=1,NHYBT(IPAN)
          NHYB(IPAN)=NHYB(IPAN)+1
C
C CHOOSE THE NEXT SET OF VALUES FROM RET.  IF THERE ARE ANY MISSING
C VALUES, WE MAY OPTIONALLY DELETE THEM.
C
          DO 200 LOCUS=1,NLOCUS
            RETAIN(IPAN,NHYB(IPAN),LOCUS)=RET(IPAN,IHYBT,INPERM(LOCUS))
            IF(SELNUM.NE.LOCUS.OR.RETAIN(IPAN,NHYB(IPAN),LOCUS).EQ.1)
     1      GO TO 190
C
C PRINT ERROR MESSAGE IF A CONDITIONAL MODEL IS REQUESTED AND THE 
C SELECTED LOCUS IS NOT PRESENT IN SOME TYPED HYBRIDS.
C
              IF(RETAIN(IPAN,NHYB(IPAN),LOCUS).EQ.0)GO TO 180
                IMISS=IMISS+NOBST(IPAN,IHYBT)
                GO TO 190
  180         IF(ICONDS.EQ.0)GO TO 190
              WRITE(KOUT,118)
 118          FORMAT(/' *** ERROR *** THE SELECTED LOCUS MAY NOT BE', 
     1        ' CODED',/15X,'AS ABSENT FROM ANY HYBRID WHEN ICONDS=1.')
              NERR=NERR+1
  190       IF(USEINC.EQ.1.OR.RETAIN(IPAN,NHYB(IPAN),LOCUS).NE.2)
     1      GO TO 200
C
C DELETE THIS HYBRID BECAUSE IT IS NOT COMPLETELY TYPED AND USEINC=0.
C CONTINUE ON TO THE NEXT HYBRID.
C
              NHYB(IPAN)=NHYB(IPAN)-1
              GO TO 230
  200     CONTINUE
C
C KEEP THE HYBRID AND UPDATE THE APPROPRIATE COUNTS.
C
          NOBS(IPAN,NHYB(IPAN))=NOBST(IPAN,IHYBT)
          NUMHYB(IPAN)=NUMHYB(IPAN)+NOBS(IPAN,NHYB(IPAN))
C
          NHYB1=NHYB(IPAN)-1
          DO 220 JHYB=1,NHYB1
            DO 210 LOCUS=1,NLOCUS
              IF(RETAIN(IPAN,NHYB(IPAN),LOCUS).NE.
     1        RETAIN(IPAN,JHYB,LOCUS))GO TO 220
  210       CONTINUE
            NOBS(IPAN,JHYB)=NOBS(IPAN,JHYB)+NOBS(IPAN,NHYB(IPAN))
            NHYB(IPAN)=NHYB(IPAN)-1
            GO TO 230
  220     CONTINUE
  230   CONTINUE
C
C IF THE SELECTED LOCUS IS COMPLETELY UNTYPED, DO NOT CONTINUE. 
C
        IF(IMISS.NE.NUMHYB(IPAN))GO TO 240
          WRITE(KOUT,119)
 119      FORMAT(/' *** ERROR *** THE SELECTED LOCUS MUST BE AT LEAST'
     1    ,/15X,'PARTIALLY TYPED')
          NERR=NERR+1
  240 CONTINUE
C
C IF WE HAVE A CONDITIONAL SELECTED LOCUS MODEL (ICONDS=0 AND MODEL=5 OR 6)
C CHECK TO MAKE SURE THAT ALL PANELS HAVE DIPLOID (OR POLYPLOID) HYBRIDS.
C
      IF(ICONDS.EQ.0.OR.MODEL.EQ.1.OR.NCHRN1.EQ.0)GO TO 250
        WRITE(KOUT,122)
 122    FORMAT(/' *** ERROR *** CONDITIONAL MODELS (ICONDS=1) ARE NOT'
     1  ,/15X,'SUPPORTED FOR HAPLOID HYBRIDS.')
        NERR=NERR+1
C
C CALCULATE THE NUMBER OF MODEL PARAMETERS.  CHECK THAT IT IS WITHIN
C BOUNDS.
C
  250 NPAR=NUMPAR(MLTOPT,MODEL,NLOCUS,NPAN)
      IF(NPAR.LE.MAXPAR)GO TO 260
        WRITE(KOUT,123)NPAR,MAXPAR
 123    FORMAT(/' *** ERROR *** THE NUMBER OF PARAMETERS',I8,' IS',
     1  ' GREATER THAN THE'/15X,'MAXIMUM NUMBER OF PARAMETERS',I8,'.')
        NERR=NERR+1
C
C ECHO THE CONTROL DATA FOR THIS PROBLEM.
C
  260 CUSINC='        NO'
      IF(USEINC.EQ.1)CUSINC='       YES'
      CINFOP='        NO'
      IF(INFOPT.EQ.1)CINFOP='       YES'
C
      CCONDS='        NO'
      IF(ICONDS.EQ.1)CCONDS='       YES'
      CMOPT='NON-PROPORTIONAL'
      IF(MLTOPT.EQ.1)CMOPT='    PROPORTIONAL'
      IF(NPAN.GT.1) WRITE(KOUT,124)IPROB,NLOCUS,NPAN,CMOPT,(NCHR(IPAN),
     1IPAN,IPAN=1,NPAN)
      IF(NPAN.EQ.1) WRITE(KOUT,125)IPROB,NLOCUS,NPAN,NCHR(1)
      IF(SELLOC.EQ.1.OR.ICONDS.EQ.1)WRITE(KOUT,126)CMODEL(MODEL),CORDOP
     1(ORDOPT),CUSINC,CINFOP,SELNAM,CCONDS,(LNAME(I),I=1,NLOCUS)
      IF(SELLOC.EQ.0.AND.ICONDS.EQ.0)WRITE(KOUT,127)CMODEL(MODEL),
     1CORDOP(ORDOPT),CUSINC,CINFOP,(LNAME(I),I=1,NLOCUS)
 124  FORMAT(///' PROBLEM NUMBER',I26//' NUMBER OF LOCI:',15X,I10/
     1' NUMBER OF HYBRID PANELS:',6X,I10,/' DISTANCES OPTION:',7X,A16,/
     2' NUMBER OF CHROMOSOMES (PLOIDY):',5X,5(I4,2X,'(PAN',I2,')'),/
     3     50(37X,5(I4,2X'(PAN',I2,')')))
 125  FORMAT(///' PROBLEM NUMBER',I26//' NUMBER OF LOCI:',15X,I10/
     1' NUMBER OF HYBRID PANELS:',6X,I10,/
     2' NUMBER OF CHROMOSOMES (PLOIDY):',5X,I4)
 126  FORMAT(' RETENTION MODEL:',14X,A10/' ORDERING OPTION:',14X,A10/
     1' USE INCOMPLETE HYBRIDS:',7X,A10/' IDENTIFY INFLUENTIAL HYBRIDS:'
     2,1X,A10/' SELECTED LOCUS:',20X,A5/' CONDITION ON SELECTED LOCUS:'
     3,2X,A10//' GENETIC LOCI:  ',12A5,100(/16X,12A5))
 127  FORMAT(' RETENTION MODEL:',14X,A10/' ORDERING OPTION:',14X,A10/
     1' USE INCOMPLETE HYBRIDS:',7X,A10/' IDENTIFY INFLUENTIAL HYBRIDS:'
     2,1X,A10//' GENETIC LOCI:  ',12A5,100(/16X,12A5))
C
      RETURN
      END
C
C
C
      SUBROUTINE NAMIND(KOUT,LNAME,LNAMET,NERR,NLOCT,NLOCUS,PERM)
C
C CHECK THAT THE LOCUS NAMES LNAME ARE ALL DIFFERENT AND THAT THEY
C ARE ALL AMONG THE NAMES IN LNAMET.
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*4 LNAM,LNAME(NLOCUS),LNAMET(NLOCT)
      INTEGER PERM(NLOCUS)
C
      NLOC1=NLOCUS-1
      DO 20 LOCUS1=1,NLOC1
        LNAM=LNAME(LOCUS1)
        DO 10 LOCUS2=LOCUS1+1,NLOCUS
          IF(LNAM.NE.LNAME(LOCUS2))GO TO 10
            WRITE(KOUT,101)LOCUS1,LOCUS2,LNAM
 101        FORMAT(/' *** ERROR *** LOCUS NUMBERS ',I4,' AND ',I4,
     1      ' HAVE THE SAME NAME, ',A4,'.')
            NERR=NERR+1
   10   CONTINUE
   20 CONTINUE
C
      DO 50 LOCUS=1,NLOCUS
        PERM(LOCUS)=1
        LNAM=LNAME(LOCUS)
        DO 30 LOCUST=1,NLOCT
          IF(LNAMET(LOCUST).EQ.LNAM)GO TO 40
   30   CONTINUE
          WRITE(KOUT,102)LOCUS,LNAM
 102      FORMAT(/' *** ERROR *** LOCUS NUMBER ',I4,' WITH NAME ',A4,
     2    ' IS NOT PRESENT AMONG'/15X,'THE LOCI FOR THIS PROBLEM SET.')
          NERR=NERR+1
          GO TO 50
   40   PERM(LOCUS)=LOCUST
   50 CONTINUE
C
      RETURN
      END
C
C
C
      FUNCTION NUMPAR(MLTOPT,MODEL,NLOCUS,NPAN)
C
C CALCULATE THE NUMBER OF PARAMETERS NPAR.  GIVEN MULTIPLE PANELS AND 
C NON-PROPORTIONAL DISTANCES, NPAR IS THE NUMBER OF PARAMETERS PER PANEL.
C FOR PROPORTIONAL DISTANCES, NPAR IS THE TOTAL NUMBER OF PARAMETERS.
C
      IMPLICIT REAL*8(A-H,O-Z)
C
      NP=NPAN
      IF(MLTOPT.EQ.0)NP=1
      GO TO (10,10,20,30,40,40,20) MODEL
C
C MODEL=1:  EQUAL RETENTION PROBABILITIES OR MODEL=2:  CENTROMERIC
C MODEL.
C
   10 NUMPAR=NLOCUS-1+MODEL*NP+NP-1
      GO TO 50
C
C MODEL=3 OR MODEL=7:  ENDPOINT RETENTION PROBABILITY MODELS.
C
   20 NUMPAR=NLOCUS*NP+NLOCUS-1+NP-1
      GO TO 50
C
C MODEL=4:  GENERAL RETENTION PROBABILITY MODEL (COX).
C (DOESN'T ALLOW FOR MULTIPLE PANELS)
C
   30 NUMPAR=(NLOCUS+3)*NLOCUS/2-1
      GO TO 50
C
C MODEL=5: S1 OR MODEL=6: S2: SELECTED LOCUS MODELS
C
   40 NUMPAR=NLOCUS-1+(MODEL-3)*NP+NP-1
   50 RETURN
      END
C
C
C
      SUBROUTINE ORDLST(ALPHA,ALPHAP,BETA,BETAP,BINOM,BLIKE,BPERM,BRLIST
     1,CHECK,CONDP,CONV,DF,DFHYB,DP,DTRANS,EMSTEP,FRMT,HPROB,ICONDS,KIN
     2,KITER,KOUT,KTERMW,LNAME,LNAMEL,MAXCHR,MAXHYB,MAXLOC,MAXORD,MAXPAN
     3,MAXPAR,MLTOPT,MODEL,MXITER,NCHR,NCONV,NHYB,NLOCUS,NOBS,NPAN,NPAR
     4,NRET,NTYPE,NUMHYB,NUMORD,OUTOPT,PAR,PERM,PNAME,RETAIN,SCROPT
     5,SELNUM,SUBPRM,TENLOG,TOL,TRANS1,TRANSP)
C
C CALCULATE THE LIKELIHOODS FOR A SET OF USER-SPECIFIED LOCUS ORDERS.
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*4 LNAME(MAXLOC),LNAMEL(MAXLOC)
      CHARACTER*8 PNAME(MAXPAR)
      CHARACTER*200 FRMT
      INTEGER BPERM(MAXORD,MAXLOC),BRLIST(0:MAXLOC)
     1,CHECK(MAXPAN,MAXHYB),NCHR(MAXPAN),NHYB(MAXPAN)
     2,NOBS(MAXPAN,MAXHYB),NUMHYB(MAXPAN),OUTOPT,PERM(MAXLOC)
     3,RETAIN(MAXPAN,MAXHYB,MAXLOC),SCROPT,SELNUM,SUBPRM(2,MAXLOC)
      REAL*4 BLIKE(MAXORD)
      REAL*8 ALPHA(MAXLOC,0:MAXCHR),ALPHAP(2,MAXLOC,0:MAXCHR,0:MAXCHR)
     1,BETA(MAXLOC,0:MAXCHR),BETAP(2,MAXLOC,0:MAXCHR)
     2,BINOM(0:MAXCHR,0:MAXCHR),CONDP(MAXHYB),DF(MAXPAR)
     3,DFHYB(MAXHYB,MAXPAR),DP(MAXPAR)
     4,DTRANS(MAXLOC,0:MAXCHR,0:MAXCHR,3),HPROB(MAXPAN,MAXHYB)
     5,NRET(MAXLOC),NTYPE(MAXLOC),PAR(MAXPAR),TRANS1(MAXLOC,0:1,0:1)
     6,TRANSP(MAXLOC,0:MAXCHR,0:MAXCHR)
C
C READ THE NUMBER OF LOCUS ORDERS AND THE FORMAT FOR READING THE
C LOCUS ORDERS.  CHECK THAT THE NUMBER OF LOCUS ORDERS IS NOT TOO
C LARGE.
C
      READ(KIN,101)NUMORD
 101  FORMAT(I4)
      IF(NUMORD.LE.MAXORD)GO TO 10
        WRITE(KOUT,102)NUMORD,MAXORD
 102      FORMAT(/' *** ERROR *** THE NUMBER OF ORDERS',I6,' IS',
     1    ' GREATER THAN THE MAXIMUM'/15X,'NUMBER OF ORDERS',I8,
     2    '.  INCREASE MAXORD.')
        STOP
C
   10 READ(KIN,103)FRMT
 103  FORMAT(A)
C
C READ EACH LOCUS ORDER AND CALCULATE ITS MAXIMUM LOG-LIKELIHOOD.
C STORE MINUS THIS VALUE IN BLIKE.  STORE THE LOCUS ORDER IN BPERM.
C
      DO 40 IORD=1,NUMORD
        READ(KIN,FRMT)(LNAMEL(LOCUS),LOCUS=1,NLOCUS)
        NERR=0
        CALL NAMIND(KOUT,LNAMEL,LNAME,NERR,NLOCUS,NLOCUS,PERM)
        IF(NERR.EQ.0)GO TO 20
          WRITE(KOUT,104)IORD,(LNAMEL(LOCUS),LOCUS=1,NLOCUS)
 104      FORMAT(' *** ERROR *** PROBLEM WITH LOCUS ORDER NUMBER',I4,
     1    ' WITH LOCUS NAMES:',100(/15X,10(1X,A4)))
C
   20     CALL MAXLIK(ALPHA,ALPHAP,BETA,BETAP,BINOM,BRLIST,CHECK,CONDP,
     1    CONV,DF,DFHYB,DP,DTRANS,EMSTEP,F,HPROB,ICONDS,KITER,KOUT,
     2    MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MLTOPT,MODEL,MXITER,NCHR,
     3    NCONV,NHYB,NLOCUS,NOBS,NPAN,NPAR,NRET,NTYPE,NUMHYB,OUTOPT,
     4    PAR,PERM,PNAME,RETAIN,SELNUM,SUBPRM,TOL,TRANS1,TRANSP)
C
        IF(SCROPT.EQ.2) WRITE(KTERMW,105)IORD,F/TENLOG,(PERM(LOCUS),
     1  LOCUS=1,NLOCUS)
 105    FORMAT(I6,F12.5,2X,15I3,66(/20X,15I3))
C
        BLIKE(IORD)=-F
        DO 30 LOCUS=1,NLOCUS
          BPERM(IORD,LOCUS)=PERM(LOCUS)
   30   CONTINUE
C
   40 CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE BRBND(ALPHA,ALPHAP,APERM,BBOPT,BESTLK,BETA,BETAP
     1,BINOM,BRLIST,BSTPRM,CHECK,CONDP,CONV,CPERM,DF,DFHYB,DP,DTRANS
     2,EMSTEP,HPROB,ICONDS,KIN,KITER,KOUT,KSCR1,KSCR2,KTERMW,KWRITE
     3,LNAME,LNAMEA,LNAMEC,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MLTOPT
     4,MODEL,MXITER,NCHR,NCONV,NHYB,NLOCUS,NOBS,NPAN,NPAR,NRET,NTYPE
     5,NUMHYB,NUMORD,NXTPRM,ORDOPT,OUTOPT,PAR,PERM,PNAME,PRTMAX,REMAIN
     6,RETAIN,SAVMAX,SCROPT,SELNUM,SUBPRM,TENLOG,TOL,TRANS1,TRANSP)
C
C USE STEPWISE LOCUS ORDERING (ORDOPT=2) OR BRANCH AND BOUND
C (ORDOPT=4) TO IDENTIFY THE MAXIMUM LIKELIHOOD LOCUS ORDERS.
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*4 LNAME(MAXLOC),LNAMEA(MAXLOC),LNAMEC(MAXLOC)
      CHARACTER*8 PNAME(MAXPAR)
      INTEGER APERM(MAXLOC),BBOPT,BRLIST(0:MAXLOC),BSTPRM(MAXLOC)
     1,CHECK(MAXPAN,MAXHYB),CPERM(MAXLOC),ENDLOC,NCHR(MAXPAN)
     1,NHYB(MAXPAN),NOBS(MAXPAN,MAXHYB),NUMHYB(MAXPAN),NXTPRM(MAXLOC)
     2,ORDOPT,OUTOPT,PERM(MAXLOC),REMAIN(MAXLOC)
     3,RETAIN(MAXPAN,MAXHYB,MAXLOC),SCROPT,SELNUM,SUBPRM(2,MAXLOC)
      REAL*8 ALPHA(MAXLOC,0:MAXCHR),ALPHAP(2,MAXLOC,0:MAXCHR,0:MAXCHR)
     1,BETA(MAXLOC,0:MAXCHR),BETAP(2,MAXLOC,0:MAXCHR)
     2,BINOM(0:MAXCHR,0:MAXCHR),CONDP(MAXHYB),DF(MAXPAR)
     3,DFHYB(MAXHYB,MAXPAR),DP(MAXPAR)
     4,DTRANS(MAXLOC,0:MAXCHR,0:MAXCHR,3),HPROB(MAXPAN,MAXHYB),NEXTLK
     5,NRET(MAXLOC),NTYPE(MAXLOC),PAR(MAXPAR),TRANS1(MAXLOC,0:1,0:1)
     6,TRANSP(MAXLOC,0:MAXCHR,0:MAXCHR)
C
C READ THE ADDITIONAL INFORMATION REQUIRED FOR THESE ORDERING OPTIONS.
C
      DO 10 LOCUS=1,NLOCUS
        APERM(LOCUS)=0
        REMAIN(LOCUS)=LOCUS
   10 CONTINUE
C
      CALL INBND(ADDMIN,APERM,BBOPT,CPERM,KIN,KOUT,LNAME,LNAMEA,LNAMEC
     1,NERR,NFORCE,NLOCUS,ORDOPT,PRTMAX,SAVMAX,TENLOG)
      IF(NERR.GT.0)GO TO 230
C
      ENDLOC=0
      IF(NFORCE.LT.0)ENDLOC=APERM(1)
C
C IF WE ARE DOING BRANCH AND BOUND, CALCULATE THE MAXIMUM LOG-LIKELIHOOD
C FOR THE CANDIDATE LOCUS ORDER.
C
      FCAND=0.D0
      IF(ORDOPT.EQ.4)CALL MAXLIK(ALPHA,ALPHAP,BETA,BETAP,BINOM,BRLIST
     1,CHECK,CONDP,CONV,DF,DFHYB,DP,DTRANS,EMSTEP,FCAND,HPROB,ICONDS
     2,KITER,KOUT,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MLTOPT,MODEL,MXITER
     3,NCHR,NCONV,NHYB,NLOCUS,NOBS,NPAN,NPAR,NRET,NTYPE,NUMHYB,OUTOPT
     4,PAR,CPERM,PNAME,RETAIN,SELNUM,SUBPRM,TOL,TRANS1,TRANSP)
C
      IF(SCROPT.GE.1.AND.ORDOPT.EQ.4)WRITE(KTERMW,101)FCAND/TENLOG
 101  FORMAT(' CANDIDATE ORDER LOG-LIKELIHOOD: ',F12.5)
C
C IF WE ARE FORCING LOCI INTO THE ORDER, DEAL WITH THEM AND GET
C SET FOR ADDING THE REMAINING LOCI.
C
      IF(IABS(NFORCE).LE.1)GO TO 30
        NUMORD=1
        NOLDOR=1
        BESTLK=0.D0
        OPEN(KSCR1,STATUS='SCRATCH')
        OPEN(KSCR2,STATUS='SCRATCH')
        DO 20 I=1,IABS(NFORCE)
          BSTPRM(I)=APERM(I)
          CALL REMOVE(NLOCUS-I+1,APERM(I),NLOCUS,REMAIN)
   20   CONTINUE
        WRITE(KSCR1,105)0.D0,(APERM(I),I=1,IABS(NFORCE))
        WRITE(KSCR2,105)0.D0,(APERM(I),I=1,IABS(NFORCE))
        IF(MODEL.EQ.1.OR.MODEL.EQ.4)GO TO 60
        NUMORD=2
        NOLDOR=2
        WRITE(KSCR1,105)0.D0,(APERM(I),I=IABS(NFORCE),1,-1)
        WRITE(KSCR2,105)0.D0,(APERM(I),I=IABS(NFORCE),1,-1)
        GO TO 60
C
C IF NOT, PUT THE FIRST THREE LOCI FOR LOCUS ADDING IN PERM.  IF WE ARE
C GENERATING THE ADDING ORDER, REMOVE THE THREE LOCI USED FROM REMAIN.
C
   30 PERM(1)=APERM(1)
      PERM(2)=APERM(2)
      PERM(3)=APERM(3)
      NPAR=NUMPAR(MLTOPT,MODEL,3,NPAN)
C
      IF(BBOPT.EQ.1)GO TO 50
        CALL BEST3(ALPHA,ALPHAP,BETA,BETAP,BINOM,BRLIST,CHECK,CONDP
     1  ,CONV,DF,DFHYB,DP,DTRANS,EMSTEP,ENDLOC,HPROB,ICONDS,KITER,KOUT
     2  ,KTERMW,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MLTOPT,MODEL
     3  ,MXITER,NCHR,NCONV,NHYB,NLOCUS,NOBS,NPAN,NPAR,NRET,NTYPE
     5  ,NUMHYB,OUTOPT,PAR,PERM,PNAME,RETAIN,SCROPT,SELNUM,SUBPRM,TOL
     6  ,TRANS1,TRANSP)
        DO 40 I=1,3
          CALL REMOVE(NLOCUS-I+1,PERM(I),NLOCUS,REMAIN)
          APERM(I)=PERM(I)
   40   CONTINUE
        IF(SCROPT.GE.1)WRITE(KTERMW,102)(LNAME(PERM(I)),I=1,3)
 102    FORMAT(' FIRST THREE LOCI IN PERMUTATION: ',3A6)
C
C CREATE A SCRATCH FILE WITH THE SUFFICIENTLY GOOD THREE-LOCUS ORDERS.
C
   50 OPEN(KSCR1,STATUS='SCRATCH')
      OPEN(KSCR2,STATUS='SCRATCH')
      CALL START3(ALPHA,ALPHAP,BETA,BETAP,BINOM,ADDMIN,BESTLK,BRLIST
     1,BSTPRM,CHECK,CONDP,CONV,DF,DFHYB,DP,DTRANS,EMSTEP,ENDLOC,FCAND
     2,HPROB,ICONDS,KITER,KOUT,KSCR1,KSCR2,MAXCHR,MAXHYB,MAXLOC,MAXPAN
     3,MAXPAR,MLTOPT,MODEL,MXITER,NCHR,NCONV,NGOOD3,NHYB,NLOCUS,NOBS
     4,NOLDOR,NPAN,NPAR,NRET,NTYPE,NUMHYB,ORDOPT,OUTOPT,PAR,PERM,PNAME
     5,RETAIN,SAVMAX,SELNUM,SUBPRM,TOL,TRANS1,TRANSP)
C
      IF(NGOOD3.EQ.1)GO TO 60
        BBOPT=-1
        WRITE(KOUT,103)ADDMIN/TENLOG
 103    FORMAT(/' *** ERROR *** NO THREE LOCI CAN BE ORDERED WITH',
     1  ' LOG-LIKELIHOOD'/15X,'DIFFERENCE BETWEEN THE TWO BEST LOCUS',
     2  ' ORDERS OF AT LEAST'/15X,F12.5,'.  TO RE-RUN, REDUCE ADDMIN.')
        GO TO 220
C
C FOR EACH REMAINING LOCUS ... (NOTE:  SET KWRITE AND NUMORD IN CASE
C NLOCUS=3 AND WE SKIP THE LOOP.)
C
   60 KWRITE=KSCR1
      NUMORD=NOLDOR
      IF(NLOCUS.EQ.3)GO TO 210
C
      LSTART=4
      IF(IABS(NFORCE).GT.3)LSTART=IABS(NFORCE)+1
      DO 200 LOCNEW=LSTART,NLOCUS
        NPAR=NUMPAR(MLTOPT,MODEL,LOCNEW,NPAN)
        LNEW1=LOCNEW-1
C
C SET THE CUTPOINT FOR SAVING LOCUS ORDERS.  FOR STEPWISE LOCUS ORDERING,
C THE CUTPOINT IS BASED ON THE BEST LOG-LIKELIHOOD FOR ADDING THE PREVIOUS
C LOCUS.  FOR BRANCH AND BOUND, IT IS BASED ON THE CANDIDATE LOCUS ORDER.
C
        FBEST=FCAND
        IF(ORDOPT.EQ.2)FBEST=BESTLK
        CUTPT=FBEST-SAVMAX
        IF(LOCNEW.EQ.NLOCUS.AND.ORDOPT.EQ.4)CUTPT=FBEST-PRTMAX
C
C REWIND THE SCRATCH UNIT WITH ORDERS OF LENGTH LOCNEW-1.  OPEN THE OTHER
C SCRATCH UNIT TO STORE ORDERS OF LENGTH LOCNEW.
C
        IF(LOCNEW/2*2.NE.LOCNEW)GO TO 70
          REWIND(KSCR1)
          CLOSE(KSCR2)
          OPEN(KSCR2,STATUS='SCRATCH')
          KREAD=KSCR1
          KWRITE=KSCR2
          GO TO 80
   70   REWIND(KSCR2)
        CLOSE(KSCR1)
        OPEN(KSCR1,STATUS='SCRATCH')
        KREAD=KSCR2
        KWRITE=KSCR1
C
C FIND THE NEXT LOCUS TO ADD TO THE LOCUS ORDER.
C
   80   NEWLOC=APERM(LOCNEW)
        IF(BBOPT.EQ.1)GO TO 90
          CALL NEXLOC(ALPHA,ALPHAP,BETA,BETAP,BINOM,BRLIST,BSTPRM
     1    ,CHECK,CONDP,CONV,DF,DFHYB,DP,DTRANS,EMSTEP,ENDLOC,HPROB
     2    ,ICONDS,KITER,KOUT,LOCNEW,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR
     3    ,MLTOPT,MODEL,MXITER,NCHR,NCONV,NHYB,NEWLOC,NLOCUS,NOBS,NPAN
     4    ,NPAR,NRET,NTYPE,NUMHYB,OUTOPT,PAR,PERM,PNAME,REMAIN,RETAIN
     5    ,SELNUM,SUBPRM,TOL,TRANS1,TRANSP)
          CALL REMOVE(NLOCUS-LOCNEW+1,NEWLOC,NLOCUS,REMAIN)
          APERM(LOCNEW)=NEWLOC
   90   IF(SCROPT.GE.1)WRITE(KTERMW,104)LOCNEW,LNAME(NEWLOC),NOLDOR
 104    FORMAT(' ADDING LOCUS NUMBER',I4,' NAMED ',A4,
     1  '.  NUMBER OF LOCUS ORDERS:',I8)
C
C FOR EACH LOCUS ORDER OF LENGTH LOCNEW-1 ...
C
        BESTLK=-1.D20
        NEXTLK=-1.D20
        NNEWOR=0
C
        DO 180 IOLDOR=1,NOLDOR
          READ(KREAD,105)F,(PERM(I),I=1,LNEW1)
 105      FORMAT(F15.9,10(100I3/))
C
C IF THIS IS STEPWISE LOCUS ORDERING, ONLY EXTEND THE CURRENT LOCUS
C ORDER IF IT IS SUFFICIENTLY CLOSE IN LOG-LIKELIHOOD TO THE BEST
C LOCUS ORDER.
C
          IF(ORDOPT.EQ.2.AND.-F.LT.CUTPT)GO TO 180
C
C ADD THE NEXT LOCUS AT ALL POSSIBLE POSITIONS IN THE OLD ORDER.
C
            PERM(LOCNEW)=NEWLOC
C
            LTOP=LOCNEW
            IF(ENDLOC.EQ.PERM(LNEW1))LTOP=LNEW1
            LBOT=1
            IF(ENDLOC.EQ.PERM(1))LBOT=2
            DO 170 LOC=LTOP,LBOT,-1
              IF(LOC.EQ.LOCNEW)GO TO 100
                ISAVE=PERM(LOC+1)
                PERM(LOC+1)=PERM(LOC)
                PERM(LOC)=ISAVE
C
C CALCULATE THE MAXIMUM LIKELIHOOD FOR THE RESULTING LOCUS ORDER.
C
  100           CALL MAXLIK(ALPHA,ALPHAP,BETA,BETAP,BINOM,BRLIST,CHECK,
     1          CONDP,CONV,DF,DFHYB,DP,DTRANS,EMSTEP,FNEW,HPROB,ICONDS,
     2          KITER,KOUT,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MLTOPT,
     3          MODEL,MXITER,NCHR,NCONV,NHYB,LOCNEW,NOBS,NPAN,NPAR,NRET,
     4          NTYPE,NUMHYB,OUTOPT,PAR,PERM,PNAME,RETAIN,SELNUM,SUBPRM,
     5          TOL,TRANS1,TRANSP)
                IF(SCROPT.EQ.2) WRITE(KTERMW,106)LOCNEW,NLOCUS,IOLDOR,
     1          NOLDOR,FNEW/TENLOG,(PERM(I),I=1,LOCNEW)
 
 106            FORMAT(2I4,2I6,F10.3,15I3,66(/30X,15I3))
C
C IF THE LOCUS ORDER IS GOOD ENOUGH, WRITE THE LOCUS ORDER TO THE SCRATCH
C FILE.  FOR BRANCH AND BOUND, GOOD ENOUGH MEANS CLOSE ENOUGH IN LOG-
C LIKELIHOOD TO THE CANDIDATE LOCUS ORDER.  FOR STEPWISE LOCUS ORDERING,
C GOOD ENOUGH MEANS CLOSE ENOUGH IN LOG-LIKELIHOOD TO THE CURRENT BEST
C LOCUS ORDER OF LENGTH LOCNEW.
C
              IF(FNEW.LT.CUTPT.AND.ORDOPT.EQ.4)GO TO 170
              IF(FNEW.LT.BESTLK-SAVMAX.AND.ORDOPT.EQ.2)GO TO 170
C
                WRITE(KWRITE,105)-FNEW,(PERM(I),I=1,LOCNEW)
                NNEWOR=NNEWOR+1
C
C IF THIS IS THE BEST ORDER OF LENGTH LOCNEW SO FAR, AND IF
C ORIENTATION MATTERS (MODEL=2,3), CHECK WHETHER THE ORDER IS THE
C REVERSE OF THE CURRENT BEST ORDER.
C
                IF(FNEW.LT.BESTLK-1.D-8)GO TO 150
                  IF(MODEL.EQ.1.OR.MODEL.EQ.4)GO TO 130
                    DO 110 I=1,LOCNEW
                      IF(PERM(I).NE.BSTPRM(LOCNEW+1-I))GO TO 130
  110               CONTINUE
C
C NEW ORDER IS BEST AND IS THE REVERSE OF THE CURRENT BEST ORDER.
C DELETE THE CURRENT BEST ORDER.  NEXT BEST ORDER REMAINS THE SAME.
C
                  BESTLK=FNEW
                  DO 120 I=1,LOCNEW
                    BSTPRM(I)=PERM(I)
  120             CONTINUE
                  GO TO 170
C
C NEW ORDER IS BEST AND IS NOT THE REVERSE OF THE CURRENT BEST.
C THE NEW ORDER IS NOW BEST, THE PREVIOUS BEST ORDER NEXT BEST.
C
  130             NEXTLK=BESTLK
                  BESTLK=FNEW
                  DO 140 I=1,LOCNEW
                    NXTPRM(I)=BSTPRM(I)
                    BSTPRM(I)=PERM(I)
  140             CONTINUE
                  GO TO 170
C
C IF THE NEW ORDER IS BETTER THAN THE CURRENT NEXT BEST ORDER, REPLACE
C THE CURRENT NEXT BEST ORDER.
C
  150          IF(FNEW.LT.NEXTLK-1.D-8)GO TO 170
                 NEXTLK=FNEW
                 DO 160 I=1,LOCNEW
                   NXTPRM(I)=PERM(I)
  160            CONTINUE
  170       CONTINUE
  180   CONTINUE
C
C IF THE TWO BEST ORDERS ENCOUNTERED SO FAR ARE TOO CLOSE IN
C LOG-LIKELIHOOD, PRINT THE PARTIAL LOCUS ORDERS AND GO TO
C THE NEXT PROBLEM.  THIS REQUIRES GETTING EVERYTHING SET UP FOR
C OUTORD.
C
        IF(BESTLK-NEXTLK.GE.ADDMIN-1.D-5)GO TO 190
C
          NUMORD=NOLDOR
          BBOPT=-(LOCNEW-1)
          CLOSE(KWRITE)
          KWRITE=KREAD
          ENDFILE(KWRITE)
C
          WRITE(KOUT,107)ADDMIN/TENLOG,LNAME(NEWLOC),(LNAME
     1    (BSTPRM(I)),I=1,LOCNEW)
 107      FORMAT(/' NOTE:  IT WAS NOT POSSIBLE TO ORDER ALL LOCI WITH',
     1    ' MINIMUM SUPPORT FOR'/' THE BEST LOCUS ORDER OF AT LEAST ',
     2    F12.5,' LOG10 UNITS.  IN THE LOCUS'/' ORDER THAT FOLLOWS,',
     3    ' ALL LOCI EXCEPT ',A6,' WERE WELL ORDERED WITH THAT'/
     4    ' LEVEL OF SUPPORT:'/70(/15A5))
          GO TO 220
C
  190   NOLDOR=NNEWOR
        ENDFILE(KWRITE)
  200 CONTINUE
C
      NUMORD=NNEWOR
C
C IF THE MACHINE GENERATED THE LOCUS ADDING ORDER, PRINT IT OUT.
C
  210 IF(BBOPT.EQ.0)WRITE(KOUT,108)(LNAME(APERM(I)),I=1,NLOCUS)
 108  FORMAT(/' ORDER FOR ADDING LOCI:  ',10A5,100(/25X,10A5))
C
C CLOSE THE LAST READ SCRATCH FILE.
C
  220 CLOSE(KSCR1+KSCR2-KWRITE)
C
  230 RETURN
      END
C
C
C
      SUBROUTINE INBND(ADDMIN,APERM,BBOPT,CPERM,KIN,KOUT,LNAME,LNAMEA
     1,LNAMEC,NERR,NFORCE,NLOCUS,ORDOPT,PRTMAX,SAVMAX,TENLOG)
C
C READ THE ADDITIONAL INFORMATION REQUIRED FOR STEPWISE LOCUS ORDERING
C AND BRANCH AND BOUND.
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*4 LNAME(NLOCUS),LNAMEA(NLOCUS),LNAMEC(NLOCUS)
      INTEGER APERM(NLOCUS),BBOPT,CPERM(NLOCUS),ORDOPT
C
C READ AND CHECK BBOPT (=1 IF USER-SPECIFIED ADDING ORDER, =0
C IF ADDING ORDER BASED ON BEST3 AND NEXLOC), THE MINIMUM LOG-LIKELIHOOD
C DIFFERENCE TO ADD THE NEXT LOCUS ADDMIN, THE MAXIMUM LOG-LIKELIHOOD
C DIFFERENCE IN COMPARISON TO THE CURRENT BEST (PARTIAL) LOCUS ORDER TO
C SAVE AN ORDER SAVMAX, THE MAXIMUM LOG-LIKELIHOOD DIFFERENCE FOR
C PRINTING AN ORDER PRTMAX, AND THE NUMBER OF LOCI TO BE FORCED IN ORDER
C NFORCE.
C
      NERR=0
      READ(KIN,101)BBOPT,ADDMIN,SAVMAX,PRTMAX,NFORCE
 101  FORMAT(I4,3F8.3,I4)
C
      IF(BBOPT.EQ.0.OR.BBOPT.EQ.1)GO TO 10
        WRITE(KOUT,102)BBOPT
 102    FORMAT(/' *** ERROR *** LOCUS ADDING OPTION VARIABLE BBOPT MUST'
     1  ,' BE ONE'/15X,'(USER-SPECIFIED ORDER) OR ZERO (MACHINE-',
     2  'DETERMINED ORDER).'/15X,'IT IS ',I4,'.')
        NERR=NERR+1
C
   10 IF(ADDMIN.GE.-1.D-8)GO TO 20
        WRITE(KOUT,103)ADDMIN
 103    FORMAT(/' *** ERROR *** THE MINIMUM DIFFERENCE FOR ADDING THE',
     1  ' NEXT LOCUS ORDER'/15X,'ADDMIN MUST BE NON-NEGATIVE.  IT IS ',
     2  F12.5,'.')
        NERR=NERR+1
C
   20 IF(ADDMIN.LE.1.D-8)ADDMIN=0.D0
C
      IF(SAVMAX.GE.-1.D-8)GO TO 30
        WRITE(KOUT,104)SAVMAX
 104    FORMAT(/' *** ERROR *** THE MAXIMUM DIFFERENCE FOR SAVING THE',
     1  ' CURRENT PARTIAL'/15X,'LOCUS ORDER SAVMAX MUST BE POSITIVE.',
     2  '  IT IS ',F12.5,'.')
        NERR=NERR+1
C
   30 IF(PRTMAX.GE.-1.D-8.AND.PRTMAX.LE.SAVMAX)GO TO 40
        WRITE(KOUT,105)PRTMAX,SAVMAX
 105    FORMAT(/' *** ERROR *** THE MAXIMUM DIFFERENCE FOR PRINTING A'
     1  ,' LOCUS ORDER PRTMAX'/15X,'MUST BE POSITIVE AND SHOULD BE LESS'
     2  ,' THAN THE MAXIMUM'/15X,'DIFFERENCE FOR SAVING A PARTIAL LOCUS'
     3  ,' ORDER SAVMAX.'/15X,'PRTMAX IS',F13.5,'; SAVMAX IS',F13.5,'.')
        NERR=NERR+1
C
   40 IF(NFORCE.EQ.0.OR.NFORCE.EQ.-1.OR. (IABS(NFORCE).GT.2.AND.IABS
     +(NFORCE).LT.NLOCUS.AND.NLOCUS.GE.4)) GO TO 50
 
        WRITE(KOUT,106)NFORCE,NLOCUS
 106    FORMAT(/' *** ERROR *** THE NUMBER OF LOCI TO BE FORCED IN',I4,
     1  ' MUST BE ZERO, -1'/15X,'(FORCED ENDPOINT), OR (IN ABSOLUTE',
     2  ' VALUE) BETWEEN 3 AND'/15X,'ONE LESS THAN THE NUMBER OF LOCI',
     3  ' IN THE PROBLEM',I4/15X,'WHICH MUST BE AT LEAST 4 IN THIS',
     4  ' CASE.  NEGATIVE NUMBERS'/15X,'HERE IMPLY THE FIRST FORCED',
     5  ' LOCUS MUST BE AT AN END OF'/15X,'THE MAP.')
        NERR=NERR+1
C
C IF WE ARE DOING BRANCH AND BOUND, READ THE CANDIDATE LOCUS ORDER.
C CHECK AND TRANSLATE THE LOCUS NAMES TO A PERMUTATION.
C
   50 IF(ORDOPT.EQ.4)READ(KIN,107)(LNAMEC(I),I=1,NLOCUS)
 107  FORMAT(20A4)
      IF(ORDOPT.EQ.4)CALL NAMIND(KOUT,LNAMEC,LNAME,NERR
     1,NLOCUS,NLOCUS,CPERM)
C
C IF BBOPT=1 OR NFORCE NE 0, READ THE LOCUS ADDING ORDER.  CHECK AND
C TRANSLATE THE LOCUS NAMES TO A PERMUTATION.
C
      IF(BBOPT.EQ.0.AND.NFORCE.EQ.0)GO TO 90
        LTOP=NLOCUS
        IF(BBOPT.EQ.0)LTOP=IABS(NFORCE)
        READ(KIN,107)(LNAMEA(I),I=1,LTOP)
        CALL NAMIND(KOUT,LNAMEA,LNAME,NERR,NLOCUS,LTOP,APERM)
C
C IF THERE IS A FORCED END LOCUS (NFORCE<0) AND A CANDIDATE ORDER,
C CHECK THAT THE CANDIDATE ORDER HAS THE FORCED END LOCUS AT AN END.
C
        IF(ORDOPT.NE.4.OR.NFORCE.EQ.0)GO TO 90
          IF(NFORCE.GE.0)GO TO 60
            IF(APERM(1).EQ.CPERM(1).OR.APERM(1).EQ.CPERM(NLOCUS))
     1      GO TO 60
            WRITE(KOUT,108)
 108        FORMAT(' *** ERROR *** THE CANDIDATE LOCUS ORDER DOES NOT',
     1      ' HAVE THE FORCED END'/15X,'LOCUS AT THE END OF THE MAP.')
            NERR=NERR+1
C
C IF THERE IS A FORCED SUBORDER (NFORCE>2) AND A CANDIDATE ORDER, CHECK
C THAT THEY ARE COMPATIBLE.  NOTE:  TRY BOTH ORIENTATIONS.
C
   60     IF(IABS(NFORCE).LE.1)GO TO 90
            LOCUSA=1
            DO 70 LOCUSC=1,NLOCUS
              IF(CPERM(LOCUSC).NE.APERM(LOCUSA))GO TO 70
                LOCUSA=LOCUSA+1
                IF(LOCUSA.GT.LTOP)GO TO 90
   70       CONTINUE
C
            LOCUSA=1
            DO 80 LOCUSC=NLOCUS,1,-1
              IF(CPERM(LOCUSC).NE.APERM(LOCUSA))GO TO 80
                LOCUSA=LOCUSA+1
                IF(LOCUSA.GT.LTOP)GO TO 90
   80       CONTINUE
C
            WRITE(KOUT,109)
 109        FORMAT(' *** ERROR *** THE CANDIDATE LOCUS ORDER AND THE',
     1      ' FORCED SUBORDER ARE'/15X,'NOT CONSISTENT.')
            NERR=NERR+1
C
C OUTPUT THE BRANCH AND BOUND OPTIONS.
C
   90 IF(ORDOPT.EQ.2)WRITE(KOUT,111)
 111  FORMAT(//' STEPWISE LOCUS ORDERING OPTIONS')
      IF(ORDOPT.EQ.4)WRITE(KOUT,112)
 112  FORMAT(//' BRANCH AND BOUND ORDERING OPTIONS')
      WRITE(KOUT,113)SAVMAX,PRTMAX,ADDMIN
 113  FORMAT(/' MAXIMUM LOG10-L DIFFERENCE TO SAVE ORDER: ',F12. 5/
     1' MAXIMUM LOG10-L DIFFERENCE TO PRINT ORDER:',F12. 5/
     2' MINIMUM LOG10-L SUPPORT TO ADD LOCUS:     ',F12.5)
      IF(ORDOPT.EQ.4)WRITE(KOUT,114)(LNAMEC(I),I=1,NLOCUS)
 114  FORMAT(/' CANDIDATE LOCUS ORDER:  ',10A5,100(/25X,10A5))
      IF(BBOPT.EQ.1)WRITE(KOUT,115)(LNAMEA(I),I=1,NLOCUS)
 115  FORMAT(/' ORDER FOR ADDING LOCI:  ',10A5,100(/25X,10A5))
      IF(NFORCE.NE.0)WRITE(KOUT,116)(LNAMEA(I),I=1,IABS(NFORCE))
 116  FORMAT(/' ORDER FOR FORCED LOCI:  ',10A5,100(/25X,10A5))
      IF(NFORCE.LT.0)WRITE(KOUT,117)LNAMEA(1)
 117  FORMAT(' FIRST LOCUS ',A4,' IN THIS ORDER IS FORCED TO',
     1' BE AT AN END OF THE MAP.')
C
C RESCALE SAVMAX, PRTMAX, AND ADDMIN TO BE SCALED AS LOGARITHM BASE E
C RATHER THAN LOGARITHM BASE 10.
C
      SAVMAX=SAVMAX*TENLOG
      PRTMAX=PRTMAX*TENLOG
      ADDMIN=ADDMIN*TENLOG
C
      RETURN
      END
C
C
C
      SUBROUTINE BEST3(ALPHA,ALPHAP,BETA,BETAP,BINOM,BRLIST,CHECK
     1,CONDP,CONV,DF,DFHYB,DP,DTRANS,EMSTEP,ENDLOC,HPROB,ICONDS,KITER
     2,KOUT,KTERMW,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MLTOPT,MODEL
     3,MXITER,NCHR,NCONV,NHYB,NLOCUS,NOBS,NPAN,NPAR,NRET,NTYPE,NUMHYB
     4,OUTOPT,PAR,PERM,PNAME,RETAIN,SCROPT,SELNUM,SUBPRM,TOL,TRANS1
     5,TRANSP)
C
C FIND THE THREE MOST CLEARLY ORDERED LOCI IN THE SENSE THAT THE
C DIFFERENCE IN MAXIMUM LIKELIHOODS FOR THE BEST AND SECOND BEST ORDERS
C IS GREATEST.  USE THE CHOSEN MODEL UNLESS IT IS THE GENERAL
C RETENTION PROBABILITY MODEL.  IN THAT CASE, USE THE EQUAL RETENTION
C PROBABILITY MODEL.
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*8 PNAME(MAXPAR)
      INTEGER BRLIST(0:MAXLOC),CHECK(MAXPAN,MAXHYB),ENDLOC,FPERM(3)
     1,INDEX(3),NCHR(MAXPAN),NHYB(MAXPAN),NUMHYB(MAXPAN)
     1,NOBS(MAXPAN,MAXHYB),OUTOPT,PERM(MAXLOC)
     2,RETAIN(MAXPAN,MAXHYB,MAXLOC),RPERM(3),SCROPT,SELNUM
     3,SUBPRM(2,MAXLOC)
      LOGICAL NMOD23
      REAL*8 ALPHA(MAXLOC,0:MAXCHR),ALPHAP(2,MAXLOC,0:MAXCHR,0:MAXCHR)
     1,BETA(MAXLOC,0:MAXCHR),BETAP(2,MAXLOC,0:MAXCHR)
     1,BINOM(0:MAXCHR,0:MAXCHR),CONDP(MAXHYB),DF(MAXPAR)
     2,DFHYB(MAXHYB,MAXPAR),DP(MAXPAR)
     3,DTRANS(MAXLOC,0:MAXCHR,0:MAXCHR,3),HPROB(MAXPAN,MAXHYB)
     4,NRET(MAXLOC),NTYPE(MAXLOC),PAR(MAXPAR),TRANS1(MAXLOC,0:1,0:1)
     5,TRANSP(MAXLOC,0:MAXCHR,0:MAXCHR)
C
      NMOD23=.TRUE.
      IF(MODEL.EQ.2.OR.MODEL.EQ.3)NMOD23=.FALSE.
      MOD123=MODEL
      IF(MODEL.EQ.4)MOD123=1
      DMAX=-1.D0
      NLOC2=NLOCUS-2
      NLOC1=NLOCUS-1
C
C OUTPUT THE HEADER FOR THE SETS OF WELL-ORDERED LOCUS TRIOS.
C
C FOR EACH DISTINCT TRIO OF LOCI ...
C
      DO 60 LOCUS1=1,NLOC2
        IF(SCROPT.EQ.2)WRITE(KTERMW,101)LOCUS1
 101    FORMAT(' CHOOSING BEST THREE LOCI.  FIRST LOCUS IS ',I5,'.')
        DO 50 LOCUS2=LOCUS1+1,NLOC1
          DO 40 LOCUS3=LOCUS2+1,NLOCUS
C
C IF WE HAVE A SELECTED LOCUS MODEL, IGNORE THE LOCUS SET IF IT DOES NOT
C CONTAIN THE SELECTED LOCUS:
C
          IF((MODEL.GE.5.OR.ICONDS.EQ.1).AND.LOCUS1.NE.SELNUM.AND.
     1    LOCUS2.NE.SELNUM.AND.LOCUS3.NE.SELNUM)GO TO 40
C
C CONSIDER EACH PERMUTATION OF THESE LOCI SATISFYING PERM(3) < PERM(1).
C
          PERM(1)=LOCUS1
          PERM(2)=LOCUS2
          PERM(3)=LOCUS3
C
C CALCULATE THE MAXIMUM LIKELIHOOD.  IF THE MODEL HAS AN ORIENTATION
C ALONG THE CHROMOSOME, DO THE LOCUS ORDERS IN INVERTED PAIRS.
C
          FSUM=0.D0
          FMIN=1.D20
          FMAX=-1.D20
C
          NPERM=0
          DO 20 IPERM=1,3
C
C INDEX=(1,2,3),(1,3,2),(2,1,3) AS IPERM=1,2,3.
C
            INDEX(1)=IPERM/3+1
            INDEX(2)=IPERM*(11-3*IPERM)/2-2
            INDEX(3)=(IPERM-2)**2+2
            IF(ENDLOC.EQ.PERM(INDEX(2)))GO TO 20
C
C EVALUATE THE LOG-LIKELIHOOD FOR THE FORWARD PERMUTATION.
C
            NPERM=NPERM+1
            FPERM(1)=PERM(INDEX(1))
            FPERM(2)=PERM(INDEX(2))
            FPERM(3)=PERM(INDEX(3))
            CALL MAXLIK(ALPHA,ALPHAP,BETA,BETAP,BINOM,BRLIST,CHECK
     1      ,CONDP,CONV,DF,DFHYB,DP,DTRANS,EMSTEP,F,HPROB,ICONDS,KITER
     2      ,KOUT,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MLTOPT,MOD123
     3      ,MXITER,NCHR,NCONV,NHYB,3,NOBS,NPAN,NPAR,NRET,NTYPE,NUMHYB
     4      ,OUTOPT,PAR,FPERM,PNAME,RETAIN,SELNUM,SUBPRM,TOL,TRANS1
     5      ,TRANSP)
C
C IF THERE IS ORIENTATION ALONG THE CHROMOSOME, EVALUATE THE LOG-
C LIKELIHOOD FOR THE REVERSE PERMUTATION.
C
            IF(NMOD23)GO TO 10
              RPERM(1)=FPERM(3)
              RPERM(2)=FPERM(2)
              RPERM(3)=FPERM(1)
              CALL MAXLIK(ALPHA,ALPHAP,BETA,BETAP,BINOM,BRLIST,CHECK
     1        ,CONDP,CONV,DF,DFHYB,DP,DTRANS,EMSTEP,FR,HPROB,ICONDS
     2        ,KITER,KOUT,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MLTOPT
     3        ,MOD123,MXITER,NCHR,NCONV,NHYB,3,NOBS,NPAN,NPAR,NRET
     4        ,NTYPE,NUMHYB,OUTOPT,PAR,RPERM,PNAME,RETAIN,SELNUM
     5        ,SUBPRM,TOL,TRANS1,TRANSP)
              IF(FR.GT.F)F=FR
C
C UPDATE THE SUM AND THE MAXIMUM AND MINIMUM.
C
   10       FSUM=FSUM+F
            IF(F.LT.FMIN)FMIN=F
            IF(F.GT.FMAX)FMAX=F
   20     CONTINUE
C
C CALCULATE THE DIFFERENCE IN LOG-LIKELIHOODS FOR THE BEST AND NEXT
C BEST ORDERS.
C
          FMID=FSUM-FMAX-FMIN
          DIFF12=FMAX-FMID
          IF(NPERM.EQ.2)DIFF12=FMAX-FMIN
C
C IS THIS TRIO BETTER THAN THE CURRENT BEST?
C
   30     IF(DIFF12.LT.DMAX)GO TO 40
            DMAX=DIFF12
            LOC1=LOCUS1
            LOC2=LOCUS2
            LOC3=LOCUS3
   40     CONTINUE
   50   CONTINUE
   60 CONTINUE
C
      PERM(1)=LOC1
      PERM(2)=LOC2
      PERM(3)=LOC3
C
      RETURN
      END
C
C
C
      SUBROUTINE START3(ALPHA,ALPHAP,BETA,BETAP,BINOM,ADDMIN,BESTLK
     1,BRLIST,BSTPRM,CHECK,CONDP,CONV,DF,DFHYB,DP,DTRANS,EMSTEP,ENDLOC
     2,FCAND,HPROB,ICONDS,KITER,KOUT,KSCR1,KSCR2,MAXCHR,MAXHYB,MAXLOC
     3,MAXPAN,MAXPAR,MLTOPT,MODEL,MXITER,NCHR,NCONV,NGOOD3,NHYB,NLOCUS
     4,NOBS,NOLDOR,NPAN,NPAR,NRET,NTYPE,NUMHYB,ORDOPT,OUTOPT,PAR,PERM
     5,PNAME,RETAIN,SAVMAX,SELNUM,SUBPRM,TOL,TRANS1,TRANSP)
C
C PUT THE CANDIDATE THREE-LOCUS ORDERS IN THE SCRATCH FILE.  NOTE
C WHICH THREE-LOCUS ORDER IS BEST.
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*8 PNAME(MAXPAR)
      INTEGER BRLIST(0:MAXLOC),BSTPRM(MAXLOC),CHECK(MAXHYB),ENDLOC
     1,FPERM(3),INDEX(3),NOBS(MAXPAN,MAXHYB),ORDOPT,OUTOPT,PERM(MAXLOC)
     2,RETAIN(MAXPAN,MAXHYB,MAXLOC),SELNUM,SUBPRM(2,MAXLOC)
     3,NHYB(MAXPAN),NUMHYB(MAXPAN),NCHR(MAXPAN)
      REAL*8 ALPHA(MAXLOC,0:MAXCHR),ALPHAP(2,MAXLOC,0:MAXCHR,0:MAXCHR)
     1,BETA(MAXLOC,0:MAXCHR),BETAP(2,MAXLOC,0:MAXCHR)
     1,BINOM(0:MAXCHR,0:MAXCHR),CONDP(MAXHYB),DF(MAXPAR)
     2,DFHYB(MAXHYB,MAXPAR),DP(MAXPAR)
     3,DTRANS(MAXLOC,0:MAXCHR,0:MAXCHR,3),HPROB(MAXPAN,MAXHYB)
     4,NRET(MAXLOC),NTYPE(MAXLOC),PAR(MAXPAR),TRANS1(MAXLOC,0:1,0:1)
     5,TRANSP(MAXLOC,0:MAXCHR,0:MAXCHR)
C
C IF THE GENERAL MODEL IS TO BE USED, STORE ALL ORDERS WITH THE SAME
C (DUMMY) LOG-LIKELIHOOD; ARBITRARILY SET THE BEST PERMUTATION.
C
      IF(MODEL.NE.4)GO TO 40
        BSTPRM(1)=PERM(1)
        BSTPRM(2)=PERM(2)
        BSTPRM(3)=PERM(3)
        NGOOD3=1
        NOLDOR=0
        IF(ENDLOC.EQ.PERM(2))GO TO 10
          WRITE(KSCR1,101)0.D0,PERM(1),PERM(2),PERM(3)
          NOLDOR=NOLDOR+1
          BSTPRM(2)=PERM(3)
          BSTPRM(3)=PERM(2)
   10   IF(ENDLOC.EQ.PERM(3))GO TO 20
          WRITE(KSCR1,101)0.D0,PERM(1),PERM(3),PERM(2)
          NOLDOR=NOLDOR+1
   20   IF(ENDLOC.EQ.PERM(1))GO TO 30
          WRITE(KSCR1,101)0.D0,PERM(2),PERM(1),PERM(3)
          NOLDOR=3
   30   GO TO 100
C
C CALCULATE THE MAXIMUM LIKELIHOOD FOR EACH LOCUS ORDER.  IF THERE IS
C NO ORIENTATION ALONG THE CHROMOSOME (MODEL=1,5,6,7), SKIP ORDERS WITH
C PERM(1) > PERM(3).  SAVE THE ORDERS AND THEIR MAXIMUM LIKELIHOODS
C IN THE SECOND SCRATCH UNIT.
C
   40 BESTLK=-1.D20
      NOR=1
      IF(MODEL.EQ.2.OR.MODEL.EQ.3)NOR=2
C
      NPERM=0
      DO 60 IPERM=1,3
C
C INDEX=(1,2,3),(1,3,2),(2,1,3) AS IPERM=1,2,3.
C
        INDEX(1)=IPERM/3+1
        INDEX(2)=IPERM*(11-3*IPERM)/2-2
        INDEX(3)=(IPERM-2)**2+2
        IF(ENDLOC.EQ.PERM(INDEX(2)))GO TO 60
C
C WHEN IOR=1, WE USE INDEX(1), INDEX(2), INDEX(3).  WHEN IOR=2, WE USE
C INDEX(3), INDEX(2), INDEX(1).
C 
        NPERM=NPERM+1
        DO 50 IOR=1,NOR
          FPERM(1)=PERM(INDEX(2*IOR-1))
          FPERM(2)=PERM(INDEX(2))
          FPERM(3)=PERM(INDEX(5-2*IOR))
C
          CALL MAXLIK(ALPHA,ALPHAP,BETA,BETAP,BINOM,BRLIST,CHECK,CONDP
     1    ,CONV,DF,DFHYB,DP,DTRANS,EMSTEP,F,HPROB,ICONDS,KITER,KOUT
     2    ,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MLTOPT,MODEL,MXITER,NCHR
     3    ,NCONV,NHYB,3,NOBS,NPAN,NPAR,NRET,NTYPE,NUMHYB,OUTOPT,PAR
     4    ,FPERM,PNAME,RETAIN,SELNUM,SUBPRM,TOL,TRANS1,TRANSP)
C
          IF(F.GT.BESTLK)BESTLK=F
          WRITE(KSCR2,101)-F,(FPERM(I),I=1,3)
 101      FORMAT(F15.9,3I3)
   50   CONTINUE
   60 CONTINUE
C
C SAVE THE LOCUS ORDERS THAT ARE GOOD ENOUGH IN THE FIRST
C SCRATCH UNIT.  ALSO FIND THE BEST THREE-LOCUS PERMUTATION
C AND COUNT THE NUMBER OF LOCUS ORDERS WITHIN ADDMIN OF THE
C BEST LOCUS ORDER.  FOR THE LATTER, CONSIDER ONLY ONE
C ORIENTATION ALONG THE CHROMOSOME.
C
      ENDFILE(KSCR2)
      REWIND(KSCR2)
C
      CUTPT=FCAND-SAVMAX
      IF(ORDOPT.EQ.2)CUTPT=BESTLK-SAVMAX
C
C NGOOD3 IS THE NUMBER OF ORDERS WITHIN ADDMIN OF THE BEST ORDER.
C REVERSE ORDERS DO NOT COUNT IN THIS TOTAL IF MODEL=2,3.  NOLDOR
C IS THE NUMBER OF ORDERS KEPT UNDER CONSIDERATION.
C
      NGOOD3=0
      NOLDOR=0
      NOR=1
      IF(MODEL.EQ.2.OR.MODEL.EQ.3)NOR=2
C
      DO 90 IORD=1,NPERM
        FMAX=-1.D20
        DO 80 IOR=1,NOR
          READ(KSCR2,101)F,(PERM(I),I=1,3)
          IF(-F.GT.FMAX)FMAX=-F
          IF(-F.LT.CUTPT)GO TO 80
            WRITE(KSCR1,101)F,(PERM(I),I=1,3)
            NOLDOR=NOLDOR+1
   70       IF(-F.LT.BESTLK-1.D-8)GO TO 80
              BSTPRM(1)=PERM(1)
              BSTPRM(2)=PERM(2)
              BSTPRM(3)=PERM(3)
   80   CONTINUE
        IF(FMAX.GE.BESTLK-ADDMIN-1.D-5)NGOOD3=NGOOD3+1
   90 CONTINUE
C
  100 ENDFILE(KSCR1)
      RETURN
      END
C
C
C
      SUBROUTINE NEXLOC(ALPHA,ALPHAP,BETA,BETAP,BINOM,BRLIST,BSTPRM
     1,CHECK,CONDP,CONV,DF,DFHYB,DP,DTRANS,EMSTEP,ENDLOC,HPROB,ICONDS
     2,KITER,KOUT,LOCNEW,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MLTOPT
     3,MODEL,MXITER,NCHR,NCONV,NHYB,NEWLOC,NLOCUS,NOBS,NPAN,NPAR,NRET
     4,NTYPE,NUMHYB,OUTOPT,PAR,PERM,PNAME,REMAIN,RETAIN,SELNUM,SUBPRM
     5,TOL,TRANS1,TRANSP)
C
C DETERMINE WHICH UNPLACED LOCUS IS MOST CLEARLY PLACED IN THE
C CURRENT BEST PARTIAL LOCUS ORDER.
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*8 PNAME(MAXPAR)
      INTEGER BRLIST(0:MAXLOC),BSTPRM(MAXLOC),CHECK(MAXHYB),ENDLOC
     1,NCHR(MAXPAN),NOBS(MAXPAN,MAXHYB),OUTOPT,PERM(MAXLOC)
     2,REMAIN(MAXLOC),RETAIN(MAXPAN,MAXHYB,MAXLOC),NHYB(MAXPAN)
     3,NUMHYB(MAXPAN),SELNUM,SUBPRM(2,MAXLOC)
      REAL*8 ALPHA(MAXLOC,0:MAXCHR),ALPHAP(2,MAXLOC,0:MAXCHR,0:MAXCHR)
     1,BETA(MAXLOC,0:MAXCHR),BETAP(2,MAXLOC,0:MAXCHR)
     1,BINOM(0:MAXCHR,0:MAXCHR),CONDP(MAXHYB),DF(MAXPAR)
     2,DFHYB(MAXHYB,MAXPAR),DP(MAXPAR)
     3,DTRANS(MAXLOC,0:MAXCHR,0:MAXCHR,3),HPROB(MAXPAN,MAXHYB)
     4,LIKE1,LIKE2,NRET(MAXLOC),NTYPE(MAXLOC),PAR(MAXPAR)
     5,TRANS1(MAXLOC,0:1,0:1),TRANSP(MAXLOC,0:MAXCHR,0:MAXCHR)
C
C FOR EACH POSSIBLE LOCUS TO BE ADDED ...
C
      DMAX=-1.D0
      NL1=NLOCUS-LOCNEW+1
      LOCN1=LOCNEW-1
C
      DO 40 L=1,NL1
        LOCADD=REMAIN(L)
C
C ADD THE LOCUS TO THE END OF BSTPRM.  EVALUATE THE RESULTING ORDER.
C
        DO 10 I=1,LOCN1
          PERM(I)=BSTPRM(I)
   10   CONTINUE
        PERM(LOCNEW)=LOCADD
C
        LIKE2=-1.D20
        IF(ENDLOC.NE.PERM(LOCN1))
     1  CALL MAXLIK(ALPHA,ALPHAP,BETA,BETAP,BINOM,BRLIST,CHECK,CONDP
     2  ,CONV,DF,DFHYB,DP,DTRANS,EMSTEP,LIKE1,HPROB,ICONDS,KITER,KOUT
     3  ,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MLTOPT,MODEL,MXITER,NCHR
     4  ,NCONV,NHYB,LOCNEW,NOBS,NPAN,NPAR,NRET,NTYPE,NUMHYB,OUTOPT,PAR
     5  ,PERM,PNAME,RETAIN,SELNUM,SUBPRM,TOL,TRANS1,TRANSP)
C
C FOR ALL OTHER POSSIBLE LOCATIONS, EVALUATE THE RESULTING ORDER.
C
        LBOT=2
        IF(ENDLOC.EQ.PERM(1))LBOT=3
        DO 30 LOC=LOCNEW,LBOT,-1
          ISAVE=PERM(LOC)
          PERM(LOC)=PERM(LOC-1)
          PERM(LOC-1)=ISAVE
          CALL MAXLIK(ALPHA,ALPHAP,BETA,BETAP,BINOM,BRLIST,CHECK,CONDP
     1    ,CONV,DF,DFHYB,DP,DTRANS,EMSTEP,FNEW,HPROB,ICONDS,KITER,KOUT
     2    ,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MLTOPT,MODEL,MXITER,NCHR
     3    ,NCONV,NHYB,LOCNEW,NOBS,NPAN,NPAR,NRET,NTYPE,NUMHYB,OUTOPT
     4    ,PAR,PERM,PNAME,RETAIN,SELNUM,SUBPRM,TOL,TRANS1,TRANSP)
          IF(FNEW.LT.LIKE2)GO TO 30
            IF(FNEW.LT.LIKE1)GO TO 20
              LIKE2=LIKE1
              LIKE1=FNEW
              GO TO 30
   20       LIKE2=FNEW
   30   CONTINUE
        DIFF=LIKE1-LIKE2
        IF(DIFF.LT.DMAX)GO TO 40
          DMAX=DIFF
          NEWLOC=LOCADD
   40 CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE REMOVE(LENGTH,LOCUS,NLOCUS,REMAIN)
C
C REMOVE LOCUS FROM REMAIN.
C
      IMPLICIT REAL*8(A-H,O-Z)
      INTEGER REMAIN(NLOCUS)
C
      DO 10 I=1,LENGTH
        IF(REMAIN(I).EQ.LOCUS)GO TO 20
   10 CONTINUE
C
   20 DO 30 J=I+1,LENGTH
        REMAIN(J-1)=REMAIN(J)
   30 CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE ANNEAL(ALPHA,ALPHAP,BETA,BETAP,BINOM,BLIKE,BPERM
     1,BRLIST,CHECK,CONDP,CONV,DF,DFHYB,DP,DTRANS,EMSTEP,HPROB,ICONDS
     2,KIN,KITER,KOUT,KTERMW,LNAME,LNAMEA,MAXCHR,MAXHYB,MAXLOC,MAXORD
     3,MAXPAN,MAXPAR,MLTOPT,MODEL,MXITER,NCHR,NCONV,NHYB,NLOCUS,NOBS
     4,NPAN,NPAR,NRET,NTYPE,NUMHYB,NUMORD,OUTOPT,PAR,PERM,PNAME
     5,PRTMAX,RETAIN,SAOPT,SCROPT,SELNUM,SUBPRM,TENLOG,TOL,TRANS1
     6,TRANSP)
C
C USE SIMULATED ANNEALING TO ARRIVE AT A LIST OF BEST LOCUS ORDERS.
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*4 LNAME(MAXLOC),LNAMEA(MAXLOC)
      CHARACTER*8 PNAME(MAXPAR)
C
      INTEGER BPERM(MAXORD,MAXLOC),BRLIST(0:MAXLOC),CHECK(MAXHYB)
     1,FINISH,NOBS(MAXPAN,MAXHYB),OUTOPT,PERM(MAXLOC)
     2,RETAIN(MAXPAN,MAXHYB,MAXLOC),SAOPT,SCROPT,START,NCHR(MAXPAN)
     3,NHYB(MAXPAN),NUMHYB(MAXPAN),SELNUM,SUBPRM(2,MAXLOC)
C
      REAL*4 BLIKE(MAXORD)
      REAL*8 ALPHA(MAXLOC,0:MAXCHR),ALPHAP(2,MAXLOC,0:MAXCHR,0:MAXCHR)
     1,BETA(MAXLOC,0:MAXCHR),BETAP(2,MAXLOC,0:MAXCHR)
     2,BINOM(0:MAXCHR,0:MAXCHR),CONDP(MAXHYB),DF(MAXPAR)
     3,DFHYB(MAXHYB,MAXPAR),DP(MAXPAR)
     4,DTRANS(MAXLOC,0:MAXCHR,0:MAXCHR,3),HPROB(MAXPAN,MAXHYB)
     5,NRET(MAXLOC)
     6,NTYPE(MAXLOC),PAR(MAXPAR),TRANS1(MAXLOC,0:1,0:1)
     7,TRANSP(MAXLOC,0:MAXCHR,0:MAXCHR)
C
C READ THE ADDITIONAL INFORMATION REQUIRED FOR SIMULATED ANNEALING.
C
      CALL INSA(FACTOR,ISEED1,ISEED2,ISEED3,KIN,KOUT,LNAME,LNAMEA
     1,MAXORD,NBET,NERR,NLOCUS,NMOVE,NTEMP,NUMORD,PERM,PRTMAX,SAOPT
     2,TENLOG,TMAX)
      IF(NERR.GT.0)GO TO 170
C
C COMPUTE THE LOG-LIKELIHOOD FOR THE INITIAL LOCUS ORDER.
C
      CALL MAXLIK(ALPHA,ALPHAP,BETA,BETAP,BINOM,BRLIST,CHECK,CONDP,CONV
     1,DF,DFHYB,DP,DTRANS,EMSTEP,F,HPROB,ICONDS,KITER,KOUT,MAXCHR,MAXHYB
     2,MAXLOC,MAXPAN,MAXPAR,MLTOPT,MODEL,MXITER,NCHR,NCONV,NHYB
     3,NLOCUS,NOBS,NPAN,NPAR,NRET,NTYPE,NUMHYB,OUTOPT,PAR,PERM,PNAME
     4,RETAIN,SELNUM,SUBPRM,TOL,TRANS1,TRANSP)
      IF(SCROPT.GE.1)WRITE(KTERMW,101)F/TENLOG
 101  FORMAT(' INITIAL ORDER LOG-LIKELIHOOD: ',F12.5)
      TOTORD=1.D0
C
C FILL IN THE LIST OF BEST ORDERS AND BEST LOG-LIKELIHOODS WITH LOTS OF
C COPIES OF -1 TO -NLOCUS WITH BIG NEGATIVE LOG-LIKELIHOODS.  PUT ONE
C COPY OF THE CANDIDATE ORDER AND ITS LOG-LIKELIHOOD IN THE LIST.
C
      DO 10 J=1,NLOCUS
        BPERM(1,J)=PERM(J)
   10 CONTINUE
      BLIKE(1)=F
      FWORST=-1.D8
      IWORST=2
C
      IF(NUMORD.EQ.1)GO TO 40
        DO 30 I=2,NUMORD
          DO 20 J=1,NLOCUS
            BPERM(I,J)=-J
   20     CONTINUE
          BLIKE(I)=-1.D8
   30   CONTINUE
C
C CARRY OUT SIMULATED ANNEALING AS SPECIFIED BY THE INPUT PARAMETERS.
C FOR EACH TEMPERATURE ...
C
   40 T=TMAX
      FBEST=-1.D20
      DO 110 JTEMP=1,NTEMP
        IF(SCROPT.EQ.2)WRITE(KTERMW,102)JTEMP,NTEMP
 102    FORMAT(' STARTING TEMPERATURE NUMBER ',I8,' OF ',I8,'.')
C
C FOR EACH MOVE AT THAT TEMPERATURE ...
C
        NSUCC=0
        DO 90 KMOVE=1,NMOVE
          IF(KMOVE/50*50.EQ.KMOVE.AND.SCROPT.EQ.2) WRITE(KTERMW,103)
     1    KMOVE,NMOVE
 103      FORMAT(' MOVE NUMBER ',I8,' OF ',I8,'.')
C
C CHOOSE THE SET OF LOCI (FROM START TO FINISH) TO INVERT.  IF
C START = FINISH, TRY AGAIN.
C
   50     START=1+INT(NLOCUS*RANDOM(ISEED1,ISEED2,ISEED3))
          FINISH=1+INT(NLOCUS*RANDOM(ISEED1,ISEED2,ISEED3))
          IF(FINISH-START)60,50,70
   60     ITEMP=FINISH
          FINISH=START
          START=ITEMP
C
C REVERSE THE PATH BEGINNING IN POSITION START AND ENDING IN
C POSITION FINISH.  RECALCUALTE THE LOG-LIKELIHOOD.
C
   70     CALL REVERS(FINISH,NLOCUS,PERM,START)
          CALL MAXLIK(ALPHA,ALPHAP,BETA,BETAP,BINOM,BRLIST,CHECK,CONDP
     1    ,CONV,DF,DFHYB,DP,DTRANS,EMSTEP,FNEW,HPROB,ICONDS,KITER,KOUT
     2    ,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MLTOPT,MODEL,MXITER,NCHR
     3    ,NCONV,NHYB,NLOCUS,NOBS,NPAN,NPAR,NRET,NTYPE,NUMHYB,OUTOPT
     4    ,PAR,PERM,PNAME,RETAIN,SELNUM,SUBPRM,TOL,TRANS1,TRANSP)
          TOTORD=TOTORD+1.D0
C
C IF THE NEW ORDER HAS HIGHER MAXIMUM LIKELIHOOD, WE MOVE FOR SURE.
C IF NOT, WE MOVE WITH THE METROPOLIS PROBABILITY.
C
          DELTA=FNEW-F
          IF(DELTA.GE.0.D0)GO TO 80
            IF(RANDOM(ISEED1,ISEED2,ISEED3).LT.EXP(DELTA/T))GO TO 80
              CALL REVERS(FINISH,NLOCUS,PERM,START)
              GO TO 90
C
C IF WE MOVE, UPDATE THE NUMBER OF SUCCESSFUL STEPS AND THE LIST OF BEST
C CURRENT ORDERS (IF APPROPRIATE).  IF THERE HAVE BEEN ENOUGH ACCEPTED
C STEPS, GO TO THE NEXT TEMPERATURE.
C
   80         F=FNEW
              NSUCC=NSUCC+1
              IF(F.GT.FBEST)FBEST=F
              IF(F.GT.FWORST)CALL UPLIST(BLIKE,BPERM,F,FWORST,IWORST
     1        ,MAXLOC,MAXORD,MODEL,NUMORD,NLOCUS,PERM)
              IF(NSUCC.GE.NBET)GO TO 100
   90   CONTINUE
  100   IF(SCROPT.GE.1)WRITE(KTERMW,104)' TEMP',JTEMP,' OF',NTEMP,
     1  ', CURRENT LOGLIK:',F/TENLOG,' BEST LOGLIK:',FBEST/TENLOG
 104    FORMAT(2(A,I6),2(A,F10.5))
        T=T*FACTOR
  110 CONTINUE
C
      IF(SCROPT.GE.1)WRITE(KTERMW,105)TOTORD
 105  FORMAT(' TOTAL NUMBER OF LIKELIHOOD MAXIMIZATIONS:',F12.0)
C
C CHANGE SIGNS ON THE LOG-LIKELIHOOD TO BE CONSISTENT WITH THE OTHER
C METHODS.  BLIKE'S ARE NOW -LOGLIK'S.
C
      DO 120 I=1,NUMORD
        BLIKE(I)=-BLIKE(I)
  120 CONTINUE
C
C REVERSE LOCUS ORDERS AS REQUIRED TO GIVE THE LOCUS ORDERS THE SAME
C ORIENTATION AS THE FIRST LOCUS ORDER.  IF THERE IS ONLY ONE ORDER,
C DON'T BOTHER.
C
      IF(NUMORD.EQ.1)GO TO 170
        MAX=(NLOCUS-1)/2
C
C FIRST, FIND THE BEST ORDER AND DETERMINE ITS TERMINAL LOCI.
C
        FBEST=1.D20
        DO 130 I=1,NUMORD
          IF(BLIKE(I).GT.FBEST)GO TO 130
            IBEST=I
            FBEST=BLIKE(I)
  130   CONTINUE
        LOCUS1=BPERM(IBEST,1)
        LOCUSN=BPERM(IBEST,NLOCUS)
C
C FOR EACH ORDER ...
C
        DO 160 I=1,NUMORD
C
C DETERMINE WHETHER IT IS IN REVERSE ORIENTATION TO THE BEST ORDER.
C
          DO 150 J=1,NLOCUS
            IF(BPERM(I,J).EQ.LOCUS1)GO TO 160
              IF(BPERM(I,J).NE.LOCUSN)GO TO 150
C
C IF NOT, REVERSE IT.
C
                DO 140 K=0,MAX
                  ISAVE=BPERM(I,K+1)
                  BPERM(I,K+1)=BPERM(I,NLOCUS-K)
                  BPERM(I,NLOCUS-K)=ISAVE
  140           CONTINUE
                GO TO 160
  150     CONTINUE
  160   CONTINUE
C
  170 RETURN
      END
C
C
C
      SUBROUTINE INSA(FACTOR,ISEED1,ISEED2,ISEED3,KIN,KOUT,LNAME,LNAMEA
     1,MAXORD,NBET,NERR,NLOCUS,NMOVE,NTEMP,NUMORD,PERM,PRTMAX,SAOPT
     2,TENLOG,TMAX)
C
C READ THE ADDITIONAL INFORMATION REQUIRED FOR SIMULATED ANNEALING.
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*3 CRAN
      CHARACTER*4 LNAME(NLOCUS),LNAMEA(NLOCUS)
      INTEGER PERM(NLOCUS),SAOPT
C
C READ AND CHECK SAOPT (=1 IF USER-SPECIFIED INITIAL PERMUTATION,
C =0 IF RANDOM PERMUTATION), THE NUMBER OF BEST ORDERS TO SAVE,
C THE SEEDS FOR THE RANDOM NUMBER GENERATOR, AND THE MAXIMUM
C LOG-LIKELIHOOD DIFFERENCE FROM THE BEST LOCUS ORDER FOR PRINTING.
C MAKE SURE THAT PRTMAX IS NON-NEGATIVE, AND RE-SCALE IT FOR
C NATURAL LOGS.
C
      NERR=0
      READ(KIN,101)SAOPT,NUMORD,ISEED1,ISEED2,ISEED3,PRTMAX
 101  FORMAT(5I8,F8.5)
      IF(PRTMAX.LT.0.D0)PRTMAX=0.D0
      PRTMAX=PRTMAX*TENLOG
C
      IF(SAOPT.EQ.0.OR.SAOPT.EQ.1)GO TO 10
        WRITE(KOUT,102)SAOPT
 102    FORMAT(/' *** ERROR *** THE INITIAL PERMUTATION OPTION FOR',
     1  ' SIMULATED ANNEALING'/15X,'MUST EQUAL ZERO (RANDOM) OR ONE',
     2  ' (USER-SPECIFIED).'/15X,'IT IS ',I8,'.')
        NERR=NERR+1
C
   10 IF(NUMORD.GT.0.AND.NUMORD.LE.MAXORD)GO TO 20
        WRITE(KOUT,103)MAXORD,NUMORD
 103    FORMAT(/' *** ERROR *** THE NUMBER OF BEST ORDERS TO SAVE',
     1  ' MUST BE GREATER THAN'/15X,'ZERO AND NO GREATER THAN ',I8,
     2  '.  IT IS',I8,'.')
        NERR=NERR+1
C
   20 IF(ISEED1.GT.0.AND.ISEED1.LT.32767.AND .ISEED2.GT.0.AND.ISEED2.LT.
     132767.AND .ISEED3.GT.0.AND.ISEED3.LT.32767)GO TO 30
 
C
        WRITE(KOUT,104)ISEED1,ISEED2,ISEED3
 104    FORMAT(/' *** ERROR *** THE SEEDS FOR THE RANDOM NUMBER',
     1  ' GENERATOR MUST BE BETWEEN'/15X,'1 AND 32767.  THEY ARE:  ',
     2  I8,', ',I8,', AND ',I8,'.')
        NERR=NERR+1
C
C READ AND CHECK THE PARAMETERS FOR SIMULATED ANNEALING:  NTEMP IS THE
C NUMBER OF DIFFERENT TEMPERATURES CONSIDERED, NBET IS THE NUMBER OF MOVES
C TO A BETTER ORDER REQUIRED TO GO TO THE NEXT TEMPERATURE, NMOVE IS THE
C MAXIMUM NUMBER OF MOVES BEFORE GOING TO THE NEXT TEMPERATURE, TMAX IS
C THE INITIAL TEMPERATURE, AND FACTOR IS THE FACTOR BY WHICH THE
C TEMPERATURE IS DECREASED.
C
   30 READ(KIN,105)NTEMP,NBET,NMOVE,TMAX,FACTOR
 105  FORMAT(3I8,2F8.5)
C
      IF(NTEMP.GT.0)GO TO 40
        WRITE(KOUT,106)NTEMP
 106    FORMAT(/' *** ERROR *** THE NUMBER OF DIFFERENT TEMPERATURES',
     1  ' FOR SIMULATED'/15X,'ANNEALING IS REPORTED TO BE ',I8,
     2  '.  IT MUST BE POSITIVE.')
        NERR=NERR+1
C
   40 IF(NBET.GT.0.AND.NBET.LE.NMOVE)GO TO 50
        WRITE(KOUT,107)NBET,NMOVE
 107    FORMAT(/' *** ERROR *** THE NUMBER OF STEPS TO A BETTER ORDER',
     1  ' REQUIRED BEFORE'/15X,'CHANGING TEMPERATURES FOR SIMULATED ',
     2  'ANNEALING IS REPORTED'/15X,'TO BE ',I8,'.  IT MUST BE ',
     3  'POSITIVE AND SHOULD BE NO MORE'/15X,'THAN THE MAXIMUM NUMBER',
     4  ' OF STEPS BEFORE CHANGING'/15X,'TEMPERATURES ',I8,'.')
        NERR=NERR+1
C
   50 IF(NMOVE.GT.0)GO TO 60
        WRITE(KOUT,108)NMOVE
 108    FORMAT(/' *** ERROR *** THE MAXIMUM NUMBER OF STEPS BEFORE', 
     1  ' CHANGING TEMPERATURES'/15X,'FOR SIMULATED ANNEALING IS',
     2  ' REPORTED TO BE',I8,'.'/15X,'IT MUST BE POSITIVE.')
        NERR=NERR+1
C
   60 IF(TMAX.GT.1.D-4)GO TO 70
        WRITE(KOUT,109)TMAX
 109    FORMAT(/' *** ERROR *** THE INITIAL TEMPERATURE FOR SIMULATED',
     1  ' ANNEALING IS '/15X,'REPORTED TO BE ',F15.3,
     2  '.  IT MUST BE POSITIVE.')
        NERR=NERR+1
C
C CHECK THAT THE TEMPERATURE WILL DECREASE AT EACH MOVE.
C
   70 IF(FACTOR.LT.1.D0)GO TO 80
        WRITE(KOUT,111)FACTOR
 111    FORMAT(' *** ERROR *** THE TEMPERATURE REDUCTION FACTOR IS',
     1  ' LISTED AS ',F10.7,'.'/15X,'IT MUST BE LESS THAN ONE.')
C
C OUTPUT THE SIMULATED ANNEALING OPTIONS OTHER THAN THE INITIAL ORDER.
C
   80 CRAN=' NO'
      IF(SAOPT.EQ.0)CRAN='YES'
      WRITE(KOUT,112)TMAX,NTEMP,NMOVE,NBET,FACTOR,CRAN,ISEED1,ISEED2,
     1ISEED3
 112  FORMAT(//' SIMULATED ANNEALING OPTIONS' //
     1' INITIAL TEMPERATURE:                  ',F12. 5/
     2' NUMBER OF DIFFERENT TEMPERATURES:         ',I8 /
     3' MAXIMUM STEPS AT A TEMPERATURE:           ',I8 /
     4' NO. OF BETTER ORDERS TO CHANGE TEMP:      ',I8 /
     5' TEMPERATURE REDUCTION FACTOR:             ',F8. 5/
     6' RANDOM INITIAL LOCUS ORDER?:                   ',A3 /
     7' SEEDS FOR RANDOM NUMBER GENERATOR:        ',3I8)
C
C IF SAOPT=1, READ THE INITIAL PERMUTATION.  CHECK AND TRANSLATE THE
C LOCUS NAMES TO A PERMUTATION.  IF SAOPT=0, GENERATE A RANDOM
C PERMUTATION OF THE LOCI.
C
      IF(SAOPT.EQ.0)GO TO 90
        READ(KIN,113)(LNAMEA(I),I=1,NLOCUS)
 113    FORMAT(20A4)
        CALL NAMIND(KOUT,LNAMEA,LNAME,NERR,NLOCUS,NLOCUS,PERM)
        GO TO 100
C
   90   CALL RANPER(NLOCUS,PERM,ISEED1,ISEED2,ISEED3)
C
C OUTPUT THE INITIAL PERMUTATION.
C
  100 WRITE(KOUT,114)(LNAME(PERM(I)),I=1,NLOCUS)
 114  FORMAT(/' INITIAL LOCUS ORDER:    ',10A5,100(/25X,10A5))
C
      IF(NERR.GT.0)SAOPT=-1
C
      RETURN
      END
C
C
C
      SUBROUTINE RANPER(N,A,ISEED1,ISEED2,ISEED3)
C
C DETERMINE A RANDOM PERMUTATION OF THE N ELEMENTS OF THE ARRAY A.
C
C REFERENCE:  NIJENHUIS A, WILF HS (1978) COMBINATORIAL ALGORITHMS
C FOR COMPUTERS AND CALCULATORS, 2ND ED.  ACADEMIC PRESS, ORLANDO,
C FLORIDA, PP. 62-64.
C
      IMPLICIT REAL*8(A-H,O-Z)
      INTEGER A(N)
C
      DO 10 I=1,N
        A(I)=I
   10 CONTINUE
C
      DO 20 M=1,N
        L=M+RANDOM(ISEED1,ISEED2,ISEED3)*(N+1-M)
        L1=A(L)
        A(L)=A(M)
        A(M)=L1
   20 CONTINUE
C
      RETURN
      END
C
C
C
      FUNCTION RANDOM(ISEED1,ISEED2,ISEED3)
C
C GENERATE A U(0,1) RANDOM NUMBER.
C
C REFERENCE:  WICHMAN BA, HILL ID (1982) AN EFFICIENT AND PORTABLE
C PSEUDO-RANDOM NUMBER GENERATOR.  APPLIED STATISTICS 31:188-192.
C
      IMPLICIT REAL*8(A-H,O-Z)
C
      ISEED1=171*MOD(ISEED1,177)- 2*(ISEED1/177)
      ISEED2=172*MOD(ISEED2,176)-35*(ISEED2/176)
      ISEED3=170*MOD(ISEED3,178)-63*(ISEED3/178)
C
      IF(ISEED1.LT.0)ISEED1=ISEED1+30269
      IF(ISEED2.LT.0)ISEED2=ISEED2+30307
      IF(ISEED3.LT.0)ISEED3=ISEED3+30323
C
      RANDOM=DBLE(ISEED1)/30269.0D0
     1      +DBLE(ISEED2)/30307.0D0
     2      +DBLE(ISEED3)/30323.0D0
      RANDOM=DMOD(RANDOM,1.D0)
C
      RETURN
      END
C
C
C
      SUBROUTINE REVERS(FINISH,NLOCUS,PERM,START)
C
C PERFORM A PATH REVERSAL OF LOCI START TO FINISH.
C
      IMPLICIT REAL*8(A-H,O-Z)
      INTEGER PERM(NLOCUS),FINISH,START
C
      MAX=(FINISH-START)/2
      DO 10 I=0,MAX
        J=PERM(START+I)
        PERM(START+I)=PERM(FINISH-I)
        PERM(FINISH-I)=J
   10 CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE UPLIST(BLIKE,BPERM,F,FWORST,IWORST,MAXLOC,MAXORD
     1,MODEL,NUMORD,NLOCUS,PERM)
C
C UPDATE THE LIST OF BEST LOCUS ORDERS FOR SIMULATED ANNEALING.
C
      IMPLICIT REAL*8(A-H,O-Z)
      REAL*4 BLIKE(MAXORD)
      INTEGER BPERM(MAXORD,MAXLOC),PERM(MAXLOC)
      LOGICAL MOD23
C
      MOD23=.TRUE.
      IF(MODEL.NE.2.AND.MODEL.NE.3)MOD23=.FALSE.
      NLOCP1=NLOCUS+1
C
C CHECK WHETHER THE CURRENT ORDER ALREADY IS IN THE LIST OF BEST ORDERS.
C IF IT IS, FORGET IT.  NOTE:  IF THERE IS NO ORIENTATION ALONG THE
C CHROMOSOME (MODEL=1,4,5,6,7), CHECK BOTH ORIENTATIONS.
C
      DO 40 J=1,NUMORD
        IF(DABS(BLIKE(J)-F).GT.1.D-3)GO TO 40
C
          DO 10 I=1,NLOCUS
            IF(BPERM(J,I).NE.PERM(I))GO TO 20
   10     CONTINUE
          GO TO 70
C
   20     IF(MOD23)GO TO 40
          DO 30 I=1,NLOCUS
            IF(BPERM(J,I).NE.PERM(NLOCP1-I))GO TO 40
   30     CONTINUE
          GO TO 70
   40 CONTINUE
C
C IF NOT, EXCHANGE THE CURRENT ORDER WITH THE WORST ORDER THAT IS
C CURRENTLY SAVED.
C
      BLIKE(IWORST)=F
      DO 50 I=1,NLOCUS
        BPERM(IWORST,I)=PERM(I)
   50 CONTINUE
C
C DETERMINE WHICH SAVED ORDER IS NOW THE WORST.
C
      FWORST=F
      DO 60 J=1,NUMORD
        IF(BLIKE(J).GE.FWORST)GO TO 60
          FWORST=BLIKE(J)
          IWORST=J
   60 CONTINUE
C
   70 RETURN
      END
C
C
C
      SUBROUTINE INDEXX(N,ARRAY,INDEX)
C
C THIS ROUTINE CONSTRUCTS THE INDEX ARRAY INDEX BASED ON THE INPUT
C ARRAY ARRAY.  AT COMPLETION, ARRAY(INDEX(I)) IS IN ASCENDING ORDER
C FOR I=1,2,...,N.
C
C REFERENCE:  PRESS WH, FLANNERY BP, TEUKOLSKY SA, VETTERLING WT
C (1986) NUMERICAL RECIPES.  THE ART OF SCIENTIFIC COMPUTING (FORTRAN
C VERSION), CAMBRIDGE UNIVERSITY PRESS, CAMBRIDGE, ENGLAND, P. 233.
C
      IMPLICIT REAL*8(A-H,O-Z)
      REAL*4 ARRAY(N)
      INTEGER INDEX(N)
C
C INITIALIZE THE INDEX ARRAY WITH CONSECUTIVE INTEGERS.
C
      DO 10 I=1,N
        INDEX(I)=I
   10 CONTINUE
      IF(N.EQ.1)RETURN
C
C FROM HERE ON WE ARE DOING A HEAPSORT WITH INDIRECT INDEXING THROUGH
C INDEX IN ALL REFERENCES TO ARRAY.
C
      L=N/2+1
      IR=N
C
   20 CONTINUE
        IF(L.GT.1)THEN
          L=L-1
          INDEXT=INDEX(L)
          Q=ARRAY(INDEXT)
        ELSE
          INDEXT=INDEX(IR)
          Q=ARRAY(INDEXT)
          INDEX(IR)=INDEX(1)
          IR=IR-1
          IF(IR.EQ.1)THEN
            INDEX(1)=INDEXT
            RETURN
          ENDIF
        ENDIF
C
        I=L
        J=L+L
C
   30   IF(J.LE.IR)THEN
          IF(J.LT.IR)THEN
            IF(ARRAY(INDEX(J)).LT.ARRAY(INDEX(J+1)))J=J+1
          ENDIF
          IF(Q.LT.ARRAY(INDEX(J)))THEN
            INDEX(I)=INDEX(J)
            I=J
            J=J+J
          ELSE
            J=IR+1
          ENDIF
        GO TO 30
        ENDIF
        INDEX(I)=INDEXT
      GO TO 20
      END
C
C
C
      SUBROUTINE OUTORD(BESTLK,BLIKE,BPERM,INDEX,KOUT,KWRITE,LNAME
     1,MAXHYB,MAXLOC,MAXORD,MAXPAN,NBEST,NHYB,NLOCUS,NLUSE,NOBS
     2,NPAN,NUMORD,PERM,PRTMAX,RETAIN,TENLOG)
C
C OUTPUT THE LOCUS ORDER TABLE FOR THIS PROBLEM.  ALSO OUTPUT THE
C RETENTION STATUS DATA FOR THE BEST LOCUS ORDER.
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*4 LNAME(MAXLOC)
      INTEGER BPERM(MAXORD,MAXLOC),INDEX(MAXORD),NOBS(MAXPAN,MAXHYB)
     1,PERM(MAXLOC),RETAIN(MAXPAN,MAXHYB,MAXLOC),NHYB(MAXPAN)
      REAL*4 BLIKE(MAXORD)
C
C IF THERE WERE TOO MANY ORDERS TO SORT, READ FROM THE SCRATCH FILE.
C OTHERWISE, GET THEM FROM BPERM.
C
      IF(NUMORD.GT.MAXORD)GO TO 60
C
C OUTPUT THE RANK-ORDERED LOCUS ORDERS TOGETHER WITH THEIR RANKS,
C LOG-LIKELIHOOD DIFFERENCES AND RATIOS FROM THE BEST LOCUS ORDER, AND
C OBLIGATE BREAKS.
C
      WRITE(KOUT,101)
C
 101  FORMAT(///' MOST LIKELY LOCUS ORDERS'//'        LOG10'/
     1'         LIKE     LIKE'/
     2' RANK    DIFF     RATIO BRKS   LOCUS ORDER')
C
      NMAX=NUMORD
      IF(NBEST.GT.0.AND.NBEST.LT.NUMORD)NMAX=NBEST
      BESTLK=-BLIKE(INDEX(1))
      DO 40 I=1,NMAX
C
C CALCULATE THE NUMBER OF OBLIGATE BREAKS FOR THE DATA SET FOR THE
C CURRENT ORDER.
C
        NUMBRK=0
        DO 30 IPAN=1,NPAN
          DO 20 IHYB=1,NHYB(IPAN)
           IROLD=RETAIN(IPAN,IHYB,BPERM(INDEX(I),1))
           DO 10 LOCUS=2,NLUSE
             IRNEW=RETAIN(IPAN,IHYB,BPERM(INDEX(I),LOCUS))
             IF(IROLD.EQ.IRNEW.OR.IRNEW.EQ.2)GO TO 10
               IF(IROLD+IRNEW.EQ.1)NUMBRK=NUMBRK+NOBS(IPAN,IHYB)
               IROLD=IRNEW
   10      CONTINUE
   20     CONTINUE
   30   CONTINUE
C
        DIFF=BLIKE(INDEX(I))+BESTLK
        IF(DIFF.GT.PRTMAX.AND.I.GT.2)GO TO 50
          RATIO=DEXP(DIFF)
          WRITE(KOUT,102)I,DIFF/TENLOG,RATIO,NUMBRK,(LNAME(BPERM(INDEX
     1    (I),LOCUS)),LOCUS=1,NLUSE)
          WRITE(KOUT,103)(BPERM(INDEX(I),LOCUS),LOCUS=1,NLUSE)
 102      FORMAT(/I4,F9.4,F10.1,I5,3X,14(A4,1X),71(/31X,14(A4,1X)))
 103      FORMAT(28X,14I5)
   40 CONTINUE
      GO TO 130
   50 NUMORD=I
      GO TO 130
C
C OUTPUT LOCUS ORDERS WHEN THERE WERE TOO MANY TO STORE IN BPERM.
C IN THIS CASE, THE ORDERS WILL NOT BE RANK ORDERED.
C
   60 WRITE(KOUT,104)
 104  FORMAT(///' MOST LIKELY LOCUS ORDERS'//'  LOG10'/
     1'   LIKE     LIKE'/'   DIFF     RATIO  BRKS   LOCUS ORDER')
C
      DO 120 I=1,NUMORD
        READ(KWRITE,105)F,(PERM(J),J=1,NLUSE)
 105    FORMAT(F15.9,10(100I3/))
        DIFF=F+BESTLK
        IF(DIFF.GT.1.D-6)GO TO 80
          DO 70 K=1,NLUSE
            BPERM(1,K)=PERM(K)
   70     CONTINUE
   80   IF(DIFF.GT.PRTMAX)GO TO 120
C
C CALCULATE THE NUMBER OF OBLIGATE BREAKS FOR THE DATA SET FOR THE
C CURRENT ORDER.
C
          NUMBRK=0
          DO 110 IPAN=1,NPAN
            DO 100 IHYB=1,NHYB(IPAN)
             IROLD=RETAIN(IPAN,IHYB,PERM(1))
             DO 90 LOCUS=2,NLUSE
               IRNEW=RETAIN(IPAN,IHYB,PERM(LOCUS))
               IF(IROLD.EQ.IRNEW.OR.IRNEW.EQ.2)GO TO 90
                 IF(IROLD+IRNEW.EQ.1)NUMBRK=NUMBRK+NOBS(IPAN,IHYB)
                 IROLD=IRNEW
   90        CONTINUE
  100       CONTINUE
  110     CONTINUE
C
          RATIO=DEXP(DIFF)
          WRITE(KOUT,106)DIFF/TENLOG,RATIO,NUMBRK,(LNAME(PERM(J)),J=1,
     1    NLUSE)
          WRITE(KOUT,107)(PERM(J),J=1,NLUSE)
 106      FORMAT(/F9.4,F10.1,I4,3X,14(A4,1X),71(/26X,14(A4,1X)))
 107      FORMAT(23X,14I5)
  120 CONTINUE
      CLOSE(KWRITE)
C
C OUTPUT THE LOG10- AND LN-LIKELIHOODS FOR THE BEST LOCUS ORDER.
C
  130 WRITE(KOUT,108)BESTLK/TENLOG,BESTLK
 108  FORMAT(//' LOG-LIKELIHOOD FOR THE MAXIMUM LIKELIHOOD LOCUS ORDER:'
     1/' LOG(10) ',F15.7/' LOG(E)  ',F15.7)
C
      RETURN
      END
C
C
C
      SUBROUTINE FRLOC(BLIKE,BPERM,FRAME,INDEX,KOUT,LNAME
     1,MAXLOC,MAXORD,NLOCUS,NUMORD,PERM,SAVMAX,TENLOG)
C
C IF THE NUMBER OF ORDERS IS NOT TOO LARGE, NOTE WHICH LOCI ARE
C CONSISTENTLY PLACED WITH 1000:1 ODDS.
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*4 LNAME(MAXLOC)
      INTEGER BPERM(MAXORD,MAXLOC),FRAME(MAXLOC,MAXLOC),INDEX(MAXORD)
     1,PERM(MAXLOC)
      REAL*4 BLIKE(MAXORD)
C
C SET THE FRAMEWORK MATRIX TO ZERO.
C
      DO 20 I=1,NLOCUS
        DO 10 J=1,NLOCUS
          FRAME(I,J)=0
   10   CONTINUE
   20 CONTINUE
C
C FOR EACH OF THE BEST LOCUS ORDERS WITH LIKELIHOODS NO MORE THAN
C 1000 (OR 10**SAVMAX IF THAT IS LESS) TIMES LESS THAN THE BEST, NOTE
C THE POSSIBLE POSITIONS OF THE LOCI.  FRAME(I,J)=1 SAYS LOCUS I
C OCCURS (FOR SOME ORDER) IN POSITION J.
C
      INDEX1=INDEX(1)
      BESTLK=BLIKE(INDEX1)
      LOCUS1=BPERM(INDEX1,1)
      LOCUSN=BPERM(INDEX1,NLOCUS)
      NLOCP1=NLOCUS+1
      DIFFMX=3.D0*TENLOG
      IF(SAVMAX.LT.DIFFMX)DIFFMX=SAVMAX
C
      DO 80 IORDER=1,NUMORD
        INDEXI=INDEX(IORDER)
        IF(BLIKE(INDEXI)-BESTLK.GT.DIFFMX)GO TO 90
C
C DETERMINE THE ORIENTATION OF THE CURRENT LOCUS ORDER.
C
          DO 30 J=1,NLOCUS
            IF(BPERM(INDEXI,J).EQ.LOCUS1)GO TO 40
            IF(BPERM(INDEXI,J).EQ.LOCUSN)GO TO 60
   30     CONTINUE
C
C ORIENTATION THE SAME AS FOR THE BEST LOCUS ORDER.
C
   40     DO 50 J=1,NLOCUS
            FRAME(BPERM(INDEXI,J),J)=1
   50     CONTINUE
          GO TO 80
C
C ORIENTATION THE REVERSE OF THAT FOR THE BEST LOCUS ORDER.
C
   60     DO 70 J=1,NLOCUS
            FRAME(BPERM(INDEXI,J),NLOCP1-J)=1
   70     CONTINUE
   80   CONTINUE
C
C OUTPUT THE POSSIBLE LOCUS POSITIONS FOR EACH LOCUS.  FIRST, OUTPUT
C A HEADER.
C
   90 WRITE(KOUT,101)DEXP(DIFFMX)
 101  FORMAT(///' POSSIBLE LOCUS POSITIONS AMONG ORDERS WITH MAXIMUM',
     1' LIKELIHOODS NO MORE'/' THAN',F12.3,' TIMES SMALLER THAN',
     2' THAT OF THE MOST LIKELY LOCUS ORDER'//' LOCUS NUMBER   LOCUS',
     3' NAME   POSSIBLE LOCUS POSITIONS'/)
C
      DO 110 I=1,NLOCUS
        NPOS=0
        DO 100 J=1,NLOCUS
          IF(FRAME(I,J).EQ.0)GO TO 100
            NPOS=NPOS+1
            PERM(NPOS)=J
  100   CONTINUE
        WRITE(KOUT,102)I,LNAME(I),(PERM(J),J=1,NPOS)
 102    FORMAT(I8,12X,A4,5X,20I3,49(/29X,20I3))
  110 CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE OUTEST(ALPHA,ALPHAP,BETA,BETAP,BINOM,BESTLK,BLIKE
     1,BPERM,BRLIST,BSTPRM,CHECK,CONDP,CONV,DF,DFHYB,DP,DTRANS,EMSTEP
     2,HPROB,ICONDS,INDEX,KITER,KOUT,LNAME,MAXCHR,MAXHYB,MAXLOC,MAXORD
     3,MAXPAN,MAXPAR,MLTOPT,MODEL,MXITER,NBEST,NCHR,NCONV,NHYB,NLOCUS
     4,NOBS,NPAN,NPAR,NRET,NTYPE,NUMHYB,NUMORD,OUTOPT,PAR,PERM,PNAME
     5,PRTMAX,RETAIN,RETEST,RETOBS,SELNUM,SUBPRM,TOL,TRANS1,TRANSP)
C
C OUTPUT THE PARAMETER ESTIMATES FOR THIS PROBLEM.
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*4 LNAME(MAXLOC)
      CHARACTER*8 PNAME(MAXPAR)
      INTEGER BPERM(MAXORD,MAXLOC),BRLIST(0:MAXLOC),BSTPRM(MAXLOC)
     1,CHECK(MAXHYB),INDEX(NUMORD),NCHR(MAXPAN),NOBS(MAXPAN,MAXHYB)
     2,OUTOPT,PERM(MAXLOC),RETAIN(MAXPAN,MAXHYB,MAXLOC)
     3,NHYB(MAXPAN),NUMHYB(MAXPAN),SELNUM,SUBPRM(2,MAXLOC)
      REAL*4 BLIKE(MAXORD)
      REAL*8 ALPHA(MAXLOC,0:MAXCHR),ALPHAP(2,MAXLOC,0:MAXCHR,0:MAXCHR)
     1,BETA(MAXLOC,0:MAXCHR),BETAP(2,MAXLOC,0:MAXCHR)
     1,BINOM(0:MAXCHR,0:MAXCHR),CONDP(MAXHYB),DF(MAXPAR)
     2,DFHYB(MAXHYB,MAXPAR),DP(MAXPAR)
     3,DTRANS(MAXLOC,0:MAXCHR,0:MAXCHR,3),HPROB(MAXPAN,MAXHYB)
     4,NRET(MAXLOC),NTYPE(MAXLOC),PAR(MAXPAR),RETEST(MAXPAN,MAXLOC)
     5,RETOBS(MAXPAN,MAXLOC),TRANS1(MAXLOC,0:1,0:1)
     6,TRANSP(MAXLOC,0:MAXCHR,0:MAXCHR)
C
C CALCULATE THE NUMBER OF PARAMETERS.
C
      NPAR=NUMPAR(MLTOPT,MODEL,NLOCUS,NPAN)
      NLOC1=NLOCUS-1
C
      WRITE(KOUT,101)
 101  FORMAT(///' PARAMETER ESTIMATES FOR THE MOST LIKELY LOCUS ORDERS')
C
C NMAX IS THE MAXIMUM NUMBER OF ORDERS TO PRINT. IF THERE ARE TOO MANY 
C ORDERS TO SORT, OUTPUT THE RESULTS ONLY FOR THE BEST ORDER, EVEN IF 
C OUTOPT>0.
C
      NMAX=NUMORD
      IF(NBEST.GT.0.AND.NBEST.LT.NUMORD)NMAX=NBEST
      IF(OUTOPT.EQ.0.OR.NUMORD.GT.MAXORD)NMAX=1
C
      DO 110 I=1,NMAX
C
C FOR EACH LOCUS ORDER ...
C
        DIFF=BLIKE(INDEX(I))+BESTLK
        IF(DIFF.GT.PRTMAX)GO TO 120
C
C PUT THE NEXT ORDER FOR MAXIMIZATION IN THE ARRAY PERM.
C IF NUMORD>MAXORD, PUT THE BEST LOCUS ORDER IN PERM.
C
        DO 10 J=1,NLOCUS
          PERM(J)=BPERM(INDEX(I),J)
   10   CONTINUE
C
        IF(NUMORD.LE.MAXORD)GO TO 25
          DO 20 J=1,NLOCUS
            PERM(J)=BSTPRM(J)
   20     CONTINUE

C
C RE-CALCULATE ITS LOGLIKELIHOOD AND ESTIMATE PARAMETERS. IF MLTOPT=0 
C (NON-PROPORTIONAL DISTANCES), CALCULATE LIKELIHOOD AND PARAMETERS
C FOR EACH PANEL SEPARATELY SO WE CAN PRINT THE PARAMETERS...
C
   25   IF(MLTOPT.EQ.1)GO TO 75
        F=0.D0
        DO 70 IPAN=1,NPAN
          CALL MAXL1(ALPHA,ALPHAP,BETA,BETAP,BINOM,BRLIST,CHECK,CONDP
     1    ,CONV,DF,DFHYB,DP,DTRANS,EMSTEP,F1,HPROB,ICONDS,IPAN,KITER
     2    ,KOUT,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MLTOPT,MODEL,MXITER
     3    ,NCHR,NCONV,NHYB,NLOCUS,NOBS,1,NPAR,NRET,NTYPE,NUMHYB,OUTOPT
     4    ,PAR,PERM,PNAME,RETAIN,SELNUM,SUBPRM,TOL,TRANS1,TRANSP)
          F=F+F1
C
C OUTPUT THE BREAKAGE AND DISTANCE ESTIMATES FOR THIS PANEL.
C
          IF(IPAN.EQ.1)WRITE(KOUT,111)
          WRITE(KOUT,102)I,(LNAME(PERM(J)),J=1,NLOCUS)
          IF(NPAN.GT.1)WRITE(KOUT,103)IPAN
          WRITE(KOUT,104)' BRK    ',(PAR(J),J=1,NLOC1)
          WRITE(KOUT,104)' DIST   ',(-DLOG(1.D0-PAR(J)),J=1,NLOC1)
 102      FORMAT(/I5,1X,14A6,71(/6X,14A6))
 103      FORMAT(' PANEL',I4/)
 104      FORMAT(1X,A8,2X,14(1X,F5.3)/71(11X,14(1X,F5.3)/))
          WRITE(KOUT,105)'  '
 105      FORMAT(A65)
C
C OUTPUT THE OBSERVED AND ESTIMATED RETENTION PROBABILITIES FOR EACH LOCUS.
C
          CALL RETLOC(ICONDS,IPAN,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MODEL
     1    ,NCHR,NHYB,NLOCUS,NOBS,1,PAR,PERM,RETAIN,RETEST,RETOBS,SELNUM)
          WRITE(KOUT,106)' RETOBS ',(RETOBS(1,J),J=1,NLOCUS)
          WRITE(KOUT,106)' RETEST ',(RETEST(1,J),J=1,NLOCUS)
 106      FORMAT(A8,14(1X,F5.3)/71(8X,14(1X,F5.3)/))
C
C OUTPUT THE RETENTION ESTIMATES.
C
          IF(MODEL.EQ.4)GO TO 30
          NRETP=MODEL
          IF(MODEL.EQ.3.OR.MODEL.EQ.7)NRETP=NLOCUS
          IF(MODEL.EQ.5.OR.MODEL.EQ.6)NRETP=MODEL-3
C
          IFIRST=NLOCUS
          ILAST=IFIRST+NRETP-1
          WRITE(KOUT,106)' RETPAR ',(PAR(J),J=IFIRST,ILAST)
          GO TO 50
C
   30     DO 40 J=1,NLOCUS
            JJ=J*NLOCUS-1-J*(J-1)/2
            WRITE(KOUT,106)' RETPAR ',(PAR(K+JJ),K=1,J)
   40     CONTINUE
   50     CONTINUE
C
C OUTPUT THE TOTAL MAP LENGTH.
C
          SUMD=TMLEN(NLOCUS,PAR)
          IF(SUMD.GE.0) WRITE(KOUT,108)SUMD
 108      FORMAT(/' TOTAL MAP LENGTH: ',F7.3/)
          IF(SUMD.LT.0) WRITE(KOUT,109)
 109      FORMAT(/' MAP LENGTH NOT CALCULATED:  SOME BREAKAGE'
     1    ,' ESTIMATES EQUAL 1.0.'/)
   70   CONTINUE
        GO TO 110
C
C OUTPUT RESULTS IF MLTOPT=1 (PROPORTIONAL DISTANCES).  CALCULATE THE
C PARAMETERS ALL AT ONCE.  FIRST, RE-CALCULATE THE ORDER'S LOGLIKELIHOOD 
C AND ESTIMATE PARAMETERS.
C
   75   CALL MAXLIK(ALPHA,ALPHAP,BETA,BETAP,BINOM,BRLIST,CHECK,CONDP
     1  ,CONV,DF,DFHYB,DP,DTRANS,EMSTEP,F,HPROB,ICONDS,KITER,KOUT,MAXCHR
     2  ,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MLTOPT,MODEL,MXITER,NCHR,NCONV
     3  ,NHYB,NLOCUS,NOBS,NPAN,NPAR,NRET,NTYPE,NUMHYB,OUTOPT,PAR,PERM
     4  ,PNAME,RETAIN,SELNUM,SUBPRM,TOL,TRANS1,TRANSP)
C
C OUTPUT THE BREAKAGE AND DISTANCE ESTIMATES.
C
        WRITE(KOUT,111)
 111    FORMAT(' RANK',7X,'LOCUS ORDER')
        WRITE(KOUT,102)I,(LNAME(PERM(J)),J=1,NLOCUS)
        WRITE(KOUT,104)' BRK    ',(PAR(J),J=1,NLOC1)
        WRITE(KOUT,104)' DIST   ',(-DLOG(1.D0-PAR(J)),J=1,NLOC1)
        WRITE(KOUT,105)'  '
C
C OUTPUT THE OBSERVED AND ESTIMATED RETENTION PROBABILITIES FOR EACH LOCUS.
C
        CALL RETLOC(ICONDS,0,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MODEL,NCHR
     1  ,NHYB,NLOCUS,NOBS,NPAN,PAR,PERM,RETAIN,RETEST,RETOBS,SELNUM)
        DO 80 IPAN=1,NPAN
          WRITE(KOUT,112)IPAN
 112      FORMAT(' PANEL ',I4/)
          WRITE(KOUT,106)' RETOBS ',(RETOBS(IPAN,J),J=1,NLOCUS)
          WRITE(KOUT,106)' RETEST ',(RETEST(IPAN,J),J=1,NLOCUS)
C
C OUTPUT THE RETENTION ESTIMATES.
C
          NRETP=MODEL
          IF(MODEL.EQ.3.OR.MODEL.EQ.7)NRETP=NLOCUS
          IF(MODEL.EQ.5.OR.MODEL.EQ.6)NRETP=MODEL-3
          IFIRST=NLOCUS+NRETP*(IPAN-1)
          ILAST=IFIRST+NRETP-1
C
          WRITE(KOUT,106)' RETPAR ',(PAR(J),J=IFIRST,ILAST)
          WRITE(KOUT,105)'  '
   80   CONTINUE
C
C OUTPUT THE PROPORTIONALITY PARAMETERS.
C
        NPPAR=ILAST+1
        DO 90 IPAN=2,NPAN
          WRITE(KOUT,113)IPAN,PAR(NPPAR)
          NPPAR=NPPAR+1
   90   CONTINUE
 113    FORMAT(' PANEL ',I2,': PROPAR=',G12.4)
C
C OUTPUT THE TOTAL MAP LENGTH.
C
        SUMD=TMLEN(NLOCUS,PAR)
        IF(SUMD.GE.0) WRITE(KOUT,108)SUMD
        IF(SUMD.LT.0) WRITE(KOUT,109)
  110 CONTINUE
C
  120 RETURN
      END
C
C
C
      FUNCTION TMLEN(NLOCUS,PAR)
C
C GIVEN THE BREAKAGE PROBABILITIES, COMPUTE THE TOTAL MAP 
C LENGTH IN RAYS.  IF ONE OF THE BREAKAGE PROBABILITIES IS AT ITS
C BOUNDARY VALUE, RETURN THE VALUE -1 FOR THE MAP LENGTH.
C
      IMPLICIT REAL*8(A-H,O-Z)
      REAL*8 PAR(NLOCUS)
C
      SMALL=1.D-4
      SUMD=0.D0
      DO 10 J=1,NLOCUS-1
        SUMD=SUMD-DLOG(1.D0-PAR(J))
        IF(PAR(J).GT.(BOUND(PAR(J),SMALL)))THEN
           SUMD=-1.D0
           GO TO 20
        ENDIF
 10   CONTINUE
 20   TMLEN=SUMD
C
      RETURN
      END
C
C
C
      SUBROUTINE RETLOC(ICONDS,IP,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MODEL,NCHR
     1,NHYB,NLOCUS,NOBS,NPAN,PAR,PERM,RETAIN,RETEST,RETOBS,SELNUM)
C
C CALCULATE THE OBSERVED AND ESTIMATED PROBABILITIES OF LOCUS
C RETENTION GIVEN THE PARAMETER ESTIMATES FOR THE CURRENT LOCUS
C ORDER.
C
      IMPLICIT REAL*8(A-H,O-Z)
      INTEGER NOBS(MAXPAN,MAXHYB),PERM(MAXLOC),NCHR(MAXPAN)
     1,NHYB(MAXPAN),RETAIN(MAXPAN,MAXHYB,MAXLOC),SELNUM
      REAL*8 PAR(MAXPAR),RETEST(MAXPAN,MAXLOC),RETOBS(MAXPAN,MAXLOC)
C
      ONE=1.D0
C
C IF IP=0, GET RETENTION ESTIMATES FOR EACH PANEL ASSUMING PROPORTIONAL
C DISTANCES. IF IP>0, GET RETENTION ESTIMATES FOR INDIVIDUAL PANEL IP.
C
      IPANF=IP
      IPANL=IP
      IF(IP.EQ.0)THEN
        IPANF=1
        IPANL=NPAN
      ENDIF
C
C DETERMINE THE OBSERVED RETENTION PROBABILITIES FOR EACH LOCUS.
C SET THE ESTIMATED RETENTION VECTOR APPROPRIATELY FOR THE EQUAL
C RETENTION MODEL.
C
      DO 30 LOC=1,NLOCUS
        LOCUS=PERM(LOC)
        DO 20 IPAN=IPANF,IPANL
          NT=0
          NR=0
          DO 10 IHYB=1,NHYB(IPAN)
            IR=RETAIN(IPAN,IHYB,LOCUS)
            IF(IR.GT.1)GO TO 10
            NT=NT+NOBS(IPAN,IHYB)
            IF(IR.EQ.1)NR=NR+NOBS(IPAN,IHYB)
   10     CONTINUE
C
C IPSTAR=1 FOR A SINGLE PANEL WITH NON-PROPORTIONAL DISTANCES (IP>0), 
C IPSTAR=IPAN FOR PANEL IPAN OF NPAN WITH PROPORTIONAL DISTANCES (IP=0).
C
          IPSTAR=IPAN**(1-MIN0(1,IP))
          RETOBS(IPSTAR,LOC)=DBLE(NR)/DBLE(NT)
          RETEST(IPSTAR,LOC)=ONE-(ONE-PAR(NLOCUS+IPSTAR-1))**NCHR(IPAN)
   20   CONTINUE
   30 CONTINUE
C
C CALCULATE THE ESTIMATED RETENTION PROBABILITIES FOR EACH LOCUS.
C DISTINGUISH MODEL 4 FROM THE OTHER MODELS.  IF WE HAVE THE 
C UNCONDITIONAL EQUAL RETENTION MODEL, WE ARE DONE.
C
      IF(MODEL.EQ.1.AND.ICONDS.EQ.0)GO TO 240
C
      IF(MODEL.EQ.4)GO TO 80
      IF(MODEL.GT.4.OR.ICONDS.EQ.1)GO TO 130
C
C MODELS 2 AND 3:  FOR THE FIRST LOCUS, THE RETENTION ESTIMATE IS
C BASED ON THE RETENTION PARAMETER FOR THE FIRST LOCUS.
C PROD IS THE PROBABILITY OF NO BREAKS PRIOR TO THE CURRENT LOCUS.
C
      NPPAR=LOCP(1,MODEL,NLOCUS,NPAN)
      DO 70 IPAN=1,NPAN
        IF(IP.GT.0)NC=NCHR(IP)
        IF(IP.EQ.0)NC=NCHR(IPAN)
C
        IR=LOCR(IPAN,ISEL,MODEL,NLOCUS)
        RETEST(IPAN,1)=ONE-(ONE-PAR(IR))**NC
        PROD=1.D0
        PPAR=PAR(NPPAR)
        IF(IPAN.EQ.1)PPAR=1.D0
C
C FOR ALL SUBSEQUENT LOCI ...
C
        DO 60 LOC=2,NLOCUS
          TPAR=ONE-(ONE-PAR(LOC-1))**PPAR
          PROD=PROD*(ONE-TPAR)
C
          IF(MODEL.EQ.3)GO TO 40
C
C MODEL 2:  CENTROMERIC MODEL.
C
            RETEST(IPAN,LOC)=
     1      ONE-(ONE-PAR(IR)*PROD-PAR(IR+1)*(ONE-PROD))**NC
          GO TO 60
C
C MODEL 3:  LEFT-ENDPOINT MODEL.
C
   40     SUM=PAR(IR)
          PNEW=PROD
          DO 50 L=LOC,2,-1
            TPAR=ONE-(ONE-PAR(L-1))**PPAR
            SUM=SUM+PAR(IR-1+L)*TPAR/PNEW
            PNEW=PNEW/(ONE-TPAR)
   50     CONTINUE
          RETEST(IPAN,LOC)=ONE-(ONE-PROD*SUM)**NC
C
   60   NPPAR=NPPAR+1
C
   70 CONTINUE
      GO TO 240
C
C MODEL 4:  GENERAL MODEL. VALID ONLY FOR A SINGLE HAPLOID PANEL.
C
   80 DO 90 I=1,NLOCUS
        RETEST(1,I)=0.D0
   90 CONTINUE
C
      THJ1=1.D0
      DO 120 J=1,NLOCUS
        PROD=1.D0
        DO 110 K=J,NLOCUS
          THK=PAR(K)
          IF(K.EQ.NLOCUS)THK=1.D0
          DO 100 I=J,K
            IPAR=K-1+(NLOCUS+NLOCUS-J+1)*J/2
            RETEST(1,I)=RETEST(1,I)+THJ1*THK*PAR(IPAR)*PROD
  100     CONTINUE
          PROD=PROD*(ONE-PAR(K))
  110   CONTINUE
        THJ1=PAR(J)
  120 CONTINUE
      GO TO 240
C
C SELECTED LOCUS MODELS 5,6,7, AND CONDITIONAL MODELS:  PROD IS THE 
C PROBABILITY OF NO BREAKS BETEWEN THE CURRENT LOCUS AND THE SELECTED
C LOCUS. DETERMINE WHERE THE SELECTED LOCUS LIES IN THE CURRENT LOCUS
C ORDER.
C
  130 ISEL=0
      DO 140 I=1,NLOCUS
        IF(PERM(I).NE.SELNUM)GO TO 140
          ISEL=I
          GO TO 150
  140 CONTINUE
  150 CONTINUE
C
C DETERMINE THE LOCATION OF FIRST PROPORTIONALITY PARAMETER
C
      NPPAR=LOCP(1,MODEL,NLOCUS,NPAN)
      DO 230 IPAN=1,NPAN
        IF(IP.GE.1)NC=NCHR(IP)
        IF(IP.EQ.0)NC=NCHR(IPAN)
        PPAR=PAR(NPPAR)
        IF(IPAN.EQ.1)PPAR=1.D0
C
C DETERMINE THE LOCATION OF THE SELECTED LOCUS RETENTION PARAMETER.
C
        IR=LOCR(IPAN,ISEL,MODEL,NLOCUS)
        RETEST(IPAN,ISEL)=ONE-(ONE-PAR(IR))**NC
        IF(ICONDS.EQ.1)RETEST(IPAN,ISEL)=1.D0
C
C FOR ALL SUBSEQUENT LOCI IN BOTH DIRECTIONS FROM THE SELECTED LOCUS...
C
        LOC2=1
        LOC1=ISEL-1
        INC=-1
        DO 220 JPERM=0,1
          PROD=1.D0
          DO 210 LOC=LOC1,LOC2,INC
            TPAR=ONE-(ONE-PAR(LOC-JPERM))**PPAR
            PROD=PROD*(ONE-TPAR)
C
            IF(MODEL.EQ.7)GO TO 160
C
C MODELS 5 AND 6 AND CONDITIONAL MODELS:
C
              RS=PAR(IR)
              IADJ=1
              IF(JPERM.EQ.0.AND.MODEL.EQ.6)IADJ=-1
              IF(MODEL.EQ.1)IADJ=0
              RO=PAR(IR+IADJ)
              IF(MODEL.NE.1)RO=PAR(IR+IADJ)
              RSC=(ONE-RS)**NC
C
C UNCONDTIONAL MODELS:
C
              IF(ICONDS.EQ.0)
     1          RETEST(IPAN,LOC)=ONE-(ONE-RO-(RS-RO)*PROD)**NC
C
C CONDITIONAL MODELS:
C
              IF(ICONDS.EQ.1)
     1          RETEST(IPAN,LOC)=ONE-(((ONE-RO-(RS-RO)*PROD)**NC-
     2          (ONE-RO*(ONE-PROD))**NC*RSC)/(ONE-RSC))
            GO TO 210
C
C MODEL 7:  SELECTED LOCUS ENDPOINT MODEL.
C
  160         SUM=PAR(IR)
              PNEW=PROD
              IF(JPERM.EQ.0)GO TO 180
              DO 170 L=LOC,ISEL+1,-1
                TPAR=ONE-(ONE-PAR(L-1))**PPAR
                SUM=SUM+PAR(IR-ISEL+L)*TPAR/PNEW
                PNEW=PNEW/(ONE-TPAR)
  170         CONTINUE
            GO TO 200
  180         DO 190 L=LOC,ISEL-1
                TPAR=ONE-(ONE-PAR(L))**PPAR
                SUM=SUM+PAR(IR-ISEL+L)*TPAR/PNEW
                PNEW=PNEW/(ONE-TPAR)
  190         CONTINUE
  200       RETEST(IPAN,LOC)=ONE-(ONE-PROD*SUM)**NC
C
  210     CONTINUE
          LOC1=ISEL+1
          LOC2=NLOCUS
          INC=1
  220   CONTINUE
        NPPAR=NPPAR+1
  230 CONTINUE
C
  240 RETURN
      END
C 
C
C
      FUNCTION LOCR(IPAN,ISEL,MODEL,NLOCUS)                                
C                                                                          
C RETURN THE LOCATION IN PAR OF THE SELECTED LOCUS RETENTION 
C PROBABILITY, OR OF THE FIRST LOCUS RETENTION PROBABILITY IF THERE 
C IS NO SELECTED LOCUS.  NOT RELEVANT TO THE GENERAL MODEL (MODEL 4). 
C NOTE: STRUCTURE OF PAR IS EXPLAINED IN INITPM.
C
      IMPLICIT REAL*8(A-H,O-Z)                                             
C                                                                          
      GO TO (10,10,20,20,30,30,40) MODEL                                   
C                                                                          
C MODEL=1 OR 2.                                                            
C                                                                          
 10   LOCR=NLOCUS+(IPAN-1)*MODEL                                           
      GO TO 50                                                             
C                                                                          
C MODEL=3                                                                  
C                                                                          
 20   LOCR=NLOCUS*IPAN                                                     
      GO TO 50                                                             
C                                                                          
C MODEL=5 OR 6                                                             
C                                                                          
 30   LOCR=NLOCUS+(IPAN-1)*(MODEL-3)+MODEL-5                               
      GO TO 50                                                             
C                                                                          
C MODEL=7                                                                  
C                                                                          
 40   LOCR=NLOCUS*IPAN+ISEL-1                                              
 50   RETURN                                                               
      END                                                                  
C
C
C
      FUNCTION LOCP(IPAN,MODEL,NLOCUS,NPAN)                                
C                                                                          
C FOR PANEL IPAN(>1), RETURN THE LOCATION IN PAR OF THE CURRENT 
C PROPORTIONALITY PARAMETER.  FOR PANEL 1 (IPAN=1), RETURN LOCATION 
C PRIOR TO FIRST PROPORTIONALITY PARAMETER.                                               
C                                                                          
      IMPLICIT REAL*8(A-H,O-Z)                                             
C                                                                          
      GO TO (10,10,20,20,30,30,20) MODEL                                   
C                                                                          
C MODEL=1 OR 2                                                             
C                                                                          
 10   LOCP=NLOCUS+MODEL*NPAN+IPAN-2                                        
      GO TO 40                                                             
C                                                                          
C MODEL=3 OR 7                                                             
C                                                                          
 20   LOCP=NLOCUS*(NPAN+1)+IPAN-2                                          
      GO TO 40                                                             
C                                                                          
C MODEL=5 OR 6                                                             
C                                                                          
 30   LOCP=NLOCUS+(MODEL-3)*NPAN+IPAN-2                                    
 40   RETURN                                                               
      END                                                                  
C
C
C
      SUBROUTINE INFHYB(ALPHA,ALPHAP,BDISTC,BETA,BETAP,BINOM,BLIKE,BPERM
     1,BRKDST,BRKOBS,BRKTOT,BRLIST,BSTPAR,CHECK,CONDP,CONV,DF,DFHYB,DP
     2,DTRANS,EMSTEP,HDLIST,HLIST,HNAMET,HPROB,HPROBB,HYBMIN,ICONDS
     3,IMISS,INCHAR,INDEX,INPERM,IPROB,KITER,KOUT,MAXCHR,MAXHYB,MAXLOC
     4,MAXORD,MAXPAN,MAXPAR,MLTOPT,MODEL,MXITER,NBEST,NCHR,NCONV,NHYB
     5,NHYBT,NLOCUS,NOBS,NOBST,NPAN,NPAR,NRET,NTYPE,NUMHYB,NUMORD,OUTOPT
     6,PAR,PBREAK,PERM,PNAME,PRODMX,PRTMAX,RET,RETAIN,RETHYB,SELNUM
     7,SUBPRM,TOL,TRANS1,TRANSP,TRMISS,TYPED,USEINC)
C
C OUTPUT THE INFLUENTIAL HYBRID INFORMATION FOR THIS PROBLEM.
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*1 INCHAR(0:2)
      CHARACTER*4 HNAMET(MAXPAN,MAXHYB)
      CHARACTER*8 PNAME(MAXPAR)
      INTEGER BPERM(MAXORD,MAXLOC),BRKOBS(0:MAXLOC),BRLIST(0:MAXLOC)
     1,CHECK(MAXPAN,MAXHYB),HLIST(MAXPAN,MAXHYB),INDEX(NUMORD)
     2,INPERM(MAXLOC),NCHR(MAXPAN),NHYB(MAXPAN),NHYBT(MAXPAN)
     3,NUMHYB(MAXPAN),NOBS(MAXPAN,MAXHYB),NOBST(MAXPAN,MAXHYB),OUTOPT
     4,PERM(MAXLOC),RET(MAXPAN,MAXHYB,MAXLOC)
     5,RETAIN(MAXPAN,MAXHYB,MAXLOC),RETHYB(MAXLOC),TYPED(MAXLOC),USEINC
     6,SELNUM,SUBPRM(2,MAXLOC)
      REAL*4 BLIKE(MAXORD)
      REAL*8 ALPHA(MAXLOC,0:MAXCHR),ALPHAP(2,MAXLOC,0:MAXCHR,0:MAXCHR)
     1,BDISTC(0:MAXLOC,0:MAXCHR),BETA(MAXLOC,0:MAXCHR)
     2,BETAP(2,MAXLOC,0:MAXCHR),BINOM(0:MAXCHR,0:MAXCHR)
     3,BRKDST(0:MAXLOC),BRKTOT(0:MAXLOC),BSTPAR(MAXPAR),CONDP(MAXHYB)
     4,DF(MAXPAR),DFHYB(MAXHYB,MAXPAR),DP(MAXPAR)
     5,DTRANS(MAXLOC,0:MAXCHR,0:MAXCHR,3),HDLIST(MAXPAN,MAXHYB)
     6,HPROB(MAXPAN,MAXHYB),HPROBB(MAXPAN,MAXHYB),NRET(MAXLOC)
     7,NTYPE(MAXLOC),PAR(MAXPAR),PBREAK(2,0:MAXLOC,0:MAXCHR)
     8,PRODMX(0:MAXCHR,0:MAXCHR),TRANS1(MAXLOC,0:1,0:1)
     9,TRANSP(MAXLOC,0:MAXCHR,0:MAXCHR),TRMISS(0:MAXCHR,0:MAXCHR)
C
C RE-READ WITHOUT COMPRESSING RET TO GIVE RETAIN FOR THIS PROBLEM.
C RE-SET NOBS AND NHYB.  CHOOSE THE NEXT SET OF VALUES FROM RET.  IF
C THERE ARE ANY MISSING VALUES, WE MAY OPTIONALLY DELETE THEM IF
C USEINC=0.  DO THIS BY SETTING THE HYBRID TO ALL MISSING; THIS
C PRESERVES THE CORRESPONDENCE BETWEEN HYBRID NUMBERS HERE
C AND AS OUTPUT FOR THE RETENTION TABLE EARLIER.
C
      DO 40 IPAN=1,NPAN
       NHYB(IPAN)=NHYBT(IPAN)
       DO 30 IHYB=1,NHYB(IPAN)
        NOBS(IPAN,IHYB)=NOBST(IPAN,IHYB)
        DO 20 LOCUS=1,NLOCUS
          RETAIN(IPAN,IHYB,LOCUS)=RET(IPAN,IHYB,INPERM(LOCUS))
          IF(USEINC.EQ.1)GO TO 20
            IF(RETAIN(IPAN,IHYB,LOCUS).NE.2)GO TO 20
              DO 10 LOC=1,NLOCUS
                RETAIN(IPAN,IHYB,LOC)=2
   10         CONTINUE
              GO TO 30
   20   CONTINUE
   30  CONTINUE
   40 CONTINUE
C
C CALCULATE THE NUMBER OF PARAMETERS.
C
      NPAR=NUMPAR(MLTOPT,MODEL,NLOCUS,NPAN)
C
C IF THERE WERE TOO MANY ORDERS TO SORT OR IF THERE IS ONLY ONE, OUTPUT
C AN ERROR MESSAGE AND RETURN.  IN CASE SIMULATED ANNEALING WAS DONE,
C MAKE SURE THAT THERE ARE AT LEAST TWO GOOD LOCUS ORDERS.
C
      NMAX=NUMORD
      IF(NBEST.GT.0.AND.NBEST.LT.NUMORD)NMAX=NBEST
      IF(BLIKE(INDEX(2))-BLIKE(INDEX(1)).GT.PRTMAX)NMAX=1
C
      IF(NUMORD.LE.MAXORD.AND.NMAX.GT.1)GO TO 50
        WRITE(KOUT,101)NMAX,MAXORD
 101    FORMAT(///' THE NUMBER OF ORDERS ',I8,' EXCEEDED THE ',
     1  ' MAXIMAL NUMBER OF '/' ORDERS',I8,', OR THE NUMBER OF',
     2  ' ORDERS TO COMPARE WAS ONLY ONE.'/' NO INFLUENTIAL HYBRID',
     3  ' STATISTICS WERE PRINTED.')
        GO TO 230
C
C CALCULATE THE HYBRID LOG-LIKELIHOODS FOR THE BEST LOCUS ORDER.
C STORE THEM IN HPROBB.
C
   50 DO 60 J=1,NLOCUS
        PERM(J)=BPERM(INDEX(1),J)
   60 CONTINUE
C
      CALL MAXLIK(ALPHA,ALPHAP,BETA,BETAP,BINOM,BRLIST,CHECK,CONDP
     1,CONV,DF,DFHYB,DP,DTRANS,EMSTEP,F,HPROBB,ICONDS,KITER,KOUT
     2,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MLTOPT,MODEL,MXITER,NCHR
     3,NCONV,NHYB,NLOCUS,NOBS,NPAN,NPAR,NRET,NTYPE,NUMHYB,OUTOPT,BSTPAR
     4,PERM,PNAME,RETAIN,SELNUM,SUBPRM,TOL,TRANS1,TRANSP)
C
C FOR EACH NEARLY BEST LOCUS ORDER, MAXIMIZE THE LOG-LIKELIHOOD AND
C COMPUTE THE HYBRID-BY-HYBRID DIFFERENCES HPROBB-HPROB.  PRINT THE
C DIFFERENCES THAT ARE SUFFICIENTLY LARGE.
C
      WRITE(KOUT,102)HYBMIN
 102  FORMAT(///' INFLUENTIAL HYBRIDS FOR THE MOST LIKELY ORDERS.',
     1'  MIN. DIFFERENCE: ',F8.5//' PANEL  RANK    HYBRID CLASS AND',
     2' LOG10-LIKELIHOOD DIFFERENCES (OTHER-BEST)'/)
C
      BESTLK=F
      DO 100 IRANK=2,NMAX
        IF(BLIKE(INDEX(IRANK))+BESTLK.GT.PRTMAX)GO TO 110
        DO 70 J=1,NLOCUS
          PERM(J)=BPERM(INDEX(IRANK),J)
   70   CONTINUE
C
        CALL MAXLIK(ALPHA,ALPHAP,BETA,BETAP,BINOM,BRLIST,CHECK,CONDP
     1 ,CONV,DF,DFHYB,DP,DTRANS,EMSTEP,F,HPROB,ICONDS,KITER,KOUT,MAXCHR
     2 ,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MLTOPT,MODEL,MXITER,NCHR,NCONV,NHYB
     3 ,NLOCUS,NOBS,NPAN,NPAR,NRET,NTYPE,NUMHYB,OUTOPT,PAR,PERM,PNAME
     4 ,RETAIN,SELNUM,SUBPRM,TOL,TRANS1,TRANSP)
C
        DO 90 IPAN=1,NPAN
          NDIFF=0
          DO 80 IHYB=1,NHYB(IPAN)
            DIFF=DLOG10(HPROB(IPAN,IHYB)/HPROBB(IPAN,IHYB))
            IF(DABS(DIFF).LT.HYBMIN)GO TO 80
            NDIFF=NDIFF+1
            HLIST(IPAN,NDIFF)=IHYB
            HDLIST(IPAN,NDIFF)=DIFF
   80     CONTINUE
C
          IF(NDIFF.EQ.0)THEN
            WRITE(KOUT,103)IPAN,IRANK
          ELSE
            WRITE(KOUT,104)IPAN,IRANK,(HLIST(IPAN,I),I=1,NDIFF)
            WRITE(KOUT,105)(HDLIST(IPAN,I),I=1,NDIFF)
          ENDIF
   90   CONTINUE
  100 CONTINUE
 103  FORMAT(/I4,2X,I5,'   NO INFLUENTIAL HYBRIDS IDENTIFIED.')
 104  FORMAT(/I4,2X,I5,2X,11I6,90(/13X,11I6))
 105  FORMAT(13X,11F6.2)
C
C IF WE ARE USING THE GENERAL MODEL, SKIP THE FOLLOWING SECTION -- 
C WE CAN'T COMPUTE THE DISTRIBUTION OF OBLIGATE BREAKS.
C
  110 IF(MODEL.EQ.4)WRITE(KOUT,106)
 106  FORMAT(///' DISTRIBUTION OF OBLIGATE BREAKS NOT SUPPORTED FOR'
     1,' THE GENERAL MODEL.')
C
      IF(MODEL.EQ.4)GO TO 230
C
C IF WE ARE USING A SELECTED LOCUS MODEL (ICONDS=1 AND MODEL=1 OR
C ICONDS=0 OR ICONDS=1 AND MODEL=5, 6, OR 7), AND THERE ARE SOME HYBRIDS
C FOR WHICH THE SELECTED LOCUS IS NOT TYPED (IMISS>0), CALCULATE THE 
C DISTRIBUTION OF OBLIGATE BREAKS AS IF THERE WERE NO UNTYPED DATA 
C FOR THAT LOCUS.  PRINT A WARNING TO LET THE USER KNOW WHATS HAPPENING.
C
      IF(IMISS.GT.0)WRITE(KOUT,107)
 107  FORMAT(///' *** WARNING *** THE SELECTED LOCUS IS ONLY PARTIALLY'
     1,' TYPED.',/17X,'INCOMPLETE TYPING OF THE SELECTED LOCUS IS NOT'
     2,/17X,'SUPPORTED IN CALCULATION OF THE DISTRIBUTION OF' 
     3,/17X,'OBLIGATE BREAKS. THE DISTRIBUTION WILL BE COMPUTED'
     4,/17X,'ASSUMING COMPLETE TYPING AT THIS LOCUS.')
C
C OUTPUT THE RETENTION STATUS DATA ACCORDING TO THE BEST LOCUS ORDER
C TOGETHER WITH THE NUMBER OF OBLIGATE BREAKS AND THE EXPECTED NUMBER
C OF OBLIGATE BREAKS AND THE STANDARDIZED RESIDUAL GIVEN THE TYPING
C PATTERN.  
C
      WRITE(KOUT,108)IPROB
 108  FORMAT(///' RETENTION DATA PERMUTED IN THE BEST LOCUS ORDER FOR ',
     1'PROBLEM',I5)
C
C DETERMINE THE BINOMIAL COEFFICIENTS NEEDED FOR LATER CALCULATIONS.
C
      CALL COMB(BINOM,MAXCHR,MAXCHR)
C
C LOAD THE BEST LOCUS ORDER INTO PERM.
C
      DO 120 J=1,NLOCUS
         PERM(J)=BPERM(INDEX(1),J)
  120 CONTINUE
C
C IF THERE IS A SELECTED LOCUS, DETERMINE WHERE IT LIES IN THE 
C CURRENT ORDER.
C
      IF(SELNUM.EQ.0)GO TO 140
      ISEL=0
      DO 130 I=1,NLOCUS
        IF(PERM(I).NE.SELNUM)GO TO 130
        ISEL=I
        GO TO 140
  130 CONTINUE
C
C FOR EACH HYBRID PANEL. . .
C
  140 DO 220 IPAN=1,NPAN
C
C IF WE HAVE MULTIPLE PANELS AND NON-PROPORTIONAL DISTANCES,  RECALCULATE
C THE PARAMETERS FOR EACH PANEL.
C
        IF(MLTOPT.EQ.0.AND.NPAN.GT.1)
     1    CALL MAXL1(ALPHA,ALPHAP,BETA,BETAP,BINOM,BRLIST,CHECK,CONDP
     2   ,CONV,DF,DFHYB,DP,DTRANS,EMSTEP,F,HPROB,ICONDS,IPAN,KITER,KOUT
     3   ,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MLTOPT,MODEL,MXITER,NCHR
     4   ,NCONV,NHYB,NLOCUS,NOBS,1,NPAR,NRET,NTYPE,NUMHYB,OUTOPT,BSTPAR
     5   ,PERM,PNAME,RETAIN,SELNUM,SUBPRM,TOL,TRANS1,TRANSP)
C
C WRITE THE HEADER FOR THIS HYBRID PANEL SET.
C
        WRITE(KOUT,109)(BPERM(INDEX(1),I),I=1,NLOCUS)
 109    FORMAT(//' PANEL HYBRID HYBRID  NUMBER   OBLIGATE BREAKS',
     1  '   LOCUS ORDER'/6X,' NUMBER  NAME  OBSERVED  O   E    TAILPR '
     2  ,1X,15I3,70(/48X,15I3))
C
C BEGIN BY CALCULATING THE HAPLOID AND POLYPLOID TRANSITION
C PROBABILITIES.  INITIALIZE THE BREAKAGE PROBABILITY DISTRIBUTIONS.
C IPSTAR=1 AND NPSTAR=1 FOR NON-PROPORTIONAL MODELS, ARE IPAN AND NPAN
C FOR PROPORTIONAL MODELS.
C
        IPSTAR=IPAN**MLTOPT
        NPSTAR=NPAN**MLTOPT
        CALL HTRANS(IPSTAR,ISEL,MAXLOC,MAXPAR,MODEL,NLOCUS,NPSTAR
     1  ,BSTPAR,TRANS1)
        CALL DPTRAN(BINOM,DTRANS,IPSTAR,ISEL,MAXCHR,MAXLOC,MAXPAR
     1  ,MODEL,NCHR(IPAN),NLOCUS,NPSTAR,BSTPAR,TRANS1,TRANSP)
C
        MAXBRK=0
        NLOCM1=NLOCUS-1
        DO 150 I=0,NLOCM1
          BRKTOT(I)=0.D0
          BRKOBS(I)=0
  150   CONTINUE
C
        INDEX1=INDEX(1)
        DO 180 IHYB=1,NHYB(IPAN)
C
          NUMBRK=0
          IROLD=RETAIN(IPAN,IHYB,BPERM(INDEX1,1))
          RETHYB(1)=IROLD
          DO 160 LOCUS=2,NLOCUS
            IRNEW=RETAIN(IPAN,IHYB,BPERM(INDEX1,LOCUS))
            RETHYB(LOCUS)=IRNEW
            IF(IROLD.EQ.IRNEW.OR.IRNEW.EQ.2)GO TO 160
              IF(IROLD+IRNEW.EQ.1)NUMBRK=NUMBRK+1
              IROLD=IRNEW
  160     CONTINUE
C
          IF(MODEL.LE.3.)
     1      CALL BRPROB(BINOM,BRKDST,BSTPAR,EBREAK,ICONDS,IPSTAR,ISEL
     2      ,MAXCHR,MAXLOC,MAXPAR,MODEL,NCHR(IPAN),NLOCUS,NPSTAR,NTYPEH
     3      ,NUMBRK,PBREAK,PRODMX,RETHYB,TAILPR,TRANSP,TRMISS,TYPED)
C
          IF(MODEL.GE.5)
     1      CALL BRPRBS(BDISTC,BINOM,BRKDST,BSTPAR,EBREAK,ICONDS,IPSTAR
     2      ,ISEL,MAXCHR,MAXLOC,MAXPAR,MODEL,NCHR(IPAN),NLOCUS,NTYPEH
     3      ,NUMBRK,PBREAK,PRODMX,RETHYB,TAILPR,TRANSP,TRMISS,TYPED)
C
          WRITE(KOUT,111)IPAN,IHYB,HNAMET(IPAN,IHYB),NOBS(IPAN,IHYB),
     1    NUMBRK,EBREAK,TAILPR,
     2    (INCHAR(RETAIN(IPAN,IHYB,BPERM(INDEX(1),J))),J=1,NLOCUS)
 111      FORMAT(I5,1X,I5,4X,A4,I7,I6,F5.1,F9.4,2X,15(2X,A1),70(/48X,15
     1    (2X,A1)))
C
C UPDATE THE OVERALL BREAKAGE DISTRIBUTIONS.
C
          BRKOBS(NUMBRK)=BRKOBS(NUMBRK)+NOBS(IPAN,IHYB)
          IF(NUMBRK.GT.MAXBRK)MAXBRK=NUMBRK
          IF(NTYPEH.EQ.0)BRKTOT(0)=BRKTOT(0)+NOBS(IPAN,IHYB)
          IF(NTYPEH.EQ.0)GO TO 180
            NTYPE1=NTYPEH-1
            DO 170 I=0,NTYPE1
              BRKTOT(I)=BRKTOT(I)+BRKDST(I)*NOBS(IPAN,IHYB)
  170       CONTINUE
  180   CONTINUE
C
C COMPARE THE OBSERVED DISTRIBUTION OF THE NUMBER OF OBLIGATE BREAKS TO
C THAT PREDICTED ON THE BASIS OF THE BREAKAGE AND RETENTION PROBABILITY
C ESTIMATES.  CONSIDER BOTH THE OBSERVED TYPING PATTERN, AND THE
C ASSUMPTION OF COMPLETE TYPING.
C
        MAXB1=MAXBRK+1
        REMPR=0.D0
        DO 190 I=MAXB1,NLOCM1
          REMPR=REMPR+BRKTOT(I)
  190   CONTINUE
        WRITE(KOUT,112)(I,I=0,MAXBRK)
 112    FORMAT(//' DISTRIBUTION OF THE NUMBER OF OBLIGATE CHROMOSOME',
     1  ' BREAKS'//' BREAKS          ',8I7,100(/17X,8I7))
        WRITE(KOUT,113)(BRKOBS(I),I=0,MAXBRK)
 113    FORMAT(' OBS             ',8I7,100(/17X,8I7))
        WRITE(KOUT,114)(BRKTOT(I),I=0,MAXBRK),REMPR
 114    FORMAT(' EXP (PARTIAL)   ',8F7.2,100(/17X,8F7.2))
C
        DO 200 I=1,NLOCUS
          RETHYB(I)=1
  200   CONTINUE
        IF(MODEL.LE.3)
     1    CALL BRPROB(BINOM,BRKDST,BSTPAR,EBREAK,ICONDS,IPSTAR,ISEL
     2    ,MAXCHR,MAXLOC,MAXPAR,MODEL,NCHR(IPAN),NLOCUS,NPSTAR,NTYPEH
     3    ,NUMBRK,PBREAK,PRODMX,RETHYB,TAILPR,TRANSP,TRMISS,TYPED)
        IF(MODEL.GE.5)
     1    CALL BRPRBS(BDISTC,BINOM,BRKDST,BSTPAR,EBREAK,ICONDS,IPSTAR
     2    ,ISEL,MAXCHR,MAXLOC,MAXPAR,MODEL,NCHR(IPAN),NLOCUS
     3    ,NTYPEH,NUMBRK,PBREAK,PRODMX,RETHYB,TAILPR,TRANSP,TRMISS
     4    ,TYPED)
        REMPR=0.D0
        DO 210 I=MAXB1,NLOCM1
          REMPR=REMPR+BRKDST(I)
  210   CONTINUE
        WRITE(KOUT,115)(NUMHYB(IPAN)*BRKDST(I),I=0,MAXBRK)
     1  ,NUMHYB(IPAN)*REMPR
 115    FORMAT(' EXP (COMPLETE)  ',8F7.2,100(/17X,8F7.2))
C
  220 CONTINUE
  230 RETURN
      END
C
C
C
      SUBROUTINE INITPM(IP,ISEL,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MODEL
     1,NCHR,NHYB,NLOCUS,NOBS,NPAN,NRET,NTYPE,PAR,PERM,RETAIN)
C
C CALCULATE INITIAL ESTIMATES FOR RETENTION AND BREAKAGE PROBABILITIES
C AND PROPORTIONALITY PARAMETERS FOR HAPLOID OR POLYPLOID DATA, SINGLE 
C OR MULTIPANEL CASE FOR ALL BUT THE GENERAL RETENTION MODEL (MODEL=4).
C
C           ****GENERAL STRUCTURE OF PARAMETER VECTOR****
C
C NRET=NUMBER OF RETENTION PARAMETERS IN THE MODEL (EQUAL=1, 
C      CENTRO & S1=2, S2=3, LEFT-ENDPT & S3=NLOCUS)
C
C PAR(1)->PAR(NLOCUS-1): BREAKAGE PROBABILITIES
C PAR(NLOCUS)->PAR(NLOCUS+NRET-1): RETENTION PROBABILITIES
C 
C FOR CENTROMERIC MODEL, PAR(NLOCUS) IS R(C), PAR(NLOCUS+1) IS R
C FOR S1, PAR(NLOCUS) IS R(S), PAR(NLOCUS+1) IS R(O)
C FOR S2, PAR(NLOCUS) IS R(R), PAR(NLOCUS+1) IS R(S), 
C                  AND PAR(NLOCUS+2) IS R(L)
C
C FOR LEFT ENDPOINT AND S3, PAR(NLOCUS-1+I) IS R(I)
C
C ****STRUCTURE OF PARAMETER VECTOR PAR FOR PRORTIONAL PANEL MODELS:****
C
C PAR(1)->PAR(NLOCUS-1):  BREAKAGE PROBABILITIES
C
C PAR(NLOCUS+(IPAN-1)*NRET)->PAR(NLOCUS+IPAN*NRET-1): RETENTION PROBS. 
C                                                     FOR PANEL IPAN
C    (IPAN=1,. . .,NPAN)
C
C PAR(NLOCUS+NPAN*NRET+IPAN-2): PROPORTIONALITY CONSTANT FOR PANEL IPAN
C    (IPAN=2,. . .,NPAN)
C
C NOTE:  IF THE DISTANCES ARE PROPORTIONAL, THE DISTANCE BETWEEN TWO
C        MARKERS IN PANEL IPAN EQUALS THE DISTANCE IN PANEL 1 TIMES
C        THE PROPORTIONALITY PARAMETER FOR PANEL IPAN:
C        D(IPAN)=PROP(IPAN)D(1).
C        THEREFORE: D(1)=D(IPAN)/PROP(IPAN)
C            OR:    THETA(1)=1-(1-THETA(IPAN))**(1/PROP(IPAN))
C
      IMPLICIT REAL*8(A-H,O-Z)
      INTEGER NCHR(MAXPAN),NOBS(MAXPAN,MAXHYB),PERM(MAXLOC)
     1,RETAIN(MAXPAN,MAXHYB,MAXLOC),NHYB(MAXPAN)
      REAL*8 NRET(MAXLOC),NRTOT,NRTOT2,NTTOT,NTTOT2
     1,NTYPE(MAXLOC),PAR(MAXPAR),NRLTOT,NTLTOT,NTRTOT,NRRTOT
C
C INITIALIZE.
C
      NLOC1=NLOCUS-1
      SMALL=1.D-5
C
C IF IP=0, WE HAVE THE PROPORTIONAL DISTANCE MODEL, AND NEED TO LOOP THROUGH
C ALL HYBRID PANELS.  IF IP>0, WE HAVE THE NON-PROPORTIONAL DISTANCE
C MODEL AND NEED ONLY TO CONSIDER THE PRESENT PANEL (IP).
C
      IPANF=1
      IPANL=NPAN
      IF(IP.GT.0)IPANF=IP
      IF(IP.GT.0)IPANL=IP
C
C FOR EACH HYBRID PANEL . . .
C
      DO 80 IPAN=IPANF,IPANL
        CHR1=1.D0/DBLE(NCHR(IPAN))
        NRTOT=0.D0
        NTTOT=0.D0
        NRLTOT=0.D0
        NTLTOT=0.D0
C
C COUNT THE NUMBERS OF TYPED AND RETAINED HYBRIDS FOR EACH LOCUS, FOR
C ALL LOCI COMBINED, AND FOR LOCI TO THE LEFT OF THE SELECTED LOCUS.
C SAVE THE LOCUS-SPECIFIC RETENTION PROBABILITY ESTIMATES IN NRET.
C
        DO 20 LOC=1,NLOCUS
          LOCUS=PERM(LOC)
          NR=0
          NT=0
          NRL=0
          NTL=0
          DO 10 IHYB=1,NHYB(IPAN)
            IR=RETAIN(IPAN,IHYB,LOCUS)
            IF(IR.GT.1)GO TO 10
              IF(IR.EQ.1)NR=NR+NOBS(IPAN,IHYB)
              NT=NT+NOBS(IPAN,IHYB)
              IF(LOC.GE.ISEL)GO TO 10
                IF(IR.EQ.1)NRL=NRL+NOBS(IPAN,IHYB)
                NTL=NTL+NOBS(IPAN,IHYB)
   10     CONTINUE
          NRET(LOC)=DBLE(NR)
          NTYPE(LOC)=DBLE(NT)
          NRTOT=NRTOT+DBLE(NR)
          NTTOT=NTTOT+DBLE(NT)
          NRLTOT=NRLTOT+DBLE(NRL)
          NTLTOT=NTLTOT+DBLE(NTL)
   20   CONTINUE
C
C DETERMINE THE LOCATION OF THE CURRENT RETENTION PARAMETER.
C
        IP1=IPAN
        IF(IP.GT.0)IP1=1
        IS=LOCR(IP1,ISEL,MODEL,NLOCUS)
C
C ESTIMATE THE RETENTION PROBABILITIES.
C
        GO TO (30,40,50,50,40,70,50) MODEL
C
C EQUAL RETENTION MODEL.  POOL OVER ALL LOCI FOR RETENTION.
C FOR THE CONDITIONAL EQUAL RETENTION MODEL, DO NOT USE RETENTION
C FROM THE SELECTED LOCUS IN THE ESTIMATE.
C
   30   IF(ISEL.GT.0)THEN
          NRTOT=NRTOT-NRET(ISEL)
          NTTOT=NTTOT-NTYPE(ISEL)
        ENDIF
        R=1.D0-(1.D0-NRTOT/NTTOT)**CHR1
        PAR(IS)=BOUND(R,SMALL)
        GO TO 80
C
C CENTROMERIC OR S1 SELECTED LOCUS RETENTION. USE THE FIRST (SELECTED) 
C LOCUS TO ESTIMATE R1 [R(S)].  POOL OVER THE REMAINING LOCI FOR R2 
C [R(O)].  NOTE:  THIS IGNORES THE DEPENDENCE OF RETENTION AT OTHER 
C LOCI ON THERETENTION PROBABILITY OF LOCUS 1 (LOCUS S).
C
   40   I=ISEL
        IF(MODEL.EQ.2)I=1
        R1=1.D0-(1.D0-NRET(I)/NTYPE(I))**CHR1
        PAR(IS)=BOUND(R1,SMALL)
        NRTOT2=NRTOT-NRET(I)
        NTTOT2=NTTOT-NTYPE(I)
        R2=1.D0-(1.D0-NRTOT2/NTTOT2)**CHR1
        PAR(IS+1)=BOUND(R2,SMALL)
        GO TO 80
C
C ENDPOINT MODELS.  ESTIMATE LOCUS-SPECIFIC RETENTION PROBABILITIES.
C NOTE:  THIS IGNORES THE DEPENDENCE OF RETENTION AT A LOCUS ON THE
C RETENTION PROBABILITIES AT THE PRECEDING LOCI.
C
   50   DO 60 LOC=1,NLOCUS
          RL=1.D0-(1.D0-NRET(LOC)/NTYPE(LOC))**CHR1
          PAR(NLOCUS*IP1+LOC-1)=BOUND(RL,SMALL)
   60   CONTINUE
        GO TO 80
C
C S2 MODEL. USE THE SELECTED LOCUS TO ESTIMATE R(S).  POOL OVER THE 
C REMAININGLOCI ON EITHER SIDE OF LOCUS S TO ESTIMATE RL AND RR.  NOTE:  
C THIS IGNORESTHE DEPENDENCE OF RETENTION AT LATER LOCI ON THE RETENTION 
C PROBABILITYOF LOCUS S.  IF THE SELECTED LOCUS IS THE FIRST OR LAST 
C LOCUS, THEN THE LEFT OR RIGHT RETENTION PROBABILITY IS SET TO 0.0.
C
   70   RS=1.D0-(1.D0-NRET(ISEL)/NTYPE(ISEL))**CHR1
        PAR(IS)=BOUND(RS,SMALL)
        RL=0.D0
        IF(NTLTOT.GT.0.D0)RL=1.D0-(1.D0-NRLTOT/NTLTOT)**CHR1
        PAR(IS-1)=BOUND(RL,SMALL)
        NTRTOT=NTTOT-NTLTOT-NTYPE(ISEL)
        NRRTOT=NRTOT-NRLTOT-NRET(ISEL)
        RR=0.D0
        IF(NTRTOT.GT.0.D0)RR=1.D0-(1.D0-NRRTOT/NTRTOT)**CHR1
        PAR(IS+1)=BOUND(RR,SMALL)
        IF(ISEL.EQ.1)PAR(IS-1)=0.D0
        IF(ISEL.EQ.NLOCUS)PAR(IS+1)=0.D0
   80   CONTINUE
C
C ESTIMATE PROPORTIONALITY PARAMETERS FOR PANELS 2,...,NPAN IF RELEVANT.
C
        IF(NPAN.EQ.1.OR.IP.GT.0) GO TO 120
C
C DETERMINE THE TOTAL ESTIMATED MAP LENGTH FOR EACH PANEL. USE IT TO
C ESTIMATE THE PROPORTIONALITY PARAMETERS FOR PANELS 2,...,NPAN.
C
        NPPAR=LOCP(1,MODEL,NLOCUS,NPAN)
        DO 110 IPAN=IPANF,IPANL
          CHR1=1.D0/DBLE(NCHR(IPAN))
          TLEN=0.D0
          DO 100 LOC1=1,NLOC1
            LOCUS1=PERM(LOC1)
            LOCUS2=PERM(LOC1+1)
            N00=0
            N11=0
            NBOTH=0
            DO 90 IHYB=1,NHYB(IPAN)
              IWT=NOBS(IPAN,IHYB)
              IR1=RETAIN(IPAN,IHYB,LOCUS1)
              IR2=RETAIN(IPAN,IHYB,LOCUS2)
              IF(IR1.GT.1.OR.IR2.GT.1)GO TO 90
              NBOTH=NBOTH+IWT
              IF(IR1+IR2.EQ.0)N00=N00+IWT
              IF(IR1+IR2.EQ.2)N11=N11+IWT
   90       CONTINUE
            P00=DBLE(N00)/NBOTH
            P11=DBLE(N11)/NBOTH
            RPAIR=1.D0-((1.D0+P00-P11)/2.D0)**CHR1
            RPAIR=BOUND(RPAIR,SMALL)
            TH=(1.D0-RPAIR-P00**CHR1)/RPAIR/(1.D0-RPAIR)
            TH=BOUND(TH,SMALL)
            TLEN=TLEN-DLOG(1.D0-TH)
  100     CONTINUE
          IF(IPAN.EQ.1)TLEN1=TLEN
          IF(IPAN.GT.1)PAR(NPPAR)=TLEN/TLEN1
          NPPAR=NPPAR+1
  110   CONTINUE
C
C ESTIMATE BREAKAGE PROBABILITIES FOR EACH LOCUS.  FOR PROPORTIONAL
C PANEL MODELS, USE THE BREAKAGE ESTIMATES FOR THE 2,...,NTH PANEL,
C MODIFIED BY THE ESTIMATE OF THE PROPORTIONALITY CONSTANT.
C
  120   DO 150 LOC1=1,NLOC1
        THLOC1=0.D0
        LOCUS1=PERM(LOC1)
        LOCUS2=PERM(LOC1+1)
        NPPAR=LOCP(1,MODEL,NLOCUS,NPAN)
C
        DO 140 IPAN=IPANF,IPANL
          CHR1=1.D0/DBLE(NCHR(IPAN))
          N00=0
          N11=0
          NBOTH=0
          PPARI=1.D0
          IF(IPAN.GT.1.AND.IP.EQ.0)PPARI=1.D0/PAR(NPPAR)
          DO 130 IHYB=1,NHYB(IPAN)
            IWT=NOBS(IPAN,IHYB)
            IR1=RETAIN(IPAN,IHYB,LOCUS1)
            IR2=RETAIN(IPAN,IHYB,LOCUS2)
            IF(IR1.GT.1.OR.IR2.GT.1)GO TO 130
              NBOTH=NBOTH+IWT
              IF(IR1+IR2.EQ.0)N00=N00+IWT
              IF(IR1+IR2.EQ.2)N11=N11+IWT
  130     CONTINUE
          P00=DBLE(N00)/NBOTH
          P11=DBLE(N11)/NBOTH
          RPAIR=1.D0-((1.D0+P00-P11)/2.D0)**CHR1
          RPAIR=BOUND(RPAIR,SMALL)
          TH=(1.D0-RPAIR-P00**CHR1)/RPAIR/(1.D0-RPAIR)
          THLOC1=THLOC1+(1.D0-(1.D0-BOUND(TH,SMALL))**PPARI)
          NPPAR=NPPAR+1
  140   CONTINUE
        PAR(LOC1)=BOUND(THLOC1/NPAN,SMALL)
  150 CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE INITPG(IP,MAXHYB,MAXLOC,MAXPAN,MAXPAR,NHYB,NLOCUS
     1,NOBS,NRET,NTYPE,PAR,PERM,RETAIN)
C
C CALCULATE INITIAL ESTIMATES FOR RETENTION AND BREAKAGE PROBABILITIES
C FOR THE GENERAL RETENTION MODEL AND HAPLOID DATA.  ASSUME ONLY A
C SINGLE PANEL OF HYBRID DATA.
C
      IMPLICIT REAL*8(A-H,O-Z)
      INTEGER NOBS(MAXPAN,MAXHYB),PERM(MAXLOC)
     1,RETAIN(MAXPAN,MAXHYB,MAXLOC)
      REAL*8 N(0:2,0:2),NRET(MAXLOC),NTOT,NTTOT,NRTOT
     2,NTYPE(MAXLOC),PAR(MAXPAR)
C
      SMALL=1.D-5
C
C COUNT THE NUMBERS OF TYPED AND RETAINED HYBRIDS FOR EACH LOCUS.
C KEEP TRACK OF THE TOTALS FOR EACH IN CASE WE ARE USING MODEL 1 OR 2.
C
      NTTOT=0.D0
      NRTOT=0.D0
      DO 20 LOC=1,NLOCUS
        LOCUS=PERM(LOC)
        NT=0
        NR=0
        DO 10 IHYB=1,NHYB
          IR=RETAIN(IP,IHYB,LOCUS)
          IF(IR.GT.1)GO TO 10
            NT=NT+NOBS(IP,IHYB)
            IF(IR.EQ.1)NR=NR+NOBS(IP,IHYB)
   10   CONTINUE
        NTYPE(LOC)=DBLE(NT)
        NRET(LOC)=DBLE(NR)
        NTTOT=NTTOT+DBLE(NT)
        NRTOT=NRTOT+DBLE(NR)
   20 CONTINUE
C
C ESTIMATE THE RETENTION PROBABILITIES FOR EACH LOCUS.  THE PARAMETER
C VECTOR WILL HAVE NLOCUS-1 PAIRWISE MOM BREAKAGE ESTIMATES, NLOCUS
C UNIVARIATE RETENTION ESTIMATES, AND NLOCUS*(NLOCUS-1)/2 PAIRWISE
C RETENTION ESTIMATES.
C
      DO 50 LOC1=1,NLOCUS
        LOCUS1=PERM(LOC1)
        R1=NRET(LOC1)/NTYPE(LOC1)
C
        DO 40 LOC2=LOC1,NLOCUS
          LOCUS2=PERM(LOC2)
          R2=NRET(LOC2)/NTYPE(LOC2)
C
C COUNT THE NUMBERS OF THE DIFFERENT TWO-LOCUS PATTERNS.
C
          N(0,0)=0.D0
          N(0,1)=0.D0
          N(1,0)=0.D0
          N(1,1)=0.D0
C
          DO 30 IHYB=1,NHYB
            IR1=RETAIN(IP,IHYB,LOCUS1)
            IR2=RETAIN(IP,IHYB,LOCUS2)
            N(IR1,IR2)=N(IR1,IR2)+NOBS(IP,IHYB)
   30     CONTINUE
          NTOT=N(0,0)+N(0,1)+N(1,0)+N(1,1)
C
C CALCULATE COX'S ESTIMATE OF THE BREAKAGE PROBABILITY FOR THIS
C LOCUS PAIR.  IF THIS IS AN ADJANCENT LOCUS PAIR, STORE THE
C ESTIMATE IN THE PARAMETER VECTOR.  ALSO CALCULATE A TWO-LOCUS
C RETENTION ESTIMATE USING COX'S METHOD OF MOMENTS ESTIMATOR.
C STORE IT IN THE PARAMETER VECTOR.  THE PARAMETER VECTOR HAS (IN
C ORDER) THETA(1), THETA(2), ..., THETA(NLOCUS-1), R(1,1), R(1,2), ...,
C R(1,NLOCUS), R(2,2), R(2,3), ..., R(2,NLOCUS), ...., R(NLOCUS,NLOCUS).
C
          COXTH=0.D0
          DENOM=R1+R2-2.D0*R1*R2
          IF(DENOM.GT.SMALL)COXTH=(N(0,1)+N(1,0))/NTOT/DENOM
          COXTH=BOUND(COXTH,SMALL)
          IF(LOC2-LOC1.EQ.1)PAR(LOC1)=COXTH
C
          R12=(N(1,1)/NTOT-COXTH*R1*R2)/(1.D0-COXTH)
          PAR(NLOCUS*LOC1+LOC2-1-LOC1*(LOC1-1)/2)=BOUND(R12,SMALL)
   40   CONTINUE
   50 CONTINUE
C
      RETURN
      END
C
C
C
      FUNCTION BOUND(X,SMALL)
C
C BOUND THE VALUE X AWAY FROM ZERO AND ONE.
C
      IMPLICIT REAL*8(A-H,O-Z)
C
      BOUND=X
      IF(X.LT.SMALL)BOUND=SMALL
      IF(X.GT.1.D0-SMALL)BOUND=1.D0-SMALL
C
      RETURN
      END
C
C
C
      SUBROUTINE QUADEQ(A,B,C,NROOT,ROOT)
C
C FIND THE NROOT REAL ROOTS OF THE QUADRATIC EQUATION AX**2+BX+C=0.
C
C REFERENCE:  PRESS WH, FLANNERY BP, TEUKOLSKY SA, VETTERLING WT
C (1986) NUMERICAL RECIPES.  THE ART OF SCIENTIFIC COMPUTING (FORTRAN
C VERSION), CAMBRIDGE UNIVERSITY PRESS, CAMBRIDGE, ENGLAND, P. 145.
C
      IMPLICIT REAL*8(A-H,O-Z)
      REAL*8 ROOT(2)
C
      NROOT=0
C
C CHECK THAT THE ROOTS ARE REAL.
C
      DISC=B**2-4.D0*A*C
      IF(DISC.LT.0.D0)GO TO 20
        SB=DSIGN(1.D0,B)
        Q=-.5D0*(B+SB*DSQRT(DISC))
C
C IF A=0 THERE IS ONLY ONE REAL ROOT.
C
        IF(DABS(A).LT.1.D-8)GO TO 10
          NROOT=1
          ROOT(1)=Q/A
   10     NROOT=NROOT+1
          ROOT(NROOT)=C/Q
   20 RETURN
      END
C
C
C
      FUNCTION LOGLIK(THETA,RA,RB,RAB,N1,N2,N3,N4)
C
C CALCULATE THE TWO-LOCUS LOG-LIKELIHOOD FOR THE GENERAL MODEL.
C
      IMPLICIT REAL*8(A-H,O-Z)
      REAL*8 LOGLIK,N1,N2,N3,N4
C
      TH1=1.D0-THETA
      TERM1=N1*DLOG10(THETA*(1.D0-RA)*(1.D0-RB)+TH1*(1.D0-RAB))
      TERM2=N2*DLOG10(THETA*RB*(1.D0-RA))
      TERM3=N3*DLOG10(THETA*RA*(1.D0-RB))
      TERM4=N4*DLOG10(TH1*RAB+THETA*RA*RB)
      LOGLIK=TERM1+TERM2+TERM3+TERM4
C
      RETURN
      END
C
C
C
      SUBROUTINE PARNAM(MAXPAR,MODEL,NLOCUS,NPAN,NPAR,PNAME)
C
C CREATE NAMES FOR THE PARAMETERS FOR THE ITERATION OUTPUT.
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*2 NUM,NUM1,NUM2
      CHARACTER*3 NUM3
      CHARACTER*8 PNAME(MAXPAR)
C
C CREATE NAMES FOR THE BREAKAGE PROBABILITIES.
C
      NLOC1=NLOCUS-1
      DO 10 I=1,NLOC1
        WRITE(NUM3,101)I
        IF(I.GE.10.AND.I.LE.99)WRITE(NUM3,102)I
        IF(I.GE.100)WRITE(NUM3,103)I
 101    FORMAT(I1)
 102    FORMAT(I2)
 103    FORMAT(I3)
        PNAME(I)='BREAK'//NUM3
   10 CONTINUE
C
C CREATE NAMES FOR THE RETENTION PROBABILITIES.
C
      GO TO (20,40,60,130,40,90,60) MODEL
C
C MODEL 1:  EQUAL RETENTION MODEL.
C
   20 PNAME(NLOCUS)='RETAIN'
      IF(NPAN.EQ.1)GO TO 110
      DO 30 J=NLOCUS,NLOCUS+NPAN-1
        I=J-NLOCUS+1
        WRITE(NUM,102)I
        PNAME(J)='RET'//NUM
   30 CONTINUE
      GO TO 110
C
C MODEL 2 & 5:  CENTROMERIC AND S1 MODELS.
C
   40 PNAME(NLOCUS)='RETAINS'
      PNAME(NLOCUS+1)='RETAIN'
      IF(NPAN.EQ.1)GO TO 110
      DO 50 J=NLOCUS,(NLOCUS+2*NPAN-1),2
        I=(J-NLOCUS)/2+1
        WRITE(NUM,102)I
        PNAME(J)='RETS'//NUM
        PNAME(J+1)='RET'//NUM
   50 CONTINUE
      GO TO 110
C
C MODEL 3 & 7:  LEFT-ENDPOINT MODEL AND S3 MODELS.
C
   60 DO 80 IPAN=1,NPAN
        NP=IPAN*NLOCUS-1
        DO 70 I=1,NLOCUS
          WRITE(NUM1,102)IPAN
          WRITE(NUM3,103)I
          IF(I.GE.10.AND.I.LE.99)WRITE(NUM2,102)I
          IF(I.GE.100)WRITE(NUM2,103)I
          IF(NPAN.GT.1)PNAME(NP+I)='R'//NUM1//'-'//NUM3
          IF(NPAN.EQ.1)PNAME(NP+I)='R'//NUM3
   70   CONTINUE
   80 CONTINUE
        GO TO 110
C
C MODEL 6:  S2 SELECTED LOCUS MODEL
C
   90 DO 100 J=NLOCUS,(NLOCUS+3*NPAN-1),3
         I=(J-NLOCUS)/3+1
         WRITE(NUM2,102)I
         PNAME(J)='RETL'//NUM2
         PNAME(J+1)='RETS'//NUM2
         PNAME(J+2)='RETR'//NUM2
  100 CONTINUE
C
C CREATE NAMES FOR THE PROPORTIONALITY PARAMETERS, IF THERE ARE ANY.
C
  110 IF(NPAN.EQ.1)GO TO 160
      DO 120 NP=NPAR-NPAN+2,NPAR
        IPAN=NPAR-NP+1
        WRITE(NUM,101)IPAN
        IF(NPAN.GT.9)WRITE(NUM,102)IPAN
        PNAME(NP)='PROP'//NUM
  120 CONTINUE
      GO TO 160
C
C MODEL 4:  GENERAL MODEL.
C
  130 N=NLOCUS
      DO 150 I=1,NLOCUS
        WRITE(NUM1,102)I
        DO 140 J=I,NLOCUS
          WRITE(NUM2,101)J
          IF(J.GE.10)WRITE(NUM2,102)J
          PNAME(N)='RET'//NUM1//'/'//NUM2
          N=N+1
  140   CONTINUE
  150 CONTINUE
C
  160 RETURN
      END
C
C
C
      SUBROUTINE UPDATE(DF,DP,EMSTEP,MAXPAR,MODEL,NCHR
     1,NLOCUS,NPAR,NUMHYB,PAR,TOL)
C
C UPDATE THE PARAMETER VECTOR BY EM.  EMSTEP=N SAYS MULTIPLY THE
C CALCULATED UPDATE BY N.  ASSUME A SINGLE HYBRID PANEL.
C
      IMPLICIT REAL*8(A-H,O-Z)
      REAL*8 DF(MAXPAR),DP(MAXPAR),PAR(MAXPAR)
C
C INITIALIZE.
C
      HC=DBLE(NUMHYB*NCHR)
      NLOC1=NLOCUS-1
C
C DEAL SEPARATELY WITH THE GENERAL MODEL.
C
      IF(MODEL.EQ.4)GO TO 40
C
C UPDATE THE BREAKAGE AND RETENTION PROBABILITIES.  USE THE UPDATED
C BREAKAGE PROBABILITIES (WITHOUT STEP MODIFICATION) FOR UPDATING
C THE RETENTION PROBABILITIES.
C
C LOOP OVER BREAKAGE PROBABILITIES.  JR KEEPS TRACK OF THE RETENTION
C PROBABILITY CURRENTLY BEING UPDATED.
C
      JR=NLOCUS
      FRAG=HC
      DO 30 I=1,NLOC1
C
C UPDATE A BREAKAGE PROBABILITY.
C
        PI=PAR(I)
        DELTA=PI*(1.D0-PI)*DF(I)/HC
        PEMEQ1=PI+DELTA
        PAR(I)=PI+EMSTEP*DELTA
C
C EITHER UPDATE A RETENTION PROBABILITY OR UPDATE THE EXPECTED
C NUMBER OF FRAGMENTS.
C
        IF(JR.LT.NPAR)GO TO 10
          FRAG=FRAG+HC*PEMEQ1
          GO TO 20
   10     PJ=PAR(JR)
          PAR(JR)=PJ*(1.D0+EMSTEP*(1.D0-PJ)*DF(JR)/FRAG)
          FRAG=HC*PEMEQ1
   20   JR=JR+1
   30 CONTINUE
C
C UPDATE THE FINAL RETENTION PROBABILITY.
C
      PN=PAR(NPAR)
      PAR(NPAR)=PN*(1.D0+EMSTEP*(1.D0-PN)*DF(NPAR)/FRAG)
C
C MAKE SURE THAT ALL PARAMETER VALUES ARE WITHIN BOUNDS.
C
      DO 35 I=1,NPAR
        PAR(I)=BOUND(PAR(I),TOL)
 35   CONTINUE
C
       GO TO 80
C
C GENERAL RETENTION MODEL.  UPDATE THE BREAKAGE PROBABILITIES.
C
   40 DO 50 I=1,NLOC1
        PI=PAR(I)
        PI=BOUND(PI*(1.D0+EMSTEP*(1.D0-PI)*DF(I)/HC),TOL)
        DP(I)=PI*(1.D0+(1.D0-PI)*DF(I)/HC)
        PAR(I)=PI
   50 CONTINUE
C
C UPDATE THE RETENTION PROBABILITIES.
C
      PROD=NUMHYB
      DO 70 I=1,NLOCUS
        DO 60 J=I,NLOCUS
          EXPTR=PROD
          IF(J.LT.NLOCUS)EXPTR=EXPTR*PAR(J)
          IJ=J-1+NLOCUS*I-I*(I-1)/2
          RIJ=PAR(IJ)
          RIJ=RIJ*(1.D0+EMSTEP*(1.D0-RIJ)*DF(IJ)/EXPTR)
          PAR(IJ)=BOUND(RIJ,TOL)
          PROD=PROD*(1.D0-PAR(J))
   60   CONTINUE
        PROD=NUMHYB*PAR(I)
   70 CONTINUE
C
   80 RETURN
      END
C
C
C
      SUBROUTINE FUNM(DF,DP,F,HPROB,IP,MAXHYB,MAXLOC,MAXPAN,MAXPAR
     1,NHYB,NLOCUS,NOBS,NPAR,PAR,PERM,RETAIN)
C
C CALCULATE THE LOG(E)-LOGLIKELIHOOD AND SCORE FOR ANY OF THE THREE
C MARKOVIAN MODELS (LEFT ENDPT, CENTROMERIC, AND EQUAL RETENTION).
C ASSUME HAPLOID DATA AND A SINGLE HYBRID PANEL.
C
      IMPLICIT REAL*8(A-H,O-Z)
      REAL*8 DF(MAXPAR),DP(MAXPAR),HPROB(MAXPAN,MAXHYB),PAR(MAXPAR)
      INTEGER FIRST,NOBS(MAXPAN,MAXHYB),PERM(MAXLOC)
     1,RETAIN(MAXPAN,MAXHYB,MAXLOC)
      LOGICAL BEGUN
C
C INITIALIZE VARIABLES.
C
      F=0.D0
      DO 10 J=1,NPAR
        DF(J)=0.D0
   10 CONTINUE
C
C FOR EACH HYBRID...
C
      DO 100 IHYB=1,NHYB
        FHYB=0.D0
        FIRST=1
        PROD=1.D0
        WT=DBLE(NOBS(IP,IHYB))
        BEGUN=.FALSE.
C
C BEGUN IS FALSE PRIOR TO FINDING THE FIRST TYPED LOCUS FOR THE
C HYBRID AND TRUE FOR SUBSEQUENT LOCI.
C
C FOR EACH LOCUS...
C
        DO 90 LOCUS=1,NLOCUS
          LOC1=LOCUS-1
          KOBS=RETAIN(IP,IHYB,PERM(LOCUS))
C
C IF THE LOCUS IS NOT TYPED, PROD ACCUMULATES THE PRODUCT OF THE
C NON-BREAKAGE PROBABILITIES FOR THE INTERVAL SINCE THE LAST TYPED
C LOCUS.  IF THE LOCUS IS TYPED, SET THE SIGN.
C
          IF(KOBS.NE.2)GO TO 20
            PROD=PROD*(1.D0-PAR(LOCUS))
            GO TO 90
C
C THE LOCUS IS TYPED.  PICK UP THE FIRST TERM IN THE SUM REQUIRED
C FOR THE INTIAL PROBABILITY OR THE CURRENT TRANSITION PROBABILITY.
C
   20     SIGN=DBLE(2*KOBS-1)
          IF(.NOT.BEGUN)GO TO 30
C
C TRANSITION.  INITIALIZE THE SUM TO THE PRODUCT OF THE NON-RETENTION
C PROBABILITIES.
C
            SUM=0.D0
            IF(RETAIN(IP,IHYB,PERM(FIRST)).EQ.KOBS)SUM=PROD
            DP(MIN(FIRST+NLOCUS-1,NPAR))=0.D0
            GO TO 40
C
C INITIAL TYPED LOCUS.  MULTIPLY PROD BY THE (NON-)RETENTION PROBABILITY.
C
   30     IF(KOBS.EQ.1)SUM=PAR(NLOCUS)*PROD
          IF(KOBS.EQ.0)SUM=(1.D0-PAR(NLOCUS))*PROD
          DP(NLOCUS)=SIGN*PROD
C
C IF THERE WERE UNTYPED LOCI PRIOR TO THIS TYPED LOCUS, ADD THE
C SUBSEQUENT TERMS TO THE SUM.  THIS REQUIRES DIVIDING THE PRODUCT
C AS WE GO THROUGH THE SUBSEQUENT TERMS.
C
   40     IF(FIRST.GE.LOCUS)GO TO 60
            DO 50 I=FIRST,LOC1
              PNEW=PROD/(1.D0-PAR(I))
C
C JR IS THE INDEX IN PAR FOR THE CURRENT RETENTION PROBABILITY.
C FACTOR IS THE CURRENT (NON-)RETENTION PROBABILITY.  PP IS THE
C PRODUCT THE LAST BREAKAGE PROBABILITY AND ALL THE MORE RECENT
C RETENTION PROBABILITIES.  DP IS THE DERIVATIVE OF SUM W.R.T.
C EACH PARAMETER FOR THIS HYBRID.
C
              J=I+NLOCUS
              JR=MIN(J,NPAR)
              FACTOR=PAR(JR)
              IF(KOBS.EQ.0)FACTOR=1.D0-FACTOR
C
C PP IS THE PRODUCT OF A BREAKAGE PROBABILITY WITH THE PRODUCT OF
C THE NON-BREAKAGE PROBABILITIES.
C
              PP=PNEW-PROD
              DP(I)=FACTOR*PNEW-SUM/(1.D0-PAR(I))
              IF(J.GT.NPAR)DP(JR)=DP(JR)+SIGN*PP
              IF(J.LE.NPAR)DP(JR)=SIGN*PP
              SUM=SUM+FACTOR*PP
              PROD=PNEW
   50       CONTINUE
C
C UPDATE THE HYBRID LOG-LIKELIHOOD FHYB.
C
   60       FHYB=FHYB+DLOG(SUM)
C
C UPDATE THE DERIVATIVES OF THE LOG-LIKELIHOOD W.R.T. THE THETA'S.
C THIS REQUIRES MODIFYING THE DERIVATIVES OF THE HYBRID LIKELIHOOD
C W.R.T. THE THETA'S.
C
            DO 70 L=FIRST,LOC1
              DF(L)=DF(L)+WT*DP(L)/SUM
   70       CONTINUE
C
C UPDATE THE DERIVATIVES OF THE LOG-LIKELIHOOD W.R.T. THE R'S.
C THIS REQUIRES MODIFYING THE DERIVATIVES OF THE HYBRID LIKELIHOOD
C W.R.T. THE R'S.
C
            LMIN=MIN(FIRST+NLOCUS-1,NPAR)
            LMAX=MIN(LOCUS+NLOCUS-1,NPAR)
            DO 80 L=LMIN,LMAX
              DF(L)=DF(L)+WT*DP(L)/SUM
   80       CONTINUE
C
C UPDATE INITIAL TERMS FOR SUBSEQUENT CALCULATIONS.
C
            FIRST=LOCUS
            PROD=1.D0-PAR(LOCUS)
            BEGUN=.TRUE.
C
   90   CONTINUE
C
C ADD THE HYBRID LOG-LIKELIHOOD TO THE TOTAL LOG-LIKELIHOOD.  STORE THE
C HYBRID LIKELIHOOD (NOT LOG-LIKELIHOOD) IN HPROB.
C
        F=F+FHYB*WT
        HPROB(IP,IHYB)=DEXP(FHYB)
  100 CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE FUNG(BRLIST,CHECK,CONDP,DF,DFHYB,F,HPROB,IP,MAXHYB
     1,MAXLOC,MAXPAN,MAXPAR,NHYB,NLOCUS,NOBS,NPAR,NUMHYB,PAR,PERM
     2,RETAIN)
C
C CALCULATE THE LIKELIHOOD AND SCORES FOR THE GENERAL RETENTION
C PROBABILITY MODEL.  ASSUME A SINGLE HYBRID PANEL.
C
      IMPLICIT REAL*8(A-H,O-Z)
      INTEGER BRLIST(0:MAXLOC),CHECK(MAXHYB)
     1,NOBS(MAXPAN,MAXHYB),PERM(MAXLOC),RETAIN(MAXPAN,MAXHYB,MAXLOC)
      REAL*8 CONDP(MAXHYB),DF(MAXPAR),DFHYB(MAXHYB,MAXPAR)
     1,HPROB(MAXPAN,MAXHYB),PAR(MAXPAR)
C
C SET THE LIST OF BREAKS TO INCLUDE ALL LOCI.  CALCULATE THE
C PROBABILITY FOR ALL BREAKS.
C
      BRLIST(0)=0
      NLOC1=NLOCUS-1
      PBREAK=1.D0
      DO 10 LOCUS=1,NLOC1
        BRLIST(LOCUS)=LOCUS
        PBREAK=PBREAK*PAR(LOCUS)
   10 CONTINUE
      NBREAK=NLOCUS
      BRLIST(NLOCUS)=NLOCUS
C
C INITIALIZE EACH HYBRID PROBABILITY AS THE JOINT PROBABILITY OF ITS
C HYBRID RETENTION VECTOR AND THE BREAKAGE LIST OF ALL ONES.  ALL
C HYBRIDS ARE CONSISTENT WITH THIS LIST, SO SET CHECK=1 FOR ALL
C HYBRIDS.
C
      DO 40 IHYB=1,NHYB
        CALL CALCON(BRLIST,CHECK,CONDP,IHYB,IP,MAXHYB,MAXLOC,MAXPAN
     1  ,NBREAK,NLOCUS,NPAR,PAR,PERM,RETAIN)
        TERM=CONDP(IHYB)*PBREAK
        HPROB(IP,IHYB)=TERM
        CHECK(IHYB)=1
C
C SIMILARLY, INITIALIZE THE DERIVATIVE TERMS FOR EACH HYBRID.
C
        DO 20 IPAR=NLOCUS,NPAR
          DFHYB(IHYB,IPAR)=0.D0
   20   CONTINUE
C
        DO 30 LOCUS=1,NLOC1
          DFHYB(IHYB,LOCUS)=TERM/PAR(LOCUS)
          IPAR=NLOCUS*LOCUS-(LOCUS-1)*(LOCUS-2)/2
          IR=RETAIN(IP,IHYB,PERM(LOCUS))
          IF(IR.EQ.0)DFHYB(IHYB,IPAR)=TERM/(PAR(IPAR)-1.D0)
          IF(IR.EQ.1)DFHYB(IHYB,IPAR)=TERM/PAR(IPAR)
   30   CONTINUE
        IR=RETAIN(IP,IHYB,PERM(NLOCUS))
        IF(IR.EQ.0)DFHYB(IHYB,NPAR)=TERM/(PAR(NPAR)-1.D0)
        IF(IR.EQ.1)DFHYB(IHYB,NPAR)=TERM/PAR(NPAR)
C
   40 CONTINUE
C
C WHILE BREAKAGE LISTS REMAIN, FIND THE NEXT BREAKAGE LIST BY BINARY
C SUBTRACTION.  WHILE DOING SO, UPDATE PBREAK.
C
   50 CALL BINSUB(BRLIST,INEW,NBREAK,NLOCUS,NPAR,PAR,PBREAK)
C
C FOR EACH HYBRID, UPDATE ITS TOTAL PROBABILITY BY ADDING THE JOINT
C PROBABILITY OF THE RETENTION DATA AND THE NEW BREAKAGE VECTOR.
C CALCULATE THE CONDITIONAL PROBABILITY OF THE RETENTION DATA GIVEN
C THE BREAKAGE VECTOR.  IF THE PREVIOUS BREAKAGE VECTOR WAS
C CONSISTENT, UPDATE THE PREVIOUS BREAKAGE PROBABILITY VECTOR.
C OTHERWISE, CALCULATE IT DE NOVO.  ALSO UPDATE THE DERIVATIVE TERMS.
C
      DO 100 IHYB=1,NHYB
        CALL CALCON(BRLIST,CHECK,CONDP,IHYB,IP,MAXHYB,MAXLOC,MAXPAN
     1  ,NBREAK,NLOCUS,NPAR,PAR,PERM,RETAIN)
C
C UPDATE THE PROBABILITIES AND DERIVATIVES ONLY IF THE NEW BREAKAGE
C VECTOR IS CONSISTENT WITH THE RETENTION INFORMATION.
C
        IF(CHECK(IHYB).EQ.0)GO TO 100
C
C UPDATE THE HYBRID LIKELIHOD.
C
          TERM=CONDP(IHYB)*PBREAK
          HPROB(IP,IHYB)=HPROB(IP,IHYB)+TERM
C
C FIND EACH FRAGMENT AND UPDATE ITS RETENTION PROBABILITY DERIVATIVE.
C
          IBREAK=1
          LSTART=1
          IROLD=2
          NBR1=BRLIST(NBREAK-1)
          DO 70 LOCUS=1,NBR1
            IR=RETAIN(IP,IHYB,PERM(LOCUS))
            IF(IROLD.EQ.2)IROLD=IR
            IF(LOCUS.EQ.BRLIST(IBREAK))GO TO 60
C
C NO BREAK, SO STILL THE SAME FRAGMENT.  JUST UPDATE THE DERIVATIVE
C WITH RESPECT TO THE APPROPRIATE BREAKAGE PROBABILITY.
C
            DFHYB(IHYB,LOCUS)=DFHYB(IHYB,LOCUS)-TERM/(1.D0-PAR(LOCUS))
            GO TO 70
C
C FINISHED A FRAGMENT:  LSTART TO LOCUS.  UPDATE DERIVATIVES WITH RESPECT
C TO A BREAKAGE PROBABILITY AND A RETENTION PROBABILITY FOR THIS FRAGMENT.
C START THE NEXT FRAGMENT.
C
   60       DFHYB(IHYB,LOCUS)=DFHYB(IHYB,LOCUS)+TERM/PAR(LOCUS)
            IPAR=LOCUS-1+NLOCUS*LSTART-LSTART*(LSTART-1)/2
            IF(IROLD.EQ.0)
     1      DFHYB(IHYB,IPAR)=DFHYB(IHYB,IPAR)-TERM/(1.D0-PAR(IPAR))
            IF(IROLD.EQ.1)
     1      DFHYB(IHYB,IPAR)=DFHYB(IHYB,IPAR)+TERM/PAR(IPAR)
            IROLD=2
            LSTART=LOCUS+1
            IBREAK=IBREAK+1
   70     CONTINUE
C
C TAKE CARE OF THE LAST FRAGMENT:  BRLIST(NBREAK-1)+1 TO NLOCUS.
C
          IROLD=2
          NBR11=NBR1+1
          IF(NBR11.EQ.NLOCUS)GO TO 90
          DO 80 LOCUS=NBR11,NLOC1
            DFHYB(IHYB,LOCUS)=DFHYB(IHYB,LOCUS)-TERM/(1.D0-PAR(LOCUS))
            IR=RETAIN(IP,IHYB,PERM(LOCUS))
            IF(IROLD.EQ.2)IROLD=IR
   80     CONTINUE
   90     IF(IROLD.EQ.2)IROLD=RETAIN(IP,IHYB,PERM(NLOCUS))
          IF(IROLD.EQ.2)GO TO 100
            IPAR=NLOCUS-1+(NLOCUS+NLOCUS-NBR11+1)*NBR11/2
            IF(IROLD.EQ.0)
     1      DFHYB(IHYB,IPAR)=DFHYB(IHYB,IPAR)-TERM/(1.D0-PAR(IPAR))
            IF(IROLD.EQ.1)
     1      DFHYB(IHYB,IPAR)=DFHYB(IHYB,IPAR)+TERM/PAR(IPAR)
  100 CONTINUE
C
C GO BACK TO SEE IF BREAKAGE LISTS REMAIN.
C
      IF(NBREAK.GT.1)GO TO 50
C
C CALCULATE THE JOINT LOG-LIKELIHOOD AND THE PARTIAL DERIVATIVES
C OVER ALL THE HYBRIDS.
C
      F=0.D0
      DO 110 IPAR=1,NPAR
        DF(IPAR)=0.D0
  110 CONTINUE
C
      NUMHYB=0
      DO 130 IHYB=1,NHYB
        PROB=HPROB(IP,IHYB)
        N=NOBS(IP,IHYB)
        NUMHYB=NUMHYB+N
        F=F+N*DLOG(PROB)
        DO 120 IPAR=1,NPAR
          DF(IPAR)=DF(IPAR)+N*DFHYB(IHYB,IPAR)/PROB
  120   CONTINUE
  130 CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE FUNP(ALPHA,BETA,BINOM,DF,DTRANS,F,FINISH,HPROB
     1,IP,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MODEL,NCHR,NHYB
     2,NLOCUS,NOBS,NPAN,NPAR,PAR,PERM,RETAIN,START,TRANS1,TRANSP
     3,IHESS,HESS)
C
C CALCULATE THE LOG(E)-LIKELIHOOD AND SCORE FOR ALL THE HYBRIDS
C FOR ANY OF THE THREE MARKOVIAN MODELS (LEFT ENDPT, CENTROMERIC,
C AND EQUAL RETENTION (UNCONDITIONAL ONLY)).
C
      IMPLICIT REAL*8(A-H,O-Z)
      INTEGER FINISH(0:2),NCHR(MAXPAN),NHYB(MAXPAN),NOBS(MAXPAN,MAXHYB)
     1,PERM(MAXLOC),RETAIN(MAXPAN,MAXHYB,MAXLOC),START(0:2)
      REAL*8 ALPHA(MAXLOC,0:MAXCHR),BETA(MAXLOC,0:MAXCHR)
     1,BINOM(0:MAXCHR,0:MAXCHR),DF(MAXPAR)
     2,DTRANS(MAXLOC,0:MAXCHR,0:MAXCHR,3),HESS(MAXPAR,MAXPAR)
     3,HPROB(MAXPAN,MAXHYB),PAR(MAXPAR),TRANS1(MAXLOC,0:1,0:1)
     4,TRANSP(MAXLOC,0:MAXCHR,0:MAXCHR)
C
C INITIALIZE THE LOG(E)-LIKELIHOOD AND THE SCORE.
C IF WE NEED TO ESTIMATE THE HESSIAN, INITIALIZE NOW.
C
      F=0.D0
      DO 20 I=1,NPAR
        DF(I)=0.D0
        IF(IHESS.EQ.0)GO TO 20
        DO 10 J=I,NPAR
          HESS(I,J)=0.D0
   10   CONTINUE
   20 CONTINUE
C
C FOR EACH HYBRID PANEL. . .
C
      DO 160 IPAN=1,NPAN
C
        IP1=IPAN
        IF(IP.GT.0)IP1=IP
C
C DETERMINE THE LOCATION IN PAR OF THE FIRST RETENTION PARAMATER (ISPAR)
C AND THE CURRENT PROPORTIONALITY PARAMETER (NPPAR).  THIS DEPENDS ON THE
C RETENTION MODEL AND THE PANEL NUMBER.
C
        ISPAR=LOCR(IPAN,0,MODEL,NLOCUS)
        NPPAR=LOCP(IPAN,MODEL,NLOCUS,NPAN)
C
C SET LIMITS ON GENOTYPES FOR POLYPLOID DATA.  NOTE: START(I) (I=0,1,2) 
C AND FINISH(0) ARE SET IN SUBROUTINE MAXL1, AND DO NOT NEED TO BE 
C RESET NOW.
C
        NCHRI=NCHR(IP1)
        FINISH(1)=NCHRI
        FINISH(2)=NCHRI
C
C CALCULATE THE HAPLOID TRANSITION PROBABILITIES.
C
      CALL HTRANS(IPAN,0,MAXLOC,MAXPAR,MODEL,NLOCUS,NPAN,PAR
     1,TRANS1)
C
C CALCULATE THE POLYPLOID TRANSITION PROBABILITIES AND THEIR
C PARTIAL DERIVATIVES.
C
      CALL DPTRAN(BINOM,DTRANS,IPAN,0,MAXCHR,MAXLOC
     1,MAXPAR,MODEL,NCHRI,NLOCUS,NPAN,PAR,TRANS1,TRANSP)
C
C FOR EACH HYBRID...
C
      IPERMN=PERM(NLOCUS)
      NLOCM1=NLOCUS-1
      NOBST=0
      LHYB=NHYB(IP1)
      DO 150 IHYB=1,LHYB
        NOBST=NOBST+NOBS(IP1,IHYB)
C
C RUN THE BACKWARD RECURSION TO EVALUATE THE LIKELIHOOD FOR THE
C CURRENT HYBRID AND TO ACCUMULATE BETA TERMS REQUIRED FOR SUBSEQUENT
C EVALUATION OF THE PARTIAL DERIVATIVE CONTRIBUTIONS FOR THE HYBRID.
C FIRST, SET THE LOWER AND UPPER BOUNDS FOR THE LAST MARKER. 
C
        KOBS=RETAIN(IP1,IHYB,IPERMN)
        KMIN=START(KOBS)
        KMAX=FINISH(KOBS)
C
C INITIALIZE THE FINAL BETAS TO 1.
C
        DO 40 I=KMIN,KMAX
          BETA(NLOCUS,I)=1.D0
   40   CONTINUE
C
C FOR EACH EARLIER LOCUS, DO THE BACKWARD RECURSION.
C
        DO 70 LOCUS=NLOCM1,1,-1
C
C THE PREVIOUS LOWER AND UPPER BOUNDS FOR THE KTH GENOTYPE SET ARE NOW
C THE LOWER AND UPPER BOUNDS FOR THE (K+1)ST GENOTYPE SET.  FIND THE
C NEW BOUNDS BASED ON THE PHENOTYPE AT THE CURRENT LOCUS.
C
          LOCP1=LOCUS+1
          KP1MIN=KMIN
          KP1MAX=KMAX
          KOBS=RETAIN(IP1,IHYB,PERM(LOCUS))
          KMIN=START(KOBS)
          KMAX=FINISH(KOBS)
C
C CARRY OUT THE BACKWARD RECURSION FOR THIS LOCUS.
C
          DO 60 I=KMIN,KMAX
            BLI=0.D0
            DO 50 J=KP1MIN,KP1MAX
              BLI=BLI+TRANSP(LOCUS,I,J)*BETA(LOCP1,J)
   50       CONTINUE
            BETA(LOCUS,I)=BLI
   60     CONTINUE
   70   CONTINUE
C
C CALCULATE THE LIKELIHOOD FOR THE CURRENT HYBRID AND THE
C PARTIAL DERIVATIVE CONTRIBUTION FOR R(1) (DLDR1).  DADR1 IS THE 
C PARTIAL DERIVATIVE OF ALPHA1 WITH RESPECT TO R(1).  ISPAR IS THE
C LOCATION IN PAR OF THE RETENTION PROBABILITY R(1).
C
        R=PAR(ISPAR)
        S=1.D0-R
        RDS=R/S
        RTS=R*S
        RC=R*NCHRI
        SN=S**NCHRI
C
        FHYB=0.D0
        DLDR1=0.D0
        DO 80 I=KMIN,KMAX
          ALPHA(1,I)=BINOM(NCHRI,I)*RDS**I*SN
          FHYB=FHYB+ALPHA(1,I)*BETA(1,I)
          DADR1=ALPHA(1,I)*(I-RC)/RTS
          DLDR1=DLDR1+DADR1*BETA(1,I)
   80   CONTINUE
C
C ADD THE HYBRID LOG(E)-LIKELIHOOD TO THE TOTAL LOG(E)-LIKELIHOOD
C AND THE R(1) TERM IN THE SCORE TO THE SCORE.  
C
        WT=DBLE(NOBS(IP1,IHYB))
        F=F+DLOG(FHYB)*WT
        DF(ISPAR)=DF(ISPAR)+DLDR1/FHYB*WT
C
C STORE THE HYBRID LIKELIHOOD (NOT LOG-LIKELIHOOD) IN HPROB.
C
        HPROB(IP1,IHYB)=FHYB
C
C UPDATE THE CURRENT RETENTION PARAMETER IF NOT THE EQUAL RETENTION MODEL.
C
        IR=ISPAR
        IF(MODEL.NE.1)IR=ISPAR+1
C
C RUN THE FORWARD RECURSION TO CALCULATE THE HYBRID CONTRIBUTION TO
C THE PARTIAL DERIVATIVES OF THE LIKELIHOOD.
C
        DO 110 LOCUS=1,NLOCM1
C
C DETERMINE THE RANGE OF GENOTYPES TO CONSIDER FOR THE (K+1)ST
C GENOTYPE SET.
C
          LOCP1=LOCUS+1
          KP1OBS=RETAIN(IP1,IHYB,PERM(LOCP1))
          KP1MIN=START(KP1OBS)
          KP1MAX=FINISH(KP1OBS)
C
C CARRY OUT THE FORWARD RECURSION TO OBTAIN ALPHA(LOCUS+1).  WHILE DOING
C SO, EVALUATE THE DERIVATIVE TERMS FOR THETA(LOCUS), R(LOCUS+1), AND
C THE PROPORTIONALITY PARAMETER.  UPDATE THE SCORE VECTOR BY USING THESE 
C TERMS.  THE ELEMEMT OF THE SCORE TO UPDATE DEPENDS ON THE RETENTION 
C MODEL WE ARE USING.
C
          DLDTHL=0.D0
          DLDPL=0.D0
          DLDRL1=0.D0
          DO 100 J=KP1MIN,KP1MAX
            AKP1J=0.D0
            DPPAR=0.D0
            DTH=0.D0
            DRET=0.D0
            DO 90 I=KMIN,KMAX
              ALPHAI=ALPHA(LOCUS,I)
              AKP1J=AKP1J+ALPHAI*TRANSP(LOCUS,I,J)
              DTH=DTH+ALPHAI*DTRANS(LOCUS,I,J,2)
              DPPAR=DPPAR+ALPHAI*DTRANS(LOCUS,I,J,3)
              DRET=DRET+ALPHAI*DTRANS(LOCUS,I,J,1)
   90       CONTINUE
            ALPHA(LOCP1,J)=AKP1J
            BETAJ=BETA(LOCP1,J)
            DLDTHL=DLDTHL+DTH*BETAJ
            DLDPL=DLDPL+DPPAR*BETAJ
            DLDRL1=DLDRL1+DRET*BETAJ
  100     CONTINUE
          DF(LOCUS)=DF(LOCUS)+DLDTHL/FHYB*WT
          IF(IPAN.GT.1)DF(NPPAR)=DF(NPPAR)+DLDPL/FHYB*WT
          IF(MODEL.EQ.3)IR=ISPAR+LOCUS
          DF(IR)=DF(IR)+DLDRL1/FHYB*WT
C
C THE LOWER AND UPPER BOUNDS FOR THE CURRENT (K+1)ST GENOTYPE SET
C WILL BE THE LOWER AND UPPER BOUNDS FOR THE NEXT KTH GENOTYPE SET.
C
          KMIN=KP1MIN
          KMAX=KP1MAX
  110   CONTINUE
C
C IF ESTIMATING THE HESSIAN, ADD TO THE APPROXIMATE HESSIAN AND
C RE-INITIALIZE THE SCORE DF FOR NEXT HYBRID.
C
        IF(IHESS.EQ.0) GO TO 150
        DO 130 I=1,NPAR
          DO 120 J=1,NPAR
            HESS(I,J)=HESS(I,J)+DF(I)*DF(J)
  120     CONTINUE
  130   CONTINUE
        DO 140 I=1,NPAR
          DF(I)=0.D0
  140   CONTINUE
  150 CONTINUE
C
  160 CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE FUNS(ALPHA,ALPHAP,BETAP,BINOM,DF,DTRANS,F
     1,FINISH,HPROB,ICONDS,IP,ISEL,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR
     2,MODEL,NCHR,NHYB,NLOCUS,NOBS,NPAN,NPAR,PAR,PERM,RETAIN,START
     3,SUBPRM,TRANS1,TRANSP,IHESS,HESS)
C
C CALCULATE THE LOG(E)-LOGLIKELIHOOD AND SCORE FOR ALL THE HYBRIDS
C FOR ANY OF THE SELECTED-LOCUS (MODELS 5, 6, 7) AND CONDITIONAL 
C MODELS (ICONDS=1, MODEL 1, 5 OR 6).  FOR THE CONDITIONAL
C MODELS, THE CALCULATION ASSUMES RETENTION OF AT LEAST ONE COPY OF 
C THE SELECTED LOCUS IN EACH HYBRID.
C 
      IMPLICIT REAL*8(A-H,O-Z)
      INTEGER FINISH(0:2),NLSUBP(2),NCHR(MAXPAN),NHYB(MAXPAN)
     1,NOBS(MAXPAN,MAXHYB),PERM(MAXLOC),RETAIN(MAXPAN,MAXHYB,MAXLOC)
     2,START(0:2),SUBPRM(2,MAXLOC)
      REAL*8 ALPHA(MAXLOC,0:MAXCHR),ALPHAP(2,MAXLOC,0:MAXCHR,0:MAXCHR)
     1,BETAP(2,MAXLOC,0:MAXCHR)
     2,BINOM(0:MAXCHR,0:MAXCHR),DF(MAXPAR)
     3,DTRANS(MAXLOC,0:MAXCHR,0:MAXCHR,3),HESS(MAXPAR,MAXPAR)
     4,HPROB(MAXPAN,MAXHYB),PAR(MAXPAR),TRANS1(MAXLOC,0:1,0:1)
     5,TRANSP(MAXLOC,0:MAXCHR,0:MAXCHR)
C
C INITIALIZE THE LOG(E)-LIKELIHOOD AND THE SCORE.
C IF WE NEED TO ESTIMATE THE HESSIAN, INITALIZE NOW.
C
      F=0.D0
      DO 6 I=1,NPAR
        DF(I)=0.D0
        IF(IHESS.EQ.0)GO TO 6
        DO 5 J=I,NPAR
          HESS(I,J)=0.D0
    5   CONTINUE
    6 CONTINUE
C
C FOR EACH HYBRID PANEL...
C
   10 DO 210 IPAN=1,NPAN
C
        IP1=IPAN
        IF(IP.GT.0)IP1=IP
C
C DETERMINE THE LOCATION IN PAR OF THE RETENTION PROBABILITY OF 
C THE SELECTED LOCUS (ISPAR), AND THE CURRENT PROPORTIONALITY 
C PARAMETER (NPPAR).  THIS DEPENDS ON THE RETENTION MODEL AND
C PANEL NUMBER.
C
        ISPAR=LOCR(IPAN,ISEL,MODEL,NLOCUS)
        NPPAR=LOCP(IPAN,MODEL,NLOCUS,NPAN)
C
C SET LIMITS ON GENOTYPES FOR POLYPLOID DATA.  NOTE: START(I) (I=0,1,2)
C AND FINISH(0) ARE SET IN SUBROUTINE MAXL1, AND DO NOT NEED TO BE 
C RESET NOW.
C
        NCHRI=NCHR(IP1)
        FINISH(1)=NCHRI
        FINISH(2)=NCHRI
C
C CALCULATE THE HAPLOID TRANSITION PROBABILITIES.
C
        CALL HTRANS(IPAN,ISEL,MAXLOC,MAXPAR,MODEL,NLOCUS,NPAN,PAR
     1  ,TRANS1)
C
C CALCULATE THE POLYPLOID TRANSITION PROBABILITIES AND THEIR
C PARTIAL DERIVATIVES.
C
        CALL DPTRAN(BINOM,DTRANS,IPAN,ISEL,MAXCHR,MAXLOC
     1  ,MAXPAR,MODEL,NCHRI,NLOCUS,NPAN,PAR,TRANS1,TRANSP)
C
C CREATE SUB-PERMUTATIONS SUBPRM(1,*) AND SUBPRM(2,*) AND SET THEIR LENGTHS, 
C NLSUBP(1) AND NLSUBP(2).  SUBPRM(1,*) HOLDS THE SUB-ORDER ISEL,...,1. 
C SUBPRM(2,*) HOLDS THE SUB-ORDER ISEL,...,NLOCUS.  
C
        DO 20 I=1,ISEL
          SUBPRM(1,I)=PERM(ISEL-I+1)
   20   CONTINUE
        DO 30 I=ISEL,NLOCUS
          SUBPRM(2,I-ISEL+1)=PERM(I)
   30   CONTINUE
        NLSUBP(1)=ISEL
        NLSUBP(2)=NLOCUS-ISEL+1
C
C FOR EACH HYBRID...
C
        NOBST=0
        LHYB=NHYB(IP1)
        DO 200 IHYB=1,LHYB
          NOBST=NOBST+NOBS(IP1,IHYB)
C
C RUN THE BACKWARD RECURSION TO EVALUATE THE LIKELIHOOD FOR THE
C CURRENT HYBRID AND TO ACCUMULATE BETA TERMS REQUIRED FOR SUBSEQUENT
C EVALUATION OF THE PARTIAL DERIVATIVE CONTRIBUTIONS FOR THE HYBRID.
C COMPUTE THE BETA TERMS FOR EACH SUB-ORDER CONDITIONAL ON THE 
C GENOTYPE AT THE SELECTED LOCUS.
C
          DO 80 JPERM=1,2
            IADJ=2*JPERM-3
            NLOC=NLSUBP(JPERM)
            NLOCM1=NLOC-1
            IPERMN=SUBPRM(JPERM,NLOC)
C
C FIRST SET THE LOWER AND UPPER BOUNDS FOR THE LAST MARKER.  
C IF THIS IS A CONDITIONAL MODEL AND THIS IS THE SELECTED LOCUS, 
C ASSUME THAT AT LEAST ONE COPY OF THE SELECTED LOCUS IS RETAINED.
C
            KOBS=RETAIN(IP1,IHYB,IPERMN)
            KMIN=START(KOBS)
            KMAX=FINISH(KOBS)
            IF(ICONDS.EQ.1.AND.NLOC.EQ.1)KMIN=1
C
C INITIALIZE THE FINAL BETAS TO 1.
C
            DO 40 I=KMIN,KMAX
              BETAP(JPERM,NLOC,I)=1.D0
   40       CONTINUE
C
C FOR EACH EARLIER LOCUS, DO THE BACKWARD RECURSION.  ITP IS THE LOCATION 
C OF THE CURRENT TRANSITION PROBABILITY.
C
            DO 70 LOCUS=NLOCM1,1,-1
              ITP=ISEL+IADJ*LOCUS-JPERM+1
C
C THE PREVIOUS LOWER AND UPPER BOUNDS FOR THE KTH GENOTYPE SET ARE NOW
C THE LOWER AND UPPER BOUNDS FOR THE (K+1)ST GENOTYPE SET.  FIND THE
C NEW BOUNDS BASED ON THE PHENOTYPE AT THE CURRENT LOCUS.
C
              LOCP1=LOCUS+1
              KP1MIN=KMIN
              KP1MAX=KMAX
              KOBS=RETAIN(IP1,IHYB,SUBPRM(JPERM,LOCUS))
              KMIN=START(KOBS)
              KMAX=FINISH(KOBS)
              IF(ICONDS.EQ.1.AND.LOCUS.EQ.1)KMIN=1
C
C CARRY OUT THE BACKWARD RECURSION FOR THIS LOCUS.
C
              DO 60 I=KMIN,KMAX
                BLI=0.D0
                DO 50 J=KP1MIN,KP1MAX
                  BLI=BLI+TRANSP(ITP,I,J)*BETAP(JPERM,LOCP1,J)
   50           CONTINUE
                BETAP(JPERM,LOCUS,I)=BLI
   60         CONTINUE
   70       CONTINUE
   80     CONTINUE
C
C CALCULATE THE LIKELIHOOD FOR THE CURRENT HYBRID AND THE
C PARTIAL DERIVATIVE CONTRIBUTION FOR R(S) (DLDR1).  DADR1 IS THE 
C PARTIAL DERIVATIVE OF ALPHA WITH RESPECT TO R(S).  ISPAR IS THE 
C LOCATION OF THE RETENTION PROBABILITY R(S) IN PAR.
C
          R=PAR(ISPAR)
          S=1.D0-R
          RDS=R/S
          RTS=R*S
          RC=R*NCHRI
          SN=S**NCHRI
C
          FHYB=0.D0
          DLDR1=0.D0
          DO 90 I=KMIN,KMAX
            ALPHA(1,I)=BINOM(NCHRI,I)*RDS**I*SN
            FHYB=FHYB+ALPHA(1,I)*BETAP(1,1,I)*BETAP(2,1,I)
            DADR1=ALPHA(1,I)*(I-RC)/RTS
            DLDR1=DLDR1+DADR1*BETAP(1,1,I)*BETAP(2,1,I)
   90     CONTINUE
C
C ADD THE HYBRID LOG(E)-LIKELIHOOD TO THE TOTAL LOG(E)-LIKELIHOOD
C AND THE R(S) TERM IN THE SCORE TO THE SCORE. 
C
          WT=DBLE(NOBS(IP1,IHYB))
          F=F+DLOG(FHYB)*WT
          DF(ISPAR)=DF(ISPAR)+DLDR1/FHYB*WT
C
C STORE THE HYBRID LIKELIHOOD (NOT LOG-LIKELIHOOD) IN HPROB.
C FOR A CONDITIONAL MODEL, ADJUST THE HYBRID LIKELIHOOD HPROB.
C IF IT IS NOT AN EQUAL RETENTION MODEL, ALSO ADJUST THE DERIVATIVE OF 
C THE SELECTED LOCUS RETENTION PROBABILITY.
C
          HPROB(IP1,IHYB)=FHYB
          IF(ICONDS.EQ.1) THEN
            HPROB(IP1,IHYB)=FHYB/(1.D0-SN)
            IF(MODEL.NE.1) THEN 
              CORFAC1=WT*DBLE(NCHRI)*S**(NCHRI-1)
              DF(ISPAR)=DF(ISPAR)-CORFAC1/(1.D0-SN)
            ENDIF
          ENDIF
C
C LEAVE THE CURRENT RETENTION PARAMETER CURRENT FOR THE EQUAL RETENTION
C MODEL.  UPDATE THE CURRENT RETENTION PARAMETER FOR MODEL 5.  TAKE 
C CARE OF OTHER MODELS WITHIN THE JPERM LOOP.  
C
          IR=ISPAR
          IF(MODEL.NE.1)IR=ISPAR+1
C
C RUN THE FORWARD RECURSION TO CALCULATE THE HYBRID CONTRIBUTION TO
C THE PARTIAL DERIVATIVES OF THE LIKELIHOOD.  COMPUTE FORWARD-RECURSION 
C ALPHAS CONDITIONAL ON THE GENOTYPE AT THE SELECTED LOCUS.
C IR AND ITP ARE THE LOCATIONS OF THE CURRENT RETENTION AND BREAKAGE 
C PROBABILITIES IN PAR.  
C
          KSMIN=KMIN
          KSMAX=KMAX
C
C COMPUTE THE HYBRID CONTRIBUTION TO THE PARTIAL DERIVATIVES FOR
C THE MARKERS ON EITHER SIDE OF THE SELECTED MARKER.
C
          DO 160 JPERM=1,2
C
C IF THE SELECTED LOCUS IS THE 1ST OR LAST MARKER IN THE ORDER,
C SKIP OVER THE APPROPRIATE JPERM LOOP.  FOR MODEL S2, THIS MEANS THAT THE 
C RETENTION PARAMETER FOR THE NON-EXISTANT SUB-ORDER WILL BE LEFT AT ITS 
C INITIALIZED VALUE OF 0.
C
            IF(NLSUBP(JPERM).EQ.1)GO TO 160
C
C START WITH THE TERMS FOR THE SELECTED LOCUS.
C
            ITP=ISEL+JPERM-2
            IADJ=2*JPERM-3
            JP=3-JPERM
            IF(MODEL.NE.5.AND.MODEL.NE.1)IR=ISPAR+IADJ
            DLDTHL=0.D0
            DLDRL1=0.D0
            DLDPL=0.D0
            KOBS=RETAIN(IP1,IHYB,SUBPRM(JPERM,2))
            KMIN=START(KOBS)
            KMAX=FINISH(KOBS)
            DO 110 J=KMIN,KMAX
              DTH=0.D0
              DRET=0.D0
              DPPAR=0.D0
              DO 100 IGS=KSMIN,KSMAX
                ALPHAP(JPERM,2,J,IGS)=TRANSP(ITP,IGS,J)
                ALPHIS=ALPHA(1,IGS)
                BTAPIS=BETAP(JP,1,IGS)
                DTH=DTH+DTRANS(ITP,IGS,J,2)*ALPHIS*BTAPIS
                DRET=DRET+DTRANS(ITP,IGS,J,1)*ALPHIS*BTAPIS
                DPPAR=DPPAR+DTRANS(ITP,IGS,J,3)*ALPHIS*BTAPIS
  100         CONTINUE
              BJ=BETAP(JPERM,2,J)
              DLDTHL=DLDTHL+DTH*BJ
              DLDRL1=DLDRL1+DRET*BJ
              DLDPL=DLDPL+DPPAR*BJ
  110       CONTINUE
            DF(ITP)=DF(ITP)+DLDTHL/FHYB*WT
            DF(IR)=DF(IR)+DLDRL1/FHYB*WT
            IF(IPAN.GT.1)DF(NPPAR)=DF(NPPAR)+DLDPL/FHYB*WT
C
C CONTINUE ALONG THE SUBPERMUTATION UNTIL WE GET TO THE END...
C
            DO 150 LOCUS=2,NLSUBP(JPERM)-1
              ITP=ISEL+IADJ*LOCUS-JPERM+1
              DLDTHL=0.D0
              DLDRL1=0.D0
              DLDPL=0.D0
              KP1OBS=RETAIN(IP1,IHYB,SUBPRM(JPERM,LOCUS+1))
              KP1MIN=START(KP1OBS)
              KP1MAX=FINISH(KP1OBS)
C
C IGS IS THE GENOTYPE AT A_S, I IS THE GENOTYPE AT A_K+1, AND
C J IS THE GENOTYPE AT A_K.
C
              DO 140 IGS=KSMIN,KSMAX
                DTHA=0.D0
                DRETA=0.D0
                DPA=0.D0
                DO 130 I=KP1MIN,KP1MAX
                  DTH=0.D0
                  DRET=0.D0
                  DPPAR=0.D0
                  AP1I=0.D0
                  DO 120 J=KMIN,KMAX
                    AP1I=AP1I+ALPHAP(JPERM,LOCUS,J,IGS)*TRANSP(ITP,J,I)
                    ALPHAJ=ALPHAP(JPERM,LOCUS,J,IGS)
                    DTH=DTH+DTRANS(ITP,J,I,2)*ALPHAJ
                    DRET=DRET+DTRANS(ITP,J,I,1)*ALPHAJ
                    DPPAR=DPPAR+DTRANS(ITP,J,I,3)*ALPHAJ
  120             CONTINUE
                  ALPHAP(JPERM,LOCUS+1,I,IGS)=AP1I
                  BETPI=BETAP(JPERM,LOCUS+1,I)
                  DTHA=DTHA+DTH*BETPI
                  DRETA=DRETA+DRET*BETPI
                  DPA=DPA+DPPAR*BETPI
  130           CONTINUE
                BPNJ=BETAP(JP,1,IGS)
                ALPHIS=ALPHA(1,IGS)
                DLDTHL=DLDTHL+DTHA*ALPHIS*BPNJ
                DLDRL1=DLDRL1+DRETA*ALPHIS*BPNJ
                DLDPL=DLDPL+DPA*ALPHIS*BPNJ
  140         CONTINUE
C
C UPDATE THE SCORE VECTOR.
C
              DF(ITP)=DF(ITP)+DLDTHL/FHYB*WT
              IF(MODEL.EQ.7)IR=IR+IADJ
              DF(IR)=DF(IR)+DLDRL1/FHYB*WT
              IF(IPAN.GT.1)DF(NPPAR)=DF(NPPAR)+DLDPL/FHYB*WT
              KMIN=KP1MIN
              KMAX=KP1MAX
  150       CONTINUE
  160     CONTINUE
C
C FOR A CONDITIONAL EQUAL RETENTION MODEL, ADJUST THE 
C DERIVATIVE OF THE RETENTION PARAMETER.
C
        IF(ICONDS.EQ.1.AND.MODEL.EQ.1) THEN 
          CORFAC1=WT*DBLE(NCHRI)*S**(NCHRI-1)
          DF(ISPAR)=DF(ISPAR)-CORFAC1/(1.D0-SN)
        ENDIF
C
C IF ESTIMATING THE HESSIAN, ADD TO THE APPROXIMATE HESSIAN AND
C RE-INITIALIZE THE SCORE DF FOR THE NEXT HYBRID. 
C
        IF(IHESS.EQ.0) GO TO 200
          DO 180 I=1,NPAR
            DO 170 J=1,NPAR
              HESS(I,J)=HESS(I,J)+DF(I)*DF(J)
  170       CONTINUE
  180     CONTINUE
          DO 190 I=1,NPAR
            DF(I)=0.D0
  190     CONTINUE
  200   CONTINUE
C
C FOR A CONDITIONAL MODEL, ADJUST THE LOGLIKELIHOOD.
C
        IF(ICONDS.EQ.1)F=F-DBLE(NOBST)*DLOG(1.D0-SN)
C
  210 CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE HTRANS(IPAN,ISEL,MAXLOC,MAXPAR,MODEL,NLOCUS,NPAN
     1,PAR,TRANS1)
C
C CALCULATE THE HAPLOID TRANSITION PROBABILITIES FOR MARKOVIAN MODELS.
C THIS REQUIRES: THE PANEL NUMBER (IPAN), THE NUMBER OF PANELS (NPAN) 
C AND THE MODEL.  FOR MODELS 5-7, ALSO REQUIRES LOCATION OF THE 
C SELECTED LOCUS (ISEL).
C NOTE: FOR SELECTED LOCUS MODELS (5-7), THE TRANSITIONS PRIOR TO THE
C SELECTED LOCUS ARE TRANSITIONS FROM RIGHT TO LEFT
C (E.G., TRANS1(S-1,0,1)= P(X(S-1)=1|X(S)=0)), WHILE THE TRANSITIONS
C AFTER THE SELECTED LOCUS ARE THE USUAL LEFT TO RIGHT TRANSITIONS
C (E.G., TRANS1(S,0,1)=P(X(S+1)=1|X(S)=1)).
C
      IMPLICIT REAL*8(A-H,O-Z)
      REAL*8 PAR(MAXPAR),TRANS1(MAXLOC,0:1,0:1)
C
      NLOCM1=NLOCUS-1
C
C DETERMINE THE LOCATION IN THE PARAMETER VECTOR OF THE PROPORTIONALITY
C PARAMETER:
C
      NPPAR=LOCP(IPAN,MODEL,NLOCUS,NPAN)
C
C THE TRANSITION FROM K TO K+1 DEPENDS ON THETA(K) AND R(K+1).  
C THE TRANSITION TO K FROM K+1 DEPENDS ON THETA(K) AND R(K).
C
      DO 10 K=1,NLOCM1
C
C DETERMINE THE LOCATION OF THE RETENTION PROBABILITY 
C IN THE PARAMETER VECTOR.  
C
        IR=IRLOC(IPAN,ISEL,K,MODEL,NLOCUS)
        R=PAR(IR)
C
C NEXT, DETERMINE THE APPROPRIATE BREAKAGE PROBABILITY FOR THIS PANEL
C AND LOCUS.
C
        THETA=PAR(K)
        IF(IPAN.GT.1) THEN
          PPAR=PAR(NPPAR)
          THETA=1.D0-(1.D0-THETA)**PPAR
        ENDIF
C
C CALCULATE THE HAPLOID TRANSITION PROBABILITIES.
C
        THETAR=THETA*R
        TRANS1(K,0,0)=1.D0-THETAR
        TRANS1(K,0,1)=THETAR
        TRANS1(K,1,0)=THETA-THETAR
        TRANS1(K,1,1)=1.D0-THETA+THETAR
   10 CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE DPTRAN(BINOM,DTRANS,IPAN,ISEL,MAXCHR,MAXLOC
     1,MAXPAR,MODEL,NCHR,NLOCUS,NPAN,PAR,TRANS1,TRANSP)
C
C CALCULATE THE POLYPLOID TRANSITION PROBABILITIES AND THEIR PARTIAL
C DERIVATIVES FOR MODELS 1-3 AND 5-7 FOR THE CURRENT PANEL.
C
C NOTE: FOR SELECTED LOCUS MODELS (5-7), THE TRANSITIONS PRIOR TO THE
C SELECTED LOCUS ARE TRANSITIONS FROM RIGHT TO LEFT
C (E.G., TRANSP(S-1,0,1)= P(G(S-1)=1|G(S)=0)), WHILE THE TRANSITIONS
C AFTER THE SELECTED LOCUS ARE THE USUAL LEFT TO RIGHT TRANSITIONS
C (E.G., TRANSP(S,0,1)=P(G(S+1)=1|G(S)=1)).
C
      IMPLICIT REAL*8(A-H,O-Z)
      REAL*8 BINOM(0:MAXCHR,0:MAXCHR)
     1,DTRANS(MAXLOC,0:MAXCHR,0:MAXCHR,3),PAR(MAXPAR)
     2,TRANS1(MAXLOC,0:1,0:1),TRANSP(MAXLOC,0:MAXCHR,0:MAXCHR)
C
C FOR EACH LOCUS K, CALCULATE THE TRANSITION PROBABILITIES AND
C THE PARTIAL DERIVATIVES WITH RESPECT TO THETA(K), R(K+1), AND THE
C PROPORTIONALITY PARAMETER P(IPAN) FOR PANEL IPAN.
C
      NLOCM1=NLOCUS-1
C
C DETERMINE THE LOCATION IN THE PARAMETER VECTOR OF THE PROPORTIONALITY
C PARAMETER:
C
      NPPAR=LOCP(IPAN,MODEL,NLOCUS,NPAN)
C
      DO 40 K=1,NLOCM1
C
C DETERMINE THE LOCATION OF THE RETENTION PROBABILITY 
C IN THE PARAMETER VECTOR.  
C
        IR=IRLOC(IPAN,ISEL,K,MODEL,NLOCUS)
        R=PAR(IR)
        S=1.D0-R
C
C NEXT, DETERMINE THE APPROPRIATE BREAKAGE PROBABILITY FOR THIS PANEL
C AND LOCUS.
C
        PPAR=PAR(NPPAR)
        IF(IPAN.EQ.1)PPAR=1.D0
C
        PARK1=1.D0-PAR(K)
        TH=1.D0-PARK1**PPAR
        DTH=PPAR*PARK1**(PPAR-1.D0)
        DPPAR=-DLOG(PARK1)*(PARK1**PPAR)
C
C INITIALIZE TERMS REQUIRED THROUGHOUT THE CALCULATIONS FOR THIS LOCUS.
C
        T1K00=TRANS1(K,0,0)
        T1K01=TRANS1(K,0,1)
        T1K10=TRANS1(K,1,0)
        T1K11=TRANS1(K,1,1)
C
        T1110=T1K11/T1K10
        T0100=T1K01/T1K00
        THT11=TH/T1K11
        THT00=TH/T1K00
        ST11=S/T1K11
        RT00=R/T1K00
C
        DO 30 J=0,NCHR
          DO 20 I=0,NCHR
C
C SAVE TERMS THAT WILL BE USED MULTIPLE TIMES IN THE GENOTYPE LOOP.
C
            IJ=I+J
            NCHRI=NCHR-I
            NCHRIJ=NCHRI-J
            MINL=MAX0(0,-NCHRIJ)
            MAXL=MIN0(I,J)
            T10I=T1K10**I
            T00NI=T1K00**NCHRI
C
C FOR EACH GENOTYPE, UPDATE THE SUMS.
C
            TKIJ=0.D0
            DTKIJR=0.D0
            DTKIJT=0.D0
            DTKIJP=0.D0
            DO 10 L=MINL,MAXL
              JL=J-L
              TERM1=BINOM(I,L)*T1110**L*T10I
              TERM2=BINOM(NCHRI,JL)*T0100**JL*T00NI
              TKIJL=TERM1*TERM2
              TKIJ=TKIJ+TKIJL
              TERMR=L*THT11+(L-I)/S+JL/R-(NCHRIJ+L)*THT00
              TERMT=(IJ-L-L)/TH-L*ST11-(NCHRIJ+L)*RT00
              DTKIJR=DTKIJR+TKIJL*TERMR
              TTKIJL=TERMT*TKIJL
              DTKIJT=DTKIJT+TTKIJL*DTH
              DTKIJP=DTKIJP+TTKIJL*DPPAR
   10       CONTINUE
C
C SAVE THE SUMS.
C
            TRANSP(K,I,J)=TKIJ
            DTRANS(K,I,J,1)=DTKIJR
            DTRANS(K,I,J,2)=DTKIJT
            IF(IPAN.EQ.1)DTRANS(K,I,J,3)=0.D0
            IF(IPAN.GT.1)DTRANS(K,I,J,3)=DTKIJP
   20     CONTINUE
   30   CONTINUE
   40 CONTINUE
C
      RETURN
      END
C
C
C
      FUNCTION IRLOC(IPAN,ISEL,K,MODEL,NLOCUS)                                
C                                                                          
C RETURN THE LOCATION IN PAR OF THE CURRENT RETENTION PROBABILITY.
C FOR MODELS 1-3, 5-7.  THIS DEPENDS ON THE CURRENT LOCUS (K) FOR
C MODELS 3, 6, AND 7, AND ON THE SELECTED LOCUS ISEL FOR MODELS 6
C AND 7. NOTE: STRUCTURE OF PAR IS EXPLAINED IN SUBROUTINE INITPM.
C
      IMPLICIT REAL*8(A-H,O-Z)                                             
C           
      NLOCM1=NLOCUS-1
      MOD=MODEL
      IF(MODEL.EQ.5.OR.MODEL.EQ.6)MOD=MODEL-3
      IF(MODEL.EQ.3.OR.MODEL.EQ.7)GO TO 10
C                                                                          
C MODEL=1, 2, 5 OR 6.
C                                                                          
      IRLOC=NLOCM1+IPAN*MOD                                           
      IF(MODEL.EQ.6.AND.K.LT.ISEL)IRLOC=IRLOC-2
      GO TO 20                                                             
C                                                                          
C MODEL=3 OR 7                                                                 
C                                                                          
 10   IRLOC=NLOCUS*IPAN+K
      IF(MODEL.EQ.7.AND.K.LT.ISEL)IRLOC=IRLOC-1
 20   RETURN                                                               
      END                                                                  
C
C
C
      SUBROUTINE COMB(BINOM,MAXN,N)
C
C CALCULATE BINOMIAL COEFFICIENTS UP TO THE MAXN ROW.
C
      IMPLICIT REAL*8(A-H,O-Z)
      REAL*8 BINOM(0:MAXN,0:MAXN)
C
C SET THE N CHOOSE ZERO TERMS AND THE N CHOOSE N TERMS TO ONE.
C
      DO 10 I=0,N
        BINOM(I,0)=1.D0
        BINOM(I,I)=1.D0
   10 CONTINUE
C
C IF THERE IS ONLY ONE ROW, WE ARE DONE.
C
      IF(N.EQ.1)GO TO 40
C
C FOR EACH REMAINING ROW AND COLUMN ...
C
      N1=N-1
      DO 30 IROW=2,N
        IROW1=IROW-1
        DO 20 ICOL=1,N1
          BINOM(IROW,ICOL)=BINOM(IROW1,ICOL-1)+BINOM(IROW1,ICOL)
   20   CONTINUE
   30 CONTINUE
C
   40 RETURN
      END
C
C
C
      SUBROUTINE CALCON(BRLIST,CHECK,CONDP,IHYB,IP,MAXHYB,MAXLOC
     1,MAXPAN,NBREAK,NLOCUS,NPAR,PAR,PERM,RETAIN)
C
C CALCULATE THE CONDITIONAL PROBABILITY OF THE RETENTION DATA GIVEN
C THE BREAKAGE VECTOR.  FOR THE GENERAL RETENTION MODEL.
C
      IMPLICIT REAL*8(A-H,O-Z)
      INTEGER BRLIST(0:MAXLOC),CHECK(MAXHYB),PERM(MAXLOC)
     1,RETAIN(MAXPAN,MAXHYB,MAXLOC)
      REAL*8 CONDP(MAXHYB),PAR(NPAR)
C
      NL2=NLOCUS+NLOCUS
      PROB=1.D0
      CHECK(IHYB)=0
      CONDP(IHYB)=0.D0
C
C FOR EACH FRAGMENT DETERMINE WHETHER THE BREAKAGE VECTOR IS CONSISTENT
C WITH THE RETENTION PATTERN FOR THE HYBRID.
C
      NBRK1=NBREAK-1
      DO 20 IBREAK=0,NBRK1
C
C FIND THE FRAGMENT END LOCI.
C
        LSTART=BRLIST(IBREAK)+1
        LEND=BRLIST(IBREAK+1)
C
C CHECK THE NEXT FRAGMENT.  IF CONSISTENT, CONTINUE; IF NOT, JUMP OUT.
C
        IROLD=2
        DO 10 LOCUS=LSTART,LEND
          IR=RETAIN(IP,IHYB,PERM(LOCUS))
          IF(IR+IROLD.EQ.1)GO TO 30
            IF(IR.NE.IROLD)IROLD=IR+IROLD-2
   10   CONTINUE
C
C IF THE FRAGMENT IS CONSISTENT, UPDATE THE CONDITIONAL
C RETENTION PROBABILITY FOR THE HYBRID GIVEN THE BREAKAGE VECTOR.
C
        IPAR=LEND-1+(NL2-LSTART+1)*LSTART/2
        IF(IROLD.EQ.0)PROB=PROB*(1.D0-PAR(IPAR))
        IF(IROLD.EQ.1)PROB=PROB*PAR(IPAR)
   20 CONTINUE
C
C IF WE HAVE GOTTEN HERE, THE VECTOR IS CONSISTENT.  UPDATE THE
C CONDITIONAL PROBABILITY VECTOR AND THE CONSISTENCY CHECK.
C
      CHECK(IHYB)=1
      CONDP(IHYB)=PROB
C
   30 RETURN
      END
C
C
C
      SUBROUTINE BINSUB(BRLIST,INEW,NBREAK,NLOCUS,NPAR,PAR,PBREAK)
C
C MODIFY THE BREAKAGE LIST IN A MANNER EQUIVALENT TO SUBTRACT ONE FROM
C THE BINARY VECTOR.  UPDATE THE PROBABILITY OF THE BREAKAGE LIST.
C
      IMPLICIT REAL*8(A-H,O-Z)
      INTEGER BRLIST(0:NLOCUS)
      REAL*8 PAR(NPAR)
C
C FIND THE LAST ELEMENT OF THE BREAKAGE LIST BEFORE NLOCUS.  DELETE
C THIS BREAK.  MODIFY THE BREAKAGE PROBABILITY.
C
      INEW=NBREAK-1
      LAST=BRLIST(INEW)
      PBREAK=PBREAK*(1.D0-PAR(LAST))/PAR(LAST)
C
C LAST+1,...,NLOCUS SHOULD BE ADDED TO THE END OF THE BREAKAGE LIST.
C ADD THESE BREAKS.  MODIFY THE BREAKAGE PROBABILITY.
C
      NLOC1=NLOCUS-1
      NBREAK=NBREAK-2
      DO 10 I=LAST+1,NLOC1
        NBREAK=NBREAK+1
        BRLIST(NBREAK)=I
        PBREAK=PBREAK*PAR(I)/(1.D0-PAR(I))
   10 CONTINUE
      NBREAK=NBREAK+1
      BRLIST(NBREAK)=NLOCUS
C
      RETURN
      END
C
C
C
      SUBROUTINE ITROUT(F,ITER,KITER,MAXPAR,NPAR,PAR,PNAME)
C
C OUTPUT THE RESULTS FOR THE CURRENT ITERATION.
C
      IMPLICIT REAL*8(A-H,O-Z)
      REAL*8 PAR(MAXPAR)
      CHARACTER*8 PNAME(MAXPAR)
C
C IF THIS IS THE FIRST ITERATION, OUTPUT A HEADER.
C
      IF(ITER.GT.1)GO TO 10
        WRITE(KITER,1000)
 1000   FORMAT(/' EM MAXIMIZATION')
        WRITE(KITER,101)(PNAME(I),I=1,NPAR)
 101    FORMAT(/' ITER       LOGLIK   ',200(T23,6(1X,A8)/))
        WRITE(KITER,102)
 102    FORMAT(A)
C
   10 WRITE(KITER,103)ITER,F/DLOG(10.D0),(PAR(I),I=1,NPAR)
 103  FORMAT(I5,2X,F14.6,6F9.5,200(/T22,6F9.5))
C
      RETURN
      END
C
C
C
      SUBROUTINE BRPROB(BINOM,BRKDST,BSTPAR,EBREAK,ICONDS,IPAN,ISEL
     1,MAXCHR,MAXLOC,MAXPAR,MODEL,NCHR,NLOCUS,NPAN,NTYPEH,NUMBRK
     2,PBREAK,PRODMX,RETHYB,TAILPR,TRANSP,TRMISS,TYPED)
C
C FOR MODELS 1-3, (CONDITIONAL OR UNCONDITIONAL MODEL 1), CARRY OUT THE 
C RECURSION TO DETERMINE THE DISTRIBUTION FOR THE NUMBER OF OBLIGATE 
C BREAKS FOR A HYBRID WITH RETENTION OBSERVATION PATTERN EMBODIED BY 
C HYBRID RETHYB.  PBREAK(*,B,K) IS THE PROBABILITY OF B OBLIGATE BREAKS 
C AND K COPIES OF THE LOCUS RETAINED AFTER A CERTAIN NUMBER OF LOCI.  
C * IS 1 FOR ODD NUMBERED LOCI, 2 FOR EVEN NUMBERED LOCI. AT THE END 
C OF THE RECURRENCE, ADD THE CALCULATED JOINT PROBABILITIES TO OBTAIN 
C THE OBLIGATE BREAK DISTRIBUTION.  
C
      IMPLICIT REAL*8(A-H,O-Z)
      INTEGER B,B1,RETHYB(MAXLOC),TYPED(MAXLOC)
      REAL*8 BINOM(0:MAXCHR,0:MAXCHR),BRKDST(0:MAXLOC),BSTPAR(MAXPAR)
     1,PBREAK(2,0:MAXLOC,0:MAXCHR),PRODMX(0:MAXCHR,0:MAXCHR)
     2,TRANSP(MAXLOC,0:MAXCHR,0:MAXCHR),TRMISS(0:MAXCHR,0:MAXCHR)
C
C BEGIN BY DETERMINING THE TYPED LOCI AND THE NUMBER OF OBLIGATE BREAKS.
C FOR A CONDITIONAL EQUAL RETENTION MODEL (MODEL=1, ICONDS=1), TREAT
C A CONDITIONAL SELECTED LOCUS AS IF IT IS TYPED AND PRESENT.
C
      NTYPEH=0
      NUMBRK=0
      LSTRET=2
      DO 10 LOCUS=1,NLOCUS
        LRET=RETHYB(LOCUS)
        IF(LRET.EQ.2.AND.LOCUS.NE.ISEL)GO TO 10
          NTYPEH=NTYPEH+1
          TYPED(NTYPEH)=LOCUS
          IF(LRET.EQ.LSTRET)GO TO 10
            IF(LSTRET.NE.2)NUMBRK=NUMBRK+1
            LSTRET=LRET
   10 CONTINUE
      NTYPE1=NTYPEH-1
C
C SET OUTPUT VARIABLES TO THE APPROPRIATE VALUES FOR 0 OR 1 TYPED LOCI.
C
      BRKDST(0)=1.D0
      EBREAK=0.D0
      TAILPR=1.D0
      IF(NTYPEH.LE.1)GO TO 250
C
C SET THE INITIAL CONDITIONS FOR THE RECURSION.  FIRST, DETERMINE THE
C RETENTION PROBABILITY FOR THE FIRST TYPED LOCUS.  IF THE FIRST LOCUS
C IS THE SELECTED LOCUS FOR A CONDITIONAL EQUAL RETENTION MODEL, WE 
C HAVE ASSUMED (SEE ABOVE) THAT THE SELECTED LOCUS IS TYPED.
C
        IR1=LOCR(IPAN,ISEL,MODEL,NLOCUS)
        R=BSTPAR(IR1)
        IF(TYPED(1).EQ.1)GO TO 30
          IR2=IR1
          IF(MODEL.NE.1)IR2=IR1+1
          ITYPE1=TYPED(1)-1
          IF(IPAN.GT.1)NPPAR=LOCP(IPAN,MODEL,NLOCUS,NPAN)
C
          DO 20 LOCUS=1,ITYPE1
            TH=BSTPAR(LOCUS)
            IF(IPAN.GT.1)TH=1.D0-(1.D0-TH)**(BSTPAR(NPPAR))
            RNEXT=BSTPAR(IR2)
            R=R*(1.D0-TH)+TH*RNEXT
            IF(MODEL.EQ.3)IR2=IR2+1
   20     CONTINUE
C
   30   R1=1.D0-R
        DO 40 K=0,NCHR
          PBREAK(1,0,K)=BINOM(NCHR,K)*R**K*R1**(NCHR-K)
   40   CONTINUE
C
C FOR EACH SUBSEQUENT LOCUS, CARRY OUT THE RECURSION TO DETERMINE
C THE DISTRIBUTION OF THE NUMBER OF OBLIGATE CHROMOSOME BREAKS.
C
        INEW=1
        IOLD=2
        DO 220 LOCT=2,NTYPEH
          LOCT1=LOCT-1
          LSTART=TYPED(LOCT1)
          LEND=TYPED(LOCT)-1
          INEW=IOLD
          IOLD=3-INEW
C
C CALCULATE THE TRANSITION MATRIX TRMISS FROM LOCUS TYPED(LOCT-1) TO LOCUS
C TYPED(LOCT).  BEGIN BY INITIALIZING TRMISS TO THE TRANSITION MATRIX
C FOR LOCUS TYPED(LOCT-1) TO LOCUS TYPED(LOCT-1)+1.
C
          DO 60 I=0,NCHR
            DO 50 J=0,NCHR
              TRMISS(I,J)=TRANSP(LSTART,I,J)
   50       CONTINUE
   60     CONTINUE
          LSTART=LSTART+1
C
C IF THERE ARE NO UNTYPED LOCI IN THIS INTERVAL, WE ARE READY TO GO.
C OTHERWISE, CALCULATE THE PRODUCT OF THE APPROPRIATE TRANSITION
C PROBABILITY MATRICES.  STORE THE RESULTING MATRIX IN TRMISS.
C
          IF(LSTART.GT.LEND)GO TO 130
            DO 120 LOC=LSTART,LEND
              DO 90 I=0,NCHR
                DO 80 J=0,NCHR
                  SUM=0.D0
                  DO 70 K=0,NCHR
                    SUM=SUM+TRMISS(I,K)*TRANSP(LOC,K,J)
   70             CONTINUE
                  PRODMX(I,J)=SUM
   80           CONTINUE
   90         CONTINUE
C
              DO 110 I=0,NCHR
                DO 100 J=0,NCHR
                  TRMISS(I,J)=PRODMX(I,J)
  100           CONTINUE
  110         CONTINUE
C
  120       CONTINUE
C
C HAVING DEALT WITH ANY MISSING LOCI, WE NOW HAVE THE APPROPRIATE
C TRANSITION PROBABILITIES IN TRMISS TO ALLOW US TO CARRY OUT THE
C NEXT STEP OF THE RECURRENCE.
C
  130     DO 210 B=0,LOCT1
            B1=B-1
C
C DO THE CASE OF K=0 CHROMOSOMES RETAINED AT THE CURRENT LOCUS.
C FOR THE CONDITIONAL EQUAL RETENTION MODEL:  IF THE CURRENT LOCUS 
C IS THE SELECTED LOCUS, THEN WE ASSUME AT LEAST ONE COPY OF THE 
C LOCUS IS RETAINED AND SET PBREAK(INEW,B,0)=0.D0.  IF THE PREVIOUS
C LOCUS IS THE SELECTED LOCUS, THEN PBREAK(IOLD,B,0)=0.D0, SO 
C PB IS A FUNCTION ONLY OF PBREAK(IOLD,B1,J), J>0.  
C
            PB=0.D0
            IF(ICONDS.EQ.1.AND.TYPED(LOCT).EQ.ISEL)GO TO 160
            IF(ICONDS.EQ.1.AND.TYPED(LOCT1).EQ.ISEL)GO TO 140
            IF(B.LT.LOCT1)PB=PBREAK(IOLD,B,0)*TRMISS(0,0)
  140       IF(B.EQ.0)GO TO 160
              DO 150 J=1,NCHR
                PB=PB+PBREAK(IOLD,B1,J)*TRMISS(J,0)
  150         CONTINUE
  160       PBREAK(INEW,B,0)=PB
C
C DO THE REMAINING CASES OF K=1,...,NCHR CHROMOSOMES RETAINED AT THE
C CURRENT LOCUS.  FOR THE CONDITIONAL EQUAL RETENTION MODEL:  IF THE 
C PREVIOUS LOCUS IS THE SELECTED LOCUS, THEN PBREAK(IOLD,B1,0)=0.D0
C SO PB IS A FUNCTION ONLY OF PBREAK(IOLD,B1,J), J>0.  
C
            DO 200 K=1,NCHR
              PB=0.D0
              IF(ICONDS.EQ.1.AND.TYPED(LOCT1).EQ.ISEL)GO TO 170
              IF(B.GT.0)PB=PBREAK(IOLD,B1,0)*TRMISS(0,K)
  170         IF(B.EQ.LOCT1)GO TO 190
                DO 180 J=1,NCHR
                  PB=PB+PBREAK(IOLD,B,J)*TRMISS(J,K)
  180           CONTINUE
  190         PBREAK(INEW,B,K)=PB
  200       CONTINUE
  210     CONTINUE
C
  220   CONTINUE
C
C CALCULATE THE BREAKAGE PROBABILITY DISTRIBUTION BY SUMMING OVER
C THE APPROPRIATE JOINT DISTRIBUTIONS.  ALSO CALCULATE THE EXPECTED
C NUMBER OF OBLIGATE BREAKS AND THE TAIL PROBABILITY FOR THE NUMBER
C OF OBLIGATE BREAKS OBSERVED FOR THE CURRENT HYBRID.
C
          EBREAK=0.D0
          TAILPR=0.D0
          SC1=1.D0-(1.D0-BSTPAR(IR1))**NCHR
          DO 240 B=0,NTYPE1
            PB=0.D0
            DO 230 K=0,NCHR
              PB=PB+PBREAK(INEW,B,K)
  230       CONTINUE
C
C FOR A CONDITIONAL MODEL, ADJUST THE PROBABILITY BY DIVIDING
C BY THE PROBABILITY OF NO COPIES OF THE SELECTED LOCUS BEING 
C RETAINED.
C
            IF(ICONDS.EQ.1)PB=PB/SC1
            BRKDST(B)=PB
            EBREAK=EBREAK+DBLE(B)*PB
            IF(B.GE.NUMBRK)TAILPR=TAILPR+BRKDST(B)
  240     CONTINUE
C
  250 RETURN
      END
C
C
C
      SUBROUTINE BRPRBS(BDISTC,BINOM,BRKDST,BSTPAR,EBREAK,ICONDS,IPAN
     1,ISEL,MAXCHR,MAXLOC,MAXPAR,MODEL,NCHR,NLOCUS,NTYPEH
     2,NUMBRK,PBREAK,PRODMX,RETHYB,TAILPR,TRANSP,TRMISS,TYPED)
C
C FOR UNCONDITIONAL MODELS 5, 6, AND 7 AND CONDITIONAL MODELS 5 AND 6
C CARRY OUT THE RECURSION TO DETERMINE THE DISTRIBUTION FOR THE NUMBER
C OF OBLIGATE BREAKS FOR A HYBRID WITH RETENTION OBSERVATION PATTERN
C EMBODIED BY HYBRID RETHYB.  PBREAK(*,B,K) IS THE PROBABILITY OF
C B OBLIGATE BREAKS AND K COPIES OF THE LOCUS RETAINED AFTER A CERTAIN
C NUMBER OF LOCI.  * IS 1 FOR ODD NUMBERED LOCI, 2 FOR EVEN NUMBERED
C LOCI.  AT THE END OF THE RECURRENCE, ADD THE CALCULATED JOINT
C PROBABILITIES TO OBTAIN THE OBLIGATE BREAK DISTRIBUTION.
C ASSUMES SELECTED LOCUS IS COMPLETELY TYPED.
C
      IMPLICIT REAL*8(A-H,O-Z)
      INTEGER B,B1,RETHYB(MAXLOC),TYPED(MAXLOC)
      REAL*8 BDISTC(0:MAXLOC,0:MAXCHR),BINOM(0:MAXCHR,0:MAXCHR)
     1,BRKDST(0:MAXLOC),BSTPAR(MAXPAR),PBREAK(2,0:MAXLOC,0:MAXCHR)
     2,PRODMX(0:MAXCHR,0:MAXCHR),TRANSP(MAXLOC,0:MAXCHR,0:MAXCHR)
     3,TRMISS(0:MAXCHR,0:MAXCHR)
C
C BEGIN BY DETERMINING THE TYPED LOCI AND THE NUMBER OF OBLIGATE BREAKS.
C ALSO DETERMINE THE POSITION OF THE SELECTED LOCUS AMONG THE TYPED LOCI.
C
      NTYPEH=0
      NUMBRK=0
      LSTRET=2
      ISELOC=0
      DO 10 LOCUS=1,NLOCUS
        LRET=RETHYB(LOCUS)
        IF(LRET.EQ.2.AND.LOCUS.NE.ISEL)GO TO 10
          NTYPEH=NTYPEH+1
          TYPED(NTYPEH)=LOCUS
          IF(LOCUS.EQ.ISEL)ISELOC=NTYPEH
          IF(LRET.EQ.LSTRET.OR.LRET.EQ.2)GO TO 10
            IF(LSTRET.NE.2)NUMBRK=NUMBRK+1
            LSTRET=LRET
   10 CONTINUE
      NTYPE1=NTYPEH-1
C
C SET OUTPUT VARIABLES TO THE APPROPRIATE VALUES FOR 0 OR 1 TYPED LOCI.
C
      BRKDST(0)=1.D0
      EBREAK=0.D0
      TAILPR=1.D0
      IF(NTYPEH.LE.1)GO TO 530
C
C DETERMINE THE RETENTION PROBABILITY FOR THE SELECTED LOCUS
C
        IS=LOCR(IPAN,ISEL,MODEL,NLOCUS)
        R=BSTPAR(IS)
        R1=1.D0-R
C
C LOOP THROUGH THE POSSIBLE GENOTYPES AT THE SELECTED LOCUS.  WE WILL
C COMPUTE THE DISTRIBUTIONS CONDITIONAL ON THE NUMBER OF COPIES (IGS)
C OF THE SELECTED MARKER THAT ARE RETAINED.
C
        IGSTRT=0
        IF(ICONDS.EQ.1)IGSTRT=1
        DO 500 IGS=IGSTRT,NCHR
C
C INITIALIZE BRKDST AND PBREAK FOR THIS ROUND . . .
C
          DO 60 B=0,NTYPEH-1
            BRKDST(B)=0.D0
            DO 50 I=1,2
              DO 40 K=0,NCHR
                 PBREAK(I,B,K)=0.D0
   40         CONTINUE
   50       CONTINUE
   60     CONTINUE
C
C FOR EACH LOCUS TO THE RIGHT OF THE SELECTED LOCUS, CARRY OUT THE 
C RECURSION TO DETERMINE THE DISTRIBUTION OF THE NUMBER OF OBLIGATE 
C CHROMOSOME BREAKS.
C
          INEW=1
          IOLD=2
          BRKDST(0)=1.D0
	  IF(ISELOC.EQ.NTYPEH)GO TO 275
          DO 250 LOCT=ISELOC+1,NTYPEH
            LOCT1=LOCT-1
            LSTART=TYPED(LOCT1)
            LEND=TYPED(LOCT)-1
            INEW=IOLD
            IOLD=3-INEW
C
C CALCULATE THE TRANSITION MATRIX TRMISS FROM LOCUS TYPED(LOCT-1) TO LOCUS
C TYPED(LOCT).  BEGIN BY INITIALIZING TRMISS TO THE TRANSITION MATRIX
C FOR LOCUS TYPED(LOCT-1) TO LOCUS TYPED(LOCT-1)+1.
C
            DO 80 I=0,NCHR
              DO 70 J=0,NCHR
                TRMISS(I,J)=TRANSP(LSTART,I,J)
   70         CONTINUE
   80       CONTINUE
            LSTART=LSTART+1
C
C IF THERE ARE NO UNTYPED LOCI IN THIS INTERVAL, WE ARE READY TO GO.
C OTHERWISE, CALCULATE THE PRODUCT OF THE APPROPRIATE TRANSITION
C PROBABILITY MATRICES.  STORE THE RESULTING MATRIX IN TRMISS.
C
            IF(LSTART.GT.LEND)GO TO 150
              DO 140 LOC=LSTART,LEND
                DO 110 I=0,NCHR
                  DO 100 J=0,NCHR
                    SUM=0.D0
                    DO 90 K=0,NCHR
                      SUM=SUM+TRMISS(I,K)*TRANSP(LOC,K,J)
   90               CONTINUE
                    PRODMX(I,J)=SUM
  100             CONTINUE
  110           CONTINUE
C
                DO 130 I=0,NCHR
                  DO 120 J=0,NCHR
                    TRMISS(I,J)=PRODMX(I,J)
  120             CONTINUE
  130           CONTINUE
C
  140         CONTINUE
C
C HAVING DEALT WITH ANY MISSING LOCI, WE NOW HAVE THE APPROPRIATE
C TRANSITION PROBABILITIES IN TRMISS TO ALLOW US TO CARRY OUT THE
C NEXT STEP OF THE RECURRENCE.
C
C INITIAL CONDITIONS IF WE ARE AT THE FIRST TYPED LOCUS AFTER ISELOC:
C
  150       IF(LOCT.GT.ISELOC+1)GO TO 180
	       IGSTAR=1-MIN0(IGS,1)
               PBREAK(INEW,1-IGSTAR,0)=TRMISS(IGS,0)
               DO 160 J=1,NCHR
                 PBREAK(INEW,IGSTAR,J)=TRMISS(IGS,J)
  160          CONTINUE
C
            GO TO 250
C
  180       LOCTI=LOCT-ISELOC
            DO 240 B=0,LOCTI
              B1=B-1
C
C DO THE CASE OF K=0 CHROMOSOMES RETAINED AT THE CURRENT LOCUS.
C
              PB=0.D0
              IF(B.LT.LOCTI)PB=PBREAK(IOLD,B,0)*TRMISS(0,0)
              IF(B.EQ.0)GO TO 200
                DO 190 J=1,NCHR
                  PB=PB+PBREAK(IOLD,B1,J)*TRMISS(J,0)
  190           CONTINUE
  200         PBREAK(INEW,B,0)=PB
C
C DO THE REMAINING CASES OF K=1,...,NCHR CHROMOSOMES RETAINED AT THE
C CURRENT LOCUS.
C
              DO 230 K=1,NCHR
                PB=0.D0
                IF(B.GT.0)PB=PBREAK(IOLD,B1,0)*TRMISS(0,K)
                IF(B.EQ.LOCTI)GO TO 220
                  DO 210 J=1,NCHR
                    PB=PB+PBREAK(IOLD,B,J)*TRMISS(J,K)
  210             CONTINUE
  220           PBREAK(INEW,B,K)=PB
  230         CONTINUE
  240       CONTINUE
  250     CONTINUE
C
C CALCULATE THE DISTRIBUTION OF OBLIGATE BREAKS SO FAR, CONDITIONAL ON
C GS=IGS.
C
          DO 270 B=0,NTYPEH-1
            PB=0.D0
            DO 260 K=0,NCHR
              PB=PB+PBREAK(INEW,B,K)
  260       CONTINUE
            BRKDST(B)=PB
  270     CONTINUE
C
C CONTINUE ON IN THE OTHER DIRECTION FROM THE SELECTED LOCUS
C
  275     IF(ISELOC.EQ.1)GO TO 475
          DO 470 LOCT=ISELOC-1,1,-1
            LOCT1=LOCT+1
            LSTART=TYPED(LOCT)
            LEND=TYPED(LOCT)+1
            INEW=IOLD
            IOLD=3-INEW
C
C CALCULATE THE TRANSITION MATRIX TRMISS FROM LOCUS TYPED(LOCT+1x) TO LOCUS
C TYPED(LOCT).  BEGIN BY INITIALIZING TRMISS TO THE TRANSITION MATRIX
C FOR LOCUS TYPED(LOCT+1) TO LOCUS TYPED(LOCT+1)-1.
C
            DO 290 I=0,NCHR
              DO 280 J=0,NCHR
                TRMISS(I,J)=TRANSP(LSTART,I,J)
  280         CONTINUE
  290       CONTINUE
            LSTART=LSTART-1
C
C IF THERE ARE NO UNTYPED LOCI IN THIS INTERVAL, WE ARE READY TO GO.
C OTHERWISE, CALCULATE THE PRODUCT OF THE APPROPRIATE TRANSITION
C PROBABILITY MATRICES.  STORE THE RESULTING MATRIX IN TRMISS.  MAKE
C USE OF THE FACT THAT THE TRANSITION PROCESS RIGHT TO LEFT AND LEFT 
C TO RIGHT ARE THE SAME.
C
            IF(LSTART.LT.LEND)GO TO 360
              DO 350 LOC=LSTART,LEND
                DO 320 I=0,NCHR
                  DO 310 J=0,NCHR
                    SUM=0.D0
                    DO 300 K=0,NCHR
                      SUM=SUM+TRMISS(I,K)*TRANSP(LOC,K,J)
  300               CONTINUE
                    PRODMX(I,J)=SUM
  310             CONTINUE
  320           CONTINUE
C
                DO 340 I=0,NCHR
                  DO 330 J=0,NCHR
                    TRMISS(I,J)=PRODMX(I,J)
  330             CONTINUE
  340           CONTINUE
C
  350         CONTINUE
C
C HAVING DEALT WITH ANY MISSING LOCI, WE NOW HAVE THE APPROPRIATE
C TRANSITION PROBABILITIES IN TRMISS TO ALLOW US TO CARRY OUT THE
C NEXT STEP OF THE RECURRENCE.
C
  360       LOCTI=NTYPEH-LOCT
            DO 460 B=0,LOCTI
              B1=B-1
              PB=0.D0
C
C INITIAL CONDITIONS IF WE ARE AT THE FIRST TYPED LOCUS BEFORE THE 
C SELECTED LOCUS.
C
              IF(LOCT.LT.ISELOC-1)GO TO 390
              IF(IGS.GT.0)GO TO 375
                PBREAK(INEW,B,0)=BRKDST(B)*TRMISS(0,0)
                IF(B.EQ.0)GO TO 450
                  DO 370 J=1,NCHR
                    PBREAK(INEW,B,J)=BRKDST(B1)*TRMISS(0,J)
  370             CONTINUE
	        GO TO 450
  375             IF(B.GT.0)PBREAK(INEW,B,0)=BRKDST(B1)*TRMISS(IGS,0)
                  DO 380 J=1,NCHR
                    PBREAK(INEW,B,J)=BRKDST(B)*TRMISS(IGS,J)
  380             CONTINUE
                GO TO 450
C
C DO THE CASE OF K=0 CHROMOSOMES RETAINED AT THE CURRENT LOCUS.
C 
  390         IF(B.LT.LOCTI)PB=PBREAK(IOLD,B,0)*TRMISS(0,0)
              IF(B.EQ.0)GO TO 410
              DO 400 J=1,NCHR
                PB=PB+PBREAK(IOLD,B1,J)*TRMISS(J,0)
  400         CONTINUE
  410         PBREAK(INEW,B,0)=PB
C
C DO THE REMAINING CASES OF K=1,...,NCHR CHROMOSOMES RETAINED AT THE
C CURRENT LOCUS.
C
              DO 440 K=1,NCHR
                PB=0.D0
                IF(B.GT.0)PB=PBREAK(IOLD,B1,0)*TRMISS(0,K)
                IF(B.EQ.LOCTI)GO TO 430
                DO 420 J=1,NCHR
                  PB=PB+PBREAK(IOLD,B,J)*TRMISS(J,K)
  420           CONTINUE
  430           PBREAK(INEW,B,K)=PB
  440         CONTINUE
  450         CONTINUE
  460       CONTINUE
  470     CONTINUE
  475     DO 490 B=0,NTYPE1
            PB=0.D0
            DO 480 K=0,NCHR
              PB=PB+PBREAK(INEW,B,K)
  480       CONTINUE
            BDISTC(B,IGS)=PB
  490     CONTINUE
  500   CONTINUE
C
C CALCULATE THE BREAKAGE PROBABILITY DISTRIBUTION BY SUMMING OVER
C THE APPROPRIATE JOINT DISTRIBUTIONS.  ALSO CALCULATE THE EXPECTED
C NUMBER OF OBLIGATE BREAKS AND THE TAIL PROBABILITY FOR THE NUMBER
C OF OBLIGATE BREAKS OBSERVED FOR THE CURRENT HYBRID.
C
        EBREAK=0.D0
        TAILPR=0.D0
        SC1=1.D0-R1**NCHR
        DO 520 B=0,NTYPE1
          PB=0.D0
          DO 510 IGS=IGSTRT,NCHR
            PB=PB+BDISTC(B,IGS)*BINOM(NCHR,IGS)*R**IGS*R1**(NCHR-IGS)
  510     CONTINUE
          IF(ICONDS.EQ.1)PB=PB/SC1
          BRKDST(B)=PB
          EBREAK=EBREAK+DBLE(B)*PB
          IF(B.GE.NUMBRK)TAILPR=TAILPR+PB
  520   CONTINUE
C
  530 RETURN
      END
C 
C 
C
      SUBROUTINE MAXLIK(ALPHA,ALPHAP,BETA,BETAP,BINOM,BRLIST,CHECK
     1,CONDP,CONV,DF,DFHYB,DP,DTRANS,EMSTEP,F,HPROB,ICONDS,KITER,KOUT
     2,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MLTOPT,MODEL,MXITER,NCHR
     3,NCONV,NHYB,NLOCUS,NOBS,NPAN,NPAR,NRET,NTYPE,NUMHYB,OUTOPT
     4,PAR,PERM,PNAME,RETAIN,SELNUM,SUBPRM,TOL,TRANS1,TRANSP)
C
C CALCULATE THE LOG(E)-LIKELIHOOD AND SCORE FOR THE MARKOVIAN AND
C GENERAL MODELS.
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*8 PNAME(MAXPAR)
      INTEGER BRLIST(0:MAXLOC),CHECK(MAXPAN,MAXHYB)
     1,NCHR(MAXPAN),NHYB(MAXPAN),NOBS(MAXPAN,MAXHYB),NUMHYB(MAXPAN)
     2,OUTOPT,PERM(MAXLOC),RETAIN(MAXPAN,MAXHYB,MAXLOC),SELNUM
     3,SUBPRM(2,MAXLOC)
      REAL*8 ALPHA(MAXLOC,0:MAXCHR),ALPHAP(2,MAXLOC,0:MAXCHR,0:MAXCHR)
     1,BETA(MAXLOC,0:MAXCHR),BETAP(2,MAXLOC,0:MAXCHR)
     2,BINOM(0:MAXCHR,0:MAXCHR),CONDP(MAXHYB),DF(MAXPAR)
     3,DFHYB(MAXHYB,MAXPAR),DP(MAXPAR)
     4,DTRANS(MAXLOC,0:MAXCHR,0:MAXCHR,3),HPROB(MAXPAN,MAXHYB)
     5,NRET(MAXLOC),NTYPE(MAXLOC),PAR(MAXPAR),TRANS1(MAXLOC,0:1,0:1)
     6,TRANSP(MAXLOC,0:MAXCHR,0:MAXCHR)
C
C INITIALIZE THE LOG(E)-LIKELIHOOD F
C
      F=0.D0
C
C IF MLTOPT=0 (DISTINCT DISTANCES), COMPUTE THE MAXIMUM LIKELIHOOD
C FOR THE ORDER FOR EACH PANEL SEPARATELY.
C
      NTRIP=NPAN
      NP=1
C
C IF MLTOPT=1 (PROPORTIONAL DISTANCES), COMPUTE THE MAXIMUM
C LIKELIHOOD FOR THE ORDER USING ALL PANELS SIMULTANEOUSLY.
C
      IF(MLTOPT.EQ.0)GO TO 10
        NTRIP=1
        IP=0
        NP=NPAN
C
   10 DO 20 IPAN=1,NTRIP
        IF(MLTOPT.EQ.0)IP=IPAN
        CALL MAXL1(ALPHA,ALPHAP,BETA,BETAP,BINOM,BRLIST,CHECK,CONDP
     1  ,CONV,DF,DFHYB,DP,DTRANS,EMSTEP,F1,HPROB,ICONDS,IP,KITER,KOUT
     2  ,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MLTOPT,MODEL,MXITER,NCHR
     3  ,NCONV,NHYB,NLOCUS,NOBS,NP,NPAR,NRET,NTYPE,NUMHYB,OUTOPT,PAR
     4  ,PERM,PNAME,RETAIN,SELNUM,SUBPRM,TOL,TRANS1,TRANSP)
        F=F+F1
   20   CONTINUE
C
        RETURN
        END
C
C
C
      SUBROUTINE MAXL1(ALPHA,ALPHAP,BETA,BETAP,BINOM,BRLIST,CHECK
     1,CONDP,CONV,DF,DFHYB,DP,DTRANS,EMSTEP,F,HPROB,ICONDS,IP,KITER,KOUT
     2,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MLTOPT,MODEL,MXITER,NCHR,NCONV
     3,NHYB,NLOCUS,NOBS,NPAN,NPAR,NRET,NTYPE,NUMHYB,OUTOPT,PAR,PERM
     4,PNAME,RETAIN,SELNUM,SUBPRM,TOL,TRANS1,TRANSP)
C
C CALCULATE THE LOG(E)-LIKELIHOOD AND SCORE FOR THE MARKOVIAN AND
C GENERAL MODELS FOR ONE PANEL OR FOR THE SET OF PANELS IF PROPORTIONAL
C DISTANCES ARE ASSUMED.
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*8 PNAME(MAXPAR)
      INTEGER BRLIST(0:MAXLOC),CHECK(MAXPAN,MAXHYB),FINISH(0:2)
     1,NCHR(MAXPAN),NHYB(MAXPAN),NOBS(MAXPAN,MAXHYB),NUMHYB(MAXPAN)
     2,OUTOPT,PERM(MAXLOC),RETAIN(MAXPAN,MAXHYB,MAXLOC),SELNUM
     3,START(0:2),IP,SUBPRM(2,MAXLOC)
      REAL*8 ALPHA(MAXLOC,0:MAXCHR),ALPHAP(2,MAXLOC,0:MAXCHR,0:MAXCHR)
     1,BETA(MAXLOC,0:MAXCHR),BETAP(2,MAXLOC,0:MAXCHR)
     2,BINOM(0:MAXCHR,0:MAXCHR),CONDP(MAXHYB),DF(MAXPAR)
     3,DFHYB(MAXHYB,MAXPAR),DP(MAXPAR)
     4,DTRANS(MAXLOC,0:MAXCHR,0:MAXCHR,3)
     5,HPROB(MAXPAN,MAXHYB),NRET(MAXLOC),NTYPE(MAXLOC),PAR(MAXPAR)
     6,TRANS1(MAXLOC,0:1,0:1),TRANSP(MAXLOC,0:MAXCHR,0:MAXCHR)
C
C IF THERE IS A SELECTED LOCUS, DETERMINE WHERE IT LIES IN THE
C CURRENT LOCUS ORDER.
C
      ISEL=0
      IF(SELNUM.EQ.0)GO TO 20
      DO 10 I=1,NLOCUS
        IF(PERM(I).NE.SELNUM)GO TO 10
          ISEL=I
          GO TO 20
   10 CONTINUE
C
C SET THE LIMITS ON THE GENOTYPES FOR EACH OF THE PHENOTYPES.  NOTE:
C THIS IS USED ONLY FOR NON-HAPLOID DATA.
C
   20 START(0)=0
      START(1)=1
      START(2)=0
      FINISH(0)=0
      FINISH(1)=NCHR(IP)
      FINISH(2)=NCHR(IP)
C
C CHOOSE EITHER EM OR QUASI-NEWTON MAXIMIZATION.
C
      IF(IP.EQ.0.OR.ICONDS.EQ.1.OR.MODEL.GT.4)GO TO 40
C
C USE EM FOR THE MARKOVIAN UNCONDITIONAL MODELS (1-3) (IF MULTIPLE
C PANELS, NON-PROPORTIONAL DISTANCES ONLY) AND THE GENERAL MODEL (4).  
C
C DETERMINE THE NUMBER OF PARAMETERS FOR THIS ANALYSIS AND THE 
C PARAMETER NAMES IF NEEDED.  DETERMINE THE INITIAL VALUES OF
C ALL PARAMETERS.  
C
      NPAR=NUMPAR(MLTOPT,MODEL,NLOCUS,NPAN)
      IF(OUTOPT.EQ.2)CALL PARNAM(MAXPAR,MODEL,NLOCUS,1,NPAR,PNAME)
      IF(MODEL.LE.3)CALL INITPM(IP,ISEL,MAXHYB,MAXLOC,MAXPAN
     1,MAXPAR,MODEL,NCHR,NHYB,NLOCUS,NOBS,NPAN,NRET,NTYPE,PAR
     2,PERM,RETAIN)
      IF(MODEL.EQ.4)CALL INITPG(IP,MAXHYB,MAXLOC,MAXPAN,MAXPAR,NHYB(IP)
     1,NLOCUS,NOBS,NRET,NTYPE,PAR,PERM,RETAIN)
C
C CARRY OUT THE EM UPDATE UNTIL CONVERGENCE OR THE ITERATION
C MAXIMUM IS REACHED.
C
      FOLD=-1.D20
      ICONV=0
C
      DO 30 ITER=1,MXITER
C
        IF(ITER.GT.1)CALL UPDATE(DF,DP,EMSTEP,MAXPAR,MODEL
     1  ,NCHR(IP),NLOCUS,NPAR,NUMHYB(IP),PAR,TOL)
C
C COMPUTE THE NEW LOG-LIKELIHOOD AND SCORES.
C
        IF(MODEL.LT.4.AND.NCHR(IP).EQ.1)CALL FUNM(DF,DP,F,HPROB,IP
     1  ,MAXHYB,MAXLOC,MAXPAN,MAXPAR,NHYB(IP),NLOCUS,NOBS,NPAR,PAR
     2  ,PERM,RETAIN)
C
        IF(MODEL.EQ.4.AND.NCHR(IP).EQ.1)CALL FUNG(BRLIST,CHECK,CONDP,DF
     1  ,DFHYB,F,HPROB,IP,MAXHYB,MAXLOC,MAXPAN,MAXPAR,NHYB(IP),NLOCUS
     2  ,NOBS,NPAR,NUMHYB(IP),PAR,PERM,RETAIN)
C
C THE LAST TWO ARGUEMENTS TO FUNP ARE ONLY RELEVANT WHEN FUNP IS CALLED
C FROM WITHIN SUBROUTINE FUN IN SEARCH (DURING QUASI-NEWTON OPTIMIZATION).  
C THEY ARE IGNORED WHEN CALLED FROM HERE, SO WE CALL WITH DUMMY ARGUMENTS.
C
        IF(NCHR(IP).GT.1)CALL FUNP(ALPHA,BETA,BINOM,DF,DTRANS,F,FINISH
     1  ,HPROB,IP,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MODEL,NCHR
     2  ,NHYB,NLOCUS,NOBS,NPAN,NPAR,PAR,PERM,RETAIN,START,TRANS1,TRANSP
     3  ,0,DUMMY)
C
C PRINT ITERATION OUTPUT FOR THIS HYBRID PANEL IF DESIRED.
C
        IF(OUTOPT.EQ.2)CALL ITROUT(F,ITER,KITER,MAXPAR,NPAR,PAR,PNAME)
C
C UPDATE THE CONVERGENCE COUNT.  IF WE HAVE REACHED CONVERGENCE, JUMP
C OUT OF THE LOOP AND RETURN.  OTHERWISE, CONTINUE.
C
        ICONV=ICONV+1
        IF(DABS(FOLD-F).GT.CONV)ICONV=0
        IF(ICONV.GE.NCONV)GO TO 70
        FOLD=F
   30 CONTINUE
      GO TO 50
C
C USE QUASI-NEWTON MAXIMIZATION FOR:  SELECTED LOCUS MODELS 
C (CONDITIONAL OR UNCONDITIONAL), CONDITIONAL EQUAL RETENTION MODEL, 
C ALL MODELS WITH PROPORTIONAL DISTANCES.
C
C DEFINE THE PARAMETER NAMES IF NEEDED AND CALL THE MAXIMIZATION 
C PROCEDURE.
C
   40 IF(OUTOPT.EQ.2)CALL PARNAM(MAXPAR,MODEL,NLOCUS,NPAN,NPAR,PNAME)
C
      CALL QNMAXL(ALPHA,ALPHAP,BETA,BETAP,BINOM,CONV,DTRANS,F,FINISH
     1,HPROB,ICONDS,IP,ISEL,ITER,KITER,MAXCHR,MAXHYB,MAXLOC,MAXPAN
     2,MAXPAR,MODEL,MXITER,NCHR,NCONV,NHYB,NLOCUS,NOBS,NPAN,NPAR,NRET
     3,NTYPE,OUTOPT,PAR,PERM,PNAME,RETAIN,START,SUBPRM,TRANS1,TRANSP)
      IF(ITER.LT.MXITER)GO TO 70
C
C IF THE ITERATION MAXIMUM WAS REACHED, PRINT A WARNING.
C
   50 WRITE(KOUT,101)MXITER,(PERM(I),I=1,NLOCUS)
 101  FORMAT(' *** WARNING:  ITERATION MAXIMUM',I8,' REACHED.',
     1'  FOR LOCUS ORDER:',50(/15I4))
C
   70 RETURN
      END
C
C
C
      SUBROUTINE QNMAXL(ALPHA,ALPHAP,BETA,BETAP,BINOM,CONV,DTRANS,F
     1,FINISH,HPROB,ICONDS,IP,ISEL,ITER,KITER,MAXCHR,MAXHYB,MAXLOC
     2,MAXPAN,MAXPAR,MODEL,MXITER,NCHR,NCONV,NHYB,NLOCUS,NOBS,NPAN,NPAR
     3,NRET,NTYPE,OUTOPT,PAR,PERM,PNAME,RETAIN,START,SUBPRM,TRANS1
     4,TRANSP)
C
C MAXIMIZE THE LOG(E)-LIKELIHOOD FOR THE CONDITIONAL AND SELECTED LOCUS
C MODELS USING THE QUASI-NEWTON MAXIMIZATION PROGRAM SEARCH.
C
      IMPLICIT REAL*8(A-H,O-Z)
C
C   LENR SHOULD BE >= 2*MAXPAR*MAXPAR+13*MAXPAR+4
C   LENI SHOULD BE >= MAXPAR
C
C THE DEFAULT SETTINGS LENR=46954, LENI=150 ALLOW FOR UP TO 150 MARKERS 
C USING THE S2 (MODEL=6) MODEL OR ANY OF THE MODELS 1-3,5.
C
      PARAMETER(LENR=46954,LENI=150)
C
      DOUBLE PRECISION RARRAY(LENR)
      INTEGER IARRAY(LENI),STDERR
      CHARACTER*8 TRAVEL
      LOGICAL DIFFER(2)
C
      CHARACTER*8 PNAME(MAXPAR)
      INTEGER FINISH(0:2)
     1,NCHR(MAXPAN),NHYB(MAXPAN),NOBS(MAXPAN,MAXHYB)
     2,OUTOPT,PERM(MAXLOC),RETAIN(MAXPAN,MAXHYB,MAXLOC),START(0:2)
     3,SUBPRM(2,MAXLOC)
      REAL*8 ALPHA(MAXLOC,0:MAXCHR),ALPHAP(2,MAXLOC,0:MAXCHR,0:MAXCHR)
     1,BETA(MAXLOC,0:MAXCHR),BETAP(2,MAXLOC,0:MAXCHR)
     1,BINOM(0:MAXCHR,0:MAXCHR)
     2,DTRANS(MAXLOC,0:MAXCHR,0:MAXCHR,3),HPROB(MAXPAN,MAXHYB)
     3,NRET(MAXLOC),NTYPE(MAXLOC),PAR(MAXPAR),TRANS1(MAXLOC,0:1,0:1)
     4,TRANSP(MAXLOC,0:MAXCHR,0:MAXCHR)
C
      DATA DP/1.0D-7/
      DATA MXSTEP,NCASE,NCNSTR,NOBS1/3,1,0,1/
      DATA NPASS,NPOINT,STDERR/1,1,0/
      DATA TRAVEL,DIFFER/'SEARCH',.TRUE.,.FALSE./
C
      CALL SEARCH(RARRAY,IARRAY,PNAME,CONV,DP,FMIN,KITER,LENR,MODEL,
     :MXITER,MXSTEP,NCASE,NCNSTR,NCONV,NOBS1,NPAR,NPASS,NPOINT,STDERR,
     :TRAVEL,DIFFER,
     1ALPHA,ALPHAP,BETA,BETAP,BINOM,DTRANS,HPROB,ICONDS,IP,ISEL,ITER,
     2MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,NCHR,NHYB,NLOCUS,NOBS,NPAN,
     3NRET,NTYPE,OUTOPT,PAR,PERM,RETAIN,SUBPRM,TRANS1,TRANSP,START,
     4FINISH)
C
      F=-FMIN
      RETURN
      END
C
C
C
      SUBROUTINE INITAL(CNSTR,CVALUE,GRID,HESS,OBS,PAR,PARMAX,PARMIN
     :,PNAME,MODEL,NCASE,NCNSTR,NOBS1,NPAR,NPOINT,TRAVEL
     2,MAXHYB,MAXLOC,MAXPAR,NCHR,NHYB,NLOCUS,NOBS,NRET,NTYPE,PERM
     2,RETAIN,ALPHA,ALPHAP,BETA,BETAP,BINOM,DF,DTRANS,FINISH,HPROB
     3,ICONDS,IP,ISEL,MAXCHR,MAXPAN,NPAN,SUBPRM,START,TRANS1,TRANSP)
C
C     IN THIS SUBROUTINE THE USER SHOULD DEFINE PARAMETER NAMES,
C     INITIAL PARAMETER VALUES, PARAMETER BOUNDS, AND LINEAR
C     EQUALITY CONSTRAINTS.  WHEN A GRID OF FUNCTION VALUES IS
C     DESIRED, DEFINE THE ARRAY GRID.  THE OBSERVATIONS FOR EACH
C     CASE CAN BE INPUT HERE AS WELL.
C
C ORIGINAL INITAL VARIABLES:
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      LOGICAL DIFFER(2)
      DOUBLE PRECISION CNSTR(NCNSTR,NPAR),CVALUE(NCNSTR)
     :,GRID(NPOINT,NPAR),HESS(NPAR,NPAR),OBS(NOBS1,NCASE)
     :,PARMAX(NPAR),PARMIN(NPAR)
      CHARACTER*8 PNAME(NPAR),TRAVEL
C
C RHMAXLIK VARIABLES:
C
      INTEGER FINISH(0:2),NCHR(MAXPAN),NHYB(MAXPAN),NOBS(MAXPAN,MAXHYB)
     1,PERM(MAXLOC),RETAIN(MAXPAN,MAXHYB,MAXLOC),START(0:2)
     2,SUBPRM(2,MAXLOC)
      REAL*8 ALPHA(MAXLOC,0:MAXCHR),ALPHAP(2,MAXLOC,0:MAXCHR,0:MAXCHR)
     1,BETA(MAXLOC,0:MAXCHR),BETAP(2,MAXLOC,0:MAXCHR)
     2,BINOM(0:MAXCHR,0:MAXCHR),DF(MAXPAR)
     3,DTRANS(MAXLOC,0:MAXCHR,0:MAXCHR,3),HPROB(MAXPAN,MAXHYB)
     4,NRET(MAXLOC),NTYPE(MAXLOC),PAR(MAXPAR),TRANS1(MAXLOC,0:1,0:1)
     5,TRANSP(MAXLOC,0:MAXCHR,0:MAXCHR)
C
C SET THE MINIMA AND MAXIMA FOR ALL PARAMETERS FOR SEARCH.
C
      NPP1=NPAR-NPAN+1
      DO 10 I=1,NPAR
        PARMIN(I)=1.0D-6
        IF(I.LE.NPP1)PARMAX(I)=9.99999D-1
   10 CONTINUE
C
C CALCULATE INITIAL ESTIMATES OF RETENTION AND BREAKAGE PROBABILITIES
C AND PROPORTIONALITY PARAMETERS, IF RELEVANT.
C
      CALL INITPM(IP,ISEL,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MODEL,NCHR
     1,NHYB,NLOCUS,NOBS,NPAN,NRET,NTYPE,PAR,PERM,RETAIN)
C
C CALCULATE THE APPROXIMATE HESSIAN USING THE HYBRID SCORES CALCULATED
C IN SUBROUTINE FUN.
C
      CALL FUN(DF,OBS,PAR,F,ITER,KASE,MODEL,NCASE,NOBS1
     :,NPAR,NPASS,1,DIFFER
     1,ALPHA,ALPHAP,BETA,BETAP,BINOM,DTRANS,FINISH,HESS,HPROB,ICONDS,1
     2,IP,ISEL,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,NCHR,NHYB,NLOCUS,NOBS
     3,NPAN,PERM,RETAIN,SUBPRM,START,TRANS1,TRANSP)
C
      RETURN
      END
C
C
C
      SUBROUTINE FUN(DF,OBS,PAR,F,ITER,KASE,MODEL,NCASE,NOBS1
     :,NPAR,NPASS,PASS,DIFFER
     1,ALPHA,ALPHAP,BETA,BETAP,BINOM,DTRANS,FINISH,HESS,HPROB,ICONDS
     2,IHESS,IP,ISEL,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,NCHR,NHYB
     3,NLOCUS,NOBS,NPAN,PERM,RETAIN,SUBPRM,START,TRANS1,TRANSP)
C
C CALCULATE THE LOG(E)-LIKELIHOOD AND SCORE FOR ALL THE HYBRIDS
C FOR ANY OF THE THREE MARKOVIAN MODELS (LEFT ENDPT, CENTROMERIC,
C AND EQUAL RETENTION).
C
C ORIGINAL FUN VARIABLES:
C
      IMPLICIT REAL*8(A-H,O-Z)
      DOUBLE PRECISION OBS(NOBS1)
      INTEGER PASS
      LOGICAL DIFFER(2)
C
C RHMAXLIK VARIABLES:
C
      INTEGER FINISH(0:2),NCHR(MAXPAN),NHYB(MAXPAN),NOBS(MAXPAN,MAXHYB)
     1,PERM(MAXLOC),RETAIN(MAXPAN,MAXHYB,MAXLOC),START(0:2)
     2,SUBPRM(2,MAXLOC)
      REAL*8 ALPHA(MAXLOC,0:MAXCHR),ALPHAP(2,MAXLOC,0:MAXCHR,0:MAXCHR)
     1,BETA(MAXLOC,0:MAXCHR),BETAP(2,MAXLOC,0:MAXCHR)
     1,BINOM(0:MAXCHR,0:MAXCHR),DF(MAXPAR)
     2,DTRANS(MAXLOC,0:MAXCHR,0:MAXCHR,3),HESS(MAXPAR,MAXPAR)
     3,HPROB(MAXPAN,MAXHYB),PAR(MAXPAR),TRANS1(MAXLOC,0:1,0:1)
     4,TRANSP(MAXLOC,0:MAXCHR,0:MAXCHR)
C
C IF THIS IS A SELECTED-LOCUS PROBLEM (MODELS 5-7 AND ICONDS=0 OR 1), OR
C (MODEL=1, ICONDS=1), USE FUNS TO COMPUTE THE LIKELIHOOD.  IF THIS 
C IS NOT A SELECTED LOCUS PROBLEM (MODELS 1-3) AND IT IS NOT A 
C CONDITIONAL EQUAL RETENTION MODEL (MODEL=1, ICONDS=1), USE FUNP.
C
      IF(MODEL.GT.4.OR.ICONDS.EQ.1)
     1CALL FUNS(ALPHA,ALPHAP,BETAP,BINOM,DF,DTRANS,F,FINISH,HPROB
     2,ICONDS,IP,ISEL,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MODEL,NCHR
     3,NHYB,NLOCUS,NOBS,NPAN,NPAR,PAR,PERM,RETAIN,START,SUBPRM,TRANS1
     4,TRANSP,IHESS,HESS)
C
      IF(MODEL.LT.4.AND.ICONDS.EQ.0)
     1CALL FUNP(ALPHA,BETA,BINOM,DF,DTRANS,F,FINISH,HPROB,IP,MAXCHR
     2,MAXHYB,MAXLOC,MAXPAN,MAXPAR,MODEL,NCHR,NHYB,NLOCUS,NOBS,NPAN
     3,NPAR,PAR,PERM,RETAIN,START,TRANS1,TRANSP,IHESS,HESS) 
C
      RETURN
      END
C
C
C
      SUBROUTINE HESSIN(DF,HESS,OBS,PAR,F,ITER,KASE,MODEL,NCASE
     :,NOBS,NPAR,DIFFER)
C
C     THIS SUBROUTINE PERMITS RECOMPUTATION OF THE OBJECTIVE FUNCTION
C     F AND ITS DIFFERENTIAL DF.  IF DIFFER(2) IS TRUE, THEN PROVIDE
C     AN APPROXIMATION TO THE SECOND DIFFERENTIAL, I.E, HESSIAN OF F.
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION DF(NPAR),HESS(NPAR,NPAR),OBS(NOBS)
     :,PAR(NPAR)
      LOGICAL DIFFER(2)
      DO 10 I=1,NPAR
      DF(I)=-DF(I)
   10 CONTINUE
      F=-F
      RETURN
      END
C
C
C
      SUBROUTINE SEARCH(RARRAY,NSWEEP,PNAME,CONV,DP,F,IOUNIT,LENR,MODEL    
     1,MXITER,MXSTEP,NCASE,NCNSTR,NCONV,NOBS1,NPAR,NPASS,NPOINT,STDERR     
     2,TRAVEL,DIFFER                                                       
     3,ALPHA,ALPHAP,BETA,BETAP,BINOM,DTRANS,HPROB,ICONDS,IP,ISEL,ITER
     5,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MXPAR,NCHR,NHYB,NLOCUS,NOBS,NPAN
     6,NRET,NTYPE,OUTOPT,PAR,PERM,RETAIN,SUBPRM,TRANS1,TRANSP,START
     7,FINISH)                                                            
C                                                                          
C THIS VERSION OF SEARCH HAS BEEN ALTERED FOR USE IN PROGRAM 
C RHMAXLIK OF THE RHMAP PACKAGE.
C                                                                          
C ORIGINAL SEARCH VARIABLES:                                               
C                                                                              
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)                                   
      DOUBLE PRECISION RARRAY(LENR)                                        
      INTEGER NSWEEP(NPAR),STDERR                                          
      CHARACTER*8 PNAME(NPAR),TRAVEL                                       
      LOGICAL DIFFER(2)                                                    
C                                                                          
C SEARCH HAS BEEN ADAPTED FOR USE WITH RHMAXLIK.                           
C RHMAXLIK VARIABLES NEEDED WITHIN SUBROUTINE FUN ARE AVAILABLE.           
C                                                                          
C RHMAXLIK VARIABLES:                                                      
C                                                                          
      INTEGER FINISH(0:2)            
     1,NCHR(MAXPAN),NHYB(MAXPAN),NOBS(MAXPAN,MAXHYB)
     2,OUTOPT,PERM(MAXLOC),RETAIN(MAXPAN,MAXHYB,MAXLOC),START(0:2)         
     3,SUBPRM(2,MAXLOC)                                                      
      REAL*8 ALPHA(MAXLOC,0:MAXCHR),ALPHAP(2,MAXLOC,0:MAXCHR,0:MAXCHR)     
     1,BETA(MAXLOC,0:MAXCHR),BETAP(2,MAXLOC,0:MAXCHR)                      
     2,BINOM(0:MAXCHR,0:MAXCHR)
     3,DTRANS(MAXLOC,0:MAXCHR,0:MAXCHR,3),HPROB(MAXPAN,MAXHYB)             
     4,NRET(MAXLOC),NTYPE(MAXLOC),PAR(MXPAR),TRANS1(MAXLOC,0:1,0:1)        
     5,TRANSP(MAXLOC,0:MAXCHR,0:MAXCHR)                                    
C                                                                         
C     INITIALIZE TWO CONSTANTS USED IN SUBROUTINE OPTIMA.                  
C                                                                          
      SAVE SMALL,TOL                                                      
      DATA SMALL,TOL/1.0D-10,1.0D-8/                                      
C                                                                          
      MAXPAR=MAX(NPAR,1)                                                   
      MAXTAB=NCNSTR+NPAR+1                                                 
      MCNSTR=MAX(NCNSTR,1)                                                 
      NCASE=MAX(NCASE,1)                                                   
      NOBS1=MAX(NOBS1,1)                                                   
      NPASS=MAX(NPASS,1)                                                   
      NPOINT=MAX(NPOINT,1)                                                 
      IF (STDERR.LT.0.OR.STDERR.GT.3) STDERR=0                             
      IF (TRAVEL(1:1).NE.'G'.AND.TRAVEL(1:1).NE.'G') THEN                  
      TRAVEL='SEARCH'                                                      
      ELSE                                                                 
      TRAVEL='GRID'                                                        
      END IF                                                               
C                                                                          
C     SET START POINTS FOR ARRAYS TO BE CARVED OUT OF RARRAY.              
C     OUTPUT AN ERROR MESSAGE AND STOP IF THERE IS INSUFFICIENT            
C     SPACE.                                                               
C                                                                          
      M9=1                                                                 
      M7=MAXPAR+M9                                                         
      M1=MAXPAR*MAXPAR+M7                                                  
      M2=MCNSTR*MAXPAR+M1                                                  
      M3=MCNSTR+M2                                                         
      M4=MAXPAR+M3                                                         
      M5=MAXPAR+M4                                                         
      M6=MAXPAR+M5                                                         
      M8=NPOINT*MAXPAR+M6                                                  
      M10=NOBS1*NCASE+M8                                                   
      M11=MAXPAR+M10                                                       
      M12=MAXPAR+M11                                                       
      M13=MAXPAR+M12                                                       
      M14=MAXTAB*MAXTAB+M13                                                
      M15=MAXPAR+M14                                                       
      IF (M15+MAXTAB-1.GT.LENR) THEN                                       
      IF (IOUNIT.GE.0) WRITE(IOUNIT,10)                                    
 10   FORMAT(' SEARCH HAS STOPPED BECAUSE RARRAY IS TOO SMALL.'
     1     ,/,'INCREASE PARAMETER LENR IN SUBROUTINE QNMAXL AND'
     2     ,/,'RECOMPILE.')           
      STOP                                                                 
      END IF                                                               
C                                                                          
C     CALL SUBROUTINE OPTIMA TO DO THE CALCULATIONS.                       
C                                                                          
      CALL OPTIMA(RARRAY(M1),RARRAY(M2),RARRAY(M3),RARRAY(M4),RARRAY(M5)   
     :,RARRAY(M6),RARRAY(M7),RARRAY(M8),RARRAY(M9),RARRAY(M10)             
     :,RARRAY(M11),RARRAY(M12),RARRAY(M13),RARRAY(M14),RARRAY(M15)         
     :,NSWEEP,PNAME,CONV,DP,F,SMALL,TOL,IOUNIT,MAXPAR,MAXTAB,MCNSTR       
     :,MODEL,MXITER,MXSTEP,NCASE,NCNSTR,NCONV,NOBS1,NPAR,NPASS,NPOINT      
     :,STDERR,TRAVEL,DIFFER                                                
     1,ALPHA,ALPHAP,BETA,BETAP,BINOM,DTRANS,HPROB,ICONDS,IP,ISEL,ITER
     2,MAXCHR,MAXHYB,MAXLOC,MAXPAN,NCHR,NHYB,NLOCUS,NOBS,NPAN,NRET
     3,NTYPE,OUTOPT,PERM,RETAIN,SUBPRM,TRANS1,TRANSP,START,FINISH)
C                                                                          
      DO 100 I=1,NPAR                                                      
 100     PAR(I)=RARRAY(M9+I-1)                                             
C                                                                          
      RETURN                                                               
      END
C
C
C                                                                           
      SUBROUTINE OPTIMA(CNSTR,CVALUE,DELTA,DF,DFOLD,GRID,HESS,OBS          
     :,PAR,PARMAX,PARMIN,PAROLD,TABLE,WORK1,WORK2,NSWEEP,PNAME,CONV        
     :,DP,F,SMALL,TOL,IOUNIT,MAXPAR,MAXTAB,MCNSTR,MODEL,MXITER,MXSTEP     
     :,NCASE,NCNSTR,NCONV,NOBS1,NPAR,NPASS,NPOINT,STDERR,TRAVEL,DIFFER     
     1,ALPHA,ALPHAP,BETA,BETAP,BINOM,DTRANS,HPROB,ICONDS,IP,ISEL,ITER
     2,MAXCHR,MAXHYB,MAXLOC,MAXPAN,NCHR,NHYB,NLOCUS,NOBS,NPAN,NRET
     3,NTYPE,OUTOPT,PERM,RETAIN,SUBPRM,TRANS1,TRANSP,START,FINISH)                                         
C                                                                          
C     THIS SUBROUTINE COMPUTES THE CONSTRAINED MINIMUM OF A FUNCTION F     
C     BY THE VARIABLE METRIC METHOD OF BIGGS, HAN, AND POWELL.  SEE:       
C     M.J.D. POWELL(1978) "A FAST ALGORITHM FOR NONLINEARLY CONSTRAINED    
C     OPTIMIZATION CALCULATIONS."  PROCEEDINGS OF THE 1977 DUNDEE          
C     CONFERENCE ON NUMERICAL ANALYSIS. G.A. WATSON EDITOR. SPRINGER       
C     VERLAG.  FOR LEAST SQUARES PROBLEMS IT USES THE CLASSICAL GAUSS      
C     NEWTON METHOD.  IN THE LIST BELOW ITEMS MARKED BY * OR ** MUST       
C     BE PROVIDED BY THE USER.  THOSE ITEMS MARKED BY * SHOULD BE          
C     PASSED TO SUBROUTINE SEARCH.  THOSE ITEMS MARKED BY ** SHOULD BE     
C     INITIALIZED IN SUBROUTINE INITAL.                                    
C                                                                          
C     CNSTR**          MATRIX OF LINEAR EQUALITY CONSTRAINTS               
C     CVALUE**         CONSTANTS FOR PARAMETER/CONSTRAINT INNER PRODUCTS   
C     DELTA            UPDATE DIRECTION FOR PARAMETERS                     
C     DF               CURRENT DIFFERENTIAL OF THE FUNCTION F              
C     DFOLD            PREVIOUS DIFFERENTIAL OF THE FUNCTION F             
C     F                VALUE OF FUNCTION TO BE MINIMIZED                   
C     GRID**           GRID OF POINTS TO EVALUATE F ON                     
C     HESS**           CURRENT APPROXIMATE HESSIAN OF F                    
C     OBS**            MATRIX OF OBSERVATIONS                              
C     PAR**            CURRENT PARAMETERS                                  
C     PARMAX,PARMIN**  PARAMETER MAXIMA AND MINIMA                         
C     PAROLD           PREVIOUS PARAMETERS                                 
C     TABLE            TABLEAU FOR QUADRATIC PROGRAMMING PROBLEM           
C     WORK1,WORK2      WORK VECTORS                                        
C     NSWEEP           INDICATOR FOR WHICH PARAMETERS HAVE BEEN SWEPT      
C                        IN TABLE                                          
C     PNAME**          PARAMETER NAMES                                     
C     CONV*            CONVERGENCE CRITERION FOR CHANGE IN F               
C     DP*              NUMERICAL DIFFERENTIATION INTERVAL                  
C     SMALL*           SMALL POSITIVE NUMBER FOR CHECKING BOUNDS           
C     TOL*             TOLERANCE FOR MATRIX SWEEPING                       
C     IOUNIT*          OUTPUT UNIT NUMBER                                  
C     MAXPAR           MAXIMUM(NPAR,1)                                     
C     MAXTAB           NCNSTR+NPAR+1                                       
C     MCNSTR           MAXIMUM(NCNSTR,1)                                   
C     MODEL*           USER MODEL NUMBER                                   
C     MXITER*          MAXIMUM NUMBER OF ITERATIONS                        
C     MXSTEP*          MAXIMUM NUMBER OF STEPS PER ITERATION               
C     NCASE*           NUMBER OF CASES IN A PROBLEM                        
C     NOBS1*            NUMBER OF OBSERVATIONS PER CASE                    
C     NPASS*           NUMBER OF PASSES PER ITERATION                      
C     NCONV*           NUMBER OF TIMES CONVERGENCE CRITERION MUST BE MET   
C     NCNSTR*          NUMBER OF LINEAR EQUALITY CONSTRAINTS               
C     NPAR*            NUMBER OF PARAMETERS                                
C     NPOINT*          NUMBER OF POINTS FOR 'GRID' OPTION                  
C     TRAVEL*          'SEARCH' OR 'GRID' OPTION                           
C     STDERR*          0 FOR NO STANDARD ERRORS, 1 FOR STANDARD ERRORS     
C                      BASED ON THE OBSERVED INFORMATION, 2 FOR STANDARD   
C                      ERRORS BASED ON THE FINAL APPROXIMATE HESSIAN, 3    
C                      FOR STANDARD ERRORS IN A LEAST SQUARES PROBLEM      
C     DIFFER*          DIFFER(1) TRUE FOR EXACT FIRST DIFFERENTIAL         
C                      DIFFER(2) TRUE FOR APPROXIMATE SECOND DIFFERENTIAL  
C                                                                          
C                                                                          
C ORIGINAL OPTIMA VARIABLES:                                               
C                                                                          
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)                                   
      DOUBLE PRECISION CNSTR(MCNSTR,MAXPAR),CVALUE(MCNSTR)                 
     1,DELTA(MAXPAR),DF(MAXPAR),DFOLD(MAXPAR),GRID(NPOINT,MAXPAR)
     2,HESS(MAXPAR,MAXPAR),OBS(NOBS1,NCASE),PARMAX(MAXPAR),PAR(MAXPAR)
     3,PARMIN(MAXPAR),PAROLD(MAXPAR),TABLE(MAXTAB,MAXTAB),WORK1(MAXPAR)    
     4,WORK2(MAXTAB)                                                       
      INTEGER NSWEEP(MAXPAR),PROBLM,SEED,STDERR                            
      CHARACTER*8 PNAME(MAXPAR),TRAVEL                                     
C      LOGICAL DIFF(2)
      LOGICAL DIFFER(2),FORWRD                                     
C                                                                          
C RHAMAXLIK VARIABLES:                                                     
C                                                                          
      INTEGER FINISH(0:2)            
     1,NCHR(MAXPAN),NHYB(MAXPAN),NOBS(MAXPAN,MAXHYB)
     2,OUTOPT,PERM(MAXLOC),RETAIN(MAXPAN,MAXHYB,MAXLOC),START(0:2)         
     3,SUBPRM(2,MAXLOC)                                                      
      REAL*8 ALPHA(MAXLOC,0:MAXCHR),ALPHAP(2,MAXLOC,0:MAXCHR,0:MAXCHR)     
     1,BETA(MAXLOC,0:MAXCHR),BETAP(2,MAXLOC,0:MAXCHR)
     2,BINOM(0:MAXCHR,0:MAXCHR),DTRANS(MAXLOC,0:MAXCHR,0:MAXCHR,3)
     3,HPROB(MAXPAN,MAXHYB),NRET(MAXLOC),NTYPE(MAXLOC)
     4,TRANS1(MAXLOC,0:1,0:1),TRANSP(MAXLOC,0:MAXCHR,0:MAXCHR)                 C                                                                          
      SAVE PROBLM,SEED                                                     
      DATA PROBLM,SEED/0,25431/                                            
C                                                                          
C     WRITE OUT THE LOGO                                                   
C                                                                          
C      PROBLM=PROBLM+1                                                      
C      IF(OUTOPT.EQ.2.AND.PROBLM.EQ.1) CALL LOGO(IOUNIT)                    
C                                                                          
C     INITIALIZE THE PARAMETER VALUES, THEIR BOUNDS, THEIR CONSTRAINTS,    
C     AND THEIR NAMES.                                                     
C                                                                          
      IF (NPAR.GT.0) THEN                                                  
      DO 10 I=1,NPAR                                                       
      PAR(I)=1.0D-6                                                        
      PARMAX(I)=1.0D20                                                     
      PARMIN(I)=-1.0D20
C      WRITE(PNAME(I),'(I6)') I                                            
C      PNAME(I)(2:4)='PAR'                                                 
      DO 10 J=1,NCNSTR                                                     
      CNSTR(J,I)=0.0D0                                                     
 10   CVALUE(J)=0.0D0                                                      
C                                                                          
C     SET THE INITIAL HESSIAN TO THE IDENTITY.                             
C                                                                          
      IF (TRAVEL.EQ.'SEARCH') THEN                                         
      DO 20 I=1,NPAR                                                       
      DO 30 J=1,NPAR                                                       
 30   HESS(J,I)=0.0D0                                                      
 20   HESS(I,I)=1.0D0                                                      
C                                                                          
C     FILL IN THE GRID WITH A SMALL POSITIVE VALUE.                        
C                                                                          
      ELSE IF (TRAVEL.EQ.'GRID') THEN                                      
      DO 40 I=1,NPAR                                                       
      DO 40 J=1,NPOINT                                                     
 40   GRID(J,I)=1.0D-6                                                     
      END IF                                                               
C                                                                          
C     LET THE USER CHANGE THE INITIAL SETTINGS.                            
C                                                                          
C                                                                          
      CALL INITAL(CNSTR,CVALUE,GRID,HESS,OBS,PAR,PARMAX,PARMIN,PNAME       
     :,MODEL,NCASE,NCNSTR,NOBS1,NPAR,NPOINT,TRAVEL                         
     1,MAXHYB,MAXLOC,MAXPAR,NCHR,NHYB,NLOCUS,NOBS,NRET,NTYPE,PERM          
     2,RETAIN,ALPHA,ALPHAP,BETA,BETAP,BINOM,DF,DTRANS,FINISH,HPROB         
     3,ICONDS,IP,ISEL,MAXCHR,MAXPAN,NPAN,SUBPRM,START,TRANS1,TRANSP)         
      END IF                                                               
C                                                                          
C     COMPUTE FUNCTION VALUES OVER A USER DEFINED GRID OF POINTS.          
C                                                                          
      IF (TRAVEL.EQ.'GRID') THEN                                           
      LAST=NPOINT                                                          
      DO 50 ITER=1,NPOINT                                                  
      DO 60 J=1,NPAR                                                       
 60   PAROLD(J)=GRID(ITER,J)                                               
      CALL DFUN(DF,WORK2,TABLE,HESS,OBS,PAROLD,PARMAX,WORK1,DP,FOLD        
     :,ITER,MAXPAR,MODEL,NCASE,0,NOBS1,NPASS,DIFFER,FORWRD                 
     1,ALPHA,ALPHAP,BETA,BETAP,BINOM,DTRANS,FINISH,HPROB,ICONDS,IP         
     2,ISEL,MAXCHR,MAXHYB,MAXLOC,MAXPAN,NCHR,NHYB,NLOCUS,NOBS,NPAN         
     3,NPAR,PERM,RETAIN,SUBPRM,START,TRANS1,TRANSP)                          
      IF (ITER.EQ.1) F=FOLD                                                
      IF (FOLD.LE.F) THEN                                                  
      F=FOLD                                                               
      DO 70 J=1,NPAR                                                       
 70   PAR(J)=PAROLD(J)                                                     
      END IF                                                               
 50   IF(OUTOPT.EQ.2)CALL OUTPUT(PAROLD,PNAME,FOLD,ITER,LAST,IOUNIT        
     1,MAXPAR,MODEL,NPAR,0,TRAVEL,DIFFER)                                  
C                                                                          
C     OTHERWISE SEARCH THE FUNCTION SURFACE.  FIRST CALL PREOPT            
C     TO CHECK THAT THE PARAMETERS SATISFY THEIR BOUNDS AND THEIR          
C     LINEAR EQUALITY CONSTRAINTS.  PREOPT ALSO CHECKS THAT THE            
C     CONSTRAINTS ARE NOT REDUNDANT.  IF ANY OF THESE CHECKS FAIL,         
C     THEN STOP.                                                           
C                                                                          
      ELSE      
C
C NOTE: FOR RHMAXLIK, PREOPT IS UNNECESSARY, SINCE CHECKS HAVE 
C ALREADY TAKEN PLACE WITHIN INITPM.
C                                                           
C      CALL PREOPT(CNSTR,CVALUE,PAR,PARMAX,PARMIN,TABLE,WORK2               
C     1,PNAME,CNORM,TOL,IERROR,IOUNIT,MAXPAR,MAXTAB,MCNSTR,NCNSTR          
C     2,NPAR,TRAVEL,OUTOPT)                                                 
C      IF (IERROR.GE.1) STOP                                                
C                                                                          
C     INITIALIZE SOME VARIABLES.                                           
C                                                                          
      ITER=1                                                               
      LAST=MXITER                                                          
      NCRIT=0                                                              
      FORWRD=.TRUE.                                                        
C                                                                          
C     COMPUTE THE INITIAL FUNCTION VALUE AND DIFFERENTIAL, AND OUTPUT      
C     THE FIRST ITERATION.                                                 
C                                                                          
      CALL DFUN(DF,WORK2,TABLE,HESS,OBS,PAR,PARMAX,WORK1,DP,F,ITER         
     :,MAXPAR,MODEL,NCASE,NPAR,NOBS1,NPASS,DIFFER,FORWRD                   
     1,ALPHA,ALPHAP,BETA,BETAP,BINOM,DTRANS,FINISH,HPROB,ICONDS,IP,ISEL    
     2,MAXCHR,MAXHYB,MAXLOC,MAXPAN,NCHR,NHYB,NLOCUS,NOBS,NPAN,NPAR         
     3,PERM,RETAIN,SUBPRM,START,TRANS1,TRANSP)                               
      IF(OUTOPT.EQ.2)CALL OUTPUT(PAR,PNAME,F,ITER,LAST,IOUNIT,MAXPAR       
     1,MODEL,NPAR,0,TRAVEL,DIFFER)                                         
C                                                                          
C     ENTER THE MAIN ITERATION LOOP.                                       
C                                                                          
      IF (MXITER.GT.1) THEN                                                
      DO 80 ITER=2,MXITER                                                  
C                                                                          
C     CREATE THE TABLEAU FOR THE QUADRATIC PROGRAMMING PROBLEM.            
C                                                                          
 110  CALL SETTAB(CNSTR,CVALUE,DF,HESS,PAR,TABLE,WORK2,CNORM               
     1,MAXPAR,MAXTAB,MCNSTR,NCNSTR,NPAR,NTAB)                              
C                                                                          
C     SOLVE THE QUADRATIC PROGRAMMING PROBLEM FOR THE NEXT                 
C     STEP DIRECTION DELTA.                                                
C                                                                          
      CALL QDPROG(DELTA,PAR,PARMAX,PARMIN,TABLE,WORK1,WORK2,NSWEEP         
     1,SMALL,TOL,MAXPAR,MAXTAB,NCNSTR,NCYCLE,NPAR,NTAB)                   
C                                                                          
C     IF NCYCLE IS NEGATIVE, THE QUADRATIC PROGRAMMING PROBLEM IS          
C     SOLVED.  IF NCYCLE IS ZERO, IT IS IMPOSSIBLE TO ADEQUATELY           
C     SWEEP THE TABLEAU.  IF NCYCLE IS POSITIVE, THERE IS A                
C     POSSIBLE INFINITE LOOP IN THE QUADRATIC PROGRAMMING ALGORITHM.       
C     IN EITHER OF THE LAST TWO CASES, RESET THE HESSIAN AND TRY AGAIN.    
C                                                                          
      IF (NCYCLE.GE.0) THEN                                                
      HMIN=1.0D20                                                          
      DO 90 J=1,NPAR                                                       
 90   IF (HESS(J,J).GT.0.0D0) HMIN=MIN(HMIN,HESS(J,J))                     
      IF (HMIN.EQ.1.0D20) HMIN=1.0D0                                       
      DO 100 J=1,NPAR                                                      
 100  IF (HESS(J,J).LE.HMIN) HESS(J,J)=HMIN*(1.0D0+RAND(SEED))          
      GO TO 110                                                            
      END IF                                                               
C                                                                          
C     COMPUTE THE INNER PRODUCT D OF DELTA AND THE DIFFERENTIAL DF.        
C     IF D IS POSITIVE, THEN DELTA IS NOT A DESCENT DIRECTION.             
C     CONVERGENCE HAS OCCURRED, OR THE SEARCH IS IN DEEP TROUBLE.          
C                                                                          
      D=0.0D0                                                              
      DO 120 J=1,NPAR                                                      
 120  D=D+DF(J)*DELTA(J)                                                   
C                                                                          
C     WHEN THE DIFFERENTIAL IS COMPUTED NUMERICALLY, CHANGE FROM           
C     FORWARD DIFFERENCES TO CENTRAL DIFFERENCES AND VICE VERSA            
C     BASED ON THE QUANTITY D.  REDO THE QUADRATIC PROGRAMMING             
C     PROBLEM IF NECESSARY.                                                
C                                                                          
      IF (.NOT.DIFFER(1)) THEN                                             
      IF (FORWRD.AND.D.GE.0.0D0) THEN                                      
      FORWRD=.FALSE.                                                       
      CALL DFUN(DF,WORK2,TABLE,HESS,OBS,PAR,PARMAX,WORK1,DP,F,ITER         
     :,MAXPAR,MODEL,NCASE,NPAR,NOBS1,NPASS,DIFFER,FORWRD                   
     1,ALPHA,ALPHAP,BETA,BETAP,BINOM,DTRANS,FINISH,HPROB,ICONDS,IP,ISEL    
     2,MAXCHR,MAXHYB,MAXLOC,MAXPAN,NCHR,NHYB,NLOCUS,NOBS,NPAN,NPAR         
     3,PERM,RETAIN,SUBPRM,START,TRANS1,TRANSP)                               
      GO TO 110                                                            
      END IF                                                               
      FORWRD=D.LE.-CONV                                                    
      END IF                                                               
C                                                                          
C     ENTER THE STEP DECREMENTING LOOP.  T IS THE FRACTION OF DELTA        
C     TAKEN.                                                               
C                                                                          
      T=1.0D0                                                              
      NSTEP=0                                                              
      D=MIN(D,0.0D0)                                                       
C                                                                          
C     RECORD THE OLD DATA IN PREPARATION FOR THE NEXT STEP.                
C                                                                          
      FOLD=F                                                               
      DO 130 J=1,NPAR                                                      
      PAROLD(J)=PAR(J)                                                     
 130  DFOLD(J)=DF(J)                                                       
C                                                                          
C     COMPUTE A NEW POINT AND A NEW FUNCTION VALUE.                        
C                                                                          
 150  DO 140 J=1,NPAR                                                      
 140  PAR(J)=PAROLD(J)+T*DELTA(J)                                          
      CALL DFUN(DF,WORK2,TABLE,HESS,OBS,PAR,PARMAX,WORK1,DP,F,ITER         
     :,MAXPAR,MODEL,NCASE,NPAR,NOBS1,NPASS,DIFFER,FORWRD                   
     1,ALPHA,ALPHAP,BETA,BETAP,BINOM,DTRANS,FINISH,HPROB,ICONDS,IP,ISEL    
     2,MAXCHR,MAXHYB,MAXLOC,MAXPAN,NCHR,NHYB,NLOCUS,NOBS,NPAN,NPAR         
     3,PERM,RETAIN,SUBPRM,START,TRANS1,TRANSP)                               
C                                                                          
C     IF THERE IS NOT A SUFFICIENT DECREASE IN F, THEN TRY TO              
C     FIND A BETTER POINT ALONG THE DIRECTION DELTA.  COMPUTE              
C     THE MINIMUM POINT FOR THE QUADRATIC IN T WHICH PASSES                
C     THROUGH FOLD AND F AND HAS SLOPE D AT T=0.  IF THIS                  
C     MINIMUM IS TOO CLOSE TO 0, DECREMENT T BY ONLY 90 PER CENT.          
C                                                                          
      IF (F.GT.FOLD+0.1D0*T*D.AND.NSTEP.LT.MXSTEP) THEN                    
      T1=-0.5D0*D*T*T/(F-FOLD-T*D)                                         
      T2=0.1D0*T                                                           
      T=MAX(T1,T2)                                                         
      NSTEP=NSTEP+1                                                        
      GO TO 150                                                            
      END IF                                                               
C                                                                          
C     QUIT WHEN THERE IS A SUFFICIENT DECREASE IN F OR TOO                 
C     MANY STEPS.  CHECK THE CONVERGENCE CRITERION.  IF IT HAS             
C     BEEN SATISFIED NCONV TIMES, THEN EXIT THE MAIN LOOP.                 
C     OTHERWISE, OUTPUT THE CURRENT ITERATION.                             
C                                                                          
      IF (ABS(FOLD-F).GT.CONV) NCRIT=-1                                    
      NCRIT=NCRIT+1                                                        
      IF (NCRIT.GE.NCONV) GO TO 160                                        
      IF(OUTOPT.EQ.2)CALL OUTPUT(PAR,PNAME,F,ITER,LAST,IOUNIT,MAXPAR       
     1,MODEL,NPAR,NSTEP,TRAVEL,DIFFER)                                     
C                                                                          
C     IF THIS IS ORDINARY MINIMIZATION, THEN UPDATE THE CURRENT            
C     APPROXIMATION TO THE HESSIAN.                                        
C                                                                          
      IF (.NOT.DIFFER(2)) THEN                                             
C                                                                          
C     RESET DELTA SO THAT IT IS THE ACTUAL STEP TAKEN.                     
C                                                                          
      DO 170 J=1,NPAR                                                      
 170  DELTA(J)=T*DELTA(J)                                                  
C                                                                          
C     PREPARE TO UPDATE THE HESSIAN.  STORE IN WORK1 THE                   
C     PRODUCT HESS*DELTA.  WORK1 APPROXIMATES THE DIFFERENCE               
C     IN DIFFERENTIALS DF-DFOLD.  STORE IN C1 AND C2 THE                   
C     INNER PRODUCT OF THESE TWO VECTORS WITH DELTA.                       
C                                                                          
      C1=0.0D0                                                             
      DO 180 J=1,NPAR                                                      
      S=0.0D0                                                              
      DO 190 K=1,NPAR                                                      
 190  S=S+HESS(J,K)*DELTA(K)                                               
      WORK1(J)=S                                                           
 180  C1=C1+DELTA(J)*S                                                     
      C2=0.0D0                                                             
      DO 200 J=1,NPAR                                                      
 200  C2=C2+(DF(J)-DFOLD(J))*DELTA(J)                                      
C                                                                          
C     IF C2 IS TOO SMALL, BIAS DF-DFOLD BY TAKING A CONVEX                 
C     COMBINATION WITH WORK1.  STORE THE RESUTING VECTOR                   
C     IN WORK2.  ITS INNER PRODUCT WITH DELTA WILL BE C4.                  
C                                                                          
      IF (C1.GT.0.0D0) THEN                                                
      IF (C2.GT.0.2D0*C1) THEN                                             
      C3=1.0D0                                                             
      ELSE                                                                 
      C3=0.8D0*C1/(C1-C2)                                                  
      END IF                                                               
      DO 210 J=1,NPAR                                                      
 210  WORK2(J)=C3*(DF(J)-DFOLD(J))+(1.0D0-C3)*WORK1(J)                     
      C4=C3*C2+(1.0D0-C3)*C1                                               
C                                                                          
C     NOW RESET THE HESSIAN USING THE RANK TWO BFGS UPDATE.                
C                                                                          
      DO 220 J=1,NPAR                                                      
      DO 220 K=1,NPAR                                                      
 220  HESS(K,J)=HESS(K,J)-WORK1(J)*WORK1(K)/C1+WORK2(J)*WORK2(K)/C4        
      END IF                                                               
      END IF                                                               
 80   CONTINUE                                                             
      IF (STDERR.GT.0) THEN                                                
      DO 230 J=1,NPAR                                                      
      DO 230 I=1,NPAR                                                      
 230  HESS(I,J)=0.0D0                                                      
      END IF                                                               
      RETURN                                                               
      END IF                                                               
C                                                                          
C     CONVERGENCE HAS OCCURRED.  OUTPUT THE LAST ITERATION                 
C                                                                          
 160  IF (ITER.NE.MXITER) THEN                                             
      IF(OUTOPT.EQ.2)CALL OUTPUT(PAR,PNAME,F,ITER,ITER,IOUNIT,MAXPAR       
     1,MODEL,NPAR,NSTEP,TRAVEL,DIFFER)                                     
      END IF                                                               
C                                                                          
C     IF THE ASYMPTOTIC COVARIANCE MATRIX IS DESIRED, THEN RECOMPUTE       
C     THE HESSIAN AND CALL ASYCOV.  USE CENTRAL DIFFERENCES FOR THE        
C     FIRST PARTIALS AND FORWARD DIFFERENCES FOR THE SECOND PARTIALS.      
C     ADJUST THE DIFFERENTIATION INTERVAL FOR THE SECOND PARTIALS.         
C                                                                          
C      IF (STDERR.EQ.1) THEN                                                
C      IF (.NOT.DIFFER(1).AND.FORWRD) CALL DFUN(DF,WORK2,TABLE,HESS,OBS     
C     :,PAR,PARMAX,WORK1,DP,F,ITER,MAXPAR,MODEL,NCASE,NPAR,NOBS1,NPASS      
C     :,DIFFER,.FALSE.                                                      
C     1,ALPHA,ALPHAP,BETA,BETAP,BINOM,DTRANS,FINISH,HPROB,ICONDS,IP,ISEL     
C     2,MAXCHR,MAXHYB,MAXLOC,MAXPAN,NCHR,NHYB,NLOCUS,NOBS,NPAN,NPAR         
C     3,PERM,RETAIN,START,TRANS1,TRANSP)                                    
C      IF (.NOT.DIFFER(1)) THEN                                             
C      DP23=DP**0.66667D0                                                   
C      ELSE                                                                 
C      DP23=DP                                                              
C      END IF                                                               
C                                                                          
C     COMPUTE THE SECOND PARTIALS AND CALL ASYCOV.  NBOUND IS THE          
C     NUMBER OF PARAMETERS ON A BOUNDARY.  NOTE THAT IT IS                 
C     UNNECESSARY TO COMPUTE THE HESSIAN AT THIS STAGE IF IT IS            
C     ALREADY GIVEN.                                                       
C                                                                          
C      DIFF(1)=DIFFER(1)                                                    
C      DIFF(2)=.FALSE.                                                      
C      NBOUND=0                                                             
C      DO 240 J=1,NPAR                                                      
C      IF (PAR(J).LE.PARMIN(J)+SMALL.OR.PAR(J).GE.PARMAX(J)-SMALL) THEN     
C      NBOUND=NBOUND+1                                                      
C      NSWEEP(J)=0                                                          
C      ELSE                                                                 
C      NSWEEP(J)=1                                                          
C      DPJ=DP23*MAX(ABS(PAR(J)),1.0D0)                                      
C      PAR(J)=PAR(J)+DPJ                                                    
C      CALL DFUN(DFOLD,WORK2,TABLE,HESS,OBS,PAR,PARMAX,WORK1,DP,FOLD        
C     :,ITER,MAXPAR,MODEL,NCASE,J,NOBS1,NPASS,DIFF,FORWRD                   
C     1,ALPHA,ALPHAP,BETA,BETAP,BINOM,DTRANS,FINISH,HPROB,ICONDS,IP,ISEL    
C     2,MAXCHR,MAXHYB,MAXLOC,MAXPAN,NCHR,NHYB,NLOCUS,NOBS,NPAN,NPAR         
C     3,PERM,RETAIN,SUBPRM,START,TRANS1,TRANSP)                               
C      PAR(J)=PAR(J)-DPJ                                                    
C      DO 250 I=1,J                                                         
C      IF (NSWEEP(I).EQ.0.OR.NSWEEP(J).EQ.0) THEN                           
C      HESS(I,J)=0.0D0                                                      
C      ELSE                                                                 
C      HESS(I,J)=(DFOLD(I)-DF(I))/DPJ                                       
C      END IF                                                               
C 250  HESS(J,I)=HESS(I,J)                                                  
C      END IF                                                               
C 240  CONTINUE                                                             
C      END IF                                                               
C                                                                          
C     ADJUST THE HESSIAN FOR A LEAST SQUARES PROBLEM BY DIVIDING           
C     BY THE RESIDUAL MEAN SQUARE.                                         
C                                                                          
C      IF (STDERR.EQ.3) THEN                                                
C      SIGMA=MAX(2.0D0*F/MAX(NCASE-NPAR+NBOUND+NCNSTR,1),1.0D-10)           
C      DO 260 I=1,NPAR                                                      
C      DO 260 J=1,NPAR                                                      
C 260  HESS(J,I)=HESS(J,I)/SIGMA                                            
C      END IF                                                               
C      IF (STDERR.GT.0) CALL ASYCOV(CNSTR,CVALUE,DF,HESS,PAR,TABLE          
C     :,WORK1,WORK2,NSWEEP,PNAME,CNORM,SMALL,TOL,IOUNIT,MAXPAR,MAXTAB      
C     :,MCNSTR,NCNSTR,NPAR)                                                 
      END IF                                                               
      END                         
C
C
C                                                                           
      FUNCTION RAND(SEED1)                                              
C                                                                          
C     THIS FUNCTION GENERATES INDEPENDENT UNIFORM DEVIATES ON              
C     THE INTERVAL (0.0,1.0).  SEE THE REFERENCE:  WICHMAN B.A.            
C     AND HILL I.D.(1982). ALGORITHM 183: AN EFFICIENT AND PORTABLE        
C     PSEUDO-RANDOM NUMBER GENERATOR. APPLIED STATISTICS 31;188-190.       
C     SEED1, SEED2, AND SEED3 SHOULD BE SET TO INTEGER VALUES              
C     BETWEEN 1 AND 30000 BEFORE THE FIRST ENTRY.  INTEGER                 
C     ARITHMETIC UP TO 30323 IS NEEDED ON THE YOUR COMPUTER.               
C                                                                          
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)                                   
      INTEGER SEED1,SEED2,SEED3                                            
      SAVE SEED2,SEED3                                                     
      DATA SEED2,SEED3/2321,18777/                                         
C                                                                          
      SEED1=171*MOD(SEED1,177)-2*(SEED1/177)                               
      SEED2=172*MOD(SEED2,176)-35*(SEED2/176)                              
      SEED3=170*MOD(SEED3,178)-63*(SEED3/178)                              
      IF (SEED1.LT.0) SEED1=SEED1+30269                                    
      IF (SEED2.LT.0) SEED2=SEED2+30307                                    
      IF (SEED3.LT.0) SEED3=SEED3+30323                                    
      R=DBLE(SEED1)/30269.D0+DBLE(SEED2)/30307.D0+DBLE(SEED3)/30323.D0     
      RAND=MOD(R,1.0D0)                                                 
      END   
C
C
C                                                               
      SUBROUTINE DFUN(DF,DG,GHESS,HESS,OBS,PAR,PARMAX,WORK1,DP,F           
     :,ITER,MAXPAR,MODEL,NCASE,NDERIV,NOBS1,NPASS,DIFFER,FORWRD            
     1,ALPHA,ALPHAP,BETA,BETAP,BINOM,DTRANS,FINISH,HPROB,ICONDS,IP,ISEL    
     2,MAXCHR,MAXHYB,MAXLOC,MAXPAN,NCHR,NHYB,NLOCUS,NOBS,NPAN,NPAR         
     3,PERM,RETAIN,SUBPRM,START,TRANS1,TRANSP)                               
C                                                                          
C     THIS SUBROUTINE CONTROLS THE COMPUTATION OF F AND ITS FIRST          
C     NDERIV PARTIAL DERIVATIVES.  WHEN THE DERIVATIVES ARE                
C     COMPUTED NUMERICALLY, FORWARD OR CENTRAL DIFFERENCES ARE             
C     USED DEPENDING ON THE LOGICAL VARIABLE FORWRD.  DIFFER(1)            
C     SHOULD BE INPUT AS TRUE WHEN ANALYTIC DERIVATIVES ARE                
C     AVAILABLE.  THE NUMERICAL DIFFERENTIATION INTERVAL IS                
C     ADJUSTED TO TAKE INTO ACCOUNT THE MAGNITUDE OF A PARAMATER           
C     AND WHETHER IT LIES ON ITS UPPER BOUND.  DIFFER(2) IS TRUE           
C     WHEN AN APPROXIMATE HESSIAN IS AVAILABLE.                            
C                                                                          
C                                                                          
C ORIGINAL DFUN VARIABLES:                                                 
C                                                                          
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)                                   
      DOUBLE PRECISION DG(MAXPAR),GHESS(MAXPAR,MAXPAR)                     
     :,HESS(MAXPAR,MAXPAR),OBS(NOBS1,NCASE)                                
     :,PARMAX(MAXPAR),WORK1(MAXPAR)                                        
      INTEGER PASS                                                         
      LOGICAL DIFFER(2),FORWRD                                             
C                                                                          
C RHMAXLIK VARIABLES:                                                      
C                                                                          
      INTEGER FINISH(0:2),NCHR(MAXPAN),NHYB(MAXPAN),NOBS(MAXPAN,MAXHYB)    
     1,PERM(MAXLOC),RETAIN(MAXPAN,MAXHYB,MAXLOC),START(0:2)                
     2,SUBPRM(2,MAXLOC)                                                      
      REAL*8 ALPHA(MAXLOC,0:MAXCHR),ALPHAP(2,MAXLOC,0:MAXCHR,0:MAXCHR)     
     1,BETA(MAXLOC,0:MAXCHR),BETAP(2,MAXLOC,0:MAXCHR)                      
     2,BINOM(0:MAXCHR,0:MAXCHR),DF(MAXPAR)                                 
     3,DTRANS(MAXLOC,0:MAXCHR,0:MAXCHR,3),HPROB(MAXPAN,MAXHYB)             
     4,PAR(MAXPAR),TRANS1(MAXLOC,0:1,0:1)                                  
     5,TRANSP(MAXLOC,0:MAXCHR,0:MAXCHR)                                    
C                                                                          
      F=0.D0                                                               
      DO 10 I=1,NDERIV                                                     
 10   DF(I)=0.                                                             
      IF (DIFFER(2)) THEN                                                  
      DO 20 J=1,NDERIV                                                     
      DO 30 I=1,NDERIV                                                     
 30   HESS(I,J)=0.                                                         
 20   CONTINUE                                                             
      END IF                                                               
C                                                                          
C     DO NOTHING ON THE FIRST FEW PASSES.                                  
C                                                                          
      DO 40 PASS=1,NPASS-1                                                 
      DO 50 KASE=1,NCASE                                                   
 50   CALL FUN(DG,OBS(1,KASE),PAR,G,ITER,KASE,MODEL,NCASE,NOBS1            
     :,MAXPAR,NPASS,PASS,DIFFER                                            
     1,ALPHA,ALPHAP,BETA,BETAP,BINOM,DTRANS,FINISH,HESS,HPROB,ICONDS,0     
     2,IP,ISEL,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,NCHR,NHYB,NLOCUS,NOBS    
     3,NPAN,PERM,RETAIN,SUBPRM,START,TRANS1,TRANSP)                          
 40   CONTINUE                                                             
C                                                                          
C     COMPUTE THE FUNCTION AND ITS DERIVATIVES ON THE LAST PASS.           
C                                                                          
      DO 60 KASE=1,NCASE                                                   
      IF (DIFFER(1)) THEN                                                  
      DO 70 I=1,NDERIV                                                     
 70   DG(I)=0.                                                             
      END IF                                                               
      CALL FUN(DG,OBS(1,KASE),PAR,G,ITER,KASE,MODEL,NCASE,NOBS1            
     :,MAXPAR,NPASS,NPASS,DIFFER                                           
     1,ALPHA,ALPHAP,BETA,BETAP,BINOM,DTRANS,FINISH,HESS,HPROB,ICONDS,0     
     2,IP,ISEL,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,NCHR,NHYB,NLOCUS,NOBS    
     3,NPAN,PERM,RETAIN,SUBPRM,START,TRANS1,TRANSP) 
      IF (.NOT.DIFFER(1)) THEN                                             
      DO 80 I=1,NDERIV                                                     
      D=DP*MAX(ABS(PAR(I)),1.0D0)                                          
      PTEMP=PAR(I)                                                         
      IF (FORWRD) THEN                                                     
C                                                                          
C     COMPUTE THE PARTIAL DERIVATIVE BY A FORWARD DIFFERENCE.              
C                                                                          
      IF (PTEMP+D.GE.PARMAX(I)) D=-D                                       
      PAR(I)=PTEMP+D                                                       
      CALL FUN(WORK1,OBS(1,KASE),PAR,GPLUS,ITER,KASE,MODEL,NCASE           
     :,NOBS1,MAXPAR,NPASS,NPASS,DIFFER                                     
     1,ALPHA,ALPHAP,BETA,BETAP,BINOM,DTRANS,FINISH,HESS,HPROB,ICONDS,0     
     2,IP,ISEL,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,NCHR,NHYB,NLOCUS,NOBS    
     3,NPAN,PERM,RETAIN,SUBPRM,START,TRANS1,TRANSP)                          
C                                                                          
      PAR(I)=PTEMP                                                         
      DG(I)=(GPLUS-G)/D                                                    
      ELSE                                                                 
C                                                                          
C     COMPUTE THE PARTIAL DERIVATIVE BY A CENTRAL DIFFERENCE.              
C                                                                          
      PAR(I)=PTEMP+D                                                       
      CALL FUN(WORK1,OBS(1,KASE),PAR,GPLUS,ITER,KASE,MODEL,NCASE           
     :,NOBS1,MAXPAR,NPASS,NPASS,DIFFER                                     
     1,ALPHA,ALPHAP,BETA,BETAP,BINOM,DTRANS,FINISH,HESS,HPROB,ICONDS,0     
     2,IP,ISEL,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,NCHR,NHYB,NLOCUS,NOBS    
     3,NPAN,PERM,RETAIN,SUBPRM,START,TRANS1,TRANSP)                          
      PAR(I)=PTEMP-D                                                       
      CALL FUN(WORK1,OBS(1,KASE),PAR,GMINUS,ITER,KASE,MODEL,NCASE          
     :,NOBS1,MAXPAR,NPASS,NPASS,DIFFER                                     
     1,ALPHA,ALPHAP,BETA,BETAP,BINOM,DTRANS,FINISH,HESS,HPROB,ICONDS,0     
     2,IP,ISEL,MAXCHR,MAXHYB,MAXLOC,MAXPAN,MAXPAR,NCHR,NHYB,NLOCUS,NOBS    
     3,NPAN,PERM,RETAIN,SUBPRM,START,TRANS1,TRANSP)                          
      PAR(I)=PTEMP                                                         
      DG(I)=(GPLUS-GMINUS)/(D+D)                                           
      END IF                                                               
 80   CONTINUE                                                             
      END IF                                                               
C                                                                          
C     UPDATE THE FUNCTION AND ITS DIFFERENTIAL.  APPROXIMATE THE           
C     HESSIAN IF DESIRED.                                                  
C                                                                          
      IF (DIFFER(2)) THEN                                                  
      DO 90 J=1,NDERIV                                                     
      DO 100 I=1,NDERIV                                                    
 100  GHESS(I,J)=0.                                                        
 90   CONTINUE                                                             
      END IF                                                               
      CALL HESSIN(DG,GHESS,OBS(1,KASE),PAR,G,ITER,KASE,MODEL,NCASE         
     :,NOBS1,MAXPAR,DIFFER)                                                
      F=F+G                                                                
      DO 110 I=1,NDERIV                                                    
 110  DF(I)=DF(I)+DG(I)                                                    
      IF (DIFFER(2)) THEN                                                  
      DO 120 J=1,NDERIV                                                    
      DO 130 I=1,NDERIV                                                    
 130  HESS(I,J)=HESS(I,J)+GHESS(I,J)                                       
 120  CONTINUE                                                             
      END IF                                                               
 60   CONTINUE                                                             
      END        
C
C
C                                                          
      SUBROUTINE OUTPUT(PAR,PNAME,F,ITER,LAST,IOUNIT,MAXPAR,MODEL          
     1,NPAR,NSTEP,TRAVEL,DIFFER)                                           
C                                                                          
C     THIS SUBROUTINE OUTPUTS THE FUNCTION VALUE AND PARAMETERS            
C     AT EACH ITERATION.                                                   
C                                                                          
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)                                   
      DOUBLE PRECISION PAR(MAXPAR)                                         
      CHARACTER*8 PNAME(MAXPAR),TRAVEL
C     CHARACTER*8 MODE*15                             
      LOGICAL DIFFER(2)                                                    
      SAVE FMIN,IMIN                                                       
C               
      IF (ITER.EQ.1) THEN                                                  
      FMIN=F                                                               
      WRITE(IOUNIT,10)
 10   FORMAT(/,' QUASI-NEWTON MAXIMIZATION')
C      IF (TRAVEL.EQ.'GRID') THEN                                           
C      MODE='NONE'                                                          
C      ELSE IF (DIFFER(2)) THEN                                             
C      MODE='USER SUPPLIED'                                                 
C      ELSE                                                                 
C      MODE='QUASI-NEWTON'                                                  
C      END IF                                                               
C      IF (IOUNIT.GE.0) WRITE(IOUNIT,10) TRAVEL,MODE,MODEL                  
C 10   FORMAT(/,' GRID OR SEARCH OPTION: ',A                                
C     1/,' HESSIAN APPROXIMATION: ',A,/,' USER MODEL NUMBER:',I4)           
      IF (IOUNIT.GE.0) WRITE(IOUNIT,20) (PNAME(I),I=1,NPAR)                
C 20   FORMAT(/,' ITER  NSTEP    FUNCTION   ',(T28,4(4X,A8),:))             
 20   FORMAT(/' ITER       LOGLIK   ',200(T23,6(1X,A8)/))
      END IF                                                               
      IF (F.LE.FMIN) THEN                                                  
      IMIN=ITER                                                            
      FMIN=F                                                               
      END IF                                                               
C      IF (IOUNIT.GE.0) WRITE(IOUNIT,30) ITER,NSTEP,F,(PAR(I),I=1,NPAR)     
      IF (IOUNIT.GE.0) WRITE(IOUNIT,30) ITER,-F/DLOG(10.D0)
     1,(PAR(I),I=1,NPAR)     
 30   FORMAT(I5,2X,F14.6,6F9.5,200(/T22,6F9.5))
C      IF (ITER.EQ.LAST.AND.IOUNIT.GE.0) WRITE(IOUNIT,40) IMIN              
C 40   FORMAT(/,' THE MINIMUM FUNCTION VALUE OCCURS AT ITERATION',I4,'.')   
      END    
C
C
C                                                                           
      SUBROUTINE SETTAB(CNSTR,CVALUE,DF,HESS,PAR,TABLE,WORK2,CNORM         
     1,MAXPAR,MAXTAB,MCNSTR,NCNSTR,NPAR,NTAB)                              
C                                                                          
C     THIS SUBROUTINE CREATES AN UPPER TRIANGULAR TABLEAU IN               
C     PREPARATION FOR THE QUADRATIC PROGRAMMING PROBLEM.                   
C                                                                          
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)                                   
      DOUBLE PRECISION CNSTR(MCNSTR,MAXPAR),CVALUE(MCNSTR),DF(MAXPAR)      
     1,HESS(MAXPAR,MAXPAR),PAR(MAXPAR),TABLE(MAXTAB,MAXTAB)                
     2,WORK2(MAXTAB)                                                       
C                                                                          
C     FIRST COMPUTE THE NORM OF THE HESSIAN FOR PURPOSES OF SCALING        
C     THE CONSTRAINT CONTRIBUTION TO THE UPPER LEFT BLOCK OF THE           
C     TABLEAU.                                                             
C                                                                          
      IF (NCNSTR.EQ.0) THEN                                                
      C=1.0D0                                                              
      ELSE                                                                 
      HNORM=0.0D0                                                          
      DO 10 I=1,NPAR                                                       
      DO 10 J=1,NPAR                                                       
 10   HNORM=HNORM+HESS(I,J)**2                                             
      HNORM=SQRT(HNORM)                                                    
      C=HNORM/CNORM                                                        
C                                                                          
C     NEXT COMPUTE THE LINEAR EQUALITY CONSTANTS FOR                       
C     THE INCREMENTS OF THE CURRENT PARAMETER VALUES.                      
C                                                                          
      DO 20 I=1,NCNSTR                                                     
      S=CVALUE(I)                                                          
      DO 30 J=1,NPAR                                                       
 30   S=S-CNSTR(I,J)*PAR(J)                                                
 20   WORK2(I)=S                                                           
      END IF                                                               
C                                                                          
C     NOW SET UP THE TABLEAU.  IN THE UPPER LEFT BLOCK LOAD THE            
C     APPROXIMATE HESSIAN.  IF THERE ARE CONSTRAINTS, AUGMENT              
C     THE HESSIAN BY A CONSTANT TIMES CNSTR(TRANSPOSE)*CNSTR.              
C     TO THE RIGHT OF THE HESSIAN LOAD CNSTR(TRANSPOSE).  TO THE           
C     RIGHT OF THIS LOAD THE NEGATIVE OF THE DIFFERENTIAL.  BELOW          
C     THE DIFFERENTIAL LOAD THE LINEAR EQUALITY CONSTANTS.  THE            
C     REST OF THE TABLEAU SHOULD BE ZERO.                                  
C                                                                          
      NTAB=NPAR+NCNSTR+1                                                   
      N1=NPAR+1                                                            
      DO 40 K=1,NPAR                                                       
      DO 40 J=1,K                                                          
      S=0.0D0                                                              
      DO 50 I=1,NCNSTR                                                     
 50   S=S+CNSTR(I,J)*CNSTR(I,K)                                            
 40   TABLE(J,K)=HESS(J,K)+C*S                                             
      DO 60 I=1,NCNSTR                                                     
      K=NPAR+I                                                             
      DO 70 J=1,NPAR                                                       
 70   TABLE(J,K)=CNSTR(I,J)                                                
      DO 80 J=N1,K                                                         
 80   TABLE(J,K)=0.0D0                                                     
 60   CONTINUE                                                             
      DO 90 J=1,NPAR                                                       
 90   TABLE(J,NTAB)=-DF(J)                                                 
      DO 100 J=1,NCNSTR                                                    
 100  TABLE(J+NPAR,NTAB)=WORK2(J)                                          
      TABLE(NTAB,NTAB)=0.0D0                                               
      END    
C
C
C                                                                           
      SUBROUTINE QDPROG(DELTA,PAR,PARMAX,PARMIN,TABLE,WORK1,WORK2          
     1,NSWEEP,SMALL,TOL,MAXPAR,MAXTAB,NCNSTR,NCYCLE,NPAR,NTAB)             
C                                                                          
C     THIS SUBROUTINE SOLVES THE QUADRATIC PROGRAMMING PROBLEM             
C         MIN  DF*DELTA+.5*DELTA(TRANSPOSE)*HESS*DELTA                     
C           SUBJECT TO CNSTR*DELTA=0                                       
C           PARMIN.LE.PAR+DELTA.LE.PARMAX.                                 
C     SEE: R.I.JENNRICH AND P.F.SAMPSON(1978)  "SOME PROBLEMS              
C     FACED IN MAKING A VARIANCE COMPONENT ALGORITHM INTO A                
C     GENERAL MIXED MODEL PROGRAM"  PROCEEDINGS OF THE ELEVENTH            
C     ANNUAL SYMPOSIUM ON THE INTERFACE. A.R.GALLANT AND T.M.GERIG         
C     EDITORS. INSTITUTE OF STATISTICS,NORTH CAROLINA STATE                
C     UNIVERSITY.                                                          
C                                                                          
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)                                   
      DOUBLE PRECISION DELTA(MAXPAR),PAR(MAXPAR),PARMAX(MAXPAR)            
     1,PARMIN(MAXPAR),TABLE(MAXTAB,MAXTAB),WORK1(MAXPAR)                   
     2,WORK2(MAXTAB)                                                       
      INTEGER NSWEEP(MAXPAR)                                               
C                                                                          
C     SEE SUBROUTINES SETTAB FOR THE CONSTRUCTION OF THE TABLEAU           
C     TABLE AND SEARCH FOR THE DEFINTION OF MOST VARIABLES.                
C     NSWEEP =1 OR 0 ACCORDING AS A PARAMETER IS SWEPT OR NOT SWEPT.       
C     FOR CHECKING TOLERANCE, SET WORK1 TO THE DIAGONAL ELEMENTS OF        
C     TABLE.  BEGIN BY SWEEPING ON THOSE DIAGONAL ELEMENTS OF TABLE        
C     CORRESPONDING TO THE PARAMETERS.  ALSO SWEEP ON THE DIAGONAL         
C     ELEMENTS CORRESPONDING TO THE CONSTRAINTS.  IF ANY PARAMETER         
C     FAILS THE TOLERANCE TEST, THEN RETURN AND RESET THE APPROXIMATE      
C     HESSIAN.                                                             
C                                                                          
      TOLS=-TOL*1.0D-3                                                     
      NCYCLE=0                                                             
      DO 10 I=1,NPAR                                                       
      IF (TABLE(I,I).LE.0.0D0) RETURN                                      
      WORK1(I)=TABLE(I,I)                                                  
 10   DELTA(I)=0.0D0                                                       
      DO 20 I=1,NPAR                                                       
      IF (TABLE(I,I)/WORK1(I).LT.TOL) RETURN                               
      CALL SWEEP(TABLE,WORK2,I,MAXTAB,NTAB,.FALSE.)                        
 20   NSWEEP(I)=1                                                          
      DO 30 I=1,NCNSTR                                                     
      K=NPAR+I                                                             
      IF (TABLE(K,K).GE.0.0D0) RETURN                                      
 30   CALL SWEEP(TABLE,WORK2,K,MAXTAB,NTAB,.FALSE.)                        
C                                                                          
C     TAKE A STEP IN THE DIRECTION TABLE(I,NTAB) FOR THE PARAMETERS        
C     I THAT ARE CURRENTLY SWEPT.  IF A BOUNDARY IS ENCOUNTERED,           
C     DETERMINE THE MAXIMAL FRACTIONAL STEP POSSIBLE.                      
C                                                                          
 70   IF (NCYCLE.GE.1000) RETURN                                           
      A=1.0D0                                                              
      DO 40 I=1,NPAR                                                       
      IF (NSWEEP(I).EQ.1) THEN                                             
      UI=TABLE(I,NTAB)                                                     
      IF (UI.GT.0.0D0) THEN                                                
      AI=PARMAX(I)-PAR(I)-DELTA(I)                                         
      ELSE                                                                 
      AI=PARMIN(I)-PAR(I)-DELTA(I)                                         
      END IF                                                               
      IF (ABS(AI).LT.ABS(UI)) A=MIN(A,AI/UI)                               
      END IF                                                               
 40   CONTINUE                                                             
C                                                                          
C     TAKE THE FRACTIONAL STEP FOR THE CURRENTLY SWEPT PARAMETERS,         
C     AND RESET THE TRANSFORMED PARTIAL DERIVATIVES FOR THESE              
C     PARAMETERS.                                                          
C                                                                          
      DO 50 I=1,NPAR                                                       
      IF (NSWEEP(I).EQ.1) THEN                                             
      UI=TABLE(I,NTAB)                                                     
      DELTA(I)=DELTA(I)+A*UI                                               
      TABLE(I,NTAB)=(1.0D0-A)*UI                                           
      END IF                                                               
 50   CONTINUE                                                             
C                                                                          
C     FIND THOSE SWEPT PARAMETERS WHICH ARE CRITICAL, AND INVERSE          
C     SWEEP THEM IF POSSIBLE.  GO BACK AND TRY TO TAKE ANOTHER             
C     STEP OR FRACTIONAL STEP.                                             
C                                                                          
      DO 60 I=1,NPAR                                                       
      IF (NSWEEP(I).EQ.1.AND.TABLE(I,I)/WORK1(I).LT.TOLS.AND               
     1.(PARMIN(I).GE.PAR(I)+DELTA(I)-SMALL.OR                              
     2.PARMAX(I).LE.PAR(I)+DELTA(I)+SMALL)) THEN                           
      NCYCLE=NCYCLE+1                                                      
      CALL SWEEP(TABLE,WORK2,I,MAXTAB,NTAB,.TRUE.)                         
      NSWEEP(I)=0                                                          
      GO TO 70                                                             
      END IF                                                               
 60   CONTINUE                                                             
C                                                                          
C     FIND AN UNSWEPT PARAMETER THAT VIOLATES THE KUHN-TUCKER              
C     CONDIION AND SWEEP ON IT.  GO BACK AND TRY TO TAKE A                 
C     STEP OR FRACTIONAL STEP.  IF NO SUCH PARAMETER EXISTS,               
C     THE PROBLEM IS SOLVED.                                               
C                                                                          
      DO 80 I=1,NPAR                                                       
      UI=TABLE(I,NTAB)                                                     
      IF (NSWEEP(I).EQ.0.AND                                               
     1.((UI.GT.0.0D0.AND.PARMIN(I).GE.PAR(I)+DELTA(I)-SMALL).OR            
     2.(UI.LT.0.0D0.AND.PARMAX(I).LE.PAR(I)+DELTA(I)+SMALL))) THEN         
      NCYCLE=NCYCLE+1                                                      
      CALL SWEEP(TABLE,WORK2,I,MAXTAB,NTAB,.FALSE.)                        
      NSWEEP(I)=1                                                          
      GO TO 70                                                             
      END IF                                                               
 80   CONTINUE                                                             
      NCYCLE=-1                                                            
      END    
C
C
C                                                                           
      SUBROUTINE SWEEP(TABLE,WORK,K,MAXTAB,NTAB,INV)                       
C                                                                          
C     THIS SUBROUTINE SWEEPS OR INVERSE SWEEPS ON THE KTH                  
C     DIAGONAL ELEMENT OF THE TABLEAU TABLE.  SET INV TO FALSE             
C     FOR SWEEP AND TO TRUE FOR INVERSE SWEEP.  OPERATIONS ARE             
C     CARRIED OUT ON ONLY THE UPPER TRIANGULAR PART OF TABLE.              
C                                                                          
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)                                   
      DOUBLE PRECISION TABLE(MAXTAB,MAXTAB),WORK(MAXTAB)                   
      LOGICAL INV                                                          
C                                                                          
      DO 10 I=1,K                                                          
      WORK(I)=TABLE(I,K)                                                   
 10   TABLE(I,K)=0.0D0                                                     
      DO 20 I=K+1,NTAB                                                     
      WORK(I)=TABLE(K,I)                                                   
 20   TABLE(K,I)=0.0D0                                                     
      S=WORK(K)                                                            
      IF (INV) THEN                                                        
      WORK(K)=1.0D0                                                        
      ELSE                                                                 
      WORK(K)=-1.0D0                                                       
      END IF                                                               
      DO 30 J=1,NTAB                                                       
      W=WORK(J)                                                            
      IF (W.EQ.0.0D0) GO TO 30                                             
      DO 40 I=1,J                                                          
 40   TABLE(I,J)=TABLE(I,J)-WORK(I)*W/S                                    
 30   CONTINUE                                                             
      END    

