C **********************************************************************
C **********************************************************************
C ************************   PROGRAM RHMINBRK   ************************
C **********************************************************************
C **************************   VERSION 3.00  ***************************
C *************************   SEPTEMBER 1996  **************************
C **********************************************************************
C *************************   PROGRAMMED BY   ************************** 
C ****************   JUSTINE URO AND MICHAEL BOEHNKE   ***************** 
C **********************************************************************
C **********************************************************************
C * IDENTIFY MINIMUM OBLIGATE BREAK LOCUS ORDERS FOR RADIATION HYBRID  * 
C * MAPPING DATA.  LOCUS ORDERING STRATEGIES:  LIST, STEPWISE LOCUS    *
C * ORDERING, SIMULATED ANNEALING, AND BRANCH AND BOUND.               *
C **********************************************************************
C **********************************************************************
C
C INITIALIZATIONS.
C
      PARAMETER(MAXHYB=200,MAXLOC=60,MAXORD=1000)
C
      CHARACTER*1 CRET(MAXLOC),INCHAR(0:2)
      CHARACTER*4 HNAMET(MAXHYB),LNAME(MAXLOC),LNAMEA(MAXLOC)
     1,LNAMEC(MAXLOC),LNAMEL(MAXLOC),LNAMET(MAXLOC)
      CHARACTER*10 CORDOP(4)
      CHARACTER*80 FILNAM
      CHARACTER*200 FRMT
C
      INTEGER APERM(MAXLOC),BPERM(MAXORD,MAXLOC),BSTPRM(MAXLOC)
     1,CPERM(MAXLOC),HBREAK(0:MAXHYB),HNUMV(MAXHYB),INDEX(MAXORD)
     2,INPERM(MAXLOC),MISS(MAXHYB),NBREAK(MAXORD),NDIFFV(MAXHYB)
     3,NOBS(MAXHYB),NOBST(MAXHYB),ORDOPT,PERM(MAXLOC),PRTMAX
     4,REMAIN(MAXLOC),RET(MAXHYB,MAXLOC),RETAIN(MAXHYB,MAXLOC)
     5,SCROPT,SUMBRK(0:MAXLOC),USE(MAXLOC),USEINC
C
      DATA KTERMR,KTERMW/5,6/
      DATA KIN,KOUT,KSCR1,KSCR2/1,2,3,4/ 
      DATA CORDOP/'      LIST','  STEPWISE','SIM ANNEAL','    BRANCH'/
C
C READ THE FILE NAMES AND DEFINE THE LOGICAL UNIT NUMBERS.
C
      CALL FILES(FILNAM,KIN,KOUT,KTERMR,KTERMW)
C
C WHILE PROBLEM SETS REMAIN, INPUT THE DATA FOR THE CURRENT PROBLEM SET.
C
      NDSET=0
 1    CALL INPUTS(CRET,FRMT,HNAMET,INCHAR,KIN,KOUT,LNAMET,MAXHYB,MAXLOC
     1,NDSET,NERR,NHYBT,NLOCT,NOBST,NPROB,RET,SCROPT)
      IF(NERR.GT.0)GO TO 100
      NDSET=NDSET+1
C
C FOR EACH PROBLEM IN THE CURRENT SET ...
C
      DO 90 IPROB=1,NPROB
        IF(SCROPT.GE.1)WRITE(KTERMW,101)' STARTING PROBLEM ',IPROB
     1  ,' OF ',NPROB,' IN PROBLEM SET ',NDSET
 101    FORMAT(/3(A,I4))
C
C READ THE CONTROL INFORMATION REQUIRED BY ALL ORDERING METHODS FOR
C THE CURRENT PROBLEM.
C
        CALL INPUTP(CORDOP,INFOPT,INPERM,IPROB,KIN,KOUT,LNAME,LNAMET
     1  ,MAXHYB,MAXLOC,NBEST,NERR,NHYBT,NHYB,NLOCT,NLOCUS,NOBS,NOBST
     2  ,ORDOPT,RET,RETAIN,USEINC)
C
C USE THE SPECIFIED ORDERING OPTION TO DETERMINE THE SET OF BEST LOCUS
C ORDERS.
C
      GO TO (10,20,30,40) ORDOPT
C
C ORDOPT=1:  CALCULATE THE NUMBER OF OBLIGATE BREAKS FOR A USER-
C SPECIFIED LIST OF ORDERS.
C
 10   CALL ORDLST(BPERM,FRMT,KIN,KOUT,KTERMW,LNAME,LNAMEL,MAXHYB,MAXLOC
     1,MAXORD,NBBEST,NBREAK,NHYB,NLOCUS,NOBS,NUMORD,PERM,PRTMAX,RETAIN
     2,SCROPT)
      GO TO 50
C
C ORDOPT=2:  USE STEPWISE LOCUS ORDERING TO ATTEMPT TO FIND THE BEST
C LOCUS ORDERS.
C
 20   CALL BRBND(APERM,BSTPRM,CPERM,KIN,KOUT,KSCR1,KSCR2,KTERMW
     1,KWRITE,LNAME,LNAMEA,LNAMEC,MAXHYB,MAXLOC,NBBEST,NHYB,NLOCUS
     2,NOBS,NUMORD,ORDOPT,PERM,PRTMAX,REMAIN,RETAIN,SCROPT,USE)
      GO TO 50
C
C ORDOPT=3:  USE SIMULATED ANNEALING TO ATTEMPT TO FIND THE BEST
C LOCUS ORDERS.
C
 30   CALL ANNEAL(BPERM,KIN,KOUT,KTERMW,LNAME,LNAMEA,MAXHYB,MAXLOC
     1,MAXORD,NBBEST,NBREAK,NHYB,NLOCUS,NOBS,NUMORD,PERM,PRTMAX
     2,RETAIN,SCROPT)
      GO TO 50
C
C ORDOPT=4:  USE BRANCH AND BOUND TO FIND THE BEST LOCUS ORDERS.
C
 40   CALL BRBND(APERM,BSTPRM,CPERM,KIN,KOUT,KSCR1,KSCR2,KTERMW
     1,KWRITE,LNAME,LNAMEA,LNAMEC,MAXHYB,MAXLOC,NBBEST,NHYB,NLOCUS
     2,NOBS,NUMORD,ORDOPT,PERM,PRTMAX,REMAIN,RETAIN,SCROPT,USE)
C
C SORT THE LOCUS ORDERS BY MINIMUM BREAKS.  FOR BRANCH AND BOUND
C AND STEPWISE LOCUS ORDERING, THIS IS DONE ONLY IF NUMORD DOES
C NOT EXCEED MAXORD.  ORDERS WITH TOO MANY BREAKS CAN BE SKIPPED.
C 
 50   IF(ORDOPT.EQ.1.OR.ORDOPT.EQ.3)GO TO 70
        REWIND(KWRITE)
        IF(NUMORD.GT.MAXORD)GO TO 80
          NCUTPT=NBBEST+PRTMAX
          NORD=0
          DO 60 I=1,NUMORD
            NORD=NORD+1
            READ(KWRITE,102)NBREAK(NORD),(BPERM(NORD,J),J=1,NLOCUS)
 102        FORMAT(I6,1000I3)
            IF(NBREAK(NORD).GT.NCUTPT)NORD=NORD-1
 60       CONTINUE
          NUMORD=NORD
          CLOSE(KWRITE)
C
C IF THERE IS SUFFICIENT SPACE, SORT THE CANDIDATE LOCUS ORDERS BY THEIR
C NUMBER OF OBLIGATE BREAKS.
C
 70   IF(NUMORD.LE.MAXORD)CALL INDEXX(NUMORD,NBREAK,INDEX)
C
C OUTPUT THE BEST ORDERS AND THE MINIMUM NUMBER OF OBLIGATE BREAKS.
C 
 80   CALL OUTORD(BPERM,INDEX,KOUT,KWRITE,LNAME,MAXLOC,MAXORD,NBBEST
     1,NBEST,NBREAK,NLOCUS,NUMORD,PERM,PRTMAX)
C
C UNLESS THERE WERE TOO MANY LOCUS ORDERS, IDENTIFY INFLUENTIAL HYBRIDS.
C
      IF(NUMORD.LE.MAXORD.AND.INFOPT.GE.1)
     1 CALL INFHYB(BPERM,HBREAK,HNAMET,HNUMV,INCHAR,INDEX,INPERM,IPROB
     2,KOUT,MAXHYB,MAXLOC,MAXORD,MISS,NBREAK,NDIFFV,NHYBT,NLOCUS
     3,NOBS,NOBST,NUMORD,PRTMAX,RET,RETAIN,SUMBRK,USEINC)
C
 90   CONTINUE
C
C CONTINUE UNTIL THERE ARE NO MORE PROBLEM SETS.
C
      GO TO 1         
C
 100  STOP
      END 
C
C
C
      SUBROUTINE FILES(FILNAM,KIN,KOUT,KTERMR,KTERMW)
C
C READ THE FILE NAMES AND DEFINE THE LOGICAL UNIT NUMBERS.
C
      CHARACTER*80 FILNAM
 101  FORMAT(A)
C
C OUTPUT A HEADER FOR THE PROGRAM TO THE SCREEN.
C
      WRITE(KTERMW,101)' **********************************************'
      WRITE(KTERMW,101)' ************   PROGRAM RHMINBRK   ************'
      WRITE(KTERMW,101)' **********************************************'
      WRITE(KTERMW,101)' ***************  VERSION 3.00  ***************'
      WRITE(KTERMW,101)' **********************************************'
      WRITE(KTERMW,101)' **************  SEPTEMBER 1996  **************'
      WRITE(KTERMW,101)' **********************************************'
      WRITE(KTERMW,101)' ****  BY JUSTINE URO AND MICHAEL BOEHNKE  ****'
      WRITE(KTERMW,101)' **********************************************'
      WRITE(KTERMW,101)' '
C
C DETERMINE THE FILE NAMES.
C
 10   WRITE(KTERMW,101)' INPUT FILE NAME:   '
      READ(KTERMR,101,ERR=20)FILNAM
      OPEN(KIN,FILE=FILNAM,STATUS='OLD',ERR=20)
      GO TO 30
C
 20   WRITE(KTERMW,101)' *** ERROR IN FILE SPECIFICATION.  TRY AGAIN.'
      GO TO 10
C    
 30   WRITE(KTERMW,101)' OUTPUT FILE NAME:  '
      READ(KTERMR,101,ERR=40)FILNAM
      OPEN(KOUT,FILE=FILNAM,STATUS='UNKNOWN',ERR=40)
      GO TO 50
C
 40   WRITE(KTERMW,101)' *** ERROR IN FILE SPECIFICATION.  TRY AGAIN.'
      GO TO 30
C
C OUTPUT A HEADER FOR THE PROGRAM TO THE OUTPUT FILE.
C
 50   WRITE(KOUT,101)' **********************************************'
      WRITE(KOUT,101)' ************   PROGRAM RHMINBRK   ************'
      WRITE(KOUT,101)' **********************************************'
      WRITE(KOUT,101)' **************   VERSION 3.00   **************'
      WRITE(KOUT,101)' **********************************************'
      WRITE(KOUT,101)' ************    SEPTEMBER 1996   *************'
      WRITE(KOUT,101)' **********************************************'
      WRITE(KOUT,101)' ****  BY JUSTINE URO AND MICHAEL BOEHNKE  ****'
      WRITE(KOUT,101)' **********************************************'
      WRITE(KOUT,101)' '
C
      RETURN
      END          
C
C
C
      SUBROUTINE INPUTS(CRET,FRMT,HNAMET,INCHAR,KIN,KOUT,LNAMET,MAXHYB
     1,MAXLOC,NDSET,NERR,NHYBT,NLOCT,NOBST,NPROB,RET,SCROPT)
C
C INPUT THE DATA FOR THE CURRENT PROBLEM SET.
C
      CHARACTER*1 CHAR,CRET(MAXLOC),INCHAR(0:2)
      CHARACTER*4 HNAMET(MAXHYB),LNAME,LNAMET(MAXLOC)
      CHARACTER*200 FRMT
      INTEGER NOBST(MAXHYB),RET(MAXHYB,MAXLOC),SCROPT
C
C READ THE NUMBER OF PROBLEMS IN THIS SET, THE TOTAL NUMBER OF LOCI,
C AND THE NUMBER OF HYBRIDS.  CHECK THAT THEIR VALUES MAKE SENSE.
C
      NERR=1
      READ(KIN,101,END=160,ERR=140)NPROB,NLOCT,NHYBT,SCROPT
 101  FORMAT(20I4)
      NERR=0
C
      IF(NPROB.GT.0)GO TO 10
        WRITE(KOUT,102)NPROB
 102    FORMAT(/' *** ERROR *** THE NUMBER OF PROBLEMS IN THE PROBLEM'
     1  ,' SET IS REPORTED TO'/15X,'BE',I4,'.  IT MUST BE POSITIVE.')
        NERR=NERR+1 
C
 10   IF(NLOCT.GT.1.AND.NLOCT.LE.MAXLOC.AND.NLOCT.LE.999)GO TO 20
        WRITE(KOUT,103)NLOCT,MAXLOC
 103    FORMAT(/' *** ERROR *** THE NUMBER OF LOCI IN THE PROBLEM SET'
     1  ,' IS REPORTED TO'/15X,'BE',I4,'.  IT MUST BE AT LEAST TWO AND'
     2  ,' NO GREATER THAN THE'/15X,'MAXIMUM OF',I6,' AND 999.')
        NERR=NERR+1
C
 20   IF(NHYBT.GT.0.AND.NHYBT.LE.MAXHYB)GO TO 30
        WRITE(KOUT,104)NHYBT,MAXHYB
 104    FORMAT(/' *** ERROR *** THE NUMBER OF HYBRIDS IN THE PROBLEM'
     1  ,' SET IS REPORTED TO'/15X,'BE ',I4,'.  IT MUST BE POSITIVE AND'
     2,' NO GREATER THAN ',I4,'.')
        NERR=NERR+1
 30   IF(SCROPT.EQ.0.OR.SCROPT.EQ.1.OR.SCROPT.EQ.2)GO TO 40
        WRITE(KOUT,105)SCROPT
 105    FORMAT(/' *** ERROR *** SCREEN OUTPUT OPTION FOR THE PROBLEM '
     1  ,'SET IS REPORTED TO'/15X,'BE ',I4,'.  IT MUST BE ZERO, ONE,'
     2  ,' OR TWO.')
        NERR=NERR+1
C
C READ THE LOCUS NAMES AND THE FORMAT FOR READING THE RETENTION DATA.
C CHECK THAT THE LOCUS NAMES ARE ALL DIFFERENT.
C
 40   READ(KIN,106)(LNAMET(I),I=1,NLOCT)
 106  FORMAT(20A4)
C
      DO 60 LOCUS1=1,NLOCT-1
        LNAME=LNAMET(LOCUS1)
        DO 50 LOCUS2=LOCUS1+1,NLOCT
          IF(LNAME.NE.LNAMET(LOCUS2))GO TO 50
            WRITE(KOUT,107)LOCUS1,LOCUS2,LNAME
 107        FORMAT(' *** ERROR *** LOCUS NUMBERS ',I4,' AND ',I4
     1      ,' HAVE THE SAME NAME, ',A4,'.')                    
            NERR=NERR+1                                          
 50     CONTINUE                                                 
 60   CONTINUE                                                   
C                                                               
      READ(KIN,108)FRMT                                           
 108  FORMAT(A)                                                
C                                                               
C ECHO THE LOCUS NAMES FOR THE DATA SET.                        
C                                                               
      WRITE(KOUT,109)NDSET+1
 109  FORMAT(///' LOCUS NAMES FOR PROBLEM SET',I6
     1//'  LOCUS        LOCUS'/'  NUMBER       NAME'/)
      DO 70 I=1,NLOCT
        WRITE(KOUT,111)I,LNAMET(I)
 111    FORMAT(I6,10X,A4)
 70   CONTINUE
C
C READ AND PRINT THE SYMBOLS FOR PRESENT, ABSENT, AND MISSING LOCI.
C
      READ(KIN,112)INCHAR(1),INCHAR(0),INCHAR(2)
 112  FORMAT(3A1)
      IF(INCHAR(1).NE.INCHAR(0).AND.INCHAR(1).NE.INCHAR(2)
     1.AND.INCHAR(0).NE.INCHAR(2))GO TO 80
C
        WRITE(KOUT,113)INCHAR(1),INCHAR(0),INCHAR(2)
 113    FORMAT(' *** ERROR *** THE SYMBOLS ',A1,', ',A1,', AND ',A1
     1  ,' FOR PRESENT, ABSENT, AND MISSING'/15X,'DATA ARE NOT ALL'
     2  ,'DIFFERENT.')
        NERR=NERR+1
C
 80   WRITE(KOUT,114)INCHAR(1),INCHAR(0),INCHAR(2),(I,I=1,NLOCT)
 114  FORMAT(//' RETENTION STATUS CHARACTERS'//5X,A1,' = RETAINED'
     1/5X,A1,' = NOT RETAINED'/5X,A1,' = UNTYPED'
     2///' RADIATION HYBRID RETENTION STATUS DATA'
     3//' HYBRID    HYBRID    NUMBER    RETENTION STATUS'
     4/ ' NUMBER     NAME    OBSERVED ',20I3,49(/29X,20I3))
      WRITE(KOUT,112)
C
C READ RETENTION INFORMATION.  PRINT THE HYBRID DATA.
C
      NTOTAL=0
      DO 130 IHYBT=1,NHYBT
C
C TRANSLATE THE SYMBOLS FOR PRESENT, ABSENT, AND MISSING LOCI
C TO 1, 0, AND 2, RESPECTIVELY.  BY CONVENTION, NOBST=0 IMPLIES
C NOBST=1.
C
 90     READ(KIN,FRMT)HNAMET(IHYBT),(CRET(J),J=1,NLOCT),NOBST(IHYBT)
        IF(NOBST(IHYBT).EQ.0)NOBST(IHYBT)=1
        NTOTAL=NTOTAL+NOBST(IHYBT)
C
C CHECK THAT THE HYBRID OBSERVATIONS ARE ADMISSIBLE.
C
        DO 110 J=1,NLOCT
          CHAR=CRET(J)
          DO 100 K=0,2
            IF(CHAR.NE.INCHAR(K))GO TO 100
              RET(IHYBT,J)=K
            GO TO 110
 100      CONTINUE
C
          WRITE(KOUT,115)IHYBT,HNAMET(IHYBT),CHAR,J,LNAMET(J)
 115      FORMAT(' *** ERROR *** HYBRID NUMBER ',I4,' NAMED ',A4
     1    ,' HAS ILLEGAL OBSERVATION ',A1/15X,'FOR LOCUS NUMBER ',I4
     2    ,' NAMED',A4,'.')
 110    CONTINUE
C
C CHECK THE NUMBER OF TIMES HYBRIDS ARE OBSERVED.
C
        IF(NOBST(IHYBT).GT.0)GO TO 120
          WRITE(KOUT,116)IHYBT,NOBST(IHYBT)
 116      FORMAT(' *** ERROR *** HYBRID NUMBER ',I4,' IS REPORTEDLY'
     1    ,' OBSERVED ',I4,' TIMES.')
C
C PRINT THE HYBRID.
C
 120    WRITE(KOUT,117)IHYBT,HNAMET(IHYBT),NOBST(IHYBT)
     1  ,(CRET(J),J=1,NLOCT)
 117    FORMAT(I4,7X,A4,I9,7X,20(A1,2X),49(/31X,20(A1,2X)))
C
 130  CONTINUE
      GO TO 150
C
 140  WRITE(KOUT,118)
 118  FORMAT(/' ERROR ENCOUNTERED WHILE READING THE FIRST INPUT'
     1,' RECORD FOR A PROBLEM'/' SET.  THIS MAY HAVE OCCURRED BECAUSE'
     2,' OF EXTRA INFORMATION OR BLANK LINES'/' AT THE END OF THE'
     3,' INPUT FILE.')
      STOP 
C
C PRINT THE NUMBER OF HYBRIDS.
C
 150  WRITE(KOUT,119)NTOTAL
 119  FORMAT(/' TOTAL NUMBER OF HYBRIDS:  ',I6)
C
 160  RETURN
      END
C
C
C  
      SUBROUTINE INPUTP(CORDOP,INFOPT,INPERM,IPROB,KIN,KOUT,LNAME,LNAMET
     1,MAXHYB,MAXLOC,NBEST,NERR,NHYBT,NHYB,NLOCT,NLOCUS,NOBS,NOBST
     2,ORDOPT,RET,RETAIN,USEINC)
C
C READ THE CONTROL INFORMATION FOR THE CURRENT PROBLEM.
C
      CHARACTER*4 LNAME(MAXLOC),LNAMET(MAXLOC)
      CHARACTER*10 CINFOP,CORDOP(4),CUSINC
      INTEGER INPERM(MAXLOC),NOBS(MAXHYB),NOBST(MAXHYB),ORDOPT
     1,RET(MAXHYB,MAXLOC),RETAIN(MAXHYB,MAXLOC),USEINC
C
C READ THE CONTROL INFORMATION FOR THE CURRENT PROBLEM.
C CHECK THAT THE INPUT VALUES MAKE SENSE.
C   NLOCUS:  NUMBER OF LOCI.
C   ORDOPT:  ORDERING OPTION FOR SELECTING BEST LOCUS ORDERS.
C   USEINC:  =1 USE ALL DATA; =0 USE COMPLETELY TYPED HYBRIDS ONLY.
C   NBEST:   NO MORE THAN THE NBEST BEST LOCUS ORDERS WILL BE PRINTED.
C   INFOPT:  =1 PRINT INFLUENTIAL HYBRID INFORMATION; =0 DO NOT.
C
      NERR=0
      READ(KIN,101)NLOCUS,ORDOPT,USEINC,NBEST,INFOPT
 101  FORMAT(20I4)
C
      IF(NLOCUS.GT.1.AND.NLOCUS.LE.NLOCT)GO TO 10
        WRITE(KOUT,102)NLOCUS,NLOCT
 102    FORMAT(' *** ERROR *** THE NUMBER OF LOCI FOR THE CURRENT'
     1  ,' PROBLEM IS REPORTED'/15X,'TO BE',I4,'.  IT MUST BE'
     2  ,' AT LEAST TWO AND NO GREATER THAN ',I4,'.')
        NERR=NERR+1
C
 10   IF(ORDOPT.GT.0.AND.ORDOPT.LT.5)GO TO 20
        WRITE(KOUT,103)ORDOPT
 103    FORMAT(' *** ERROR ***  ORDERING OPTIONS 1 (LIST), 2'
     1  ,' (STEPWISE), 3 (SIMULATED'/15X,'ANNEALING), AND 4 (BRANCH'
     2  ,' AND BOUND) ARE ALLOWED.'/15X,'ORDERING OPTION ',I4
     3  ,' WAS REQUESTED.')
        NERR=NERR+1
C
 20   IF(NLOCUS.GT.2.OR.ORDOPT.EQ.1)GO TO 30
        WRITE(KOUT,104)
 104    FORMAT(' *** ERROR *** IF THERE ARE ONLY TWO LOCI, ONLY THE'
     1  ,' LIST OF ORDERS'/15X,'ORDERING OPTION (ORDOPT=1) IS ALLOWED.')
        NERR=NERR+1
C
 30   IF(USEINC.EQ.0.OR.USEINC.EQ.1)GO TO 40
        WRITE(KOUT,105)USEINC
 105    FORMAT(' *** ERROR *** INCOMPLETE DATA INDICATOR MUST BE ONE'
     1  ,' (USE INCOMPLETELY)'/15X,'TYPED HYBRIDS) OR ZERO (DO NOT).'
     2  ,'  IT IS ',I4,'.')
        NERR=NERR+1
C
C IF NBEST=0, BY CONVENTION, ALL ORDERS ARE TO BE PRINTED IF POSSIBLE.
C
 40   IF(NBEST.GE.0)GO TO 50
        WRITE(KOUT,106)NBEST
 106    FORMAT(' *** ERROR *** THE NUMBER OF BEST ORDERS TO BE PRINTED'
     1  ,' IS LISTED'/15X,'AS ',I6,'.  IT MUST BE NON-NEGATIVE.')
        NERR=NERR+1
C
 50   IF(INFOPT.EQ.0.OR.INFOPT.EQ.1)GO TO 60
        WRITE(KOUT,107)INFOPT
 107    FORMAT(' *** ERROR *** INFLUENTIAL HYBRID INDICATOR MUST BE ONE'
     1  ,' (YES) OR ZERO'/15X,'(NO).  IT IS ',I4,'.')
        NERR=NERR+1
C
 60   IF(NLOCUS.LE.0.OR.NLOCUS.GT.NLOCT)GO TO 70
C
C READ THE LOCUS NAMES FOR THE CURRENT PROBLEM.  CHECK THAT THEY ARE ALL
C DIFFERENT AND THAT THEY ARE IN THE DATA SET.  DETERMINE THE INPUT
C ORDER OF THE LOCI.
C
        READ(KIN,108)(LNAME(LOCUS),LOCUS=1,NLOCUS)
 108    FORMAT(20A4)
        CALL NAMIND(KOUT,LNAME,LNAMET,NERR,NLOCT,NLOCUS,INPERM)
C
C RE-ORDER AND COMPRESS RET TO GIVE RETAIN FOR THIS PROBLEM.  SET
C NOBS AND NHYB.
C
 70   NHYB=0
      DO 110 IHYBT=1,NHYBT
        NHYB=NHYB+1
C
C CHOOSE THE NEXT SET OF VALUES FROM RET.  IF THERE ARE ANY MISSING
C VALUES, WE MAY OPTIONALLY DELETE THEM.
C 
        DO 80 LOCUS=1,NLOCUS
          RETAIN(NHYB,LOCUS)=RET(IHYBT,INPERM(LOCUS))
          IF(USEINC.EQ.1)GO TO 80
          IF(RETAIN(NHYB,LOCUS).NE.2)GO TO 80
            NHYB=NHYB-1
            GO TO 110
 80     CONTINUE
        NOBS(NHYB)=NOBST(IHYBT)
C
        NHYB1=NHYB-1
        DO 100 JHYB=1,NHYB1
          DO 90 LOCUS=1,NLOCUS
            IF(RETAIN(NHYB,LOCUS).NE.RETAIN(JHYB,LOCUS))GO TO 100
 90       CONTINUE
          NOBS(JHYB)=NOBS(JHYB)+NOBS(NHYB)
          NHYB=NHYB-1
          GO TO 110
 100    CONTINUE
 110  CONTINUE
C
C ECHO THE CONTROL DATA FOR THIS PROBLEM.
C
      CUSINC='        NO'
      IF(USEINC.EQ.1)CUSINC='       YES'
      CINFOP='        NO'
      IF(INFOPT.EQ.1)CINFOP='       YES'
C
      WRITE(KOUT,109)IPROB,NLOCUS,CORDOP(ORDOPT),CUSINC,CINFOP
     1,(LNAME(I),I=1,NLOCUS)
 109  FORMAT(///' PROBLEM NUMBER',I26//
     1' NUMBER OF LOCI:',15X,I10/' ORDERING OPTION:',14X,A10
     2/' USE INCOMPLETE HYBRIDS:',7X,A10
     3/' IDENTIFY INFLUENTIAL HYBRIDS:',1X,A10//' GENETIC LOCI:'
     4,5X,10A5,99(/19X,10A5))
C
      RETURN
      END
C
C
C 
      SUBROUTINE NAMIND(KOUT,LNAME,LNAMET,NERR,NLOCT,NLOCUS,PERM)
C
C CHECK THAT THE LOCUS NAMES LNAME ARE ALL DIFFERENT AND THAT THEY
C ARE ALL AMONG THE NAMES IN LNAMET.
C
      CHARACTER*4 LNAM,LNAME(NLOCUS),LNAMET(NLOCT)
      INTEGER PERM(NLOCUS)
C
      NLOC1=NLOCUS-1
      DO 20 LOCUS1=1,NLOC1
        LNAM=LNAME(LOCUS1)
        DO 10 LOCUS2=LOCUS1+1,NLOCUS
          IF(LNAM.NE.LNAME(LOCUS2))GO TO 10
            WRITE(KOUT,101)LOCUS1,LOCUS2,LNAM
 101        FORMAT(' *** ERROR *** LOCUS NUMBERS ',I4,' AND ',I4
     1      ,' HAVE THE SAME NAME, ',A4,'.')
            NERR=NERR+1
 10     CONTINUE
 20   CONTINUE
C
      DO 50 LOCUS=1,NLOCUS
        PERM(LOCUS)=1
        LNAM=LNAME(LOCUS)
        DO 30 LOCUST=1,NLOCT
          IF (LNAMET(LOCUST).EQ.LNAM)GO TO 40
 30     CONTINUE
          WRITE(KOUT,102)LOCUS,LNAM
 102      FORMAT(' *** ERROR *** LOCUS NUMBER ',I4,' WITH NAME ',A4
     1    ,' IS NOT PRESENT AMONG'/15X,'THE LOCI FOR THIS PROBLEM SET.')
          NERR=NERR+1
          GO TO 50
 40     PERM(LOCUS)=LOCUST
 50   CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE ORDLST(BPERM,FRMT,KIN,KOUT,KTERMW,LNAME,LNAMEL,MAXHYB
     1,MAXLOC,MAXORD,NBBEST,NBREAK,NHYB,NLOCUS,NOBS,NUMORD,PERM,PRTMAX
     2,RETAIN,SCROPT)
C
C CALCULATE THE NUMBER OF OBLIGATE BREAKS FOR A SET OF USER-SPECIFIED
C LOCUS ORDERS.
C
      CHARACTER*4 LNAME(MAXLOC),LNAMEL(MAXLOC)
      CHARACTER*200 FRMT
      INTEGER BPERM(MAXORD,MAXLOC),NBREAK(MAXORD),NOBS(MAXHYB)
     1,PERM(MAXLOC),PRTMAX,RETAIN(MAXHYB,MAXLOC),SCROPT
C
C READ THE NAME OF THE LOCUS ORDER FILE AND THE FORMAT FOR READING THE
C LOCUS ORDERS.  SET PRTMAX TO A LARGE NUMBER SO THAT RESULTS FOR ALL
C LOCUS ORDERS ARE PRINTED.
C
      READ(KIN,101)NUMORD
 101  FORMAT(I4)
      IF(NUMORD.LE.MAXORD)GO TO 10
        WRITE(KOUT,102)MAXORD
 102    FORMAT(/' *** ERROR *** THE NUMBER OF ORDERS LISTED IS'
     1  ,' GREATER THAN THE MAXIMUM'/15X,'NUMBER OF ORDERS',I8
     2  ,'.   INCREASE MAXORD.')
        STOP
C
 10   READ(KIN,103)FRMT
 103  FORMAT(A)
C
      PRTMAX=10000
      NBBEST=32767
C
C READ EACH LOCUS ORDER AND CALCULATE ITS OBLIGATE NUMBER OF BREAKS.
C STORE THIS VALUE IN NBREAK.  STORE THE LOCUS ORDER IN BPERM.
C
      DO 40 IORD=1,NUMORD
        READ(KIN,FRMT)(LNAMEL(LOCUS),LOCUS=1,NLOCUS)
        NERR=0
        CALL NAMIND(KOUT,LNAMEL,LNAME,NERR,NLOCUS,NLOCUS,PERM)
        IF(NERR.EQ.0)GO TO 20
          WRITE(KOUT,104)IORD,(LNAMEL(LOCUS),LOCUS=1,NLOCUS)
 104      FORMAT(' *** ERROR *** PROBLEM WITH LOCUS ORDER ',I4
     1    ,' WITH LOCUS NAMES:',84(/15X,12(1X,A4)))
          STOP
C
 20     MINB=MINBRK(MAXHYB,MAXLOC,NHYB,NLOCUS,NOBS,PERM,RETAIN)
C
        IF(SCROPT.EQ.2)
     1  WRITE(KTERMW,105)IORD,MINB,(PERM(LOCUS),LOCUS=1,NLOCUS)
 105    FORMAT(I6,I8,2X,20I3,49(/16X,20I3))
C
        NBREAK(IORD)=MINB
        DO 30 LOCUS=1,NLOCUS
          BPERM(IORD,LOCUS)=PERM(LOCUS)
 30     CONTINUE
C
C UPDATE THE MINIMUM BREAKS COUNT.
C
        IF(MINB.LT.NBBEST)NBBEST=MINB
 40   CONTINUE
C   
      RETURN
      END
C
C
C         
      FUNCTION MINBRK(MAXHYB,MAXLOC,NHYB,NLOCUS,NOBS,PERM,RETAIN)
C    
C CALCULATE THE MINIMUM NUMBER OF OBLIGATE BREAKS FOR A LOCUS ORDER.
C
      INTEGER NOBS(MAXHYB),PERM(NLOCUS),RETAIN(MAXHYB,MAXLOC)
      MINBRK=0
C
C FOR EACH HYBRID ...
C
      DO 30 IHYB=1,NHYB
        LAST=RETAIN(IHYB,PERM(1))
C
C FOR EACH LOCUS AFTER THE FIRST, CHECK WHETHER THERE IS A DIFFERENCE
C IN RETENTION STATUS.  IF SO, UPDATE LAST.  IF IT IS BETWEN TWO TYPED
C LOCI, ALSO UPDATE THE NUMBER OF BREAKS. 
C 
        DO 20 JLOC=2,NLOCUS
          JR=RETAIN(IHYB,PERM(JLOC))
          IF(JR.EQ.LAST)GO TO 20 
            IF(JR.EQ.2)GO TO 20 
              IF(JR+LAST.EQ.1)MINBRK=MINBRK+NOBS(IHYB) 
              LAST=JR          
 20     CONTINUE 
C
 30   CONTINUE
C      
      RETURN
      END 
C
C
C 
      SUBROUTINE BRBND(APERM,BSTPRM,CPERM,KIN,KOUT,KSCR1,KSCR2
     1,KTERMW,KWRITE,LNAME,LNAMEA,LNAMEC,MAXHYB,MAXLOC,NBBEST
     2,NHYB,NLOCUS,NOBS,NUMORD,ORDOPT,PERM,PRTMAX,REMAIN,RETAIN,SCROPT
     3,USE)
C
C USE STEPWISE LOCUS ORDERING (ORDOPT=2) OR BRANCH AND BOUND
C (ORDOPT=4) TO IDENTIFY THE BEST LOCUS ORDERS.
C
      CHARACTER*4 LNAME(MAXLOC),LNAMEA(MAXLOC),LNAMEC(MAXLOC)
      INTEGER APERM(MAXLOC),BBOPT,BSTPRM(MAXLOC),CANBRK,CANOPT
     1,CPERM(MAXLOC),ENDLOC,NOBS(MAXHYB),ORDOPT,PERM(MAXLOC),PRTMAX
     2,REMAIN(MAXLOC),RETAIN(MAXHYB,MAXLOC),SAVMAX,SCROPT,USE(NLOCUS)
C
C INITIALIZE REMAIN, THE LOCI THAT REMAIN TO BE INCLUDED IN THE LOCUS      
C ORDER.  ALSO SET THE ADDING PERMUTATION TO ZEROS IN CASE THE ADDING
C ORDER HAS TO BE MACHINE-GENERATED.
C
      DO 10 LOCUS=1,NLOCUS
        APERM(LOCUS)=0
        REMAIN(LOCUS)=LOCUS
 10   CONTINUE      
C 
C READ THE ADDITIONAL INFORMATION REQUIRED FOR THESE ORDERING OPTIONS.
C
      CALL INBND(APERM,BBOPT,CANOPT,CPERM,KIN,KOUT,LNAME,LNAMEA,LNAMEC
     1,NFORCE,NLOCUS,ORDOPT,PRTMAX,SAVMAX)
      IF(NFORCE.LT.0)ENDLOC=APERM(1)
C
C IF BBOPT=1 AND ORDOPT=4, CALCULATE THE NUMBER OF OBLIGATE BREAKS FOR THE 
C USER-SPECIFIED CANDIDATE LOCUS ORDER CPERM.
C
      CANBRK=0
      IF(BBOPT.EQ.1.AND.ORDOPT.EQ.4)
     1 CANBRK=MINBRK(MAXHYB,MAXLOC,NHYB,NLOCUS,NOBS,CPERM,RETAIN)   
C
C IF BBOPT=0 AND ORDOPT=4, CALL CANORD TO GET A CANDIDATE ORDER CPERM
C AND NUMBER OF BREAKS CANBRK.
C
      IF(BBOPT.EQ.0.AND.ORDOPT.EQ.4)CALL CANORD(CANBRK,CPERM,KTERMW
     1,MAXHYB,MAXLOC,NHYB,NLOCUS,NOBS,PERM,RETAIN,SCROPT,USE)
C
C OUTPUT THE NUMBER OF BREAKS FOR THE CANDIDATE LOCUS ORDER IF DESIRED.
C
      IF(SCROPT.GE.1.AND.ORDOPT.EQ.4)WRITE(KTERMW,101)CANBRK
 101  FORMAT(' NUMBER OF OBLIGATE BREAKS FOR THE CANDIDATE ORDER:',I12)
C
C IF WE ARE FORCING LOCI INTO THE ORDER, DEAL WITH THEM AND GET
C SET FOR ADDING THE REMAINING LOCI.
C
      IF(IABS(NFORCE).LE.1)GO TO 15
        NUMORD=1
        NOLDOR=1
        NBBEST=32767
        OPEN(KSCR1,STATUS='SCRATCH')
        OPEN(KSCR2,STATUS='SCRATCH')
        DO 12 I=1,IABS(NFORCE)
          BSTPRM(I)=APERM(I)
          CALL REMOVE(NLOCUS-I+1,APERM(I),NLOCUS,REMAIN)
 12     CONTINUE
        WRITE(KSCR1,104)0,(APERM(I),I=1,IABS(NFORCE))
        WRITE(KSCR2,104)0,(APERM(I),I=1,IABS(NFORCE))
        GO TO 40
C
C IF NOT, PUT THE FIRST THREE LOCI FOR LOCUS ADDING IN PERM.  IF WE ARE
C GENERATING THE ADDING ORDER, REMOVE THE THREE LOCI USED FROM REMAIN.
C
 15   PERM(1)=APERM(1)
      PERM(2)=APERM(2)
      PERM(3)=APERM(3)
      IF(BBOPT.EQ.1)GO TO 30
        CALL BEST3(ENDLOC,MAXHYB,MAXLOC,NHYB,NLOCUS,NOBS,PERM,RETAIN) 
        DO 20 I=1,3
          CALL REMOVE(NLOCUS+1-I,PERM(I),NLOCUS,REMAIN)
          APERM(I)=PERM(I)
 20     CONTINUE
 30   IF(SCROPT.GE.1)WRITE(KTERMW,102)(LNAME(PERM(I)),I=1,3)
 102  FORMAT(' FIRST THREE LOCI IN PERMUTATION: ',3A6)
C
C CREATE A SCRATCH FILE WITH THE SUFFICIENTLY GOOD THREE-LOCUS ORDERS.
C
      OPEN(KSCR1,STATUS='SCRATCH')
      OPEN(KSCR2,STATUS='SCRATCH')
C
      CALL START3(BSTPRM,CANBRK,ENDLOC,KSCR1,KSCR2,MAXHYB,MAXLOC
     1,NBBEST,NHYB,NOBS,NOLDOR,ORDOPT,PERM,RETAIN,SAVMAX)
C
C FOR EACH REMAINING LOCUS ... (NOTE:  SET KWRITE AND NUMORD IN CASE 
C NLOCUS=3 AND WE SKIP THE LOOP.
C
 40   KWRITE=KSCR1
      KREAD=KSCR2
      NUMORD=NOLDOR
      IF(NLOCUS.EQ.3)GO TO 130
      LSTART=4
      IF(IABS(NFORCE).GT.3)LSTART=IABS(NFORCE)+1
      DO 120 LOCNEW=LSTART,NLOCUS
C
C SET THE CUTPOINT FOR SAVING LOCUS.  IT IS BASED ON THE BEST CANDIDATE
C ORDER IF WE ARE USING BRANCH AND BOUND, AND ON THE BEST PARTIAL
C ORDER FOR THE PREVIOUS LOCUS SET IF WE ARE USING STEPWISE LOCUS
C ORDERING.
C
        NCUTPT=NBBEST+SAVMAX
        IF(ORDOPT.EQ.4)NCUTPT=CANBRK+SAVMAX
        IF(ORDOPT.EQ.4.AND.LOCNEW.EQ.NLOCUS)NCUTPT=CANBRK+PRTMAX
C
C REWIND THE SCRATCH UNIT WITH ORDERS OF LENGTH LOCNEW-1.  OPEN THE 
C OTHER SCRATCH UNIT TO STORE ORDERS OF LENGTH LOCNEW.
C
        IF(LOCNEW/2*2.NE.LOCNEW)GO TO 50
          REWIND(KSCR1)
          CLOSE(KSCR2)
          OPEN(KSCR2,STATUS='SCRATCH')
          KREAD=KSCR1
          KWRITE=KSCR2
          GO TO 60
 50     REWIND(KSCR2)
        CLOSE(KSCR1)
        OPEN(KSCR1,STATUS='SCRATCH')
        KREAD=KSCR2
        KWRITE=KSCR1
C
C FIND THE NEXT LOCUS TO ADD TO THE LOCUS ORDER.
C
 60     NEWLOC=APERM(LOCNEW)
        IF(BBOPT.EQ.1)GO TO 70
C
          CALL NEXLOC(BSTPRM,ENDLOC,LOCNEW,MAXHYB,MAXLOC,NEWLOC
     1    ,NHYB,NLOCUS,NOBS,PERM,REMAIN,RETAIN)
C
          CALL REMOVE(NLOCUS-LOCNEW+1,NEWLOC,NLOCUS,REMAIN)
          APERM(LOCNEW)=NEWLOC
C
 70       IF(SCROPT.GE.1)WRITE(KTERMW,103)LOCNEW,LNAME(NEWLOC),NOLDOR
 103      FORMAT(' ADDING LOCUS NUMBER',I4,' NAMED ',A4
     1    ,'.  NUMBER OF LOCUS ORDERS:',I8)
C
C FOR EACH LOCUS ORDER OF LENGTH LOCNEW-1 ...
C
        NBBEST=32767
        NNEWOR=0
C
        DO 110 IOLDOR=1,NOLDOR
          READ(KREAD,104)NXXX,(PERM(I),I=1,LOCNEW-1)
 104      FORMAT(I6,1000I3)
C
C IF THIS IS STEPWISE LOCUS ORDERING, CHECK IF NXXX IS TOO LARGE IN
C COMPARISON TO THE BEST OF ITS LOT.
C
          IF(ORDOPT.EQ.2.AND.NXXX.GT.NCUTPT)GO TO 110 
C         
C ADD THE NEXT LOCUS AT ALL POSSIBLE POSITIONS IN THE OLD ORDER.
C CALCULATE THE MINIMUM NUMBER OF OBLIGATE BREAKS FOR THE RESULTING
C LOCUS ORDER.  IF IT IS GOOD ENOUGH OR IF WE ARE DOING STEPWISE 
C LOCUS ORDERING, WRITE THE LOCUS ORDER TO THE SCRATCH FILE.  IF 
C THIS IS THE BEST ORDER OF LENGTH LOCNEW SO FAR, SAVE THE PERMUTATION
C IN BSTPRM.
C         
          PERM(LOCNEW)=NEWLOC
C
          LTOP=LOCNEW
          IF(ENDLOC.EQ.PERM(LOCNEW-1))LTOP=LOCNEW-1
          LBOT=1
          IF(ENDLOC.EQ.PERM(1))LBOT=2
          DO 100 LOC=LTOP,LBOT,-1
C
C IF THIS IS NOT THE FIRST ORDER, INTERCHANGE LOCI LOC AND LOC+1.
C
            IF(LOC.EQ.LOCNEW)GO TO 80
              ISAVE=PERM(LOC+1)
              PERM(LOC+1)=PERM(LOC)
              PERM(LOC)=ISAVE
C
C CALCULATE THE NUMBER OF BREAKS FOR THIS ORDER.  PRINT THE ORDER IS 
C DESIRED.
C
 80         NBREAK=MINBRK(MAXHYB,MAXLOC,NHYB,LOCNEW,NOBS,PERM,RETAIN)
C
            IF(SCROPT.EQ.2)WRITE(KTERMW,105)LOCNEW,NLOCUS,IOLDOR,NOLDOR
     1      ,NBREAK,(PERM(I),I=1,LOCNEW)
 105        FORMAT(2I4,2I6,I10,15I3,66(/30X,15I3))
C
C IF THE NUMBER OF BREAKS IS SUFFICIENTLY SMALL, OR WE ARE DOING
C STEPWISE LOCUS ORDERING, SAVE THE LOCUS ORDER.  ALSO, IF THIS IS
C THE BEST ORDER SO FAR, SAVE IT AND THE NUMBER OF BREAKS.
C
            IF(NBREAK.GT.NCUTPT.AND.ORDOPT.EQ.4)GO TO 100
              IF(NBREAK.GT.NBBEST+SAVMAX.AND.ORDOPT.EQ.2)GO TO 100
                WRITE(KWRITE,104)NBREAK,(PERM(I),I=1,LOCNEW)
                NNEWOR=NNEWOR+1
                IF(NBREAK.GT.NBBEST)GO TO 100
                  NBBEST=NBREAK
                  DO 90 I=1,LOCNEW
                    BSTPRM(I)=PERM(I)
 90               CONTINUE
 100      CONTINUE
 110    CONTINUE
        NOLDOR=NNEWOR
 120  CONTINUE
C
      NUMORD=NNEWOR
C
 130  CLOSE(KREAD)
C
C IF THE MACHINE GENERATED THE CANDIDATE LOCUS ORDER, PRINT IT OUT.
C
      IF(CANOPT.EQ.0.AND.ORDOPT.EQ.4)
     1WRITE(KOUT,106)(LNAME(CPERM(I)),I=1,NLOCUS)
 106  FORMAT(/' CANDIDATE LOCUS ORDER:   ',10A5,99(/26X,10A5))
C
C IF THE MACHINE GENERATED THE LOCUS ADDING ORDER, PRINT IT OUT.
C
      IF(BBOPT.EQ.0)WRITE(KOUT,107)(LNAME(APERM(I)),I=1,NLOCUS)
 107  FORMAT(' ORDER FOR ADDING LOCI:   ',10A5,99(/26X,10A5))
C
      RETURN
      END 
C
C
C
      SUBROUTINE INBND(APERM,BBOPT,CANOPT,CPERM,KIN,KOUT,LNAME,LNAMEA
     1,LNAMEC,NFORCE,NLOCUS,ORDOPT,PRTMAX,SAVMAX)
C
C READ THE ADDITIONAL INFORMATION REQUIRED FOR STEPWISE LOCUS ORDERING
C AND BRANCH AND BOUND.
C
      CHARACTER*4 LNAME(NLOCUS),LNAMEA(NLOCUS),LNAMEC(NLOCUS)
      INTEGER APERM(NLOCUS),BBOPT,CANOPT,CPERM(NLOCUS),ORDOPT
     1,PRTMAX,SAVMAX
C
C READ AND CHECK BBOPT (=1 IF USER-SPECIFIED ADDING ORDER, =0 IF
C ADDING ORDER BASED ON BEST3 AND NEXLOC), CANOPT (=1 IF USER-SPECIFIED 
C CANDIDATE ORDER, =0 IF CANDIDATE ORDER GENERATED BY CANORD), THE MAXIMUM
C OBLIGATE BREAK DIFFERENCE IN COMPARISON TO THE CURRENT BEST (PARTIAL) 
C LOCUS ORDER TO SAVE AN ORDER SAVMAX, THE MAXIMUM OBLIGATE BREAK
C DIFFERENCE FOR PRINTING AN ORDER PRTMAX, AND THE NUMBER OF LOCI TO
C BE FORCED INTO THE LOCUS ORDER IN A SPECIFIED SUBORDER.
C 
      NERR=0
      READ(KIN,101)BBOPT,CANOPT,SAVMAX,PRTMAX,NFORCE
 101  FORMAT(5I4)
C
      IF(BBOPT.EQ.0.OR.BBOPT.EQ.1)GO TO 10
        WRITE(KOUT,102)BBOPT
 102    FORMAT(' *** ERROR *** LOCUS ADDING OPTION VARIABLE BBOPT MUST'
     1  ,' BE ONE'/15X,'(USER-SPECIFIED ORDER) OR ZERO (MACHINE-'
     2  ,'GENERATED ORDER).'/15X,'IT IS',I4,'.')
        NERR=NERR+1
C
 10   IF(SAVMAX.GE.0)GO TO 20
        WRITE(KOUT,104)SAVMAX
 103    FORMAT(' *** ERROR *** THE MAXIMUM DIFFERENCE FOR SAVING THE'
     1  ,' CURRENT PARTIAL'/15X,'LOCUS ORDER SAVMAX MUST BE'
     2  ,' NON-NEGATIVE.  IT IS ',I4,'.')
        NERR=NERR+1
C
 20   IF(PRTMAX.GE.0.AND.PRTMAX.LE.SAVMAX)GO TO 25
        WRITE(KOUT,104)PRTMAX,SAVMAX
 104    FORMAT(' *** ERROR *** THE MAXIMUM DIFFERENCE FOR  PRINTING A'
     1  ,' LOCUS ORDER PRTMAX'/15X,'MUST BE NON-NEGATIVE AND SHOULD BE'
     2  ,' NO GREATER THAN THE'/15X,'MAXIMUM DIFFERENCE FOR SAVING A '
     3  ,'PARTIAL LOCUS ORDER SAVMAX.'/15X,'PRTMAX IS ',I4,'; SAVMAX IS'
     4  ,I6,'.')
        NERR=NERR+1
C
 25   IF(IABS(NFORCE).LT.NLOCUS.AND.NFORCE.NE.1.AND.NFORCE.NE.2)GO TO 30
        WRITE(KOUT,202)NFORCE,NLOCUS
 202    FORMAT(/' *** ERROR *** THE NUMBER OF LOCI TO BE FORCED IN',I4
     1  ,' MUST BE ZERO, -1'/15X,'(FORCED ENDPOINT), OR (IN ABSOLUTE'
     2  ,' VALUE) BETWEEN 3 AND'/15X,'ONE LESS THAN THE NUMBER OF LOCI'
     3  ,' IN THE PROBLEM.'/15X,'NEGATIVE NUMBERS HERE IMPLY THE FIRST'
     4  ,' FORCED LOCUS MUST'/15X,'BE AT THE END OF THE MAP.')
        NERR=NERR+1
C
 30   IF(CANOPT.EQ.0.OR.CANOPT.EQ.1)GO TO 40
        WRITE(KOUT,105)CANOPT
 105    FORMAT(' *** ERROR *** CANDIDATE ORDER OPTION CANOPT MUST'
     1  ,' BE ONE'/15X,'(USER-SPECIFIED ORDER) OR ZERO (MACHINE-'
     2  ,'GENERATED ORDER).'/15X,'IT IS',I4,'.')
        NERR=NERR+1
        GO TO 60
C
C IF CANOPT=1 AND ORDOPT=4, READ THE CANDIDATE LOCUS ORDER.  CHECK
C AND TRANSLATE THE LOCUS NAMES TO A PERMUTATION.
C
 40   IF(CANOPT.EQ.0.OR.ORDOPT.EQ.2)GO TO 50
        READ(KIN,106)(LNAMEC(I),I=1,NLOCUS)
 106    FORMAT(20A4)
        CALL NAMIND(KOUT,LNAMEC,LNAME,NERR,NLOCUS,NLOCUS,CPERM)
C
C IF BBOPT=1 OR NFORCE NE 0, READ THE LOCUS ADDING ORDER.  CHECK AND
C TRANSLATE THE LOCUS NAMES TO A PERMUTATION.  
C
 50   IF(BBOPT.EQ.0.AND.NFORCE.EQ.0)GO TO 60
        LTOP=NLOCUS
        IF(BBOPT.EQ.0)LTOP=IABS(NFORCE)
        READ(KIN,106)(LNAMEA(I),I=1,LTOP)
        CALL NAMIND(KOUT,LNAMEA,LNAME,NERR,NLOCUS,LTOP,APERM)
C
C IF THERE IS A FORCED END LOCUS (NFORCE<0) AND A CANDIDATE ORDER,
C CHECK THAT THE CANDIDATE ORDER HAS THE FORCED END LOCUS AT AN END. 
C
        IF(CANOPT.EQ.0.OR.NFORCE.EQ.0)GO TO 60
          IF(NFORCE.GE.0)GO TO 55
            IF(APERM(1).EQ.CPERM(1).OR.APERM(1).EQ.CPERM(NLOCUS))
     1      GO TO 55
            WRITE(KOUT,116)
 116        FORMAT(' *** ERROR *** THE CANDIDATE LOCUS ORDER DOES NOT'
     1      ,' HAVE THE FORCED END'/15X,'LOCUS AT THE END OF THE MAP.')
            NERR=NERR+1
C
C IF THERE IS A FORCED SUBORDER (NFORCE>2) AND A CANDIDATE ORDER, CHECK
C THAT THEY ARE COMPATIBLE.  NOTE:  TRY BOTH ORIENTATIONS.
C
 55       IF(IABS(NFORCE).LE.1)GO TO 60
            LOCUSA=1
            DO 56 LOCUSC=1,NLOCUS
              IF(CPERM(LOCUSC).NE.APERM(LOCUSA))GO TO 56
                LOCUSA=LOCUSA+1
                IF(LOCUSA.GT.LTOP)GO TO 60
 56         CONTINUE
C
            LOCUSA=1
            DO 57 LOCUSC=NLOCUS,1,-1
              IF(CPERM(LOCUSC).NE.APERM(LOCUSA))GO TO 57
                LOCUSA=LOCUSA+1
                IF(LOCUSA.GT.LTOP)GO TO 60
 57         CONTINUE
C
            WRITE(KOUT,117)
 117        FORMAT(' *** ERROR *** THE CANDIDATE LOCUS ORDER AND THE'
     1      ,' FORCED SUBORDER ARE'/15X,'NOT CONSISTENT.')
            NERR=NERR+1
C
C IF ERRORS HAVE BEEN DETECTED, STOP.
C
 60   IF(NERR.GT.0)STOP
C
C ECHO THE ADDITIONAL CONTROL INFORMATION FOR STEPWISE LOCUS ORDERING
C AND BRANCH AND BOUND.
C
      IF(ORDOPT.EQ.2)WRITE(KOUT,107)
 107  FORMAT(//' STEPWISE LOCUS ORDERING OPTIONS')
      IF(ORDOPT.EQ.4)WRITE(KOUT,108)
 108  FORMAT(//' BRANCH AND BOUND ORDERING OPTIONS')
C
      WRITE(KOUT,109)SAVMAX,PRTMAX
 109  FORMAT(/' MAXIMUM BREAK DIFFERENCE TO SAVE ORDER: ',I3
     1       /' MAXIMUM BREAK DIFFERENCE TO PRINT ORDER:',I3)
C
      IF(BBOPT.EQ.0)WRITE(KOUT,111)
 111  FORMAT(' ADDING ORDER:             MACHINE-GENERATED')
      IF(BBOPT.EQ.1)WRITE(KOUT,112)(LNAMEA(I),I=1,NLOCUS)
 112  FORMAT(/' ORDER FOR ADDING LOCI:  ',10A5,99(/25X,10A5))
C
      IF(CANOPT.EQ.0)WRITE(KOUT,113)
 113  FORMAT(' CANDIDATE ORDER:          MACHINE-GENERATED')
      IF(CANOPT.EQ.1.AND.ORDOPT.EQ.4)
     1WRITE(KOUT,114)(LNAMEC(I),I=1,NLOCUS)
 114  FORMAT(' CANDIDATE LOCUS ORDER:  ',10A5,99(/25X,10A5))
C
      IF(NFORCE.NE.0)WRITE(KOUT,115)(LNAMEA(I),I=1,IABS(NFORCE))
 115  FORMAT(' ORDER FOR FORCED LOCI:  ',10A5,99(/25X,10A5))
      IF(NFORCE.LT.0)WRITE(KOUT,118)LNAMEA(1)
 118  FORMAT(' FIRST LOCUS ',A4,' IN THIS ORDER IS FORCED TO'
     1,' BE AT AN END OF THE MAP.')
C
      RETURN
      END
C
C
C
      SUBROUTINE BEST3(ENDLOC,MAXHYB,MAXLOC,NHYB,NLOCUS,NOBS,PERM
     1,RETAIN)
C
C FIND THE THREE MOST CLEARLY ORDERED LOCI IN THE SENSE THAT THE
C DIFFERENCE IN NUMBER OF OBLIGATE BREAKS FOR THE BEST AND SECOND
C BEST ORDERS IS GREATEST.  
C
      INTEGER ENDLOC,FPERM(3),INDEX(3),NBRK3(3),NOBS(MAXHYB)
     1,PERM(MAXLOC),RETAIN(MAXHYB,MAXLOC)
C
      MAXDFF=0
      NLOC1=NLOCUS-1
      NLOC2=NLOCUS-2
C
C FOR EACH DISTINCT TRIO OF LOCI ...
C
      DO 40 LOCUS1=1,NLOC2
        DO 30 LOCUS2=LOCUS1+1,NLOC1
          DO 20 LOCUS3=LOCUS2+1,NLOCUS
C
C CONSIDER EACH PERMUTATION OF THESE LOCI SATISFYING PERM(3) < PERM(1).
C 
            PERM(1)=LOCUS1
            PERM(2)=LOCUS2
            PERM(3)=LOCUS3
C
C INDEX=(1,2,3),(1,3,2),(2,1,3) AS IPERM=1,2,3.
C 
            DO 10 IPERM=1,3
              NBRK3(IPERM)=20000
              INDEX(1)=IPERM/3+1    
              INDEX(2)=IPERM*(11-3*IPERM)/2-2
              INDEX(3)=(IPERM-2)**2+2
              IF(ENDLOC.EQ.PERM(INDEX(2)))GO TO 10
C
C CALCULATE THE MINIMUM NUMBER OF OBLIGATE BREAKS FOR THIS PERMUTATION.
C
              FPERM(1)=PERM(INDEX(1))
              FPERM(2)=PERM(INDEX(2))
              FPERM(3)=PERM(INDEX(3))
              NBRK3(IPERM)=
     1          MINBRK(MAXHYB,MAXLOC,NHYB,3,NOBS,FPERM,RETAIN)
 10         CONTINUE
C
C FIND THE TWO SMALLEST OF THE THREE MINIMUM OBLIGATE BREAKS.  CALCULATE
C THEIR DIFFERENCE.
C
            NBMAX=MAX0(NBRK3(1),NBRK3(2),NBRK3(3))
            NBMIN=MIN0(NBRK3(1),NBRK3(2),NBRK3(3))
            NBMID=NBRK3(1)+NBRK3(2)+NBRK3(3)-NBMAX-NBMIN
            NDIFF=NBMID-NBMIN
C
C IS THIS TRIO BETTER THAN THE CURRENT BEST?
C
            IF(NDIFF.LE.MAXDFF)GO TO 20
              MAXDFF=NDIFF
              LOC1=LOCUS1
              LOC2=LOCUS2
              LOC3=LOCUS3
 20       CONTINUE
 30     CONTINUE
 40   CONTINUE
C
      PERM(1)=LOC1
      PERM(2)=LOC2
      PERM(3)=LOC3 
C
      RETURN
      END  
C
C
C
      SUBROUTINE START3(BSTPRM,CANBRK,ENDLOC,KSCR1,KSCR2,MAXHYB,MAXLOC
     1,NBBEST,NHYB,NOBS,NOLDOR,ORDOPT,PERM,RETAIN,SAVMAX)
C
C PUT THE CANDIDATE THREE-LOCUS ORDERS IN THE SCRATCH FILE.  NOTE
C WHICH THREE-LOCUS ORDER IS BEST.
C
      INTEGER BSTPRM(MAXLOC),CANBRK,ENDLOC,FPERM(3),INDEX(3)
     1,NOBS(MAXHYB),ORDOPT,PERM(MAXLOC),RETAIN(MAXHYB,MAXLOC),SAVMAX
C
C CALCULATE THE MINIMUM NUMBER OF OBLIGATE BREAKS FOR EACH LOCUS ORDER
C SUCH THAT PERM(1) > PERM(3).  SAVE THE ORDERS AND THEIR MINIMUM 
C NUMBER OF OBLIGATE BREAKS IN THE SECOND SCRATCH UNIT.  ALSO FIND
C THE BEST PERMUTATION.  INDEX=(1,2,3),(1,3,2),(2,1,3) AS IPERM=1,2,3.
C 
      NBBEST=32767
      NPERM=0
      DO 30 IPERM=1,3
        INDEX(1)=IPERM/3+1    
        INDEX(2)=IPERM*(11-3*IPERM)/2-2
        INDEX(3)=(IPERM-2)**2+2
C
        IF(ENDLOC.EQ.PERM(INDEX(2)))GO TO 30
        NPERM=NPERM+1
        FPERM(1)=PERM(INDEX(1))
        FPERM(2)=PERM(INDEX(2))
        FPERM(3)=PERM(INDEX(3))
C
        NBREAK=MINBRK(MAXHYB,MAXLOC,NHYB,3,NOBS,FPERM,RETAIN)
C        NBREAK=MINBRK(MAXHYB,MAXLOC,NHYB,3,NOBS,FPERM,RETAIN)
        IF(NBREAK.GE.NBBEST)GO TO 20
          NBBEST=NBREAK
          DO 10 I=1,3
            BSTPRM(I)=FPERM(I)
 10       CONTINUE
 20     WRITE(KSCR2,101)NBREAK,(FPERM(I),I=1,3)
 101    FORMAT(I6,3I3)
 30   CONTINUE
C
C SAVE THE LOCUS ORDERS THAT ARE GOOD ENOUGH IN THE FIRST
C SCRATCH UNIT.  
C
      NCUTPT=CANBRK+SAVMAX
      IF(ORDOPT.EQ.2)NCUTPT=NBBEST+SAVMAX
      REWIND(KSCR2)
C
C NOLDOR IS THE NUMBER OF ORDERS SAVED THAT WILL BE EXTENDED.
C
      NOLDOR=0
      DO 40 IORD=1,NPERM
        READ(KSCR2,101)NBREAK,(PERM(I),I=1,3)
        IF(NBREAK.GT.NCUTPT)GO TO 40
          WRITE(KSCR1,101)NBREAK,(PERM(I),I=1,3)
          NOLDOR=NOLDOR+1
 40   CONTINUE
      ENDFILE(KSCR1)
C
      RETURN
      END
C
C
C
      SUBROUTINE NEXLOC(BSTPRM,ENDLOC,LOCNEW,MAXHYB,MAXLOC,NEWLOC,NHYB
     1,NLOCUS,NOBS,PERM,REMAIN,RETAIN)
C
C DETERMINE WHICH UNPLACED LOCUS IS MOST CLEARLY PLACED IN THE
C CURRENT BEST PARTIAL LOCUS ORDER.
C
      INTEGER BSTPRM(MAXLOC),ENDLOC,NOBS(MAXHYB),PERM(MAXLOC)
     1,REMAIN(MAXLOC),RETAIN(MAXHYB,MAXLOC)
C 
C FOR EACH POSSIBLE LOCUS TO BE ADDED ...
C
      NL1=NLOCUS+1-LOCNEW
      LOCN1=LOCNEW-1
      NDMAX=32767 
      DO 40 L=1,NL1
        LOCADD=REMAIN(L)
C
C ADD THE LOCUS TO THE END OF BSTPRM.  EVALUATE THE RESULTING ORDER.
C
        DO 10 I=1,LOCN1
          PERM(I)=BSTPRM(I)
 10     CONTINUE
        PERM(LOCNEW)=LOCADD
C
        NBRK2=32767
        IF(ENDLOC.NE.PERM(LOCN1))
     1    NBRK1=MINBRK(MAXHYB,MAXLOC,NHYB,LOCNEW,NOBS,PERM,RETAIN)
C
C FOR ALL OTHER POSSIBLE LOCATIONS, EVALUATE THE RESULTING ORDER.
C
 15     LBOT=2
        IF(ENDLOC.EQ.PERM(1))LBOT=3
        DO 30 LOC=LOCNEW,LBOT,-1
          ISAVE=PERM(LOC)
          PERM(LOC)=PERM(LOC-1)
          PERM(LOC-1)=ISAVE
          NEWBRK=MINBRK(MAXHYB,MAXLOC,NHYB,LOCNEW,NOBS,PERM,RETAIN) 
          IF(NEWBRK.GT.NBRK2)GO TO 30
            IF(NEWBRK.GT.NBRK1)GO TO 20
              NBRK2=NBRK1
              NBRK1=NEWBRK
              GO TO 30
 20         NBRK2=NEWBRK
 30     CONTINUE
        NDIFF=NBRK1-NBRK2
        IF(NDIFF.GT.NDMAX)GO TO 40
          NDMAX=NDIFF
          NEWLOC=LOCADD  
 40   CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE CANORD(CANBRK,CPERM,KTERMW,MAXHYB,MAXLOC,NHYB,NLOCUS
     1,NOBS,PERM,RETAIN,SCROPT,USE)
C
C USE A GREEDY ALGORITHM TO DETERMINE A CANDIDATE LOCUS ORDER.
C
      INTEGER BBEST,CANBRK,CPERM(NLOCUS),DBEST,NOBS(MAXHYB),PBEST
     1,PERM(MAXLOC),RETAIN(MAXHYB,MAXLOC),SCROPT,SUMBR,UPDATE
     2,USE(MAXLOC)
C
C FOR ALL POSSIBLE LOCUS PAIRS ...
C
      CANBRK=32767
      NLOC1=NLOCUS-1
      DO 70 LOCUS1=1,NLOC1
        IF(SCROPT.EQ.2)WRITE(KTERMW,101)' CANDIDATE ORDER DETERMINATION'
     1  ,' STARTING LOCUS:  ',LOCUS1,' MINBRK= ',CANBRK
 101    FORMAT(2A,I4,A,I4)
        DO 60 LOCUS2=LOCUS1+1,NLOCUS
C
          PERM(1)=LOCUS1
          PERM(2)=LOCUS2
          NBREAK=UPDATE(2,2,MAXHYB,MAXLOC,NHYB,LOCUS2,NOBS,PERM,RETAIN)
C
          DO 10 LOCUS=1,NLOCUS
            USE(LOCUS)=0
 10       CONTINUE
          USE(LOCUS1)=1
          USE(LOCUS2)=1
C
C START WITH THAT PAIR, AND ADD LOCI UNTIL ALL ARE INCLUDED
C IN THE PERMUTATION.
C
          DO 50 LOCUS=3,NLOCUS
C
C DETERMINE WHICH LOCUS TO ADD TO THE PERMUTATION.
C
            DBEST=-1
            DO 30 NEXT=1,NLOCUS
              IF(USE(NEXT).EQ.1)GO TO 30
C
C FOR EACH POSSIBLE POSITION FOR THE POSSIBLE NEXT LOCUS, CALCULATE
C THE INCREASE IN THE NUMBER OF OBLIGATE BREAKS ASSOCIATED WITH
C ITS ADDITION.  NBEST IS THE FEWEST ADDITIONAL BREAKS, LPOS THE
C POSITION FOR THE POSSIBLE NEXT LOCUS THAT ACHIEVES IT.
C
              NBEST=32767
              SUMBR=0
              DO 20 IPOS=1,LOCUS
                NEWBR=UPDATE(IPOS,LOCUS,MAXHYB,MAXLOC,NHYB,NEXT
     1                       ,NOBS,PERM,RETAIN)
                SUMBR=SUMBR+NEWBR
                IF(NEWBR.GE.NBEST)GO TO 20
                  NBEST=NEWBR
                  LPOS=IPOS
 20           CONTINUE
C
C SAVE THE BEST PLACE TO ADD THE CURRENT LOCUS AND THE
C ADVANTAGE OF DOING IT THERE OVER ALL OTHER POSITIONS.
C LBEST IS THE BEST LOCUS TO ADD NEXT.  PBEST IS THE
C POSITION TO ADD IT.
C
              DBREAK=SUMBR-NBEST
              IF(DBREAK.LE.DBEST)GO TO 30
                LBEST=NEXT
                DBEST=DBREAK
                PBEST=LPOS
                BBEST=NBEST
 30         CONTINUE
C
C ADD THE BEST LOCUS IN THE IDENTIFIED LOCATION AND UPDATE
C THE NUMBER OF OBLIGATE BREAKS.
C
            USE(LBEST)=1
            NBREAK=NBREAK+BBEST
            DO 40 IPERM=LOCUS,PBEST+1,-1
              PERM(IPERM)=PERM(IPERM-1)
 40         CONTINUE
            PERM(PBEST)=LBEST
 50       CONTINUE
C
          IF(NBREAK.GE.CANBRK)GO TO 60
            CANBRK=NBREAK
            DO 55 I=1,NLOCUS
              CPERM(I)=PERM(I)
 55         CONTINUE
C
 60     CONTINUE
 70   CONTINUE
C
      RETURN
      END
C
C
C
      FUNCTION UPDATE(IPOS,LOCUS,MAXHYB,MAXLOC,NHYB,NEXT,NOBS
     1,PERM,RETAIN)
C
      INTEGER FTYPE,NOBS(MAXHYB),PERM(MAXLOC),RETAIN(MAXHYB,MAXLOC)
     1,UPDATE
C
      UPDATE=0
C
C FOR EACH CLASS OF RADIATION HYBRID ...
C
      DO 50 IHYB=1,NHYB
        IRN=RETAIN(IHYB,NEXT)
        IF(IRN.EQ.2)GO TO 50
C
C FIND THE TYPE OF THE LEADING FRAGMENT AND UPDATE THE
C NUMBER OBLIGATE BREAKS.
C
        LTYPE=2
        IF(IPOS.EQ.1)GO TO 20
        DO 10 I=IPOS-1,1,-1
          IF(RETAIN(IHYB,PERM(I)).EQ.2)GO TO 10
          LTYPE=RETAIN(IHYB,PERM(I))
          GO TO 20
 10     CONTINUE
C
C FIND THE TYPE OF THE FOLLOWING FRAGMENT AND UPDATE THE
C NUMBER OBLIGATE BREAKS.
C
 20     FTYPE=2
        IF(IPOS.EQ.LOCUS)GO TO 40
        DO 30 I=IPOS,LOCUS-1
          IF(RETAIN(IHYB,PERM(I)).EQ.2)GO TO 30
          FTYPE=RETAIN(IHYB,PERM(I))
          GO TO 40
 30     CONTINUE
C
 40     IF(LTYPE*FTYPE.EQ.4)GO TO 50
        IF(LTYPE.EQ.2.AND.FTYPE.NE.IRN)UPDATE=UPDATE+NOBS(IHYB)
        IF(FTYPE.EQ.2.AND.LTYPE.NE.IRN)UPDATE=UPDATE+NOBS(IHYB)
        IF(LTYPE.EQ.FTYPE.AND.LTYPE.NE.IRN)UPDATE=UPDATE+2*NOBS(IHYB)
 50   CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE REMOVE(LENGTH,LOCUS,NLOCUS,REMAIN)
C
C REMOVE LOCUS FROM REMAIN.
C
      INTEGER REMAIN(NLOCUS)
C
      DO 10 I=1,LENGTH
        IF(REMAIN(I).EQ.LOCUS)GO TO 20
 10   CONTINUE
C
 20   DO 30 J=I+1,LENGTH
        REMAIN(J-1)=REMAIN(J)
 30   CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE ANNEAL(BPERM,KIN,KOUT,KTERMW,LNAME,LNAMEA,MAXHYB,MAXLOC
     1,MAXORD,NBBEST,NBREAK,NHYB,NLOCUS,NOBS,NUMORD,PERM,PRTMAX,RETAIN
     2,SCROPT)
C
C USE SIMULATED ANNEALING TO ARRIVE AT A LIST OF BEST LOCUS ORDERS.
C
      CHARACTER*4 LNAME(MAXLOC),LNAMEA(MAXLOC)
      INTEGER BPERM(MAXORD,MAXLOC),FINISH,NBREAK(MAXORD),NOBS(MAXHYB)
     1,PERM(MAXLOC),PRTMAX,RETAIN(MAXHYB,MAXLOC),SAOPT,SCROPT,START
      REAL*8 FACTOR,RANDOM,T,TMAX,TOTORD
C
C READ THE ADDITIONAL INFORMATION REQUIRED FOR SIMULATED ANNEALING.
C
      CALL INSA(FACTOR,ISEED1,ISEED2,ISEED3,KIN,KOUT,LNAME,LNAMEA
     1,MAXORD,NBET,NLOCUS,NMOVE,NTEMP,NUMORD,PERM,PRTMAX,SAOPT,TMAX)
C
C COMPUTE THE MINIMUM THE NUMBER OF OBLIGATE BREAKS FOR THE INITIAL
C ORDER.  
C
      MINB1=MINBRK(MAXHYB,MAXLOC,NHYB,NLOCUS,NOBS,PERM,RETAIN)
      IF(SCROPT.GE.1)WRITE(KTERMW,101)MINB1
 101  FORMAT(' INITIAL ORDER NUMBER OF OBLIGATE BREAKS:',I6)
      TOTORD=1.D0
C
C FILL IN THE BEST ORDERS AND BEST NUMBER OF OBLIGATE BREAKS WITH LOTS
C OF COPIES OF -1 TO -NLOCUS WITH BIG NUMBER OF OBLIGATE BREAKS.  PUT ONE
C COPY OF THE CANDIDATE IN THE LIST.
C
      DO 10 J=1,NLOCUS
        BPERM(1,J)=PERM(J)
 10   CONTINUE
      NBREAK(1)=MINB1
      NFWORS=32767
      IWORST=2
C
      IF(NUMORD.EQ.1)GO TO 40
        DO 30 I=2,NUMORD
          DO 20 J=1,NLOCUS
            BPERM(I,J)=-J
 20       CONTINUE
          NBREAK(I)=32767
 30     CONTINUE
C
C CARRY OUT SIMULATED ANNEALING AS SPECIFIED BY THE INPUT PARAMETERS.
C FOR EACH TEMPERATURE ...
C
 40   T=TMAX
      DO 110 JTEMP=1,NTEMP
C
C FOR EACH MOVE AT THAT TEMPERATURE ...
C
        NSUCC=0
        DO 90 KMOVE=1,NMOVE
C
C CHOOSE THE SET OF LOCI (FROM START TO FINISH) TO INVERT.  IF
C START=FINISH, TRY AGAIN.
C
 50       START=1+INT(NLOCUS*RANDOM(ISEED1,ISEED2,ISEED3))
          FINISH=1+INT(NLOCUS*RANDOM(ISEED1,ISEED2,ISEED3))
          IF(FINISH-START)60,50,70
 60       ITEMP=FINISH
          FINISH=START
          START=ITEMP
C
C REVERSE THE PATH BEGINNING IN POSITION START AND ENDING IN POSITION
C FINISH.  RECALCULATE THE MINIMUM NUMBER OF OBLIGATE BREAKS.
C
 70       CALL REVERS(FINISH,NLOCUS,PERM,START)
          MINB2=MINBRK(MAXHYB,MAXLOC,NHYB,NLOCUS,NOBS,PERM,RETAIN)
          TOTORD=TOTORD+1.D0
C
C IF THE NEW ORDER HAS LOWER OR EQUAL MIMIMUM NUMBER OF OBLIGATE BREAKS,
C WE MOVE FOR SURE.  IF NOT, WE MOVE WITH METROPOLIS PROBABILITY.
C
          NDELTA=MINB2-MINB1
          IF(NDELTA.LE.0)GO TO 80
            IF(RANDOM(ISEED1,ISEED2,ISEED3).LT.DEXP(-DBLE(NDELTA)/T))
     1      GO TO 80
              CALL REVERS(FINISH,NLOCUS,PERM,START)
              GO TO 90
C
C IF WE MOVE, UPDATE THE NUMBER OF SUCCESSFUL STEPS AND THE LIST OF 
C BEST CURRENT ORDERS (IF APPROPRIATE).  IF THERE HAVE BEEN ENOUGH
C ACCEPTED STEPS, WE MAY GO TO THE NEXT TEMPERATURE.
C
 80             MINB1=MINB2
                NSUCC=NSUCC+1
                IF(MINB1.LT.NFWORS)CALL UPLIST(BPERM,MINB1,NBREAK,NFWORS
     1          ,IWORST,MAXLOC,MAXORD,NUMORD,NLOCUS,PERM)
                IF(NSUCC.GE.NBET)GO TO 100
 90     CONTINUE
 100    IF(SCROPT.GE.1)WRITE(KTERMW,102)' TEMPERATURE',JTEMP,' OF'
     1  ,NTEMP,', CURRENT NUMBER OF OBLIGATE BREAKS:',MINB1
 102    FORMAT(3(A,I6))
        T=T*FACTOR
 110  CONTINUE
C
      WRITE(KTERMW,103)TOTORD
 103  FORMAT(' TOTAL NUMBER OF ORDERS EVALUATED:',F12.0)
C
C FIND THE MINIMUM NUMBER OF BREAKS ENCOUNTERED.
C
      NBBEST=32767
      DO 120 I=1,NUMORD
        IF(NBREAK(I).LT.NBBEST)NBBEST=NBREAK(I)
 120  CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE INSA(FACTOR,ISEED1,ISEED2,ISEED3,KIN,KOUT,LNAME,LNAMEA
     1,MAXORD,NBET,NLOCUS,NMOVE,NTEMP,NUMORD,PERM,PRTMAX,SAOPT,TMAX)
C
C READ THE ADDITIONAL INFORMATION REQUIRED FOR SIMULATED ANNEALING.
C
      CHARACTER*3 CRAN
      CHARACTER*4 LNAME(NLOCUS),LNAMEA(NLOCUS)
      INTEGER PERM(NLOCUS),PRTMAX,SAOPT
      REAL*8 FACTOR,TMAX
C
C READ AND CHECK SAOPT (=1 IF USER-SPECIFIED INITIAL PERMUTAION,
C =0 IF RANDOM PERMUTATION), THE NUMBER OF BEST ORDERS TO SAVE, AND
C THE SEEDS FOR THE RANDOM NUMBER GENERATOR, AND THE MAXIMUM
C DIFFERENCE TO PRINT A LOCUS ORDER.
C
      NERR=0
      READ(KIN,101)SAOPT,NUMORD,ISEED1,ISEED2,ISEED3,PRTMAX
 101  FORMAT(6I8)
C
      IF(SAOPT.EQ.0.OR.SAOPT.EQ.1)GO TO 10
        WRITE(KOUT,102)SAOPT
 102    FORMAT(/' *** ERROR *** THE INITIAL PERMUTATION OPTION FOR'
     1  ,' SIMULATED ANNEALING'/15X,'MUST EQUAL ZERO (RANDOM) OR ONE'
     2  ,' (USER-SPECIFIED).'/15X,'IT IS ',I8,'.')
        NERR=NERR+1
C
 10   IF(NUMORD.GT.0.AND.NUMORD.LE.MAXORD)GO TO 20
        WRITE(KOUT,103)MAXORD,NUMORD
 103    FORMAT(/' *** ERROR *** THE NUMBER OF BEST ORDERS TO SAVE'
     1  ,' MUST BE GREATER THAN ZERO'/15X,'AND NO GREATER THAN ',I8
     2  ,'.  IT IS',I8,'.')
        NERR=NERR+1
C
 20   IF(ISEED1.GT.0.AND.ISEED1.LT.32767.AND
     1  .ISEED2.GT.0.AND.ISEED2.LT.32767.AND
     2  .ISEED3.GT.0.AND.ISEED3.LT.32767)GO TO 30
C
        WRITE(KOUT,104)ISEED1,ISEED2,ISEED3
 104    FORMAT(/' *** ERROR *** THE SEEDS FOR THE RANDOM NUMBER'
     1  ,' GENERATOR MUST BE BETWEEN'/15X,'1 AND 32767.  THEY ARE:  '
     2  ,I8,', ',I8,', AND',I8,'.')
        NERR=NERR+1
C
 30     IF(PRTMAX.GE.0)GO TO 40
          WRITE(KOUT,105)PRTMAX
 105      FORMAT(/' *** ERROR *** THE MINIMUM DIFFERENCE FROM THE BEST'
     1    ,' LOCUS ORDER TO'/15X,'PRINT A LOCUS ORDER MUST BE'
     2    ,' NON-NEGATIVE.  IT IS ',I8,'.')
          NERR=NERR+1
C
C READ AND CHECK THE PARAMETERS FOR SIMULATED ANNEALING:  NTEMP IS THE
C NUMBER OF DIFFERENT TEMPERATURES CONSIDERED, NBET IS THE NUMBER OF MOVES
C TO A BETTER STATE REQUIRED TO GO TO THE NEXT TEMPERATURE, NMOVE IS THE
C MAXIMUM NUMBER OF MOVES BEFORE GOING TO THE NEXT TEMPERATURE, TMAX IS
C THE INITIAL TEMPERATURE, AND FACTOR IS THE FACTOR BY WHICH THE
C TEMPERATURE IS DECREASED.
C
 40   READ(KIN,106)NTEMP,NBET,NMOVE,TMAX,FACTOR
 106  FORMAT(3I8,2F8.5)
C
      IF(NTEMP.GT.0)GO TO 50
        WRITE(KOUT,107)NTEMP
 107    FORMAT(/' *** ERROR *** THE NUMBER OF DIFFERENT TEMPERATURES'
     1  ,' FOR SIMULATED'/15X,'ANNEALING IS REPORTED TO BE ',I8
     2  ,'.  IT MUST BE POSITIVE.')
        NERR=NERR+1
C
 50   IF(NBET.GT.0.AND.NBET.LE.NMOVE)GO TO 60
        WRITE(KOUT,108)NBET,NMOVE
 108    FORMAT(/' *** ERROR *** THE NUMBER OF STEPS TO A BETTER ORDER'
     1  ,' REQUIRED BEFORE'/15X,'CHANGING TEMPERATURES FOR SIMULATED '
     2  ,'ANNEALING IS REPORTED'/15X,'TO BE ',I8,'.  IT MUST BE '
     3  ,'POSITIVE AND SHOULD BE NO MORE'/15X,'THAN THE MAXIMUM NUMBER'
     4  ,' OF STEPS BEFORE CHANGING'/15X,'TEMPERATURES ',I8,'.')
        NERR=NERR+1
C
 60   IF(NMOVE.GT.0)GO TO 70
        WRITE(KOUT,109)NMOVE
 109    FORMAT(/' *** ERROR *** THE MAXIMUM NUMBER OF STEPS BEFORE'
     1  ,' CHANGING TEMPERATURES'/15X,'FOR SIMULATED ANNEALING IS'
     2  ,' REPORTED TO BE',I8,'.'/15X,'IT MUST BE POSITIVE.')
        NERR=NERR+1
C
 70   IF(TMAX.GT.1.D-4)GO TO 80
        WRITE(KOUT,111)TMAX
 111    FORMAT(/' *** ERROR *** THE INITIAL TEMPERATURE FOR SIMULATED'
     1  ,' ANNEALING IS '/15X,'REPORTED TO BE ',F15.3
     2  ,'.  IT MUST BE POSITIVE.')
        NERR=NERR+1
C
 80   IF(FACTOR.LT.0.99999D0.AND.FACTOR.GT.0.D0)GO TO 90
        WRITE(KOUT,112)FACTOR
 112    FORMAT(' *** ERROR *** THE FACTOR FOR DECREASING THE SIMULATE'
     1  ,' ANNEALING'/15X,'TEMPERATURE IS REPORTED TO BE ',F12.8
     2  ,' BUT SHOULD'/15X,'BE GREATER THAN ZERO AND NOT TOO CLOSE'
     3  ,' TO ONE.')
        NERR=NERR+1
C
C OUTPUT THE SIMULATED ANNEALING OPTIONS EXCEPT FOR THE INITIAL ORDER.
C
 90   CRAN=' NO'
      IF(SAOPT.EQ.0)CRAN='YES'
      WRITE(KOUT,113)TMAX,NTEMP,NMOVE,NBET,FACTOR,CRAN
     1,ISEED1,ISEED2,ISEED3
 113  FORMAT(//' SIMULATED ANNEALING OPTIONS'
     1       //' INITIAL TEMPERATURE:                  ',F12.5
     2        /' NUMBER OF DIFFERENT TEMPERATURES:         ',I8
     3        /' MAXIMUM STEPS AT A TEMPERATURE:           ',I8
     4        /' NO. OF BETTER ORDERS TO CHANGE TEMP:      ',I8
     5        /' TEMPERATURE REDUCTION FACTOR:             ',F8.5
     6        /' RANDOM INITIAL LOCUS ORDER?:                   ',A3
     7        /' SEEDS FOR RANDOM NUMBER GENERATOR:        ',3I8)
C
C IF SAOPT=1, READ THE INITIAL PERMUTATION.  CHECK AND TRANSLATE THE
C LOCUS NAMES TO A PERMUTATION.  IF SAOPT=0, GENERATE A RANDOM
C PERMUTATION OF THE LOCI.
C
      IF(SAOPT.EQ.0)GO TO 100
        READ(KIN,114)(LNAMEA(I),I=1,NLOCUS)
 114    FORMAT(20A4)
        CALL NAMIND(KOUT,LNAMEA,LNAME,NERR,NLOCUS,NLOCUS,PERM)
        GO TO 110
C
 100  CALL RANPER(NLOCUS,PERM,ISEED1,ISEED2,ISEED3)
C
C PRINT THE INITIAL LOCUS ORDER.
C
 110  WRITE(KOUT,115)(LNAME(PERM(I)),I=1,NLOCUS)
 115  FORMAT(/' INITIAL LOCUS ORDER:  ',10A5,99(/23X,10A5))
C
C IF ERRORS HAVE BEEN DETECTED, STOP.
C
      IF(NERR.GT.0)STOP
C
      RETURN
      END
C
C
C
      SUBROUTINE RANPER(N,A,ISEED1,ISEED2,ISEED3)
C
C DETERMINE A RANDOM PERMUTATION OF THE N ELEMENTS OF THE ARRAY A.
C
C REFERENCE:  NIJENHUIS A, WILF HS (1978) COMBINATORIAL ALGORITHMS 
C FOR COMPUTERS AND CALCULATORS, 2ND ED.  ACADEMIC PRESS, ORLANDO,
C FLORIDA, PP. 62-64.
C
      INTEGER A(N)
      REAL*8 RANDOM
C
      DO 10 I=1,N
        A(I)=I
 10   CONTINUE
C
      DO 20 M=1,N
        L=M+RANDOM(ISEED1,ISEED2,ISEED3)*(N+1-M)
        L1=A(L)
        A(L)=A(M)
        A(M)=L1
 20   CONTINUE
C
      RETURN
      END
C
C
C
      FUNCTION RANDOM(ISEED1,ISEED2,ISEED3)
C
C GENERATE A U(0,1) RANDOM NUMBER.
C
C REFERENCE:  WICHMAN BA, HILL ID (1982) AN EFFICIENT AND PORTABLE
C PSEUDO-RANDOM NUMBER GENERATOR.  APPLIED STATISTICS 31:188-192.
C
      REAL*8 RANDOM
C
      ISEED1=171*MOD(ISEED1,177)- 2*(ISEED1/177)
      ISEED2=172*MOD(ISEED2,176)-35*(ISEED2/176)
      ISEED3=170*MOD(ISEED3,178)-63*(ISEED3/178)
C
      IF(ISEED1.LT.0)ISEED1=ISEED1+30269
      IF(ISEED2.LT.0)ISEED2=ISEED2+30307
      IF(ISEED3.LT.0)ISEED3=ISEED3+30323
C
      RANDOM=DBLE(ISEED1)/30269.0D0
     1      +DBLE(ISEED2)/30307.0D0
     2	    +DBLE(ISEED3)/30323.0D0
      RANDOM=DMOD(RANDOM,1.D0)
C
      RETURN
      END
C
C
C
      SUBROUTINE REVERS(FINISH,NLOCUS,PERM,START)
C
C PERFORM A PATH REVERSAL OF LOCI START TO FINISH.
C
      INTEGER FINISH,PERM(NLOCUS),START
C
      MAX=(FINISH-START)/2
      DO 10 I=0,MAX
        J=PERM(START+I)
        PERM(START+I)=PERM(FINISH-I)
        PERM(FINISH-I)=J
 10   CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE UPLIST(BPERM,MINB1,NBREAK,NFWORS,IWORST,MAXLOC,MAXORD
     1,NUMORD,NLOCUS,PERM)
C
C UPDATE THE LIST OF BEST CURRENT LOCUS ORDERS.
C
      INTEGER BPERM(MAXORD,MAXLOC),NBREAK(MAXORD),PERM(NLOCUS)
C
C CHECK WHETHER THE CURRENT ORDER ALREADY IS IN THE LIST OF BEST 
C ORDERS. IF IT IS, FORGET IT.  NOTE: CHECK BOTH ORIENTATIONS.
C
      DO 40 J=1,NUMORD
        IF(NBREAK(J).NE.MINB1)GO TO 40
C
          DO 10 I=1,NLOCUS
            IF(BPERM(J,I).NE.PERM(I))GO TO 20
 10       CONTINUE
          GO TO 70
C
 20       DO 30 I=1,NLOCUS
            IF(BPERM(J,I).NE.PERM(NLOCUS-I+1))GO TO 40
 30       CONTINUE
          GO TO 70
 40   CONTINUE
C
C IF NOT, EXCHANGE THE CURRENT ORDER WITH THE WORST ORDER THAT IS
C CURRENTLY SAVED.
C
      NBREAK(IWORST)=MINB1
      DO 50 I=1,NLOCUS
        BPERM(IWORST,I)=PERM(I)
 50   CONTINUE
C
C DETERMINE WHICH SAVED ORDER IS NOW THE WORST.
C
      NFWORS=MINB1
      DO 60 J=1,NUMORD
        IF(NBREAK(J).LT.NFWORS)GO TO 60
          NFWORS=NBREAK(J)
          IWORST=J
 60   CONTINUE
C
 70   RETURN
      END
C
C
C
      SUBROUTINE INDEXX(N,ARRAY,INDEX)
C
C THIS ROUTINE CONSTRUCTS THE INDEX ARRAY INDEX BASED ON THE INPUT
C ARRAY ARRAY.  AT COMPLETION, ARRAY(INDEX(I)) IS IN ASCENDING ORDER
C FOR I=1,2,...,N.  
C
C REFERENCE:  PRESS WH, FLANNERY BP, TEUKOLSKY SA, VETTERLING WT
C (1986) NUMERICAL RECIPES.  THE ART OF SCIENTIFIC COMPUTING (FORTRAN
C VERSION), CAMBRIDGE UNIVERSITY PRESS, CAMBRIDGE, ENGLAND, P. 233.
C
      INTEGER ARRAY(N),INDEX(N)
C
C INITIALIZE THE INDEX ARRAY WITH CONSECUTIVE INTEGERS.
C
      DO 1 I=1,N
        INDEX(I)=I
    1 CONTINUE
C
C FROM HERE ON WE ARE DOING A HEAPSORT WITH INDIRECT INDEXING THROUGH
C INDEX IN ALL REFERENCES TO ARRAY.
C
      IF(N.EQ.1)RETURN
      L=N/2+1
      IR=N
C
 10   CONTINUE
      IF(L.GT.1)THEN
        L=L-1
        INDEXT=INDEX(L)
        Q=ARRAY(INDEXT)
      ELSE
        INDEXT=INDEX(IR)
        Q=ARRAY(INDEXT)
        INDEX(IR)=INDEX(1)
        IR=IR-1
        IF(IR.EQ.1)THEN
          INDEX(1)=INDEXT
          RETURN
        ENDIF
      ENDIF
C
      I=L
      J=L+L
C
 20   IF(J.LE.IR)THEN
        IF(J.LT.IR)THEN
          IF(ARRAY(INDEX(J)).LT.ARRAY(INDEX(J+1)))J=J+1
        ENDIF
        IF(Q.LT.ARRAY(INDEX(J)))THEN
          INDEX(I)=INDEX(J)
          I=J
          J=J+J
        ELSE
          J=IR+1
        ENDIF
        GO TO 20
      ENDIF
      INDEX(I)=INDEXT
      GO TO 10
      END
C
C
C
      SUBROUTINE OUTORD(BPERM,INDEX,KOUT,KWRITE,LNAME,MAXLOC,MAXORD
     1,NBBEST,NBEST,NBREAK,NLOCUS,NUMORD,PERM,PRTMAX)
C
C OUTPUT THE LOCUS ORDER TABLE FOR THIS PROBLEM.
C
      CHARACTER*4 LNAME(NLOCUS)
      INTEGER BPERM(MAXORD,MAXLOC),INDEX(NUMORD),NBREAK(MAXORD)
     1,PERM(NLOCUS),PRTMAX
C
C OUTPUT THE TABLE HEADER.
C
      WRITE(KOUT,101)
 101  FORMAT(///' LIST OF BEST MINIMUM OBLIGATE BREAK LOCUS ORDERS'
     1/' RANK  BREAKS  LOCUS ORDER')
C
C IF THERE WERE TOO MANY ORDERS TO SORT, READ FROM THE SCRATCH FILE.
C OTHERWISE, GET THEM FROM BPERM.
C 
      IF(NUMORD.GT.MAXORD)GO TO 20
        NMAX=NUMORD
        IF(NBEST.LT.NUMORD.AND.NBEST.GT.0)NMAX=NBEST
        DO 10 I=1,NMAX
          NDIFF=NBREAK(INDEX(I))-NBBEST
          IF(NDIFF.GT.PRTMAX.AND.I.GT.2)GO TO 40
            WRITE(KOUT,102)I,NBREAK(INDEX(I))
     1      ,(LNAME(BPERM(INDEX(I),LOCUS)),LOCUS=1,NLOCUS)
            WRITE(KOUT,103)(BPERM(INDEX(I),LOCUS),LOCUS=1,NLOCUS)
 102        FORMAT(/I4,I8,3X,16(A4,1X),63(/15X,16(A4,1X)))
 103        FORMAT(12X,16I5)
 10     CONTINUE
        GO TO 40
C
 20   DO 30 I=1,NUMORD
        READ(KWRITE,104)NBRKI,(PERM(J),J=1,NLOCUS)
 104    FORMAT(I6,1000I3)
        NDIFF=NBRKI-NBBEST
        IF(NDIFF.GT.PRTMAX)GO TO 30
          WRITE(KOUT,105)NBRKI,(LNAME(PERM(LOCUS)),LOCUS=1,NLOCUS)
 105      FORMAT(/I12,3X,16(A4,1X),63(/15X,16(A4,1X)))
          WRITE(KOUT,103)(PERM(LOCUS),LOCUS=1,NLOCUS)
 30   CONTINUE
C
 40   RETURN
      END
C
C
C
      SUBROUTINE INFHYB(BPERM,HBREAK,HNAMET,HNUMV,INCHAR,INDEX,INPERM
     1,IPROB,KOUT,MAXHYB,MAXLOC,MAXORD,MISS,NBREAK,NDIFFV,NHYBT
     2,NLOCUS,NOBS,NOBST,NUMORD,PRTMAX,RET,RETAIN,SUMBRK,USEINC)
C
C IDENTIFY THE INFLUENTIAL HYBRIDS BY COMPARING EACH CANDIDATE FOR
C BEST ORDER TO THE PRESENT BEST ORDER.
C
      CHARACTER*1 INCHAR(0:2)
      CHARACTER*4 HNAMET(MAXHYB)
      INTEGER BPERM(MAXORD,MAXLOC),HBREAK(0:MAXHYB),HBRK,HNUMV(MAXHYB)
     1,INDEX(MAXORD),INPERM(MAXLOC),MISS(MAXHYB),NDIFFV(MAXHYB)
     2,NBREAK(MAXORD),NOBS(MAXHYB),NOBST(MAXHYB),PRTMAX
     3,RET(MAXHYB,MAXLOC),RETAIN(MAXHYB,MAXLOC),SUMBRK(0:MAXLOC),USEINC
C
C INITIALIZE SUMBRK TO ZERO.
C
      DO 10 I=0,NLOCUS
        SUMBRK(I)=0
 10   CONTINUE
C
C RE-READ WITHOUT COMPRESSING RET TO GIVE RETAIN FOR THIS PROBLEM.
C RE-SET NOBS AND NHYB.  CHOOSE THE NEXT SET OF VALUES FROM RET.
C IF THERE ARE ANY MISSING VALUES, WE MAY OPTIONALLY DELETE THEM
C IF USEINC=0.  DO THIS BY MAKING THE ENTIRE HYBRID MISSING.  THIS
C PRESERVES THE ORDERING OF THE HYBRIDS.
C
      NHYB=NHYBT
      DO 40 IHYB=1,NHYB
        NOBS(IHYB)=NOBST(IHYB)
        MISS(IHYB)=0
        DO 30 LOCUS=1,NLOCUS
          RETAIN(IHYB,LOCUS)=RET(IHYB,INPERM(LOCUS))
          IF(USEINC.EQ.1)GO TO 30
            IF(RETAIN(IHYB,LOCUS).NE.2)GO TO 30
              DO 20 LOC=1,NLOCUS
                RETAIN(IHYB,LOC)=2
 20           CONTINUE
              MISS(IHYB)=1
              GO TO 40
 30     CONTINUE
 40   CONTINUE
C
C WRITE THE HEADER.
C
      WRITE(KOUT,101)IPROB,(BPERM(INDEX(1),I),I=1,NLOCUS)
 101  FORMAT(///' RETENTION DATA PERMUTED IN THE BEST LOCUS ORDER FOR '
     1,'PROBLEM',I5//' HYBRID HYBRID  NUMBER  OBLIGATE   RETENTION '
     2,'STATUS'/' NUMBER  NAME  OBSERVED  BREAKS   ',20I3
     3,49(/34X,20I3))
      WRITE(KOUT,102)
 102  FORMAT(A)
C
C COUNT THE NUMBER OF BREAKS PER HYBRID UNDER THE BEST PERMUTATION
C AND UPDATE THE SUMBRK VECTOR.  OUTPUT THE HYBRID.
C 
      INDEX1=INDEX(1)
      DO 60 IHYB=1,NHYB
        IF(MISS(IHYB).EQ.1)GO TO 60
          NB=0
          LAST=RETAIN(IHYB,BPERM(INDEX1,1))
          DO 50 JLOC=2,NLOCUS
            JR=RETAIN(IHYB,BPERM(INDEX1,JLOC))
            IF(JR.EQ.LAST)GO TO 50 
              IF(JR.EQ.2)GO TO 50 
                IF(JR+LAST.EQ.1)NB=NB+1 
                LAST=JR          
 50       CONTINUE 
          SUMBRK(NB)=SUMBRK(NB)+NOBS(IHYB)
          HBREAK(IHYB)=NB
          WRITE(KOUT,103)IHYB,HNAMET(IHYB),NOBS(IHYB),NB
     1    ,(INCHAR(RETAIN(IHYB,BPERM(INDEX(1),ILOC))),ILOC=1,NLOCUS)
 103      FORMAT(I5,4X,A4,I7,I9,5X,20(2X,A1),49(/34X,20(2X,A1)))
 60   CONTINUE
C
C STARTING FROM THE LAST COMPONENT OF THE SUMBRK VECTOR, LOOK FOR THE
C FIRST NON-ZERO COMPONENT.  PRINT ALL SUCH COMPONENTS.
C
      DO 70 IBREAK=NLOCUS-1,0,-1
        IF (SUMBRK(IBREAK).NE.0)GO TO 80
 70   CONTINUE
 80   WRITE(KOUT,104)(I,I=0,IBREAK)
 104  FORMAT(///' NUMBERS OF OBLIGATE BREAKS PER HYBRID:'
     1//' NUMBER OF BREAKS     ',10I5,99(/22X,10I5))
      WRITE(KOUT,105)(SUMBRK(I),I=0,IBREAK)
 105  FORMAT(/' NUMBER OF HYBRIDS    ',10I5,99(/22X,10I5))
C
C PRINT THE HEADER FOR HYBRID NUMBER AND DIFFERENCES.
C
      WRITE(KOUT,106)
 106  FORMAT(///' INFLUENTIAL HYBRIDS FOR THE MOST LIKELY ORDERS'//
     1' RANK  BREAKS   HYBRID NAME AND BREAK DIFFERENCES (OTHER-BEST)')
C
C FOR EACH OF THE OTHER REMAINING PERMUTATIONS, PROVIDED NBREAK IS NOT
C PRTMAX MORE THAN THE MINIMUM NUMBER OF OBLIGATE BREAKS ...
C
      NCUTPT=NBREAK(INDEX1)+PRTMAX
      DO 120 IORD=2,NUMORD
        INDEXI=INDEX(IORD)
        IF(NBREAK(INDEXI).GT.NCUTPT)GO TO 130
C
C FOR EACH HYBRID ...
C
        ICOUNT=0
        DO 100 IHYB=1,NHYBT
          HBRK=0
          NDIFF=0
C
C COUNT THE NUMBER OF BREAKS.
C
          LAST=RETAIN(IHYB,BPERM(INDEXI,1))
          DO 90 JLOC=2,NLOCUS
            JR=RETAIN(IHYB,BPERM(INDEXI,JLOC))
            IF(JR.EQ.LAST)GO TO 90 
              IF(JR.EQ.2)GO TO 90 
                IF(JR+LAST.EQ.1)HBRK=HBRK+1
                LAST=JR          
 90       CONTINUE 
          NDIFF=HBRK-HBREAK(IHYB)
          IF(NDIFF.EQ.0)GO TO 100
            ICOUNT=ICOUNT+1
            NDIFFV(ICOUNT)=NDIFF
            HNUMV(ICOUNT)=IHYB
 100    CONTINUE
C
C DETERMINE THE NUMBER OF GROUP OF 15'S NEEDED TO BE PRINTED IN THE
C OUTPUT.
C
        IF(ICOUNT.EQ.0)WRITE(KOUT,107)IORD,NBREAK(INDEX(IORD))
 107    FORMAT(/I4,I8,5X,'NO INFLUENTIAL HYBRIDS IDENTIFIED.')
        ILOOP=ICOUNT/12
        IF(ICOUNT.GT.0)WRITE(KOUT,108)IORD,NBREAK(INDEX(IORD))
     1       ,(HNAMET(HNUMV(I)),I=1,MIN(12,ICOUNT))
 108    FORMAT(/I4,I8,5X,12(A4,1X))
        IF(ICOUNT.GT.0)WRITE(KOUT,109)(NDIFFV(I),I=1,MIN(12,ICOUNT))
 109    FORMAT(16X,12I5)
        DO 110 IREP=1,ILOOP
          WRITE(KOUT,111)(HNAMET(HNUMV(I))
     1    ,I=12*IREP+1,MIN(12*(IREP+1),ICOUNT))
 111    FORMAT(/17X,12(A4,1X))
          WRITE(KOUT,109)(NDIFFV(I),I=12*IREP+1,MIN(12*(IREP+1),ICOUNT))
 110    CONTINUE      
 120  CONTINUE   
C
 130  RETURN
      END
