#include<iostream>
#include<cstdio>
#include<cstdlib>
#include<cmath>
#include<cstring>
#include<iomanip>
#include <fstream>
#include <string>
#include <vector>
#include <sstream>

using namespace std;

const int MAX_IT = 100000000;
const int ITMAX = 100;
const double EPSL = 3.0e-7;
const double FPMIN = 1.0e-30;
const double EPS = 1e-5;
const double ZEPS = 1e-12;
const double MIN = 1e-54;

// comparison between 2 integers and return the smaller one
int Min(int x1, int x2)
  {
    if(x1 >= x2) return x2;
    else if(x1 < x2) return x1;
  }
  
//chisquare test for 2 by 2 contingency table
    
double stat(int m0, int m1, int n0, int n1)
  {
    double chsqstat;
    if(m0 == 0 && m1 == 0) chsqstat = 0.0;
    else if(2*n0-m0 == 0 && 2*n1-m1 == 0) chsqstat = 0.0;
    else if(m0 < 0 | m1 < 0) chsqstat = 0.0;
    else if(2*n0-m0 < 0 | 2*n1-m1< 0) chsqstat = 0.0;
    
    else chsqstat = double((n0+n1))*(n0*m1-n1*m0)*(n0*m1-n1*m0)*2.0/n0/n1/(m0+m1)/(2*(n0+n1)-(m0+m1));
    return(chsqstat);
  } 

  
//calculate binomial density

double gammln(double xx)
  {
    double x,y,tmp,ser;
    static double cof[6]={76.18009172947146, -86.50532032941677,
    24.01409824083091, -1.231739572450155, 0.1208650973866179e-2,
    -0.5395239384953e-5};
    int j;
    
    y = x = xx;
    tmp = x+5.5;
    tmp -= (x+0.5)*log(tmp);
    ser = 1.000000000190015;
    for (j=0; j<=5; j++) ser += cof[j]/++y;
    return -tmp+log(2.5066282746310005*ser/x); 
  }


double factln(int n)
  {
    double gammln(double xx);
   // void nrerror(char error_text[]);
    static double a[10001];
    
    //if (n < 0) nrerror("Negative factorial in routine factln");
    if (n <= 1) return 0.0;
    if (n <= 10000) return a[n] ? a[n] : (a[n] = gammln(n+1.0));
    else return gammln(n+1.0);    
  }
  
double coeff(int n, int k)
  {
    double factln(int n);
    
    //return floor(0.5+exp(factln(n) - factln(k) - factln(n-k)));
    return (factln(n) - factln(k) - factln(n-k));
    
  }
  
double binom(int n, int k, double p)
  {
    double density, log_dens;
    
    log_dens = coeff(n, k)*log10(exp(1.0)) + k*log10(p) + (n-k)*log10(1-p);
    
    if (log_dens < -50) return (0.0);
    
    else return (pow(10,(log_dens)));
  
  }

//transform p in order to keep p in (0, 1)
double transp(double x)
  {
    double p;
    p = exp(x)/(1+exp(x));
    return p;
  }  


//transform delta in order to keep d in (-0.4, 0.4)
double transd(double x)
  {
    double delta;
    delta = 0.3 - 0.6 * exp(x)/(1+exp(x));
    return delta;
  }   
  
  
double binom1(int n, int k, double x)
  {
    double density, log_dens;
    double p;
    
    p = transp(x);
    
    
    log_dens = coeff(n, k)*log10(exp(1.0)) + k*log10(p) + (n-k)*log10(1-p);
    
    if (log_dens < -150) return (1e-150);
    
    else return (pow(10,(log_dens)));
  
  }
  
double binom2(int n, int k, double x, double y)
  {
    double density, log_dens;
    double p, d;
    
    p = transp(x);
    d = transd(y);
    
    log_dens = coeff(n, k)*log10(exp(1.0)) + k*log10(p+d) + (n-k)*log10(1-p-d);
    
    if (log_dens < -150) return (1e-150);
    
    else return (pow(10,(log_dens)));
  
  }
    

//joint density of x0 and x1;
double joint(int n0, int n1, int x0, int x1, double x, double y)
  {
    return (binom1(2*n0, x0, x)*binom2(2*n1, x1, x, y));
  }

/////////////////get quantile for the chi-square distn
void gser(double *gamser, double a, double x, double *gln)
{
  int n;
  double sum, del, ap;
  
  *gln=gammln(a);
  if(x <= 0.0)
  {
    *gamser = 0.0;
    return;   
  }
  
  else
  {
    ap = a;
    del = sum = 1.0/a;
    for(n=1; n <= ITMAX; n++)
    {
      ++ap;
      del *= x/ap;
      sum += del;
      if (fabs(del) < fabs(sum)*EPSL)
      {
         *gamser = sum*exp(-x+a*log(x)-(*gln));
         return;   
      }   
    }
    
    return;   
  }   
}


void gcf(double *gammcf, double a, double x, double *gln)
{
  int i;
  double an, b, c, d, del, h;
  
  *gln = gammln(a);
  b=x+1.0-a;
  c=1.0/FPMIN;
  d=1.0/b;
  h=d;
  for(i=1; i<=ITMAX; i++)
  {
    an = -i*(i-a);
    b += 2.0;
    d =an*d+b;
    if(fabs(d) < FPMIN) d = FPMIN;
    c =b+an/c;
    if(fabs(c) < FPMIN) c = FPMIN;
    d=1.0/d;
    del=d*c;
    h *= del;
    if(fabs(del-1.0) < EPSL) break;   
  }
  *gammcf = exp(-x+a*log(x)-(*gln))*h;
     
}
      
double gammq(double a, double x)
{
  double gamser, gammcf, gln;
  if(x < (a+1.0))
  {
    gser(&gamser, a, x, &gln);
    return 1.0 - gamser;   
  }
  
  else
  {
    gcf(&gammcf, a, x, &gln);
    return gammcf;   
  }   
}
  

double pval(double df, double chisq)
{
  return gammq(df/2, chisq/2);   
} 

///use loop to get the chi-square quantile;
double cutoff(double df, double alpha)
{
  double diff = 1.0, chisq=40.0;
  
  while(diff > alpha*.0001 & chisq > 0.0)
  {
    diff = alpha - pval(df, chisq);
    chisq -= .0001;   
  } 
  
  return chisq;   
} 
    
//analytically calculate the P(X>x | N, p, delta) for simplex
double denom_simplex(int N0, int N1, double x,  double y, double critic) 
  {
  
   int i, j, m0, m1;
   double denom_curr, denom_curr_1, denom_curr_2, denom_prev;
   
   if(N0 <= N1)
   {
    denom_curr = 0,denom_curr_1 =0, denom_curr_2 = 0;
       for(i = 0; i <= N0*2; i++)
      {
        m0 = i;
	
	    m1 = m0;
	
	while(stat(m0, m1, N0, N1) <= critic && m1 <= m0)	
	  {
	    denom_prev = joint(N0, N1, m0, m1, x, y);
	    denom_curr_1 += denom_prev;
	    m1++;
	  }
	  	    
	 m1 = m0 - 1;
	 while(stat(m0, m1, N0, N1) <= critic && m1 >= 0)	
	  {
	    denom_prev = joint(N0, N1, m0, m1, x, y);
	    denom_curr_2 += denom_prev;
	    m1--;
	  }
	   
      } 
      denom_curr = 1 - (denom_curr_1 + denom_curr_2);
      
    }
    
   else if(N0 > N1)
   {
    denom_curr = 0,denom_curr_1 =0, denom_curr_2 = 0;
       for(i = 0; i <= N0*2; i++)
      {
        m0 = i ;
	
	    m1 = Min(m0, 2*N1);
	
	while(stat(m0, m1, N0, N1) <= critic && m1 <= 2*N1)	
	  {
	    denom_prev = joint(N0, N1, m0, m1, x, y);
	    denom_curr_1 += denom_prev;
	    m1++;
	  }
	  	    
	 m1 = Min(m0 - 1, 2*N1);
	 while(stat(m0, m1, N0, N1) <= critic && m1 >= 0)	
	  {
	    denom_prev = joint(N0, N1, m0, m1, x, y);
	    denom_curr_2 += denom_prev;
	    m1--;
	  }
	   
      } 
      denom_curr = 1 - (denom_curr_1 + denom_curr_2);
      
    }
    
    return(denom_curr);
}

//analytically calculate the P(X>x | N, p, delta) for simplex
double denom_simplex_1(int N0, int N1, double x,  double y, double critic) 
  {
  
   int i, j, m0, m1;
   double denom_curr = 0.0;
   
   for(i=0; i<= N0*2; i++)
   {
     for(j=0; j <= N1*2; j++)
     {
       if(stat(i, j, N0, N1) > critic) denom_curr += joint(N0, N1, i, j, x, y);    
         
     }   
   }
   

    return(denom_curr);
}

//////////////////////////asymptotic SE by calculating the information matrix
double var_delta(int N0, int N1, int x0, int x1, double x,  double y, double critic) 
  {
  
   int i, j, m0, m1;
   double A = 0,B =0, C = 0, D=0, E=0, denom_prev, denom_curr_1=0, denom_curr_2=0;
   double I, a, b, d;
   
   if(N0 <= N1)
   {    
    for(i = 0; i <= N0*2; i++)
    {
      m0 = i;
	
	  m1 = 0;
	
	while(stat(m0, m1, N0, N1) > critic && m1 <= m0)	
	  {
	    denom_prev = binom(2*N0,m0,x)*binom(2*N1, m1, x+y);
        denom_curr_1 += denom_prev;
        A += (double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y))*denom_prev;
        B += (double(m0)/(x*x) + double((2*N0-m0))/((1-x)*(1-x)) + double(m1)/((x+y)*(x+y)) + double((2*N1-m1))/((1-x-y)*(1-x-y)) - pow((double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y)),2))*denom_prev;
        C += (double(m1)/((x+y)*(x+y)) + double(2*N1-m1)/((1-x-y)*(1-x-y)) - (double(m1)/(x+y) - double(2*N1-m1)/(1-x-y))*(double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y)))*denom_prev;
        D += (double(m1)/(x+y) - double((2*N1-m1))/(1-x-y))*denom_prev;
        E += (double(m1)/((x+y)*(x+y)) + double((2*N1-m1))/((1-x-y)*(1-x-y)) - pow(double(m1)/(x+y) - double((2*N1-m1))/(1-x-y),2))*denom_prev;
	    m1++;
	  }
	  	    
	 m1 = 2*N1;
	 while(stat(m0, m1, N0, N1) > critic && m1 >= m0)	
	  {
	    denom_prev = binom(2*N0,m0,x)*binom(2*N1, m1, x+y);
        denom_curr_2 += denom_prev;        
        A += (double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y))*denom_prev;
        B += (double(m0)/(x*x) + double((2*N0-m0))/((1-x)*(1-x)) + double(m1)/((x+y)*(x+y)) + double((2*N1-m1))/((1-x-y)*(1-x-y)) - pow((double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y)),2))*denom_prev;
        C += (double(m1)/((x+y)*(x+y)) + double(2*N1-m1)/((1-x-y)*(1-x-y)) - (double(m1)/(x+y) - double(2*N1-m1)/(1-x-y))*(double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y)))*denom_prev;
        D += (double(m1)/(x+y) - double((2*N1-m1))/(1-x-y))*denom_prev;
        E += (double(m1)/((x+y)*(x+y)) + double((2*N1-m1))/((1-x-y)*(1-x-y)) - pow(double(m1)/(x+y) - double((2*N1-m1))/(1-x-y),2))*denom_prev;
	    m1--;
	  }
	   
    } 
 
    I = denom_curr_1+denom_curr_2;     
    a = -double(x0)/(x*x) - double(2*N0-x0)/((1-x)*(1-x)) - double(x1)/((x+y)*(x+y)) - double(2*N1-x1)/((1-x-y)*(1-x-y)) + A*A/(I*I) + B/I;
    b = - double(x1)/((x+y)*(x+y)) - double(2*N1-x1)/((1-x-y)*(1-x-y)) + A*D/(I*I) + C/I;
    d = - double(x1)/((x+y)*(x+y)) - double(2*N1-x1)/((1-x-y)*(1-x-y)) + D*D/(I*I) + E/I;
  } 
 
   else if(N0 > N1)
   {    
    for(i = 0; i <= N1*2; i++)
    {
      m1 = i;
	
	  m0 = 0;
	
	while(stat(m0, m1, N0, N1) > critic && m0 <= m1)	
	  {
	    denom_prev = binom(2*N0,m0,x)*binom(2*N1, m1, x+y);
        denom_curr_1 += denom_prev;
        A += (double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y))*denom_prev;
        B += (double(m0)/(x*x) + double((2*N0-m0))/((1-x)*(1-x)) + double(m1)/((x+y)*(x+y)) + double((2*N1-m1))/((1-x-y)*(1-x-y)) - pow((double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y)),2))*denom_prev;
        C += (double(m1)/((x+y)*(x+y)) + double(2*N1-m1)/((1-x-y)*(1-x-y)) - (double(m1)/(x+y) - double(2*N1-m1)/(1-x-y))*(double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y)))*denom_prev;
        D += (double(m1)/(x+y) - double((2*N1-m1))/(1-x-y))*denom_prev;
        E += (double(m1)/((x+y)*(x+y)) + double((2*N1-m1))/((1-x-y)*(1-x-y)) - pow(double(m1)/(x+y) - double((2*N1-m1))/(1-x-y),2))*denom_prev;
	    m0++;
	  }
	  	    
	 m0 = 2*N0;
	 while(stat(m0, m1, N0, N1) > critic && m0 >= m1)	
	  {
	    denom_prev = binom(2*N0,m0,x)*binom(2*N1, m1, x+y);
        denom_curr_2 += denom_prev;        
        A += (double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y))*denom_prev;
        B += (double(m0)/(x*x) + double((2*N0-m0))/((1-x)*(1-x)) + double(m1)/((x+y)*(x+y)) + double((2*N1-m1))/((1-x-y)*(1-x-y)) - pow((double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y)),2))*denom_prev;
        C += (double(m1)/((x+y)*(x+y)) + double(2*N1-m1)/((1-x-y)*(1-x-y)) - (double(m1)/(x+y) - double(2*N1-m1)/(1-x-y))*(double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y)))*denom_prev;
        D += (double(m1)/(x+y) - double((2*N1-m1))/(1-x-y))*denom_prev;
        E += (double(m1)/((x+y)*(x+y)) + double((2*N1-m1))/((1-x-y)*(1-x-y)) - pow(double(m1)/(x+y) - double((2*N1-m1))/(1-x-y),2))*denom_prev;
	    m0--;
	  }
	   
    } 
 
    I = denom_curr_1+denom_curr_2;     
    a = -double(x0)/(x*x) - double(2*N0-x0)/((1-x)*(1-x)) - double(x1)/((x+y)*(x+y)) - double(2*N1-x1)/((1-x-y)*(1-x-y)) + A*A/(I*I) + B/I;
    b = - double(x1)/((x+y)*(x+y)) - double(2*N1-x1)/((1-x-y)*(1-x-y)) + A*D/(I*I) + C/I;
    d = - double(x1)/((x+y)*(x+y)) - double(2*N1-x1)/((1-x-y)*(1-x-y)) + D*D/(I*I) + E/I;
  }  
     
return(-a/(a*d - b*b));

}


double var_p(int N0, int N1, int x0, int x1, double x,  double y, double critic) 
  {
  
   int i, j, m0, m1;
   double A = 0,B =0, C = 0, D=0, E=0, denom_prev, denom_curr_1=0, denom_curr_2=0;
   double I, a, b, d;
   
   if(N0 <= N1)
   {
    for(i = 0; i <= N0*2; i++)
    {
        m0 = i;
	
	  m1 = 0;
	
	while(stat(m0, m1, N0, N1) > critic && m1 <= m0)	
	  {
	    denom_prev = binom(2*N0,m0,x)*binom(2*N1, m1, x+y);
        denom_curr_1 += denom_prev;
        A += (double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y))*denom_prev;
        B += (double(m0)/(x*x) + double((2*N0-m0))/((1-x)*(1-x)) + double(m1)/((x+y)*(x+y)) + double((2*N1-m1))/((1-x-y)*(1-x-y)) - pow((double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y)),2))*denom_prev;
        C += (double(m1)/((x+y)*(x+y)) + double(2*N1-m1)/((1-x-y)*(1-x-y)) - (double(m1)/(x+y) - double(2*N1-m1)/(1-x-y))*(double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y)))*denom_prev;
        D += (double(m1)/(x+y) - double((2*N1-m1))/(1-x-y))*denom_prev;
        E += (double(m1)/((x+y)*(x+y)) + double((2*N1-m1))/((1-x-y)*(1-x-y)) - pow(double(m1)/(x+y) - double((2*N1-m1))/(1-x-y),2))*denom_prev;
	    m1++;
	  }
	  	    
	 m1 = 2*N1;
	 while(stat(m0, m1, N0, N1) > critic && m1 >= m0)	
	  {
	    denom_prev = binom(2*N0,m0,x)*binom(2*N1, m1, x+y);
        denom_curr_2 += denom_prev;        
        A += (double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y))*denom_prev;
        B += (double(m0)/(x*x) + double((2*N0-m0))/((1-x)*(1-x)) + double(m1)/((x+y)*(x+y)) + double((2*N1-m1))/((1-x-y)*(1-x-y)) - pow((double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y)),2))*denom_prev;
        C += (double(m1)/((x+y)*(x+y)) + double(2*N1-m1)/((1-x-y)*(1-x-y)) - (double(m1)/(x+y) - double(2*N1-m1)/(1-x-y))*(double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y)))*denom_prev;
        D += (double(m1)/(x+y) - double((2*N1-m1))/(1-x-y))*denom_prev;
        E += (double(m1)/((x+y)*(x+y)) + double((2*N1-m1))/((1-x-y)*(1-x-y)) - pow(double(m1)/(x+y) - double((2*N1-m1))/(1-x-y),2))*denom_prev;
	    m1--;
	  }
	   
    } 
 
   I = denom_curr_1+denom_curr_2;     
   a = -double(x0)/(x*x) - double(2*N0-x0)/((1-x)*(1-x)) - double(x1)/((x+y)*(x+y)) - double(2*N1-x1)/((1-x-y)*(1-x-y)) + A*A/(I*I) + B/I;
   b = - double(x1)/((x+y)*(x+y)) - double(2*N1-x1)/((1-x-y)*(1-x-y)) + A*D/(I*I) + C/I;
   d = - double(x1)/((x+y)*(x+y)) - double(2*N1-x1)/((1-x-y)*(1-x-y)) + D*D/(I*I) + E/I;
   }   
   
   
   if(N0 > N1)
   {
    for(i = 0; i <= N1*2; i++)
    {
        m1 = i;
	
	  m0 = 0;
	
	while(stat(m0, m1, N0, N1) > critic && m0 <= m1)	
	  {
	    denom_prev = binom(2*N0,m0,x)*binom(2*N1, m1, x+y);
        denom_curr_1 += denom_prev;
        A += (double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y))*denom_prev;
        B += (double(m0)/(x*x) + double((2*N0-m0))/((1-x)*(1-x)) + double(m1)/((x+y)*(x+y)) + double((2*N1-m1))/((1-x-y)*(1-x-y)) - pow((double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y)),2))*denom_prev;
        C += (double(m1)/((x+y)*(x+y)) + double(2*N1-m1)/((1-x-y)*(1-x-y)) - (double(m1)/(x+y) - double(2*N1-m1)/(1-x-y))*(double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y)))*denom_prev;
        D += (double(m1)/(x+y) - double((2*N1-m1))/(1-x-y))*denom_prev;
        E += (double(m1)/((x+y)*(x+y)) + double((2*N1-m1))/((1-x-y)*(1-x-y)) - pow(double(m1)/(x+y) - double((2*N1-m1))/(1-x-y),2))*denom_prev;
	    m0++;
	  }
	  	    
	 m0 = 2*N0;
	 while(stat(m0, m1, N0, N1) > critic && m0 >= m1)	
	  {
	    denom_prev = binom(2*N0,m0,x)*binom(2*N1, m1, x+y);
        denom_curr_2 += denom_prev;        
        A += (double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y))*denom_prev;
        B += (double(m0)/(x*x) + double((2*N0-m0))/((1-x)*(1-x)) + double(m1)/((x+y)*(x+y)) + double((2*N1-m1))/((1-x-y)*(1-x-y)) - pow((double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y)),2))*denom_prev;
        C += (double(m1)/((x+y)*(x+y)) + double(2*N1-m1)/((1-x-y)*(1-x-y)) - (double(m1)/(x+y) - double(2*N1-m1)/(1-x-y))*(double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y)))*denom_prev;
        D += (double(m1)/(x+y) - double((2*N1-m1))/(1-x-y))*denom_prev;
        E += (double(m1)/((x+y)*(x+y)) + double((2*N1-m1))/((1-x-y)*(1-x-y)) - pow(double(m1)/(x+y) - double((2*N1-m1))/(1-x-y),2))*denom_prev;
	    m0--;
	  }
	   
    } 
 
   I = denom_curr_1+denom_curr_2;     
   a = -double(x0)/(x*x) - double(2*N0-x0)/((1-x)*(1-x)) - double(x1)/((x+y)*(x+y)) - double(2*N1-x1)/((1-x-y)*(1-x-y)) + A*A/(I*I) + B/I;
   b = - double(x1)/((x+y)*(x+y)) - double(2*N1-x1)/((1-x-y)*(1-x-y)) + A*D/(I*I) + C/I;
   d = - double(x1)/((x+y)*(x+y)) - double(2*N1-x1)/((1-x-y)*(1-x-y)) + D*D/(I*I) + E/I;
   }      
return(-d/(a*d - b*b));
// return(b);

}

double cov(int N0, int N1, int x0, int x1, double x,  double y, double critic) 
  {
  
   int i, j, m0, m1;
   double A = 0,B =0, C = 0, D=0, E=0, denom_prev, denom_curr_1=0, denom_curr_2=0;
   double I, a, b, d;
   
  if(N0 <= N1)
  { 
    for(i = 0; i <= N0*2; i++)
    {
      m0 = i;
	
	  m1 = 0;
	
	while(stat(m0, m1, N0, N1) > critic && m1 <= m0)	
	  {
	    denom_prev = binom(2*N0,m0,x)*binom(2*N1, m1, x+y);
        denom_curr_1 += denom_prev;
        A += (double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y))*denom_prev;
        B += (double(m0)/(x*x) + double((2*N0-m0))/((1-x)*(1-x)) + double(m1)/((x+y)*(x+y)) + double((2*N1-m1))/((1-x-y)*(1-x-y)) - pow((double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y)),2))*denom_prev;
        C += (double(m1)/((x+y)*(x+y)) + double(2*N1-m1)/((1-x-y)*(1-x-y)) - (double(m1)/(x+y) - double(2*N1-m1)/(1-x-y))*(double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y)))*denom_prev;
        D += (double(m1)/(x+y) - double((2*N1-m1))/(1-x-y))*denom_prev;
        E += (double(m1)/((x+y)*(x+y)) + double((2*N1-m1))/((1-x-y)*(1-x-y)) - pow(double(m1)/(x+y) - double((2*N1-m1))/(1-x-y),2))*denom_prev;
	    m1++;
	  }
	  	    
	 m1 = 2*N1;
	 while(stat(m0, m1, N0, N1) > critic && m1 >= m0)	
	  {
	    denom_prev = binom(2*N0,m0,x)*binom(2*N1, m1, x+y);
        denom_curr_2 += denom_prev;        
        A += (double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y))*denom_prev;
        B += (double(m0)/(x*x) + double((2*N0-m0))/((1-x)*(1-x)) + double(m1)/((x+y)*(x+y)) + double((2*N1-m1))/((1-x-y)*(1-x-y)) - pow((double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y)),2))*denom_prev;
        C += (double(m1)/((x+y)*(x+y)) + double(2*N1-m1)/((1-x-y)*(1-x-y)) - (double(m1)/(x+y) - double(2*N1-m1)/(1-x-y))*(double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y)))*denom_prev;
        D += (double(m1)/(x+y) - double((2*N1-m1))/(1-x-y))*denom_prev;
        E += (double(m1)/((x+y)*(x+y)) + double((2*N1-m1))/((1-x-y)*(1-x-y)) - pow(double(m1)/(x+y) - double((2*N1-m1))/(1-x-y),2))*denom_prev;
	    m1--;
	  }
	   
   } 
 
   I = denom_curr_1+denom_curr_2;     
   a = -double(x0)/(x*x) - double(2*N0-x0)/((1-x)*(1-x)) - double(x1)/((x+y)*(x+y)) - double(2*N1-x1)/((1-x-y)*(1-x-y)) + A*A/(I*I) + B/I;
   b = - double(x1)/((x+y)*(x+y)) - double(2*N1-x1)/((1-x-y)*(1-x-y)) + A*D/(I*I) + C/I;
   d = - double(x1)/((x+y)*(x+y)) - double(2*N1-x1)/((1-x-y)*(1-x-y)) + D*D/(I*I) + E/I;
  } 
  
  if(N0 > N1)
  { 
    for(i = 0; i <= N1*2; i++)
    {
      m1 = i;
	
	  m0 = 0;
	
	while(stat(m0, m1, N0, N1) > critic && m0 <= m1)	
	  {
	    denom_prev = binom(2*N0,m0,x)*binom(2*N1, m1, x+y);
        denom_curr_1 += denom_prev;
        A += (double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y))*denom_prev;
        B += (double(m0)/(x*x) + double((2*N0-m0))/((1-x)*(1-x)) + double(m1)/((x+y)*(x+y)) + double((2*N1-m1))/((1-x-y)*(1-x-y)) - pow((double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y)),2))*denom_prev;
        C += (double(m1)/((x+y)*(x+y)) + double(2*N1-m1)/((1-x-y)*(1-x-y)) - (double(m1)/(x+y) - double(2*N1-m1)/(1-x-y))*(double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y)))*denom_prev;
        D += (double(m1)/(x+y) - double((2*N1-m1))/(1-x-y))*denom_prev;
        E += (double(m1)/((x+y)*(x+y)) + double((2*N1-m1))/((1-x-y)*(1-x-y)) - pow(double(m1)/(x+y) - double((2*N1-m1))/(1-x-y),2))*denom_prev;
	    m0++;
	  }
	  	    
	 m0 = 2*N0;
	 while(stat(m0, m1, N0, N1) > critic && m0 >= m1)	
	  {
	    denom_prev = binom(2*N0,m0,x)*binom(2*N1, m1, x+y);
        denom_curr_2 += denom_prev;        
        A += (double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y))*denom_prev;
        B += (double(m0)/(x*x) + double((2*N0-m0))/((1-x)*(1-x)) + double(m1)/((x+y)*(x+y)) + double((2*N1-m1))/((1-x-y)*(1-x-y)) - pow((double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y)),2))*denom_prev;
        C += (double(m1)/((x+y)*(x+y)) + double(2*N1-m1)/((1-x-y)*(1-x-y)) - (double(m1)/(x+y) - double(2*N1-m1)/(1-x-y))*(double(m0)/x - double((2*N0-m0))/(1-x) + double(m1)/(x+y) - double((2*N1 - m1))/(1-x-y)))*denom_prev;
        D += (double(m1)/(x+y) - double((2*N1-m1))/(1-x-y))*denom_prev;
        E += (double(m1)/((x+y)*(x+y)) + double((2*N1-m1))/((1-x-y)*(1-x-y)) - pow(double(m1)/(x+y) - double((2*N1-m1))/(1-x-y),2))*denom_prev;
	    m0--;
	  }
	   
   } 
 
   I = denom_curr_1+denom_curr_2;     
   a = -double(x0)/(x*x) - double(2*N0-x0)/((1-x)*(1-x)) - double(x1)/((x+y)*(x+y)) - double(2*N1-x1)/((1-x-y)*(1-x-y)) + A*A/(I*I) + B/I;
   b = - double(x1)/((x+y)*(x+y)) - double(2*N1-x1)/((1-x-y)*(1-x-y)) + A*D/(I*I) + C/I;
   d = - double(x1)/((x+y)*(x+y)) - double(2*N1-x1)/((1-x-y)*(1-x-y)) + D*D/(I*I) + E/I;
  }         
return(b/(a*d - b*b));
// return(b);

}

double OR(double p, double d)
  {
    return((p+d)*(1-p)/p/(1-p-d));
  }
  
double OR_delta(double mle_p, double mle_d, double pvar, double cov, double dvar)
  {
    double a, b;
    a=-mle_d*(1-2*mle_p-mle_d)/((mle_p*(1-mle_p-mle_d))*(mle_p*(1-mle_p-mle_d)));
    b=mle_p*(1-mle_p)/((mle_p*(1-mle_p-mle_d))*(mle_p*(1-mle_p-mle_d)));
    
    return(a*(a*pvar+b*cov)+b*(a*cov + b*dvar));
  
  }
  
// log-likelihood function for simplex;
int nfunc = 0;
double like_simplex(int N0, int N1, int m0, int m1, double x,  double y, double critic) 
  {
    double likelihood;

    likelihood = -log10(joint(N0, N1, m0, m1, x, y)/denom_simplex(N0, N1, x, y, critic));
    nfunc++;
    return(likelihood);
  } 


//maximization using simplex;
double * alloc_vector(int cols)
  {
    return (double *) malloc(sizeof(double) * cols);
  }
  
void free_vector (double * vector, int cols)
  {
    free(vector);
  }
  
double ** alloc_matrix(int rows, int cols)
  {
    int i;
    double ** matrix = (double **) malloc(sizeof(double *) * rows);
    
    for (i = 0; i < rows; i++)
      matrix[i] = alloc_vector(cols);
      
    return matrix;
  }
  
void free_matrix(double ** matrix, int rows, int cols)
  {
    int i;
    for (i = 0; i < rows; i++)
    free_vector(matrix[i], cols);
    free(matrix);
  }
  
double ** make_simplex(double * point, int dim)
  {
    int i, j;
    double ** simplex = alloc_matrix(dim + 1, dim);
    
    for (int i = 0; i < dim + 1; i++)
       for (int j = 0; j < dim; j++)
         simplex[i][j] = point[j];
	 
    for (int i = 0; i < dim; i++)
       simplex[i][i] += 1.0;
       
    return simplex;
  }
  
void evaluate_simplex (double ** simplex, int dim, int N0, int N1, int m0, int m1, double critic, double *fx, double (*func)(int N0, int N1, int m0, int m1, double p, double delta, double critic))
  {
    for (int i = 0; i < dim + 1; i++)
      fx[i] = (*func)(N0, N1, m0, m1, simplex[i][0], simplex[i][1], critic);
  }
  
void simplex_extremes(double * fx, int dim, int * ihi, int * ilo, int * inhi)
  {
    int i;
    
    if (fx[0] > fx[1])
       { *ihi = 0; *ilo = *inhi = 1; }
    else
      { *ihi = 1; *ilo = *inhi = 0; }
      
    for (i = 2; i < dim + 1; i++)
       if (fx[i] <= fx[*ilo])
          *ilo = i;
       else if (fx[i] > fx[*ihi])
          { *inhi = *ihi; *ihi = i;}
       else if (fx[i] > fx[*inhi])
          *inhi = i;
  }
  
void simplex_bearings(double ** simplex, int dim, double * midpoint, double *
                     line, int ihi)
  {
    int i, j;
    for (j = 0; j < dim; j++)
      midpoint[j] = 0.0;
      
    for (i = 0; i < dim + 1; i++)
       if ( i != ihi)
          for (j = 0; j < dim; j++)
	      midpoint[j] += simplex[i][j];
	      
    for (j = 0; j < dim; j++)
      {
        midpoint[j] /= dim;
	line[j] = simplex[ihi][j] - midpoint[j];
      }
  }
  
int update_simplex(double * point, int dim, double * fmax, double * midpoint,
                   double * line, double scale, int N0, int N1, int m0, int m1, double critic, double (*func)(int N0, int N1, int m0, int m1, double p, double delta, double critic))
  {
    int i, update = 0;
    double * next = alloc_vector(dim), fx;
    
    for (i = 0; i < dim; i++)
      next[i] = midpoint[i] + scale * line[i];
    fx = (*func)(N0, N1, m0, m1, next[0], next[1], critic);
    
    if (fx < *fmax)
       {
         for (i = 0; i < dim; i++) point[i] = next[i];
	 *fmax = fx;
	 update = 1;
       }
       
     free_vector(next, dim);
     return update;
   }
   
void contract_simplex(double ** simplex, int dim, double * fx, int ilo, int N0, int N1, int m0, int m1, double critic, double (*func)(int N0, int N1, int m0, int m1, double p, double delta, double critic))
  {
    int i, j;
    
    for (int i = 0; i < dim + 1; i++)
        if (i != ilo)
	   {
	     for (int j = 0; j < dim; j++)
	        simplex[i][j] = (simplex[ilo][j] + simplex[i][j]) * 0.5;
	     fx[i] = (*func)(N0, N1, m0, m1, simplex[i][0], simplex[i][1], critic);
	   }
  }

// checking convergence

int check_tol(double fmax, double fmin, double ftol)
  {
    double delta = fabs(fmax - fmin);
    double accuracy = (fabs(fmax) + fabs(fmin)) * ftol;
 
    return (delta < (accuracy + ZEPS));
  }
    
// minimization

double amoeba(double * point, int dim, int N0, int N1, int m0, int m1, double critic, double (*func)(int N0, int N1, int m0, int m1, double p, double delta, double critic), double tol)
  {
    int ihi, ilo, inhi, j, iter=0;
    double fmin;
    double * fx = alloc_vector(dim + 1);
    double * midpoint = alloc_vector(dim);
    double * line = alloc_vector(dim);
    double ** simplex = make_simplex(point, dim);
    
    evaluate_simplex(simplex, dim, N0, N1, m0, m1, critic, fx, func);
    
    while (iter < MAX_IT)
       {
         simplex_extremes(fx, dim, &ihi, &ilo, &inhi);
	 simplex_bearings(simplex, dim, midpoint, line, ihi);
	 
	 if (check_tol(fx[ihi], fx[ilo], tol)) break;
	 
	 update_simplex(simplex[ihi], dim, &fx[ihi],midpoint, line, -1.0,  N0, N1, m0, m1, critic, func);
			
         if (fx[ihi] < fx[ilo])
	    update_simplex(simplex[ihi], dim, &fx[ihi], midpoint, line, -2.0,  N0, N1, m0, m1, critic, func);
	 else if (fx[ihi] >= fx[inhi])
	    if (!update_simplex(simplex[ihi], dim, &fx[ihi], midpoint, line, 0.5,  N0, N1, m0, m1, critic, func))
               contract_simplex(simplex, dim, fx, ilo, N0, N1, m0, m1, critic, func);
	       
	       iter++;
        }
	
     for (j = 0; j < dim; j++)
       {
       point[j] = simplex[ilo][j];
      // printf(" pars = %f\n", point[j]);
       }
     fmin = fx[ilo];
     
     free_vector(fx, dim);
     free_vector(midpoint, dim);
     free_vector(line, dim);
     free_matrix(simplex, dim + 1, dim);
     
     //printf("max_loglike= %f \n", -fmin);
     return fmin;
  }
  
//Get initial value for p and delta;
void init(double* pars)
  {
    pars[0] = -log(1/.51 - 1);
    pars[1] = -log(.6/(.3-(.01)) - 1);
  } 
        
int main(int argc, char *argv[])
 { 
   double pars[2], llk;
   double p, d, alpha, chsq;
   int i, j, N0, N1, m0, m1;
   double prob_cond;

   double p_naive, d_naive, OR_naive, mle_p, mle_d, mle_OR, asy_sd_p, asy_sd_d, asy_sd_OR, asy_cov;

   if(argc==1){
       std::cout << "syntax: ./winner -input input_file -alpha alpha_level" << std::endl << " -o outfile" << std::endl;
       exit(0);
   }

   ifstream pf1 (argv[2]);
   string line;

   int rowlines = 0;
   while (!pf1.eof())  { rowlines ++; getline(pf1,line);} pf1.close();
      
   ifstream pf2 (argv[2]);
   getline(pf2,line);

   int matrix[rowlines-2][4];
   vector<string> snp;
   
  // char snp[rowlines-2];

   for (i = 0; i < rowlines-2; i ++)
   {  getline (pf2,line);
      string buff;
      vector<string> tokens;
      tokens.clear();
      stringstream ss(line);
      while (ss >> buff) tokens.push_back(buff);
      //cout << tokens[0].c_str() << endl;
      snp.push_back(tokens[0]);
      
      for (j = 0; j < 4;j ++)
      { matrix[i][j] = atoi(tokens[j+1].c_str());
        //cout << matrix[i][j] <<"\t"<< endl;
      }
   }

   pf2.close();
   
   alpha = atof(argv[4]);
   cout << "The significance level = " << alpha << endl;
   cout << "The number of SNPs = " << rowlines - 2 << endl;
    
   /*// pass varaibles from command line;
   if(argc==1){
       std::cout << "syntax: ./winner -n_control control_sz -n_case case_sz -allele_control control_allele_ct -allele_case case_allele_ct -alpha alpha_level" << std::endl << " -o outfile" << std::endl;
       exit(0);
   }
   
   for(i=1; i <= argc-3; i++)
   {
      if(strcmp(argv[i], "-n_control")==0){N0 = atoi(argv[i+1]); i++;} 
      else if(strcmp(argv[i], "-n_case")==0){N1 = atoi(argv[i+1]); i++;} 
      else if(strcmp(argv[i], "-allele_control")==0){m0 = atoi(argv[i+1]); i++;} 
      else if(strcmp(argv[i], "-allele_case")==0){m1 = atoi(argv[i+1]); i++;} 
      else if(strcmp(argv[i], "-alpha")==0){alpha = atof(argv[i+1]); i++;}
      //else if(strcmp(argv[i], "-o")==0){outputfile(argv[i]); i++;}
      else { std::cout << "invalid parameter" << std::endl; exit(1);}   
   }*/
       
   chsq = cutoff(1.0, alpha);
   
// cout << "SNP" << "\t" << "N0"  << "\t" << "N1" << "\t" << "m0" << "\t" << "m1" << "\t" << "Naive_p" << "\t" << "Naive_d" << "\t" << "Naive_OR" << "\t" << "mle_p" << "\t" << "mle_d" << "\t" << "mle_OR" << "\t" << "SD_p" << "\t" << "SD_d" << "\t" << "SD_OR" << endl;  
printf("%s \t %s \t %s \t %s \t %s \t %s \t %s \t %s \t %s \t %s \t %s \t %s \t %s \t %s \t \n", "SNP", "N0", "N1", "m0", "m1", "naive_p", "naive_d", "naive_OR", "as_mle_p", "as_mle_d", "as_mle_OR", "asy_sd_p", "asy_sd_d", "asy_sad_OR");
  for(int k=0; k < rowlines-2; k++)
 {     
   init(pars); 
   
   N0 = matrix[k][0];
   N1 = matrix[k][1];
   m0 = matrix[k][2];
   m1 = matrix[k][3];

    llk = amoeba(pars,2, N0, N1, m0, m1, chsq, like_simplex, EPS);
    mle_p = exp(pars[0])/(1+exp(pars[0]));
    mle_d = 0.3 - 0.6 * exp(pars[1])/(1+exp(pars[1]));

    mle_OR = OR(mle_p, mle_d);
    
    asy_sd_p = sqrt(var_p(N0, N1,m0,m1,mle_p,mle_d,chsq));
    asy_sd_d = sqrt(var_delta(N0,N1,m0,m1,mle_p,mle_d,chsq));
    asy_cov = cov(N0,N1,m0,m1,mle_p,mle_d,chsq);
    
    asy_sd_OR = sqrt(OR_delta(mle_p,mle_d, asy_sd_p*asy_sd_p, asy_cov, asy_sd_d*asy_sd_d));
              
    p_naive = double(m0)/(2.0*N0);
    d_naive = double(m1)/(2.0*N1) - double(m0)/(2.0*N0);                   
    OR_naive = OR(p_naive, d_naive);
     
    //cout << snp[k] << "\t" << N0  << "\t" << N1 << "\t" << m0 << "\t" << m1 << "\t" << p_naive << "\t" << d_naive << "\t" << OR_naive << "\t" << mle_p << "\t" << mle_d << "\t" << mle_OR << "\t" << asy_sd_p << "\t" << asy_sd_d << "\t" << asy_sd_OR << endl;  

   
  printf("% s \t %d \t %d \t %d \t %d \t %5.4f \t %5.4f \t %5.4f \t %5.4f \t %5.4f \t %5.4f \t %5.4f \t %5.4f \t %5.4f \t \n",snp[k].c_str(), N0, N1, m0, m1, p_naive, d_naive, OR_naive, mle_p, mle_d, mle_OR, asy_sd_p, asy_sd_d, asy_sd_OR);
  
    
 }
 
return(0);
}
